/*
 * Decompiled with CFR 0.152.
 */
package Trace;

import Funk.CloseFrame;
import Trace.MultiScrollPanel;
import Trace.StreamDelegator;
import Trace.TracePanel;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.Toolkit;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MTV
extends CloseFrame
implements ComponentListener,
AdjustmentListener {
    private Vector<TracePanel> tps;
    private Scrollbar scrollbar;
    private Panel trace_holder;
    private int vertical_overhead = -1;
    private int preferred_panel_height;

    public MTV(Vector<String> traces) {
        this.setup(traces);
    }

    public static void main(String[] argv) {
        StreamDelegator.guess_compression();
        StreamDelegator.set_local(true);
        Vector<String> v = new Vector<String>();
        v.addElement("ye50d01.s1");
        v.addElement("ye50d01.r1");
        v.addElement("ye50d01.s1");
        new MTV(v);
    }

    void setup(Vector<String> traces) {
        MultiScrollPanel msp = new MultiScrollPanel();
        Dimension ss = Toolkit.getDefaultToolkit().getScreenSize();
        int preferred_width = (int)((double)ss.width * 0.65);
        int preferred_height = (int)((double)ss.height * 0.85);
        this.preferred_panel_height = (int)((double)ss.height * 0.24);
        Vector tps = new Vector();
        for (String s : traces) {
            System.err.println("DEBUG: " + s);
            TracePanel tp = new TracePanel(s);
            tp.setPreferredSize(new Dimension(preferred_width, this.preferred_panel_height));
            tp.setMinimumSize(new Dimension(preferred_width, this.preferred_panel_height));
            tp.setMaximumSize(new Dimension(ss.width, this.preferred_panel_height));
            msp.add(tp);
        }
        this.setLayout(new BorderLayout());
        this.add("Center", msp);
        this.pack();
        this.setVisible(true);
    }

    public void handle_resize() {
        int sh;
        int fit;
        System.err.println("**RESIZE**");
        int total_panels = this.tps.size();
        int panel_heights = 0;
        int panel_height = 0;
        for (TracePanel tp : this.tps) {
            Dimension d = tp.getSize();
            System.err.println("  panel size:" + d);
            panel_heights += d.height;
            panel_height = d.height;
        }
        Dimension screen = this.getSize();
        System.err.println("panel h=" + panel_heights);
        int holder_height = this.trace_holder.getSize().height;
        System.err.println("hh:" + holder_height + " ph:" + panel_heights);
        int visible = holder_height * total_panels / panel_heights;
        System.err.println("visible:" + visible);
        System.err.println("screen size:" + screen);
        System.err.println("container:" + holder_height);
        int value = 0;
        int minimum = 0;
        int maximum = total_panels;
        this.scrollbar.setValues(value, visible, minimum, maximum);
        System.err.println("setting scrollbar to: " + value + "," + visible + "," + minimum + "," + maximum);
        if (this.vertical_overhead == -1) {
            this.vertical_overhead = screen.height - panel_heights;
            System.err.println("OVERHEAD=" + this.vertical_overhead);
        }
        if ((fit = (sh = screen.height - this.vertical_overhead) / panel_height) < 1) {
            fit = 1;
        }
        if (fit > total_panels) {
            fit = total_panels;
        }
        int leftover = sh % panel_height;
        System.err.println("overhead:" + this.vertical_overhead + " panel:" + panel_height + " fit:" + fit + " left:" + leftover);
        if (leftover > 0) {
            System.err.println("RESIZING");
            int new_h = fit * panel_height + this.vertical_overhead;
            this.setSize(screen.width, new_h);
        }
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        System.err.println("scroll value=" + this.scrollbar.getValue());
        int start_visible = this.scrollbar.getValue();
        int end_visible = start_visible + this.scrollbar.getVisibleAmount();
        int i = 0;
        this.trace_holder.removeAll();
        for (TracePanel tp : this.tps) {
            if (i >= start_visible && i <= end_visible) {
                this.trace_holder.add(tp);
            }
            ++i;
        }
        this.trace_holder.validate();
        System.err.println("vis start:" + start_visible + " end:" + end_visible);
    }

    @Override
    public void componentResized(ComponentEvent e) {
        Dimension d = this.getSize();
        System.err.println("resize: w=" + d.width + " h=" + d.height);
        this.handle_resize();
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }
}

