/*
 * Decompiled with CFR 0.152.
 */
package Trace;

import Trace.Poly;
import Trace.StreamDelegator;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Vector;

public class PolyFile {
    public Vector data;
    public String filename;
    public boolean reverse_complemented = false;
    private boolean load_error = false;

    public PolyFile(String name) {
        this.load(name);
    }

    void load(String filename) {
        DataInputStream d;
        this.filename = filename;
        this.data = new Vector();
        try {
            d = StreamDelegator.getStream(filename, 2);
        }
        catch (IOException e) {
            this.load_error = true;
            return;
        }
        if (d == null) {
            this.load_error = true;
            return;
        }
        BufferedReader d2 = new BufferedReader(new InputStreamReader(d));
        try {
            String line = d2.readLine();
            while ((line = d2.readLine()) != null) {
                this.data.addElement(new Poly(line));
            }
            this.load_error = false;
        }
        catch (IOException e) {
            System.out.println(e);
        }
    }

    public void reverse_complement(int num_samples) {
        Vector<Poly> newdata = new Vector<Poly>();
        for (int i = this.data.size() - 1; i >= 0; --i) {
            Poly p = (Poly)this.data.elementAt(i);
            p.reverse_complement(num_samples);
            newdata.addElement(p);
        }
        this.data = newdata;
        this.reverse_complemented = !this.reverse_complemented;
    }

    public static void main(String[] argv) {
        StreamDelegator.set_local(true);
        PolyFile pf = new PolyFile("/fccc/chlcfs/chlc5/edmonson/src/java2/VirtualNorthern/het/poly_dir/SHE1030-plt4_p53_4a_C07.f1.poly");
        System.out.println(pf.get_poly_at((int)0).called_base);
        pf.reverse_complement(10000);
        System.out.println(pf.get_poly_at((int)0).called_base);
        pf.reverse_complement(10000);
        System.out.println(pf.get_poly_at((int)0).called_base);
    }

    public Poly get_poly_at(int index) {
        return (Poly)this.data.elementAt(index);
    }
}

