/*
 * Decompiled with CFR 0.152.
 */
package Trace;

import Funk.Stream;
import Trace.GZIPOpen;
import java.applet.Applet;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Hashtable;

public class StreamDelegator {
    private static boolean TRY_LOCAL = false;
    private static String hint = "";
    private static String hostname = "lpgws.nci.nih.gov";
    private static boolean compression = false;
    private static boolean use_mod_perl = false;

    public static void setup(Applet a) {
        URL cb = a.getCodeBase();
        String hm = cb.getHost();
        if (hm.length() > 0) {
            System.out.println("using host:" + hm);
            hostname = hm;
        }
        if (cb.getPort() != cb.getDefaultPort() && cb.getPort() != -1) {
            hostname = hostname.concat(":" + cb.getPort());
        }
        StreamDelegator.guess_compression();
    }

    public static void set_host(String s) {
        hostname = s;
    }

    public static void set_local(boolean status) {
        TRY_LOCAL = status;
    }

    public static String get_cgi_base() {
        return "http://" + hostname + (use_mod_perl ? "/perl/" : "/cgi-bin/");
    }

    public static void set_mod_perl(boolean status) {
        System.out.println("set_mod_perl:" + status);
        use_mod_perl = status;
    }

    public static void try_compression(boolean status) {
        compression = status;
    }

    public static void guess_compression() {
        try {
            Class<?> t = Class.forName("java.util.zip.GZIPInputStream");
            System.err.println("using data compression!");
            StreamDelegator.try_compression(true);
        }
        catch (ClassNotFoundException e) {
            System.err.println("data compression not available");
            StreamDelegator.try_compression(false);
        }
    }

    public static DataInputStream getStream(String s, int type) throws IOException {
        DataInputStream result = null;
        if (s.equals("stdin")) {
            System.out.println("reading from stdin!");
            result = new DataInputStream(new BufferedInputStream(System.in));
        } else if (s.length() >= 7 && s.substring(0, 7).equals("http://")) {
            result = StreamDelegator.open_url(s);
        } else if (TRY_LOCAL) {
            result = StreamDelegator.try_file(s);
            if (result == null) {
                switch (type) {
                    case 0: {
                        result = StreamDelegator.try_file("../chromat_dir/" + s);
                        break;
                    }
                    case 1: {
                        result = StreamDelegator.try_file("../phd_dir/" + s + ".phd.1");
                        break;
                    }
                    case 2: {
                        result = StreamDelegator.try_file("../poly_dir/" + s + ".poly");
                    }
                }
                if (result == null) {
                    try {
                        Class<?> t = Class.forName("java.util.zip.ZipInputStream");
                        String xname = "";
                        switch (type) {
                            case 0: {
                                xname = s;
                                break;
                            }
                            case 1: {
                                xname = s + ".phd.1";
                                break;
                            }
                            default: {
                                System.out.println("uh-oh!!");
                            }
                        }
                        String zipfile = "/usr/chlc/SNP/traces/" + s.substring(0, 2) + "/" + s.substring(0, 4) + "/" + s + ".zip";
                        ByteArrayInputStream bs = Stream.get_zip_stream(zipfile, xname);
                        if (bs != null) {
                            result = new DataInputStream(bs);
                        }
                    }
                    catch (ClassNotFoundException e) {
                        System.out.println("Can't extract from zip on this JVM.");
                    }
                }
            }
            if (result == null) {
                System.err.println("Local file " + s + " does not exist");
            }
        }
        if (result == null) {
            boolean do_comp;
            if (type == 3) {
                hint = s;
            }
            System.err.println("loading " + s + " via gettrace.pl, type " + type + "(hint=" + hint + ")");
            long start = System.currentTimeMillis();
            Hashtable<String, String> params = new Hashtable<String, String>();
            params.put("trace", s);
            params.put("type", "" + type);
            params.put("hint", hint);
            boolean bl = do_comp = compression && type <= 3;
            if (do_comp) {
                params.put("comp", "yes");
            }
            result = StreamDelegator.open_url(StreamDelegator.get_cgi_base() + "gettrace.pl", params);
            if (do_comp) {
                result = GZIPOpen.open(result);
            }
            System.out.println("start lag time: " + (System.currentTimeMillis() - start) + " ms");
        }
        return result;
    }

    static DataInputStream try_file(String filename) {
        File f = new File(filename);
        DataInputStream result = null;
        if (f.exists()) {
            try {
                result = new DataInputStream(new BufferedInputStream(new FileInputStream(filename)));
            }
            catch (FileNotFoundException e) {
                System.err.println(e);
            }
        } else {
            System.err.println("File " + filename + " doesn't exist");
        }
        return result;
    }

    public static DataInputStream open_url(String s) throws IOException {
        System.out.println("URL: " + s);
        DataInputStream result = null;
        try {
            URL url = new URL(s);
            result = new DataInputStream(new BufferedInputStream(url.openStream()));
        }
        catch (MalformedURLException e) {
            System.err.println("bad url: " + e);
        }
        return result;
    }

    public static DataInputStream open_url(String s, boolean cacheable) throws IOException {
        System.out.println("URL: " + s);
        System.out.println("   caching allowed: " + cacheable);
        DataInputStream result = null;
        try {
            URL url = new URL(s);
            URLConnection uc = url.openConnection();
            uc.setUseCaches(cacheable);
            result = new DataInputStream(new BufferedInputStream(uc.getInputStream()));
        }
        catch (MalformedURLException e) {
            System.out.println("bad url: " + e);
        }
        return result;
    }

    public static BufferedReader open_url_br(String s, boolean cacheable) throws IOException {
        System.err.println("URL: " + s);
        System.err.println("   caching allowed: " + cacheable);
        BufferedReader result = null;
        try {
            URL url = new URL(s);
            URLConnection uc = url.openConnection();
            uc.setUseCaches(cacheable);
            result = new BufferedReader(new InputStreamReader(uc.getInputStream()));
        }
        catch (MalformedURLException e) {
            System.err.println("bad url: " + e);
        }
        return result;
    }

    public static DataInputStream open_url(String u, Hashtable params) throws IOException {
        URL url = new URL(StreamDelegator.get_cgi_base() + "gettrace.pl");
        URLConnection urlConn = url.openConnection();
        urlConn.setDoInput(true);
        urlConn.setDoOutput(true);
        urlConn.setUseCaches(false);
        urlConn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        DataOutputStream printout = new DataOutputStream(urlConn.getOutputStream());
        int count = 0;
        StringBuffer sb = new StringBuffer();
        Enumeration e = params.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = (String)params.get(key);
            if (count++ > 0) {
                sb.append("&");
            }
            sb.append(key + "=" + URLEncoder.encode(value, "UTF-8"));
        }
        System.out.println("POST: " + u + "?" + sb.toString());
        printout.writeBytes(sb.toString());
        printout.flush();
        printout.close();
        DataInputStream result = new DataInputStream(new BufferedInputStream(urlConn.getInputStream()));
        return result;
    }
}

