/*
 * Decompiled with CFR 0.152.
 */
package Trace;

import Funk.Gr;
import Trace.PhdData;
import Trace.PhdFile;
import Trace.TraceDataView;
import Trace.TraceFile;
import java.awt.BasicStroke;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Scrollbar;
import java.util.Observable;
import java.util.Observer;

public class TraceCanvas
extends Canvas
implements Observer {
    private TraceFile trace;
    private Scrollbar scrollbar;
    private TraceDataView tdv = null;
    private static boolean SCROLL_BY_BASES = false;
    private static boolean BASE_SCROLL_FIXED_BLOCK_SIZE = false;
    private static int BASE_SCROLL_FIXED_BLOCK_SIZE_AMOUNT = 0;
    private boolean BASE_SCROLL_CENTERED_MODE = false;
    public static double DEFAULT_HEIGHT_TO_WIDTH_RATIO = 4.0;
    public static boolean ENABLE_ANTIALIASING = true;
    private static double HEIGHT_TO_WIDTH_RATIO = DEFAULT_HEIGHT_TO_WIDTH_RATIO;
    private static final Color c_color = new Color(160, 32, 240);
    private static final boolean LOAD_PHD = false;
    private int centered_on = 0;
    private boolean center_visible;
    private boolean center_requested = false;
    private boolean resized = false;
    private Image offscreen;
    private int start_position = 0;
    private boolean loaded = false;
    private PhdFile phd = null;
    private int trace_bytes_loaded = 0;
    private String trace_label = null;
    private BasicStroke thin_stroke = new BasicStroke(0.33f);
    private int start_center_base = 0;

    public TraceCanvas(TraceFile t, int start_position, Scrollbar s) {
        this.scrollbar = s;
        if (start_position > 0) {
            this.center_on(start_position);
        }
        this.trace = t;
        this.loaded = true;
        if (this.trace.status() != 1) {
            System.err.println("TraceCanvas called w/non-loaded trace!");
        }
    }

    public TraceCanvas(TraceFile t, int start_position, Scrollbar s, String trace_label) {
        this.scrollbar = s;
        this.trace_label = trace_label;
        if (start_position > 0) {
            this.center_on(start_position);
        }
        this.trace = t;
        this.loaded = true;
        if (this.trace.status() != 1) {
            System.err.println("TraceCanvas called w/non-loaded trace!");
        }
    }

    TraceCanvas(String filename, int start_position, boolean rc, Scrollbar s) {
        this.scrollbar = s;
        this.start_position = start_position;
        this.trace = new TraceFile(filename, rc, (Observer)this);
    }

    public static Color get_trace_color(int i) {
        switch (i) {
            case 0: 
            case 65: 
            case 97: {
                return Color.green;
            }
            case 1: 
            case 67: 
            case 99: {
                return c_color;
            }
            case 2: 
            case 71: 
            case 103: {
                return Color.black;
            }
            case 3: 
            case 84: 
            case 116: {
                return Color.red;
            }
        }
        return Color.black;
    }

    public TraceFile get_trace() {
        return this.trace;
    }

    public void setPhd(PhdFile p) {
        this.phd = p;
        this.repaint();
    }

    public void update(Observable o, Object arg) {
        if (o instanceof TraceFile) {
            if (arg == null) {
                this.loaded = true;
                if (this.start_position > 0) {
                    this.center_on(this.start_position);
                }
            } else {
                this.trace_bytes_loaded = (Integer)arg;
            }
            this.repaint();
        } else if (o instanceof PhdFile) {
            if (this.trace.reverse_complemented) {
                while (this.trace.status() != 1) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.phd.reverse_complement(this.trace.num_samples);
            }
            this.repaint();
        } else {
            System.out.println("unknown observable " + o);
        }
    }

    public boolean loaded() {
        return this.loaded;
    }

    public boolean error() {
        return this.trace.error();
    }

    public void go_to(TraceFile tf, int offset) {
        this.trace = tf;
        this.center_on(offset);
    }

    public void center_on(int i) {
        this.centered_on = i;
        if (SCROLL_BY_BASES) {
            int closest_i = 0;
            int closest_diff = -1;
            for (i = 0; i < this.trace.num_bases; ++i) {
                int pos = this.trace.base_position[i];
                int diff = Math.abs(this.trace.base_position[i] - this.centered_on);
                if (i != 0 && diff >= closest_diff) continue;
                closest_diff = diff;
                closest_i = i;
            }
            this.start_center_base = closest_i;
            this.BASE_SCROLL_CENTERED_MODE = true;
        }
        this.center_requested = true;
        this.repaint();
    }

    public void center_on(int i, boolean auto_rc) {
        if (auto_rc && this.trace.flipped) {
            i = this.trace.num_samples - i;
        }
        this.center_on(i);
    }

    public void update(Graphics g) {
        Dimension d = this.getSize();
        int status = this.trace.status();
        if (this.offscreen == null) {
            this.paint(g);
        } else if (status == 1) {
            this.buffer_paint(this.offscreen.getGraphics(), d.width, d.height);
            g.drawImage(this.offscreen, 0, 0, this);
        } else {
            String message;
            if (status == 2) {
                message = "No trace available for " + this.trace.name + ".";
            } else if (status == 3) {
                message = "Can't decode trace data for " + this.trace.name + ".";
            } else {
                message = "Loading " + this.trace.name + "...";
                if (this.trace_bytes_loaded > 0) {
                    message = message + " (" + this.trace_bytes_loaded / 1024 + "k read)";
                }
            }
            Gr.centerText(this, message);
        }
    }

    public void paint(Graphics g) {
        Dimension d = this.getSize();
        this.offscreen = this.createImage(d.width, d.height);
        this.resized = true;
        this.update(g);
    }

    public void buffer_paint(Graphics gr, int width, int height) {
        int i;
        int base_y_position;
        int font_height;
        int start_point;
        Graphics2D g = (Graphics2D)gr;
        if (ENABLE_ANTIALIASING) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        int start_base_index = 0;
        if (SCROLL_BY_BASES) {
            if (this.BASE_SCROLL_CENTERED_MODE) {
                start_base_index = this.scrollbar.getValue();
                start_point = 0;
            } else {
                start_base_index = this.scrollbar.getValue();
                start_point = this.trace.base_position[start_base_index];
                if ((start_point -= this.trace.average_peak_spacing) < 0) {
                    start_point = 0;
                }
            }
        } else {
            start_point = this.scrollbar.getValue();
        }
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int base_offset = fm.charWidth('C') / 2;
        g.setColor(Color.white);
        g.fillRect(0, 0, width, height);
        int base_number_y_position = font_height = (int)((double)fm.getHeight() * 1.1);
        int phred_y_position = 0;
        if (this.phd != null && this.phd.loaded) {
            phred_y_position = font_height * 2;
            base_y_position = font_height * 3;
        } else {
            base_y_position = font_height * 2;
        }
        int trace_top = base_y_position + fm.getMaxDescent() + 5;
        int trace_bottom = (int)((double)height * 0.98);
        int trace_space = trace_bottom - trace_top;
        double y_mult = (double)trace_space / (double)this.trace.max_amplitude;
        double x_mult = (double)(trace_space / this.trace.average_peak_spacing) / HEIGHT_TO_WIDTH_RATIO;
        int fit = (int)((double)width / x_mult) + 2;
        int end_point = start_point + fit;
        int chunk_size = end_point - start_point;
        if (this.center_requested || this.resized && this.center_visible) {
            start_point = this.centered_on - chunk_size / 2;
            if (start_point < 1) {
                start_point = 1;
            }
            end_point = start_point + chunk_size;
            this.center_requested = false;
            this.resized = false;
            start_base_index = this.start_center_base;
        } else if (SCROLL_BY_BASES && this.BASE_SCROLL_CENTERED_MODE) {
            start_point = this.trace.base_position[start_base_index] - chunk_size / 2;
            end_point = start_point + chunk_size;
            if (start_point < 0) {
                start_point = 0;
            }
        }
        if (end_point > this.trace.num_samples) {
            start_point = this.trace.num_samples - chunk_size;
            end_point = this.trace.num_samples;
        }
        int[] x = new int[chunk_size];
        int[] y = new int[chunk_size];
        if (this.tdv == null) {
            this.tdv = new TraceDataView(this.trace);
        }
        this.tdv.set_buffer(y);
        this.tdv.set_start_point(start_point);
        this.tdv.analyze();
        for (i = 0; i < 4; ++i) {
            g.setColor(TraceCanvas.get_trace_color(i));
            this.tdv.get_samples(i);
            for (int j = 0; j < chunk_size; ++j) {
                x[j] = (int)((double)j * x_mult);
                y[j] = trace_bottom - (int)((double)y[j] * y_mult);
            }
            g.drawPolyline(x, y, chunk_size);
        }
        int base_number_start_x = 0;
        if (this.trace_label != null) {
            g.setColor(Color.black);
            Font old_font = g.getFont();
            Font new_font = new Font(old_font.getName(), 2, old_font.getSize());
            g.setFont(new_font);
            int buffer = 5;
            g.drawString(this.trace_label, buffer, base_number_y_position);
            base_number_start_x = fm.stringWidth(this.trace_label) + buffer * 2;
            g.setFont(old_font);
        }
        boolean base_x = false;
        for (i = 0; i < this.trace.num_bases; ++i) {
            String s;
            int sx;
            int pos = this.trace.base_position[i];
            if (pos < start_point) continue;
            if (pos > end_point) break;
            int x_point = (int)((double)(pos - start_point) * x_mult);
            g.setColor(Color.black);
            if ((i == 0 || (i + 1) % 10 == 0) && (sx = x_point - fm.stringWidth(s = String.valueOf(i + 1)) / 2) > base_number_start_x) {
                g.drawString(s, sx, base_number_y_position);
            }
            int trace_index = -1;
            switch (this.trace.bases[i]) {
                case 'A': 
                case 'a': {
                    trace_index = 0;
                    break;
                }
                case 'C': 
                case 'c': {
                    trace_index = 1;
                    break;
                }
                case 'G': 
                case 'g': {
                    trace_index = 2;
                    break;
                }
                case 'T': 
                case 't': {
                    trace_index = 3;
                }
            }
            if (trace_index == -1) {
                int max = -1;
                for (int b = 0; b < 4; ++b) {
                    if (this.trace.trace_data[b][pos] <= max) continue;
                    max = this.trace.trace_data[b][pos];
                    trace_index = b;
                }
            }
            g.setColor(TraceCanvas.get_trace_color(trace_index));
            g.drawString(String.valueOf(this.trace.bases[i]), x_point - base_offset, base_y_position);
            g.setStroke(this.thin_stroke);
            int basecall_y = this.tdv.get_sample(trace_index, pos);
            int yy = (int)((double)trace_bottom - (double)basecall_y * y_mult) - 3;
            if (yy < trace_top) {
                yy = trace_top;
            }
            g.drawLine(x_point, trace_top, x_point, yy);
        }
        if (this.phd != null && this.phd.loaded) {
            for (i = 0; i < this.phd.data.size(); ++i) {
                PhdData p = (PhdData)this.phd.data.elementAt(i);
                if (p.position < start_point) continue;
                if (p.position > end_point) break;
                int x_point = (int)((double)(p.position - start_point) * x_mult);
                String base = String.valueOf(p.base);
                if (base.equalsIgnoreCase("A")) {
                    g.setColor(Color.green);
                } else if (base.equalsIgnoreCase("C")) {
                    g.setColor(c_color);
                } else if (base.equalsIgnoreCase("T")) {
                    g.setColor(Color.red);
                } else {
                    g.setColor(Color.black);
                }
                g.drawString(base, x_point - base_offset, phred_y_position);
                g.drawLine(x_point, trace_top, x_point, trace_bottom);
            }
        }
        if (this.centered_on > 0 && start_point <= this.centered_on && start_point + chunk_size >= this.centered_on) {
            this.center_visible = true;
            g.setColor(Color.black);
            int[] tri_x = new int[3];
            int[] tri_y = new int[3];
            int x_point = (int)((double)(this.centered_on - start_point) * x_mult);
            tri_x[0] = x_point - 5;
            tri_y[0] = base_number_y_position;
            tri_x[1] = x_point + 5;
            tri_y[1] = base_number_y_position;
            tri_x[2] = x_point;
            tri_y[2] = base_number_y_position + 5;
            g.fillPolygon(tri_x, tri_y, 3);
        } else {
            this.center_visible = false;
        }
        if (SCROLL_BY_BASES) {
            int chunk;
            int bases_per_screen = chunk_size / this.trace.average_peak_spacing;
            int max = this.trace.num_bases + (this.BASE_SCROLL_CENTERED_MODE ? bases_per_screen / 2 : bases_per_screen);
            --max;
            if (BASE_SCROLL_FIXED_BLOCK_SIZE) {
                if (BASE_SCROLL_FIXED_BLOCK_SIZE_AMOUNT == 0) {
                    BASE_SCROLL_FIXED_BLOCK_SIZE_AMOUNT = bases_per_screen;
                }
                chunk = BASE_SCROLL_FIXED_BLOCK_SIZE_AMOUNT;
            } else {
                chunk = bases_per_screen;
            }
            this.scrollbar.setValues(start_base_index, chunk, 0, max);
        } else {
            this.scrollbar.setValues(start_point, chunk_size, 0, this.trace.num_samples - chunk_size);
            this.scrollbar.setBlockIncrement(chunk_size - this.trace.average_peak_spacing / 2);
            this.scrollbar.setUnitIncrement(this.trace.average_peak_spacing);
        }
    }

    public static void set_width_to_height_ratio(double r) {
        HEIGHT_TO_WIDTH_RATIO = r;
    }

    public static void set_antialiasing(boolean aa) {
        ENABLE_ANTIALIASING = aa;
    }

    public static void set_scroll_by_bases(boolean sbb) {
        SCROLL_BY_BASES = sbb;
    }

    public static void set_fixed_bases_scroll(boolean fsc) {
        BASE_SCROLL_FIXED_BLOCK_SIZE = fsc;
    }

    public int get_bases_delta_since_start() {
        if (SCROLL_BY_BASES && this.BASE_SCROLL_CENTERED_MODE) {
            return this.scrollbar.getValue() - this.start_center_base;
        }
        return 0;
    }

    public void apply_absolute_delta(int abs_delta) {
        if (SCROLL_BY_BASES && this.BASE_SCROLL_CENTERED_MODE) {
            this.scrollbar.setMaximum(this.trace.num_bases);
            this.resized = false;
            this.center_requested = false;
            int v = this.start_center_base + abs_delta;
            int max = this.scrollbar.getMaximum();
            if (v > max) {
                v = max;
            }
            this.scrollbar.setValue(v);
            this.repaint();
        }
    }
}

