/*
 * Decompiled with CFR 0.152.
 */
package Trace;

import Trace.BaseBasecaller;
import Trace.FakeFile;
import Trace.RandomAccessStream;
import Trace.StreamDelegator;
import Trace.abi_header;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Observable;
import java.util.Observer;

public class TraceFile
extends Observable
implements Runnable,
Observer {
    public static final short TRACE_A = 0;
    public static final short TRACE_C = 1;
    public static final short TRACE_G = 2;
    public static final short TRACE_T = 3;
    public static final short TRACE_UNDEF = -1;
    public static boolean NORMALIZE = false;
    private static double DUBIOUS_BASECALL_CORRUPTION_THRESHOLD = 0.33;
    public static final short UNINITIALIZED = -1;
    public static final short LOADING = 0;
    public static final short LOADED = 1;
    public static final short NO_DATA = 2;
    public static final short UNKNOWN_FORMAT = 3;
    public String name;
    public int format;
    public int num_bases;
    public int num_samples;
    public int average_peak_spacing;
    public int max_amplitude = 0;
    public int[][] trace_data = new int[4][];
    public int[] base_position;
    public char[] bases;
    public boolean reverse_complemented = false;
    public boolean flipped = false;
    private static final int ABI_NUM_INDICES = 14;
    private static final int ABI_TRACE1 = 0;
    private static final int ABI_TRACE2 = 1;
    private static final int ABI_TRACE3 = 2;
    private static final int ABI_TRACE4 = 3;
    private static final int ABI_BASMAP = 4;
    private static final int ABI_BASES = 5;
    private static final int ABI_BASPOS = 6;
    private static final int ABI_SIGSTR = 7;
    private static final int ABI_AVGSPC = 8;
    private static final int ABI_PRIPOS = 9;
    private static final int ABI_MCHNAM = 10;
    private static final int ABI_DYEPRI = 11;
    private static final int ABI_SMPNAM = 12;
    private static final int ABI_THMPRT = 13;
    private static final int[] ABI_HEADER_SERIAL = new int[]{9, 10, 11, 12, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
    private static final String[] ABI_HEADER_LABELS = new String[]{"DATA", "DATA", "DATA", "DATA", "FWO_", "PBAS", "PLOC", "S/N%", "SPAC", "PPOS", "MCHN", "PDMF", "SMPL", "THUM"};
    private short status = (short)-1;
    private boolean load_from_dis = false;
    private DataInputStream passed_dis = null;
    private boolean internal_basecalls_corrupt = false;

    public TraceFile(String name) {
        this.load(name);
    }

    public TraceFile(String name, DataInputStream dis) {
        this.load_stream(name, dis);
    }

    public TraceFile(String name, DataInputStream dis, Observer o) {
        this.load_from_dis = true;
        this.passed_dis = dis;
        this.load_async(name, o);
    }

    public TraceFile(String name, Observer o) {
        this.load_async(name, o);
    }

    public TraceFile(String name, boolean rc, Observer o) {
        this.reverse_complemented = rc;
        this.load_async(name, o);
    }

    public static char index_to_base(short s) {
        switch (s) {
            case 0: {
                return 'A';
            }
            case 1: {
                return 'C';
            }
            case 2: {
                return 'G';
            }
            case 3: {
                return 'T';
            }
        }
        return '?';
    }

    public static short base_to_index(char c) {
        switch (c) {
            case 'A': 
            case 'a': {
                return 0;
            }
            case 'C': 
            case 'c': {
                return 1;
            }
            case 'G': 
            case 'g': {
                return 2;
            }
            case 'T': 
            case 't': {
                return 3;
            }
        }
        return -1;
    }

    public void update(Observable o, Object arg) {
        this.setChanged();
        this.notifyObservers(arg);
    }

    void load_async(String name, Observer o) {
        this.name = name;
        this.addObserver(o);
        new Thread(this).start();
    }

    public int status() {
        return this.status;
    }

    public boolean loaded() {
        return this.status == 1;
    }

    public boolean error() {
        return this.status == 2 || this.status == 3;
    }

    public int get_value(short index, int position) {
        int value = 0;
        if (index < 0 || index > 3) {
            System.out.println("get_value: bad base " + index + "!");
        } else {
            value = this.trace_data[index][position];
        }
        return value;
    }

    public int get_value(char base, int position) {
        switch (base) {
            case 'A': 
            case 'a': {
                return this.get_value((short)0, position);
            }
            case 'C': 
            case 'c': {
                return this.get_value((short)1, position);
            }
            case 'G': 
            case 'g': {
                return this.get_value((short)2, position);
            }
            case 'T': 
            case 't': {
                return this.get_value((short)3, position);
            }
        }
        return -1;
    }

    public void run() {
        if (this.load_from_dis) {
            if (this.passed_dis == null) {
                System.err.println("WTF, null stream!");
                System.exit(1);
            } else {
                this.load_stream(this.name, this.passed_dis);
            }
        } else {
            this.load(this.name);
        }
        this.setChanged();
        this.notifyObservers();
    }

    public void load(String name) {
        this.name = name;
        try {
            this.load_stream(name, StreamDelegator.getStream(name, 0));
        }
        catch (IOException e) {
            this.status = (short)2;
        }
    }

    public void load_stream(String name, DataInputStream d) {
        this.status = 0;
        this.name = name;
        if (d == null) {
            System.err.println("WTF: null trace stream!");
            this.status = (short)2;
        } else {
            FakeFile rs = new FakeFile(d, this);
            this.setup_stream(rs);
        }
    }

    private void setup_stream(RandomAccessStream rs) {
        if (rs.length() > 0L) {
            this.format = this.get_format(rs);
            if (this.format == 1) {
                this.load_scf(rs);
            } else if (this.format == 2) {
                this.load_abi(rs);
            } else {
                this.status = (short)3;
                System.out.println("format " + this.format + " not implemented");
                return;
            }
            this.corruption_check();
            if (NORMALIZE) {
                this.normalize_peaks();
            }
            if (this.reverse_complemented) {
                this.reverse_complement();
            }
            this.status = 1;
        } else {
            this.status = (short)2;
        }
    }

    int get_format(RandomAccessStream rs) {
        int result = 0;
        String SCF_magic = ".scf";
        String ABI_magic = "ABIF";
        rs.seek(0);
        String s = rs.readString(4);
        if (s.equals(SCF_magic)) {
            result = 1;
        } else if (s.equals(ABI_magic)) {
            result = 2;
        } else {
            rs.seek(128);
            s = rs.readString(4);
            if (s.equals(ABI_magic)) {
                result = 2;
            }
        }
        return result;
    }

    void load_scf(RandomAccessStream rs) {
        int i;
        float vers;
        rs.seek(4);
        this.num_samples = rs.readInt();
        int samples_offset = rs.readInt();
        this.num_bases = rs.readInt();
        int bases_left_clip = rs.readInt();
        int bases_right_clip = rs.readInt();
        int bases_offset = rs.readInt();
        int comments_size = rs.readInt();
        int comments_offset = rs.readInt();
        String version = rs.readString(4);
        int sample_size = rs.readInt();
        int code_set = rs.readInt();
        try {
            vers = Float.valueOf(version).floatValue();
        }
        catch (NumberFormatException e) {
            vers = 0.0f;
        }
        if ((double)vers < 2.0) {
            sample_size = 1;
        }
        if (vers > 3.0f) {
            System.out.println("WARNING: possibly unsupported scf version " + vers + "!");
        }
        this.trace_data[0] = new int[this.num_samples];
        this.trace_data[1] = new int[this.num_samples];
        this.trace_data[2] = new int[this.num_samples];
        this.trace_data[3] = new int[this.num_samples];
        this.base_position = new int[this.num_bases];
        this.bases = new char[this.num_bases];
        rs.seek(samples_offset);
        if (vers >= 3.0f) {
            for (int base = 0; base < 4; ++base) {
                for (i = 0; i < this.num_samples; ++i) {
                    if (sample_size == 1) {
                        this.trace_data[base][i] = rs.readUnsignedByte();
                        continue;
                    }
                    if (sample_size == 2) {
                        this.trace_data[base][i] = rs.readShort();
                        continue;
                    }
                    System.out.println("unknown ss " + sample_size);
                    System.exit(1);
                }
                for (int deref = 0; deref < sample_size; ++deref) {
                    int p_value = 0;
                    for (i = 0; i < this.num_samples; ++i) {
                        this.trace_data[base][i] = this.trace_data[base][i] + p_value;
                        p_value = this.trace_data[base][i];
                    }
                }
                if (sample_size != 2) {
                    System.out.println("warning: untested delta w/this ss!");
                }
                for (i = 0; i < this.num_samples; ++i) {
                    if (this.trace_data[base][i] <= this.max_amplitude) continue;
                    this.max_amplitude = this.trace_data[base][i];
                }
            }
        } else if (sample_size == 1) {
            for (i = 0; i < this.num_samples; ++i) {
                int base;
                this.trace_data[0][i] = base = rs.readUnsignedByte();
                if (base > this.max_amplitude) {
                    this.max_amplitude = base;
                }
                this.trace_data[1][i] = base = rs.readUnsignedByte();
                if (base > this.max_amplitude) {
                    this.max_amplitude = base;
                }
                this.trace_data[2][i] = base = rs.readUnsignedByte();
                if (base > this.max_amplitude) {
                    this.max_amplitude = base;
                }
                this.trace_data[3][i] = base = rs.readUnsignedByte();
                if (base <= this.max_amplitude) continue;
                this.max_amplitude = base;
            }
        } else if (sample_size == 2) {
            for (i = 0; i < this.num_samples; ++i) {
                short base = rs.readShort();
                this.trace_data[0][i] = base;
                if (base > this.max_amplitude) {
                    this.max_amplitude = base;
                }
                base = rs.readShort();
                this.trace_data[1][i] = base;
                if (base > this.max_amplitude) {
                    this.max_amplitude = base;
                }
                base = rs.readShort();
                this.trace_data[2][i] = base;
                if (base > this.max_amplitude) {
                    this.max_amplitude = base;
                }
                base = rs.readShort();
                this.trace_data[3][i] = base;
                if (base <= this.max_amplitude) continue;
                this.max_amplitude = base;
            }
        } else {
            System.out.println("unimplemented sample size " + sample_size + "!");
        }
        rs.seek(bases_offset);
        if (vers == 3.0f) {
            for (i = 0; i < this.num_bases; ++i) {
                this.base_position[i] = rs.readInt();
            }
            for (int base = 0; base < 4; ++base) {
                for (i = 0; i < this.num_bases; ++i) {
                    rs.readUnsignedByte();
                }
            }
            for (i = 0; i < this.num_bases; ++i) {
                this.bases[i] = (char)rs.readByte();
            }
        } else {
            for (i = 0; i < this.num_bases; ++i) {
                this.base_position[i] = rs.readInt();
                rs.skipBytes(4);
                this.bases[i] = (char)rs.readByte();
                rs.skipBytes(3);
            }
        }
        int total = 0;
        for (i = 1; i < this.num_bases; ++i) {
            total += this.base_position[i] - this.base_position[i - 1];
        }
        this.average_peak_spacing = total / (this.num_bases - 1);
    }

    void load_abi(RandomAccessStream rs) {
        int i;
        abi_header[] abi_index = new abi_header[14];
        for (int i2 = 0; i2 < 14; ++i2) {
            abi_index[i2] = new abi_header();
            abi_index[i2].offset = -1;
            abi_index[i2].occur = false;
            abi_index[i2].num_bytes = 0;
            abi_index[i2].num_words = 0;
            abi_index[i2].label = ABI_HEADER_LABELS[i2];
            abi_index[i2].serial_number = ABI_HEADER_SERIAL[i2];
        }
        int start_offset = -1;
        rs.seek(0);
        if (rs.readString(4).equals("ABIF")) {
            start_offset = 0;
        } else {
            rs.seek(128);
            if (rs.readString(4).equals("ABIF")) {
                start_offset = 128;
            }
        }
        rs.seek(start_offset + 16);
        short block_size = rs.readShort();
        rs.seek(start_offset + 26);
        int first_block_offset = rs.readInt() + start_offset;
        rs.seek(first_block_offset);
        byte[] buf = new byte[block_size];
        int max_num_bytes = 0;
        while (rs.read(buf) == block_size) {
            FakeFile rs2 = new FakeFile(buf);
            String label = rs2.readString(4);
            int serial_number = rs2.readInt();
            for (i = 0; i < 14; ++i) {
                if (!abi_index[i].label.equals(label) || abi_index[i].serial_number != serial_number) continue;
                abi_index[i].occur = true;
                short data_type = rs2.readShort();
                short word_size = rs2.readShort();
                int num_words = abi_index[i].num_words = rs2.readInt();
                abi_index[i].num_bytes = rs2.readInt();
                int num_bytes = abi_index[i].num_bytes;
                if (num_bytes > max_num_bytes) {
                    max_num_bytes = num_bytes;
                }
                if (num_bytes <= 4 && data_type != 18) {
                    if (word_size == 1) {
                        abi_index[i].data = rs2.readString(num_words);
                        continue;
                    }
                    if (word_size == 2) {
                        abi_index[i].data = String.valueOf(rs2.readShort());
                        continue;
                    }
                    if (word_size == 4) {
                        abi_index[i].data = String.valueOf(rs2.readInt());
                        continue;
                    }
                    System.out.println("unsupported word size " + word_size);
                    continue;
                }
                abi_index[i].offset = start_offset + rs2.readInt();
            }
        }
        this.max_amplitude = 0;
        char[] base_map = abi_index[4].data.toCharArray();
        for (int trace = 0; trace <= 3; ++trace) {
            if (abi_index[trace].occur) {
                int words;
                rs.seek(abi_index[trace].offset);
                this.num_samples = words = abi_index[trace].num_words;
                int[] samples = new int[words];
                for (i = 0; i < words; ++i) {
                    short sample;
                    samples[i] = rs.readShort();
                    if (sample <= this.max_amplitude) continue;
                    this.max_amplitude = sample;
                }
                switch (base_map[trace]) {
                    case 'A': {
                        this.trace_data[0] = samples;
                        break;
                    }
                    case 'C': {
                        this.trace_data[1] = samples;
                        break;
                    }
                    case 'G': {
                        this.trace_data[2] = samples;
                        break;
                    }
                    case 'T': {
                        this.trace_data[3] = samples;
                        break;
                    }
                    default: {
                        System.out.println("argggh");
                        break;
                    }
                }
                continue;
            }
            System.err.println("missing trace data; huh?");
        }
        if (abi_index[5].occur) {
            rs.seek(abi_index[5].offset);
            String s = rs.readString(abi_index[5].num_bytes);
            this.num_bases = abi_index[5].num_words;
            this.bases = s.toCharArray();
        } else {
            System.out.println("No base information; huh?");
        }
        if (abi_index[6].occur) {
            rs.seek(abi_index[6].offset);
            int words = abi_index[6].num_words;
            this.base_position = new int[words];
            int total = 0;
            for (i = 0; i < words; ++i) {
                this.base_position[i] = rs.readShort();
                if (i <= 0) continue;
                total += this.base_position[i] - this.base_position[i - 1];
            }
            this.average_peak_spacing = total / (this.num_bases - 1);
        } else {
            System.out.println("No base information; huh?");
        }
    }

    public void reverse_complement() {
        int i;
        this.flipped = !this.flipped;
        this.trace_data[0] = this.reverse(this.trace_data[0]);
        this.trace_data[1] = this.reverse(this.trace_data[1]);
        this.trace_data[2] = this.reverse(this.trace_data[2]);
        this.trace_data[3] = this.reverse(this.trace_data[3]);
        int[] temp = this.trace_data[0];
        this.trace_data[0] = this.trace_data[3];
        this.trace_data[3] = temp;
        temp = this.trace_data[1];
        this.trace_data[1] = this.trace_data[2];
        this.trace_data[2] = temp;
        this.base_position = this.reverse(this.base_position);
        for (i = 0; i < this.base_position.length; ++i) {
            this.base_position[i] = this.num_samples - 1 - this.base_position[i];
        }
        this.bases = this.reverse(this.bases);
        block28: for (i = 0; i < this.num_bases; ++i) {
            switch (this.bases[i]) {
                case 'a': {
                    this.bases[i] = 116;
                    continue block28;
                }
                case 'A': {
                    this.bases[i] = 84;
                    continue block28;
                }
                case 'c': {
                    this.bases[i] = 103;
                    continue block28;
                }
                case 'C': {
                    this.bases[i] = 71;
                    continue block28;
                }
                case 'g': {
                    this.bases[i] = 99;
                    continue block28;
                }
                case 'G': {
                    this.bases[i] = 67;
                    continue block28;
                }
                case 't': {
                    this.bases[i] = 97;
                    continue block28;
                }
                case 'T': {
                    this.bases[i] = 65;
                    continue block28;
                }
                case 'R': {
                    this.bases[i] = 89;
                    continue block28;
                }
                case 'r': {
                    this.bases[i] = 121;
                    continue block28;
                }
                case 'Y': {
                    this.bases[i] = 82;
                    continue block28;
                }
                case 'y': {
                    this.bases[i] = 114;
                    continue block28;
                }
                case 'M': {
                    this.bases[i] = 75;
                    continue block28;
                }
                case 'm': {
                    this.bases[i] = 107;
                    continue block28;
                }
                case 'K': {
                    this.bases[i] = 77;
                    continue block28;
                }
                case 'k': {
                    this.bases[i] = 109;
                    continue block28;
                }
                case 'B': {
                    this.bases[i] = 86;
                    continue block28;
                }
                case 'b': {
                    this.bases[i] = 118;
                    continue block28;
                }
                case 'V': {
                    this.bases[i] = 66;
                    continue block28;
                }
                case 'v': {
                    this.bases[i] = 98;
                    continue block28;
                }
                case 'D': {
                    this.bases[i] = 72;
                    continue block28;
                }
                case 'd': {
                    this.bases[i] = 104;
                    continue block28;
                }
                case 'H': {
                    this.bases[i] = 100;
                    continue block28;
                }
                case 'h': {
                    this.bases[i] = 100;
                    continue block28;
                }
                case '-': 
                case 'N': 
                case 'S': 
                case 'W': 
                case 's': 
                case 'w': {
                    continue block28;
                }
                default: {
                    System.out.println("reverse_complement: don't know how to handle base " + this.bases[i]);
                }
            }
        }
    }

    private void normalize_peaks() {
        int i;
        int bi;
        int[] max_call = new int[4];
        max_call[3] = 0;
        max_call[2] = 0;
        max_call[1] = 0;
        max_call[0] = 0;
        for (int base = 0; base < this.num_bases; ++base) {
            bi = TraceFile.base_to_index(this.bases[base]);
            if (bi < 0) continue;
            int bp = this.base_position[base];
            if (bp >= 0) {
                int amp = this.trace_data[bi][bp];
                if (amp <= max_call[bi]) continue;
                max_call[bi] = amp;
                continue;
            }
            System.err.println("ERROR: illegal base position in " + this.name + ": " + bp);
        }
        int max_i = 0;
        for (i = 0; i < 4; ++i) {
            if (max_call[i] <= max_call[max_i]) continue;
            max_i = i;
        }
        for (bi = 0; bi < 4; bi = (int)((short)(bi + 1))) {
            if (bi == max_i || max_call[bi] <= 0) continue;
            double ratio = (double)max_call[max_i] / (double)max_call[bi];
            i = 0;
            while (i < this.num_samples) {
                int[] nArray = this.trace_data[bi];
                int n = i++;
                nArray[n] = (int)((double)nArray[n] * ratio);
            }
        }
    }

    private void normalize_peaks_old() {
        int j;
        int index;
        int i;
        int[] peak_counts = new int[4];
        int[] peak_sizes = new int[4];
        int[] trace_sums = new int[this.num_samples];
        int start = (int)((double)this.num_samples * 0.3);
        int end = (int)((double)this.num_samples * 0.7);
        for (i = start; i < end; ++i) {
            trace_sums[i] = this.trace_data[0][i] + this.trace_data[1][i] + this.trace_data[2][i] + this.trace_data[3][i];
        }
        for (i = start + 1; i < end - 1; ++i) {
            if (trace_sums[i] <= trace_sums[i - 1] || trace_sums[i] <= trace_sums[i + 1]) continue;
            index = 0;
            for (j = 1; j < 4; ++j) {
                if (this.trace_data[j][i] <= this.trace_data[index][i]) continue;
                index = j;
            }
            int n = index;
            peak_counts[n] = peak_counts[n] + 1;
            int n2 = index;
            peak_sizes[n2] = peak_sizes[n2] + this.trace_data[index][i];
        }
        for (i = 0; i < 4; ++i) {
            if (peak_counts[i] <= 0) continue;
            int n = i;
            peak_sizes[n] = peak_sizes[n] / peak_counts[i];
        }
        index = 0;
        for (i = 0; i < 4; ++i) {
            if (peak_sizes[i] <= 0 || peak_sizes[i] >= peak_sizes[index]) continue;
            index = i;
        }
        for (i = 0; i < 4; ++i) {
            if (i == index || peak_counts[i] <= 0) continue;
            double ratio = (double)peak_sizes[index] / (double)peak_sizes[i];
            j = 0;
            while (j < this.num_samples) {
                int[] nArray = this.trace_data[i];
                int n = j++;
                nArray[n] = (int)((double)nArray[n] * ratio);
            }
        }
    }

    int[] reverse(int[] a) {
        int len = a.length;
        int[] result = new int[len];
        int i = 0;
        int j = len - 1;
        while (i < len) {
            result[j] = a[i];
            ++i;
            --j;
        }
        return result;
    }

    char[] reverse(char[] a) {
        int len = a.length;
        char[] result = new char[len];
        int i = 0;
        int j = len - 1;
        while (i < len) {
            result[j] = a[i];
            ++i;
            --j;
        }
        return result;
    }

    public static void main(String[] argv) {
        StreamDelegator.set_local(true);
        TraceFile tf = new TraceFile("/fccc/chlcfs/chlc5/edmonson/src/java2/VirtualNorthern/1_f_only/chromat_dir/SHE1030-plt4_p53_4a_C07.f1");
    }

    private void corruption_check() {
        this.internal_basecalls_corrupt = false;
        HashSet<Integer> bases_seen = new HashSet<Integer>();
        int dubious_calls = 0;
        for (int base = 0; base < this.num_bases; ++base) {
            int bp = this.base_position[base];
            if (bp < 0) {
                this.internal_basecalls_corrupt = true;
                System.err.println("ERROR: illegal base position in " + this.name + ": " + bp);
                continue;
            }
            int bi = TraceFile.base_to_index(this.bases[base]);
            if (bi != 0 && bi != 1 && bi != 2 && bi != 3) continue;
            bases_seen.add(new Integer(bi));
            int max_i = 0;
            int max = 0;
            for (int bi_scan = 0; bi_scan < 4; ++bi_scan) {
                int v = this.trace_data[bi_scan][bp];
                if (v <= max) continue;
                max = v;
                max_i = bi_scan;
            }
            if (bi == max_i) continue;
            ++dubious_calls;
        }
        double dubious_ratio = (double)dubious_calls / (double)this.num_bases;
        if (dubious_ratio > DUBIOUS_BASECALL_CORRUPTION_THRESHOLD) {
            System.err.println("ERROR: " + (int)(dubious_ratio * 100.0) + "% of basecalls don't match strongest channel");
            this.internal_basecalls_corrupt = true;
        }
        if (bases_seen.size() != 4) {
            System.err.println("ERROR: not all of A/C/G/T observed in basecalls");
            this.internal_basecalls_corrupt = true;
        }
        if (this.internal_basecalls_corrupt) {
            System.err.println("internal basecalls appear to be corrupt!  Using trivial recalling.");
            BaseBasecaller bbc = new BaseBasecaller(this);
            bbc.assign_called();
            bbc.set_tracefile_values();
        }
    }

    public void dump_first_sample(String msg) {
        System.err.println("debug: " + msg);
        System.err.println("A0: " + this.trace_data[0][0]);
        System.err.println("C0: " + this.trace_data[1][0]);
        System.err.println("G0: " + this.trace_data[2][0]);
        System.err.println("T0: " + this.trace_data[3][0]);
    }
}

