/*
 * Decompiled with CFR 0.152.
 */
package Trace;

import Funk.Str;
import Funk.ZipTools;
import Trace.TraceFile;
import Trace.TraceViewer;
import java.applet.Applet;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipInputStream;
import org.apache.tools.bzip2.CBZip2InputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TraceServerClient
extends Observable
implements Observer {
    private String compression_type;
    public static final int TYPE_TRACE = 0;
    public static final String COMPRESS_BZIP2 = "bz2";
    public static final String COMPRESS_GZIP = "gz";
    private static String CGI_BASE = "http://cgwb.nci.nih.gov/cgi-bin/ts";

    public TraceServerClient() {
        this.setup();
    }

    private void setup() {
        this.compression_type = COMPRESS_BZIP2;
    }

    public void set_compression(String ct) {
        if (ct.equals(COMPRESS_BZIP2) || ct.equals(COMPRESS_GZIP)) {
            this.compression_type = ct;
        } else {
            System.err.println("ERROR: invalid compression type (bz2/gz)");
            System.exit(1);
        }
    }

    public TraceFile get_trace(int ti) {
        TraceFile result = null;
        try {
            DataInputStream dis = this.getStream(ti, 0);
            if (dis == null) {
                System.err.println("WTF, null stream");
            } else {
                result = new TraceFile(Integer.toString(ti), dis);
            }
        }
        catch (Exception e) {
            System.err.println("ERROR opening trace stream: " + e);
        }
        return result;
    }

    public void get_trace(int ti, Observer o) {
        int max_tries = 3;
        for (int attempt = 0; attempt < max_tries; ++attempt) {
            try {
                DataInputStream dis = this.getStream(ti, 0);
                if (dis == null) {
                    throw new Exception("ERROR: no stream!");
                }
                new TraceFile(Integer.toString(ti), dis, o);
                break;
            }
            catch (Exception e) {
                System.err.println("ERROR opening trace stream: " + e);
                if (attempt < max_tries) {
                    System.err.println("Retrying.");
                    continue;
                }
                System.err.println("giving up after " + max_tries + " attempts");
                continue;
            }
        }
    }

    public void get_traces(Collection<String> tid_list, Observer o) throws IOException {
        this.addObserver(o);
        Hashtable<String, String> params = new Hashtable<String, String>();
        HashSet<String> wanted = new HashSet<String>(tid_list);
        String list = Str.join(",", tid_list.iterator());
        params.put("ti", list);
        params.put("zip", "1");
        if (this.compression_type != null) {
            params.put("compress", this.compression_type);
        }
        InputStream result = this.open_url(CGI_BASE, params);
        ZipInputStream zis = new ZipInputStream(result);
        ZipTools zt = new ZipTools(zis);
        while (zt.next()) {
            String trace_name = zt.get_name();
            byte[] data_buf = zt.get_bytearray();
            InputStream data_stream = new ByteArrayInputStream(data_buf);
            data_stream = this.compression_filter(data_stream);
            TraceFile t = new TraceFile(trace_name, new DataInputStream(data_stream));
            int lio = t.name.lastIndexOf(46);
            if (lio != -1) {
                t.name = t.name.substring(0, lio);
            }
            this.setChanged();
            this.notifyObservers(t);
            wanted.remove(t.name);
            System.err.println("received " + t.name);
        }
        if (wanted.size() > 0) {
            Object[] missing_list = wanted.toArray();
            String msg = "Couldn't retrieve " + wanted.size() + " traces (trace ID: " + missing_list[0] + ")";
            throw new FileNotFoundException(msg);
        }
    }

    public DataInputStream getStream(int ti, int type) throws IOException {
        Hashtable<String, String> params = new Hashtable<String, String>();
        params.put("ti", Integer.toString(ti));
        if (this.compression_type != null) {
            params.put("compress", this.compression_type);
        }
        InputStream result = this.open_url(CGI_BASE, params);
        result = this.compression_filter(result);
        return new DataInputStream(result);
    }

    private InputStream compression_filter(InputStream result) throws IOException {
        if (this.compression_type != null) {
            if (this.compression_type.equals(COMPRESS_GZIP)) {
                result = new GZIPInputStream(result);
            } else if (this.compression_type.equals(COMPRESS_BZIP2)) {
                boolean error = false;
                if (result.read() != 66) {
                    error = true;
                }
                if (result.read() != 90) {
                    error = true;
                }
                if (error) {
                    throw new IOException("bzip2 BZ header not found!");
                }
                result = new CBZip2InputStream(result);
            } else {
                System.err.println("ack!");
                System.exit(1);
            }
        }
        return result;
    }

    public InputStream open_url(String u, Hashtable params) throws IOException {
        URL url = new URL(u);
        URLConnection urlConn = url.openConnection();
        urlConn.setDoInput(true);
        urlConn.setDoOutput(true);
        urlConn.setUseCaches(false);
        urlConn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        DataOutputStream printout = new DataOutputStream(urlConn.getOutputStream());
        int count = 0;
        StringBuffer sb = new StringBuffer();
        Enumeration e = params.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = (String)params.get(key);
            if (count++ > 0) {
                sb.append("&");
            }
            sb.append(key + "=" + URLEncoder.encode(value, "UTF-8"));
        }
        System.err.println("POST: " + u + "?" + sb.toString());
        printout.writeBytes(sb.toString());
        printout.flush();
        printout.close();
        return urlConn.getInputStream();
    }

    public static void main(String[] argv) {
        try {
            System.err.println("can't");
            HashSet<String> allt = new HashSet<String>();
            allt.add("1");
            allt.add("2");
            allt.add("3");
            TraceServerClient traceServerClient = new TraceServerClient();
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e);
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o instanceof TraceFile) {
            TraceFile t = (TraceFile)o;
            new TraceViewer(t);
        }
    }

    public static void set_applet_base(Applet ap) {
        URL codebase = ap.getCodeBase();
        String spec = null;
        spec = codebase.getHost().equals("lpgws.nci.nih.gov") ? "/perl/ts" : "/cgi-bin/ts";
        try {
            URL url = new URL(codebase, spec);
            CGI_BASE = url.toString();
        }
        catch (Exception e) {
            System.err.println("ERROR constructing URL for " + spec);
        }
        System.err.println("set CGI base from applet to: " + CGI_BASE);
    }

    public static void set_cgi_base(String base) {
        CGI_BASE = base;
    }

    public static URI get_uri() {
        URI uri = null;
        try {
            uri = new URI(CGI_BASE);
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e);
        }
        return uri;
    }

    public URL get_download_url(Collection<String> ti_list, String genotype_url) {
        URI base_uri = TraceServerClient.get_uri();
        URL result = null;
        Hashtable<String, String> params = new Hashtable<String, String>();
        params.put("ti", Str.join(",", ti_list.iterator()));
        params.put("zip", "1");
        params.put("gd", genotype_url);
        try {
            URI uri = new URI("http", base_uri.getAuthority(), base_uri.getPath(), Str.url_query_string(params), null);
            result = uri.toURL();
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e);
        }
        return result;
    }
}

