/*
 * Decompiled with CFR 0.152.
 */
package Trace;

import Funk.CloseFrame;
import Funk.Str;
import Trace.PhdFile;
import Trace.StreamDelegator;
import Trace.TraceCanvas;
import Trace.TraceFile;
import Trace.TracePanel;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.util.Observable;
import java.util.Observer;

public class TraceViewer
extends CloseFrame
implements Observer {
    TracePanel tp;
    private double initial_w_ratio = 0.65;
    private double initial_h_ratio = 0.35;

    public TraceViewer(String filename) {
        this.tp = new TracePanel(filename);
        this.setup();
    }

    public TraceViewer(TraceFile t) {
        this.tp = new TracePanel(t);
        this.setup();
    }

    public TraceViewer(TraceFile t, double w, double h) {
        this.initial_w_ratio = w;
        this.initial_h_ratio = h;
        this.tp = new TracePanel(t);
        this.setup();
    }

    public TraceViewer(String filename, int position) {
        this.tp = new TracePanel(filename, position);
        this.setup();
    }

    public TraceViewer(String filename, int position, boolean reverse_complemented) {
        this.tp = new TracePanel(filename, position, reverse_complemented);
        this.setup();
    }

    public TraceViewer(String filename, boolean reverse_complemented) {
        this.tp = new TracePanel(filename, reverse_complemented);
        this.setup();
    }

    public void setPhd(PhdFile p) {
        this.tp.setPhd(p);
    }

    public static void main(String[] argv) {
        StreamDelegator.guess_compression();
        String trace = null;
        boolean rc = false;
        int offset = 0;
        boolean use_trace_server = false;
        for (int i = 0; i < argv.length; ++i) {
            if (argv[i].equals("-local")) {
                StreamDelegator.set_local(true);
                continue;
            }
            if (argv[i].equals("-rc")) {
                rc = true;
                continue;
            }
            if (argv[i].equals("-ts")) {
                use_trace_server = true;
                continue;
            }
            if (argv[i].equals("-sbb")) {
                System.err.println("scrolling by bases");
                TraceCanvas.set_scroll_by_bases(true);
                TraceCanvas.set_fixed_bases_scroll(true);
                continue;
            }
            if (argv[i].equals("-offset")) {
                offset = Integer.parseInt(argv[++i]);
                continue;
            }
            if (argv[i].equals("-h")) {
                StreamDelegator.set_host(argv[++i]);
                continue;
            }
            if (argv[i].equals("-mp")) {
                StreamDelegator.set_mod_perl(true);
                continue;
            }
            trace = argv[i];
        }
        if (trace == null) {
            System.out.println("Usage: TraceViewer tracefile [options]");
            System.exit(1);
        } else if (use_trace_server) {
            System.err.println("DISABLED (so applet JDK4 code can compile)");
        } else {
            new TraceViewer(trace, offset, rc);
        }
    }

    void setup() {
        this.setTitle(this.tp.filename);
        this.add("Center", this.tp);
        this.pack();
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize((int)((double)d.width * this.initial_w_ratio), (int)((double)d.height * this.initial_h_ratio));
        this.setVisible(true);
    }

    public void center_in_screen(Point p) {
        if (p != null) {
            this.setLocation(p.x - this.getSize().width / 2, p.y);
        }
    }

    public void center_on(int i) {
        this.tp.center_on(i);
    }

    public void center_on(int i, boolean auto_rc) {
        this.tp.center_on(i, auto_rc);
    }

    public void go_to(TraceFile tf, int offset) {
        this.setTitle(Str.basename(tf.name));
        this.tp.go_to(tf, offset);
        this.setVisible(true);
    }

    public boolean loaded() {
        return this.tp.loaded();
    }

    public boolean error() {
        return this.tp.error();
    }

    public TraceFile get_trace() {
        return this.tp.get_trace();
    }

    public void update(Observable o, Object arg) {
        System.err.println("UPDATE");
    }
}

