/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Task;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.common.TaskFieldLists;

class BaselineManager {
    private static final TaskField[] SOURCE_FIELDS = new TaskField[]{TaskField.COST, TaskField.DURATION, TaskField.FINISH, TaskField.FIXED_COST_ACCRUAL, TaskField.FIXED_COST, TaskField.START, TaskField.WORK};
    private static final TaskField[] BASELINE0_FIELDS = new TaskField[]{TaskField.BASELINE_COST, TaskField.BASELINE_DURATION, TaskField.BASELINE_FINISH, TaskField.BASELINE_FIXED_COST_ACCRUAL, TaskField.BASELINE_FIXED_COST, TaskField.BASELINE_START, TaskField.BASELINE_WORK};

    BaselineManager() {
    }

    public void clearBaseline(ProjectFile project, int index) {
        TaskField[] baselineFields = this.getBaselineFields(index);
        project.getTasks().forEach(t -> this.populateBaseline((Task)t, null, baselineFields));
    }

    public void populateBaseline(ProjectFile project, ProjectFile baseline, int index, Function<Task, Object> keyFunction) {
        TaskField[] baselineFields = this.getBaselineFields(index);
        Map<Object, Task> map = baseline.getTasks().stream().filter(t -> keyFunction.apply((Task)t) != null).collect(Collectors.toMap(t -> keyFunction.apply((Task)t), t -> t));
        project.getTasks().forEach(t -> this.populateBaseline((Task)t, (Task)map.get(keyFunction.apply((Task)t)), baselineFields));
    }

    private void populateBaseline(Task task, Task baseline, TaskField[] baselineFields) {
        IntStream.range(0, SOURCE_FIELDS.length).forEach(i -> task.set((FieldType)baselineFields[i], baseline == null ? null : baseline.getCachedValue(SOURCE_FIELDS[i])));
    }

    private TaskField[] getBaselineFields(int index) {
        TaskField[] fields = index == 0 ? BASELINE0_FIELDS : new TaskField[]{TaskFieldLists.BASELINE_COSTS[--index], TaskFieldLists.BASELINE_DURATIONS[index], TaskFieldLists.BASELINE_FINISHES[index], TaskFieldLists.BASELINE_FIXED_COST_ACCRUALS[index], TaskFieldLists.BASELINE_FIXED_COSTS[index], TaskFieldLists.BASELINE_STARTS[index], TaskFieldLists.BASELINE_WORKS[index]};
        return fields;
    }
}

