/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import net.sf.mpxj.AccrueType;
import net.sf.mpxj.ActivityCodeValue;
import net.sf.mpxj.ActivityStatus;
import net.sf.mpxj.ActivityType;
import net.sf.mpxj.ChildTaskContainer;
import net.sf.mpxj.ConstraintType;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Duration;
import net.sf.mpxj.EarnedValueMethod;
import net.sf.mpxj.ExpenseItem;
import net.sf.mpxj.FieldContainer;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.FieldTypeClass;
import net.sf.mpxj.Notes;
import net.sf.mpxj.PercentCompleteType;
import net.sf.mpxj.Priority;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectConfig;
import net.sf.mpxj.ProjectEntity;
import net.sf.mpxj.ProjectEntityWithID;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.RecurringTask;
import net.sf.mpxj.Relation;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.SubProject;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.TaskMode;
import net.sf.mpxj.TaskType;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.common.BooleanHelper;
import net.sf.mpxj.common.DateHelper;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.common.TaskFieldLists;
import net.sf.mpxj.listener.FieldListener;

public final class Task
extends ProjectEntity
implements Comparable<Task>,
ProjectEntityWithID,
FieldContainer,
ChildTaskContainer {
    private Object[] m_array = new Object[TaskField.MAX_VALUE];
    private Task m_parent;
    private List<Task> m_children = new ArrayList<Task>();
    private List<ResourceAssignment> m_assignments = new ArrayList<ResourceAssignment>();
    private List<ActivityCodeValue> m_activityCodes = new ArrayList<ActivityCodeValue>();
    private RecurringTask m_recurringTask;
    private boolean m_eventsEnabled = true;
    private boolean m_null;
    private boolean m_resumeValid;
    private String m_externalTaskProject;
    private boolean m_expanded = true;
    private List<FieldListener> m_listeners;

    Task(ProjectFile file, Task parent) {
        super(file);
        this.setType(TaskType.FIXED_UNITS);
        this.setConstraintType(ConstraintType.AS_SOON_AS_POSSIBLE);
        this.setTaskMode(TaskMode.AUTO_SCHEDULED);
        this.setActive(true);
        this.set((FieldType)TaskField.PREDECESSORS, new ArrayList());
        this.set((FieldType)TaskField.SUCCESSORS, new ArrayList());
        this.m_parent = parent;
        ProjectConfig config = file.getProjectConfig();
        if (config.getAutoTaskUniqueID()) {
            this.setUniqueID(config.getNextTaskUniqueID());
        }
        if (config.getAutoTaskID()) {
            this.setID(config.getNextTaskID());
        }
        if (config.getAutoWBS()) {
            this.generateWBS(parent);
        }
        if (config.getAutoOutlineNumber()) {
            this.generateOutlineNumber(parent);
        }
        if (config.getAutoOutlineLevel()) {
            if (parent == null) {
                this.setOutlineLevel(1);
            } else {
                this.setOutlineLevel(NumberHelper.getInt(parent.getOutlineLevel()) + 1);
            }
        }
    }

    public void generateWBS(Task parent) {
        String wbs;
        if (parent == null) {
            wbs = NumberHelper.getInt(this.getUniqueID()) == 0 ? "0" : Integer.toString(this.getParentFile().getChildTasks().size() + 1);
        } else {
            wbs = parent.getWBS();
            int childTaskCount = parent.getChildTasks().size() + 1;
            wbs = wbs.equals("0") ? Integer.toString(childTaskCount) : wbs + "." + childTaskCount;
        }
        this.setWBS(wbs);
    }

    public void generateOutlineNumber(Task parent) {
        String outline;
        if (parent == null) {
            outline = NumberHelper.getInt(this.getUniqueID()) == 0 ? "0" : Integer.toString(this.getParentFile().getChildTasks().size() + 1);
        } else {
            outline = parent.getOutlineNumber();
            int index = outline.lastIndexOf(".0");
            if (index != -1) {
                outline = outline.substring(0, index);
            }
            int childTaskCount = parent.getChildTasks().size() + 1;
            outline = outline.equals("0") ? Integer.toString(childTaskCount) : outline + "." + childTaskCount;
        }
        this.setOutlineNumber(outline);
    }

    public void setNotes(String notes) {
        this.set((FieldType)TaskField.NOTES, notes == null ? null : new Notes(notes));
    }

    public void setNotesObject(Notes notes) {
        this.set((FieldType)TaskField.NOTES, notes);
    }

    @Override
    public Task addTask() {
        ProjectFile parent = this.getParentFile();
        Task task = new Task(parent, this);
        this.m_children.add(task);
        parent.getTasks().add(task);
        this.setSummary(true);
        return task;
    }

    public void addChildTask(Task child, int childOutlineLevel) {
        int outlineLevel = NumberHelper.getInt(this.getOutlineLevel());
        if (outlineLevel + 1 == childOutlineLevel) {
            this.m_children.add(child);
            this.setSummary(true);
        } else if (!this.m_children.isEmpty()) {
            this.m_children.get(this.m_children.size() - 1).addChildTask(child, childOutlineLevel);
        }
    }

    public void addChildTask(Task child) {
        child.m_parent = this;
        this.m_children.add(child);
        this.setSummary(true);
        if (this.getParentFile().getProjectConfig().getAutoOutlineLevel()) {
            child.setOutlineLevel(NumberHelper.getInt(this.getOutlineLevel()) + 1);
        }
    }

    public void addChildTaskBefore(Task child, Task previousSibling) {
        int index = this.m_children.indexOf(previousSibling);
        if (index == -1) {
            this.m_children.add(child);
        } else {
            this.m_children.add(index, child);
        }
        child.m_parent = this;
        this.setSummary(true);
        if (this.getParentFile().getProjectConfig().getAutoOutlineLevel()) {
            child.setOutlineLevel(NumberHelper.getInt(this.getOutlineLevel()) + 1);
        }
    }

    public void removeChildTask(Task child) {
        if (this.m_children.remove(child)) {
            child.m_parent = null;
        }
        this.setSummary(!this.m_children.isEmpty());
    }

    public void clearChildTasks() {
        if (!this.m_children.isEmpty()) {
            this.m_children.clear();
            this.setSummary(false);
        }
    }

    public RecurringTask addRecurringTask() {
        if (this.m_recurringTask == null) {
            this.m_recurringTask = new RecurringTask();
        }
        return this.m_recurringTask;
    }

    public RecurringTask getRecurringTask() {
        return this.m_recurringTask;
    }

    public List<ActivityCodeValue> getActivityCodes() {
        return this.m_activityCodes;
    }

    public void addActivityCode(ActivityCodeValue value) {
        this.m_activityCodes.add(value);
    }

    public ResourceAssignment addResourceAssignment(Resource resource) {
        ResourceAssignment assignment = this.getExistingResourceAssignment(resource);
        if (assignment == null) {
            assignment = new ResourceAssignment(this.getParentFile(), this);
            this.m_assignments.add(assignment);
            this.getParentFile().getResourceAssignments().add(assignment);
            assignment.setTaskUniqueID(this.getUniqueID());
            assignment.setWork(this.getDuration());
            assignment.setUnits(ResourceAssignment.DEFAULT_UNITS);
            if (resource != null) {
                assignment.setResourceUniqueID(resource.getUniqueID());
                resource.addResourceAssignment(assignment);
            }
        }
        return assignment;
    }

    public void addResourceAssignment(ResourceAssignment assignment) {
        if (this.getExistingResourceAssignment(assignment.getResource()) == null) {
            this.m_assignments.add(assignment);
            this.getParentFile().getResourceAssignments().add(assignment);
            Resource resource = assignment.getResource();
            if (resource != null) {
                resource.addResourceAssignment(assignment);
            }
        }
    }

    private ResourceAssignment getExistingResourceAssignment(Resource resource) {
        ResourceAssignment assignment = null;
        Integer resourceUniqueID = null;
        if (resource != null) {
            Integer uniqueID;
            Iterator<ResourceAssignment> iter = this.m_assignments.iterator();
            resourceUniqueID = resource.getUniqueID();
            while (iter.hasNext() && ((uniqueID = (assignment = iter.next()).getResourceUniqueID()) == null || !uniqueID.equals(resourceUniqueID))) {
                assignment = null;
            }
        }
        return assignment;
    }

    public List<ResourceAssignment> getResourceAssignments() {
        return this.m_assignments;
    }

    void removeResourceAssignment(ResourceAssignment assignment) {
        this.m_assignments.remove(assignment);
    }

    public Relation addPredecessor(Task targetTask, RelationType type, Duration lag) {
        if (lag == null) {
            lag = Duration.getInstance(0, TimeUnit.DAYS);
        }
        List predecessorList = (List)this.getCachedValue(TaskField.PREDECESSORS);
        Relation predecessorRelation2 = null;
        for (Relation predecessorRelation2 : predecessorList) {
            if (predecessorRelation2.getTargetTask() == targetTask) {
                if (predecessorRelation2.getType() == type && predecessorRelation2.getLag().compareTo(lag) == 0) break;
                predecessorRelation2 = null;
                break;
            }
            predecessorRelation2 = null;
        }
        if (predecessorRelation2 == null) {
            predecessorRelation2 = new Relation(this, targetTask, type, lag);
            predecessorList.add(predecessorRelation2);
        }
        List successorList = (List)targetTask.getCachedValue(TaskField.SUCCESSORS);
        Relation successorRelation2 = null;
        for (Relation successorRelation2 : successorList) {
            if (successorRelation2.getTargetTask() == this) {
                if (successorRelation2.getType() == type && successorRelation2.getLag().compareTo(lag) == 0) break;
                successorRelation2 = null;
                break;
            }
            successorRelation2 = null;
        }
        if (successorRelation2 == null) {
            successorRelation2 = new Relation(targetTask, this, type, lag);
            successorList.add(successorRelation2);
        }
        return predecessorRelation2;
    }

    public void setPercentageComplete(Number val) {
        this.set((FieldType)TaskField.PERCENT_COMPLETE, val);
    }

    public void setPercentageWorkComplete(Number val) {
        this.set((FieldType)TaskField.PERCENT_WORK_COMPLETE, val);
    }

    public void setActualCost(Number val) {
        this.set((FieldType)TaskField.ACTUAL_COST, val);
    }

    public void setActualDuration(Duration val) {
        this.set((FieldType)TaskField.ACTUAL_DURATION, val);
    }

    public void setActualFinish(Date val) {
        this.set((FieldType)TaskField.ACTUAL_FINISH, val);
    }

    public void setActualStart(Date val) {
        this.set((FieldType)TaskField.ACTUAL_START, val);
    }

    public void setActualWork(Duration val) {
        this.set((FieldType)TaskField.ACTUAL_WORK, val);
    }

    public void setBaselineCost(Number val) {
        this.set((FieldType)TaskField.BASELINE_COST, val);
    }

    public void setBaselineDuration(Duration val) {
        this.set((FieldType)TaskField.BASELINE_DURATION, val);
    }

    public void setBaselineFinish(Date val) {
        this.set((FieldType)TaskField.BASELINE_FINISH, val);
    }

    public void setBaselineStart(Date val) {
        this.set((FieldType)TaskField.BASELINE_START, val);
    }

    public void setBaselineWork(Duration val) {
        this.set((FieldType)TaskField.BASELINE_WORK, val);
    }

    public void setBCWP(Number val) {
        this.set((FieldType)TaskField.BCWP, val);
    }

    public void setBCWS(Number val) {
        this.set((FieldType)TaskField.BCWS, val);
    }

    public void setConfirmed(boolean val) {
        this.set((FieldType)TaskField.CONFIRMED, val);
    }

    public void setConstraintDate(Date val) {
        this.set((FieldType)TaskField.CONSTRAINT_DATE, val);
    }

    public void setSecondaryConstraintDate(Date date) {
        this.set((FieldType)TaskField.SECONDARY_CONSTRAINT_DATE, date);
    }

    public void setConstraintType(ConstraintType type) {
        this.set((FieldType)TaskField.CONSTRAINT_TYPE, type);
    }

    public void setSecondaryConstraintType(ConstraintType type) {
        this.set((FieldType)TaskField.SECONDARY_CONSTRAINT_TYPE, type);
    }

    public void setContact(String val) {
        this.set((FieldType)TaskField.CONTACT, val);
    }

    public void setCost(Number val) {
        this.set((FieldType)TaskField.COST, val);
    }

    public void setCost(int index, Number value) {
        this.set((FieldType)this.selectField(TaskFieldLists.CUSTOM_COST, index), value);
    }

    public Number getCost(int index) {
        return (Number)this.getCachedValue(this.selectField(TaskFieldLists.CUSTOM_COST, index));
    }

    public void setCostVariance(Number val) {
        this.set((FieldType)TaskField.COST_VARIANCE, val);
    }

    public void setCreateDate(Date val) {
        this.set((FieldType)TaskField.CREATED, val);
    }

    public void setCritical(boolean val) {
        this.set((FieldType)TaskField.CRITICAL, val);
    }

    public void setCV(Number val) {
        this.set((FieldType)TaskField.CV, val);
    }

    public void setLevelingDelay(Duration val) {
        this.set((FieldType)TaskField.LEVELING_DELAY, val);
    }

    public void setDuration(Duration val) {
        this.set((FieldType)TaskField.DURATION, val);
    }

    public void setDurationText(String val) {
        this.set((FieldType)TaskField.DURATION_TEXT, val);
    }

    public void setManualDuration(Duration dur) {
        this.set((FieldType)TaskField.MANUAL_DURATION, dur);
    }

    public Duration getManualDuration() {
        return (Duration)this.getCachedValue(TaskField.MANUAL_DURATION);
    }

    public void setDurationVariance(Duration duration) {
        this.set((FieldType)TaskField.DURATION_VARIANCE, duration);
    }

    public void setEarlyFinish(Date date) {
        this.set((FieldType)TaskField.EARLY_FINISH, date);
    }

    public void setRemainingEarlyFinish(Date date) {
        this.set((FieldType)TaskField.REMAINING_EARLY_FINISH, date);
    }

    public void setEarlyStart(Date date) {
        this.set((FieldType)TaskField.EARLY_START, date);
    }

    public void setRemainingEarlyStart(Date date) {
        this.set((FieldType)TaskField.REMAINING_EARLY_START, date);
    }

    public void setFinish(Date date) {
        this.set((FieldType)TaskField.FINISH, date);
    }

    public void setFinishText(String val) {
        this.set((FieldType)TaskField.FINISH_TEXT, val);
    }

    public void setFinishVariance(Duration duration) {
        this.set((FieldType)TaskField.FINISH_VARIANCE, duration);
    }

    public void setFixedCost(Number val) {
        this.set((FieldType)TaskField.FIXED_COST, val);
    }

    public void setFreeSlack(Duration duration) {
        this.set((FieldType)TaskField.FREE_SLACK, duration);
    }

    public void setHideBar(boolean flag) {
        this.set((FieldType)TaskField.HIDE_BAR, flag);
    }

    @Override
    public void setID(Integer val) {
        ProjectFile parent = this.getParentFile();
        Integer previous = this.getID();
        if (previous != null) {
            parent.getTasks().unmapID(previous);
        }
        parent.getTasks().mapID(val, this);
        this.set((FieldType)TaskField.ID, val);
    }

    public void setLateFinish(Date date) {
        this.set((FieldType)TaskField.LATE_FINISH, date);
    }

    public void setRemainingLateFinish(Date date) {
        this.set((FieldType)TaskField.REMAINING_LATE_FINISH, date);
    }

    public void setLateStart(Date date) {
        this.set((FieldType)TaskField.LATE_START, date);
    }

    public void setRemainingLateStart(Date date) {
        this.set((FieldType)TaskField.REMAINING_LATE_START, date);
    }

    public void setLinkedFields(boolean flag) {
        this.set((FieldType)TaskField.LINKED_FIELDS, flag);
    }

    public void setMarked(boolean flag) {
        this.set((FieldType)TaskField.MARKED, flag);
    }

    public void setMilestone(boolean flag) {
        this.set((FieldType)TaskField.MILESTONE, flag);
    }

    public void setName(String name) {
        this.set((FieldType)TaskField.NAME, name);
    }

    public void setObjects(Integer val) {
        this.set((FieldType)TaskField.OBJECTS, val);
    }

    public void setOutlineLevel(Integer val) {
        this.set((FieldType)TaskField.OUTLINE_LEVEL, val);
    }

    public void setOutlineNumber(String val) {
        this.set((FieldType)TaskField.OUTLINE_NUMBER, val);
    }

    public void setPriority(Priority priority) {
        this.set((FieldType)TaskField.PRIORITY, priority);
    }

    public void setProject(String val) {
        this.set((FieldType)TaskField.PROJECT, val);
    }

    public void setRemainingCost(Number val) {
        this.set((FieldType)TaskField.REMAINING_COST, val);
    }

    public void setRemainingDuration(Duration val) {
        this.set((FieldType)TaskField.REMAINING_DURATION, val);
    }

    public void setRemainingWork(Duration val) {
        this.set((FieldType)TaskField.REMAINING_WORK, val);
    }

    public void setResourceGroup(String val) {
        this.set((FieldType)TaskField.RESOURCE_GROUP, val);
    }

    public void setResourceInitials(String val) {
        this.set((FieldType)TaskField.RESOURCE_INITIALS, val);
    }

    public void setResourceNames(String val) {
        this.set((FieldType)TaskField.RESOURCE_NAMES, val);
    }

    public void setResume(Date val) {
        this.set((FieldType)TaskField.RESUME, val);
    }

    public void setRollup(boolean val) {
        this.set((FieldType)TaskField.ROLLUP, val);
    }

    public void setStart(Date val) {
        this.set((FieldType)TaskField.START, val);
    }

    public void setStartText(String val) {
        this.set((FieldType)TaskField.START_TEXT, val);
    }

    public void setStartVariance(Duration val) {
        this.set((FieldType)TaskField.START_VARIANCE, val);
    }

    public void setStop(Date val) {
        this.set((FieldType)TaskField.STOP, val);
    }

    public void setSubprojectName(String val) {
        this.set((FieldType)TaskField.SUBPROJECT_FILE, val);
    }

    public void setSummary(boolean val) {
        this.set((FieldType)TaskField.SUMMARY, val);
    }

    public void setSV(Number val) {
        this.set((FieldType)TaskField.SV, val);
    }

    public void setTotalSlack(Duration val) {
        this.set((FieldType)TaskField.TOTAL_SLACK, val);
    }

    @Override
    public void setUniqueID(Integer val) {
        this.set((FieldType)TaskField.UNIQUE_ID, val);
    }

    public void setUpdateNeeded(boolean val) {
        this.set((FieldType)TaskField.UPDATE_NEEDED, val);
    }

    public void setWBS(String val) {
        this.set((FieldType)TaskField.WBS, val);
    }

    public void setWork(Duration val) {
        this.set((FieldType)TaskField.WORK, val);
    }

    public void setWorkVariance(Duration val) {
        this.set((FieldType)TaskField.WORK_VARIANCE, val);
    }

    public Number getPercentageComplete() {
        return (Number)this.getCachedValue(TaskField.PERCENT_COMPLETE);
    }

    public Number getPercentageWorkComplete() {
        return (Number)this.getCachedValue(TaskField.PERCENT_WORK_COMPLETE);
    }

    public Number getActualCost() {
        return (Number)this.getCachedValue(TaskField.ACTUAL_COST);
    }

    public Duration getActualDuration() {
        return (Duration)this.getCachedValue(TaskField.ACTUAL_DURATION);
    }

    public Date getActualFinish() {
        return (Date)this.getCachedValue(TaskField.ACTUAL_FINISH);
    }

    public Date getActualStart() {
        return (Date)this.getCachedValue(TaskField.ACTUAL_START);
    }

    public Duration getActualWork() {
        return (Duration)this.getCachedValue(TaskField.ACTUAL_WORK);
    }

    public Number getBaselineCost() {
        return (Number)this.getCachedValue(TaskField.BASELINE_COST);
    }

    public Duration getBaselineDuration() {
        Object result = this.getCachedValue(TaskField.BASELINE_DURATION);
        if (result == null) {
            result = this.getCachedValue(TaskField.BASELINE_ESTIMATED_DURATION);
        }
        if (!(result instanceof Duration)) {
            result = null;
        }
        return (Duration)result;
    }

    public String getBaselineDurationText() {
        Object result = this.getCachedValue(TaskField.BASELINE_DURATION);
        if (result == null) {
            result = this.getCachedValue(TaskField.BASELINE_ESTIMATED_DURATION);
        }
        if (!(result instanceof String)) {
            result = null;
        }
        return (String)result;
    }

    public void setBaselineDurationText(String value) {
        this.set((FieldType)TaskField.BASELINE_DURATION, value);
    }

    public Date getBaselineFinish() {
        Object result = this.getCachedValue(TaskField.BASELINE_FINISH);
        if (result == null) {
            result = this.getCachedValue(TaskField.BASELINE_ESTIMATED_FINISH);
        }
        if (!(result instanceof Date)) {
            result = null;
        }
        return (Date)result;
    }

    public String getBaselineFinishText() {
        Object result = this.getCachedValue(TaskField.BASELINE_FINISH);
        if (result == null) {
            result = this.getCachedValue(TaskField.BASELINE_ESTIMATED_FINISH);
        }
        if (!(result instanceof String)) {
            result = null;
        }
        return (String)result;
    }

    public void setBaselineFinishText(String value) {
        this.set((FieldType)TaskField.BASELINE_FINISH, value);
    }

    public Date getBaselineStart() {
        Object result = this.getCachedValue(TaskField.BASELINE_START);
        if (result == null) {
            result = this.getCachedValue(TaskField.BASELINE_ESTIMATED_START);
        }
        if (!(result instanceof Date)) {
            result = null;
        }
        return (Date)result;
    }

    public String getBaselineStartText() {
        Object result = this.getCachedValue(TaskField.BASELINE_START);
        if (result == null) {
            result = this.getCachedValue(TaskField.BASELINE_ESTIMATED_START);
        }
        if (!(result instanceof String)) {
            result = null;
        }
        return (String)result;
    }

    public void setBaselineStartText(String value) {
        this.set((FieldType)TaskField.BASELINE_START, value);
    }

    public Duration getBaselineWork() {
        return (Duration)this.getCachedValue(TaskField.BASELINE_WORK);
    }

    public Number getBCWP() {
        return (Number)this.getCachedValue(TaskField.BCWP);
    }

    public Number getBCWS() {
        return (Number)this.getCachedValue(TaskField.BCWS);
    }

    public boolean getConfirmed() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(TaskField.CONFIRMED));
    }

    public Date getConstraintDate() {
        return (Date)this.getCachedValue(TaskField.CONSTRAINT_DATE);
    }

    public Date getSecondaryConstraintDate() {
        return (Date)this.getCachedValue(TaskField.SECONDARY_CONSTRAINT_DATE);
    }

    public ConstraintType getConstraintType() {
        return (ConstraintType)this.getCachedValue(TaskField.CONSTRAINT_TYPE);
    }

    public ConstraintType getSecondaryConstraintType() {
        return (ConstraintType)this.getCachedValue(TaskField.SECONDARY_CONSTRAINT_TYPE);
    }

    public String getContact() {
        return (String)this.getCachedValue(TaskField.CONTACT);
    }

    public Number getCost() {
        return (Number)this.getCachedValue(TaskField.COST);
    }

    public Number getCostVariance() {
        Number variance = (Number)this.getCachedValue(TaskField.COST_VARIANCE);
        if (variance == null) {
            Number cost = this.getCost();
            Number baselineCost = this.getBaselineCost();
            if (cost != null && baselineCost != null) {
                variance = NumberHelper.getDouble(cost.doubleValue() - baselineCost.doubleValue());
                this.set((FieldType)TaskField.COST_VARIANCE, variance);
            }
        }
        return variance;
    }

    public Date getCreateDate() {
        return (Date)this.getCachedValue(TaskField.CREATED);
    }

    public boolean getCritical() {
        Boolean critical = (Boolean)this.getCachedValue(TaskField.CRITICAL);
        if (critical == null) {
            Duration totalSlack = this.getTotalSlack();
            ProjectProperties props = this.getParentFile().getProjectProperties();
            int criticalSlackLimit = NumberHelper.getInt(props.getCriticalSlackLimit());
            if (criticalSlackLimit != 0 && totalSlack.getDuration() != 0.0 && totalSlack.getUnits() != TimeUnit.DAYS) {
                totalSlack = totalSlack.convertUnits(TimeUnit.DAYS, props);
            }
            critical = totalSlack.getDuration() <= (double)criticalSlackLimit && NumberHelper.getInt(this.getPercentageComplete()) != 100 && (this.getTaskMode() == TaskMode.AUTO_SCHEDULED || this.getDurationText() == null && this.getStartText() == null && this.getFinishText() == null);
            this.set((FieldType)TaskField.CRITICAL, critical);
        }
        return BooleanHelper.getBoolean(critical);
    }

    public Number getCV() {
        Number variance = (Number)this.getCachedValue(TaskField.CV);
        if (variance == null) {
            variance = NumberHelper.getDouble(this.getBCWP()) - NumberHelper.getDouble(this.getACWP());
            this.set((FieldType)TaskField.CV, variance);
        }
        return variance;
    }

    public Duration getLevelingDelay() {
        return (Duration)this.getCachedValue(TaskField.LEVELING_DELAY);
    }

    public Duration getDuration() {
        return (Duration)this.getCachedValue(TaskField.DURATION);
    }

    public String getDurationText() {
        return (String)this.getCachedValue(TaskField.DURATION_TEXT);
    }

    public void setDuration(int index, Duration value) {
        this.set((FieldType)this.selectField(TaskFieldLists.CUSTOM_DURATION, index), value);
    }

    public Duration getDuration(int index) {
        return (Duration)this.getCachedValue(this.selectField(TaskFieldLists.CUSTOM_DURATION, index));
    }

    public Duration getDurationVariance() {
        Duration variance = (Duration)this.getCachedValue(TaskField.DURATION_VARIANCE);
        if (variance == null) {
            Duration duration = this.getDuration();
            Duration baselineDuration = this.getBaselineDuration();
            if (duration != null && baselineDuration != null) {
                variance = Duration.getInstance(duration.getDuration() - baselineDuration.convertUnits(duration.getUnits(), this.getParentFile().getProjectProperties()).getDuration(), duration.getUnits());
                this.set((FieldType)TaskField.DURATION_VARIANCE, variance);
            }
        }
        return variance;
    }

    public Date getEarlyFinish() {
        return (Date)this.getCachedValue(TaskField.EARLY_FINISH);
    }

    public Date getRemainingEarlyFinish() {
        return (Date)this.getCachedValue(TaskField.REMAINING_EARLY_FINISH);
    }

    public Date getEarlyStart() {
        return (Date)this.getCachedValue(TaskField.EARLY_START);
    }

    public Date getRemainingEarlyStart() {
        return (Date)this.getCachedValue(TaskField.REMAINING_EARLY_START);
    }

    public Date getFinish() {
        return (Date)this.getCachedValue(TaskField.FINISH);
    }

    public String getFinishText() {
        return (String)this.getCachedValue(TaskField.FINISH_TEXT);
    }

    public void setFinish(int index, Date value) {
        this.set((FieldType)this.selectField(TaskFieldLists.CUSTOM_FINISH, index), value);
    }

    public Date getFinish(int index) {
        return (Date)this.getCachedValue(this.selectField(TaskFieldLists.CUSTOM_FINISH, index));
    }

    public Duration getFinishVariance() {
        Duration variance = (Duration)this.getCachedValue(TaskField.FINISH_VARIANCE);
        if (variance == null) {
            TimeUnit format = this.getParentFile().getProjectProperties().getDefaultDurationUnits();
            variance = DateHelper.getVariance(this, this.getBaselineFinish(), this.getFinish(), format);
            this.set((FieldType)TaskField.FINISH_VARIANCE, variance);
        }
        return variance;
    }

    public Number getFixedCost() {
        return (Number)this.getCachedValue(TaskField.FIXED_COST);
    }

    public void setFlag(int index, boolean value) {
        this.set((FieldType)this.selectField(TaskFieldLists.CUSTOM_FLAG, index), value);
    }

    public boolean getFlag(int index) {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(this.selectField(TaskFieldLists.CUSTOM_FLAG, index)));
    }

    public Duration getFreeSlack() {
        return (Duration)this.getCachedValue(TaskField.FREE_SLACK);
    }

    public boolean getHideBar() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(TaskField.HIDE_BAR));
    }

    @Override
    public Integer getID() {
        return (Integer)this.getCachedValue(TaskField.ID);
    }

    public Date getLateFinish() {
        return (Date)this.getCachedValue(TaskField.LATE_FINISH);
    }

    public Date getRemainingLateFinish() {
        return (Date)this.getCachedValue(TaskField.REMAINING_LATE_FINISH);
    }

    public Date getLateStart() {
        return (Date)this.getCachedValue(TaskField.LATE_START);
    }

    public Date getRemainingLateStart() {
        return (Date)this.getCachedValue(TaskField.REMAINING_LATE_START);
    }

    public boolean getLinkedFields() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(TaskField.LINKED_FIELDS));
    }

    public boolean getMarked() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(TaskField.MARKED));
    }

    public boolean getMilestone() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(TaskField.MILESTONE));
    }

    public String getName() {
        return (String)this.getCachedValue(TaskField.NAME);
    }

    public String getNotes() {
        Object notes = this.getCachedValue(TaskField.NOTES);
        return notes == null ? "" : notes.toString();
    }

    public Notes getNotesObject() {
        Object notes = this.getCachedValue(TaskField.NOTES);
        return notes == null ? null : (Notes)notes;
    }

    public void setNumber(int index, Number value) {
        this.set((FieldType)this.selectField(TaskFieldLists.CUSTOM_NUMBER, index), value);
    }

    public Number getNumber(int index) {
        return (Number)this.getCachedValue(this.selectField(TaskFieldLists.CUSTOM_NUMBER, index));
    }

    public Integer getObjects() {
        return (Integer)this.getCachedValue(TaskField.OBJECTS);
    }

    public Integer getOutlineLevel() {
        return (Integer)this.getCachedValue(TaskField.OUTLINE_LEVEL);
    }

    public String getOutlineNumber() {
        return (String)this.getCachedValue(TaskField.OUTLINE_NUMBER);
    }

    public List<Relation> getPredecessors() {
        return (List)this.getCachedValue(TaskField.PREDECESSORS);
    }

    public List<Relation> getSuccessors() {
        return (List)this.getCachedValue(TaskField.SUCCESSORS);
    }

    public Priority getPriority() {
        return (Priority)this.getCachedValue(TaskField.PRIORITY);
    }

    public String getProject() {
        return (String)this.getCachedValue(TaskField.PROJECT);
    }

    public Number getRemainingCost() {
        return (Number)this.getCachedValue(TaskField.REMAINING_COST);
    }

    public Duration getRemainingDuration() {
        return (Duration)this.getCachedValue(TaskField.REMAINING_DURATION);
    }

    public Duration getRemainingWork() {
        return (Duration)this.getCachedValue(TaskField.REMAINING_WORK);
    }

    public String getResourceGroup() {
        return (String)this.getCachedValue(TaskField.RESOURCE_GROUP);
    }

    public String getResourceInitials() {
        return (String)this.getCachedValue(TaskField.RESOURCE_INITIALS);
    }

    public String getResourceNames() {
        return (String)this.getCachedValue(TaskField.RESOURCE_NAMES);
    }

    public Date getResume() {
        return (Date)this.getCachedValue(TaskField.RESUME);
    }

    public boolean getRollup() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(TaskField.ROLLUP));
    }

    public Date getStart() {
        return (Date)this.getCachedValue(TaskField.START);
    }

    public String getStartText() {
        return (String)this.getCachedValue(TaskField.START_TEXT);
    }

    public void setStart(int index, Date value) {
        this.set((FieldType)this.selectField(TaskFieldLists.CUSTOM_START, index), value);
    }

    public Date getStart(int index) {
        return (Date)this.getCachedValue(this.selectField(TaskFieldLists.CUSTOM_START, index));
    }

    public Duration getStartVariance() {
        Duration variance = (Duration)this.getCachedValue(TaskField.START_VARIANCE);
        if (variance == null) {
            TimeUnit format = this.getParentFile().getProjectProperties().getDefaultDurationUnits();
            variance = DateHelper.getVariance(this, this.getBaselineStart(), this.getStart(), format);
            this.set((FieldType)TaskField.START_VARIANCE, variance);
        }
        return variance;
    }

    public Date getStop() {
        return (Date)this.getCachedValue(TaskField.STOP);
    }

    public String getSubprojectName() {
        return (String)this.getCachedValue(TaskField.SUBPROJECT_FILE);
    }

    public boolean getSummary() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(TaskField.SUMMARY));
    }

    public Number getSV() {
        Number variance = (Number)this.getCachedValue(TaskField.SV);
        if (variance == null) {
            Number bcwp = this.getBCWP();
            Number bcws = this.getBCWS();
            if (bcwp != null && bcws != null) {
                variance = NumberHelper.getDouble(bcwp.doubleValue() - bcws.doubleValue());
                this.set((FieldType)TaskField.SV, variance);
            }
        }
        return variance;
    }

    public void setText(int index, String value) {
        this.set((FieldType)this.selectField(TaskFieldLists.CUSTOM_TEXT, index), value);
    }

    public String getText(int index) {
        return (String)this.getCachedValue(this.selectField(TaskFieldLists.CUSTOM_TEXT, index));
    }

    public void setOutlineCode(int index, String value) {
        this.set((FieldType)this.selectField(TaskFieldLists.CUSTOM_OUTLINE_CODE, index), value);
    }

    public String getOutlineCode(int index) {
        return (String)this.getCachedValue(this.selectField(TaskFieldLists.CUSTOM_OUTLINE_CODE, index));
    }

    public Duration getTotalSlack() {
        Duration totalSlack = (Duration)this.getCachedValue(TaskField.TOTAL_SLACK);
        if (totalSlack == null) {
            Duration duration = this.getDuration();
            if (duration == null) {
                duration = Duration.getInstance(0, TimeUnit.DAYS);
            }
            TimeUnit units = duration.getUnits();
            Duration startSlack = this.getStartSlack();
            if (startSlack == null) {
                startSlack = Duration.getInstance(0, units);
            } else if (startSlack.getUnits() != units) {
                startSlack = startSlack.convertUnits(units, this.getParentFile().getProjectProperties());
            }
            Duration finishSlack = this.getFinishSlack();
            if (finishSlack == null) {
                finishSlack = Duration.getInstance(0, units);
            } else if (finishSlack.getUnits() != units) {
                finishSlack = finishSlack.convertUnits(units, this.getParentFile().getProjectProperties());
            }
            double startSlackDuration = startSlack.getDuration();
            double finishSlackDuration = finishSlack.getDuration();
            totalSlack = startSlackDuration == 0.0 || finishSlackDuration == 0.0 ? (startSlackDuration != 0.0 ? startSlack : finishSlack) : (startSlackDuration < finishSlackDuration ? startSlack : finishSlack);
            this.set((FieldType)TaskField.TOTAL_SLACK, totalSlack);
        }
        return totalSlack;
    }

    @Override
    public Integer getUniqueID() {
        return (Integer)this.getCachedValue(TaskField.UNIQUE_ID);
    }

    public boolean getUpdateNeeded() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(TaskField.UPDATE_NEEDED));
    }

    public String getWBS() {
        return (String)this.getCachedValue(TaskField.WBS);
    }

    public Duration getWork() {
        return (Duration)this.getCachedValue(TaskField.WORK);
    }

    public Duration getWorkVariance() {
        Duration variance = (Duration)this.getCachedValue(TaskField.WORK_VARIANCE);
        if (variance == null) {
            Duration work = this.getWork();
            Duration baselineWork = this.getBaselineWork();
            if (work != null && baselineWork != null) {
                variance = Duration.getInstance(work.getDuration() - baselineWork.convertUnits(work.getUnits(), this.getParentFile().getProjectProperties()).getDuration(), work.getUnits());
                this.set((FieldType)TaskField.WORK_VARIANCE, variance);
            }
        }
        return variance;
    }

    public Task getParentTask() {
        return this.m_parent;
    }

    @Override
    public List<Task> getChildTasks() {
        return this.m_children;
    }

    @Override
    public int compareTo(Task o) {
        int id2;
        int id1 = NumberHelper.getInt(this.getID());
        return id1 < (id2 = NumberHelper.getInt(o.getID())) ? -1 : (id1 == id2 ? 0 : 1);
    }

    public boolean getEstimated() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(TaskField.ESTIMATED));
    }

    public void setEstimated(boolean estimated) {
        this.set((FieldType)TaskField.ESTIMATED, estimated);
    }

    public Date getDeadline() {
        return (Date)this.getCachedValue(TaskField.DEADLINE);
    }

    public void setDeadline(Date deadline) {
        this.set((FieldType)TaskField.DEADLINE, deadline);
    }

    public TaskType getType() {
        return (TaskType)this.getCachedValue(TaskField.TYPE);
    }

    public void setType(TaskType type) {
        this.set((FieldType)TaskField.TYPE, type);
    }

    public boolean getNull() {
        return this.m_null;
    }

    public void setNull(boolean isNull) {
        this.m_null = isNull;
    }

    public boolean getResumeValid() {
        return this.m_resumeValid;
    }

    public void setResumeValid(boolean resumeValid) {
        this.m_resumeValid = resumeValid;
    }

    public boolean getRecurring() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(TaskField.RECURRING));
    }

    public void setRecurring(boolean recurring) {
        this.set((FieldType)TaskField.RECURRING, recurring);
    }

    public boolean getOverAllocated() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(TaskField.OVERALLOCATED));
    }

    public void setOverAllocated(boolean overAllocated) {
        this.set((FieldType)TaskField.OVERALLOCATED, overAllocated);
    }

    public Integer getSubprojectTaskUniqueID() {
        return (Integer)this.getCachedValue(TaskField.SUBPROJECT_UNIQUE_TASK_ID);
    }

    public void setSubprojectTaskUniqueID(Integer subprojectUniqueTaskID) {
        this.set((FieldType)TaskField.SUBPROJECT_UNIQUE_TASK_ID, subprojectUniqueTaskID);
    }

    public Integer getSubprojectTaskID() {
        return (Integer)this.getCachedValue(TaskField.SUBPROJECT_TASK_ID);
    }

    public void setSubprojectTaskID(Integer subprojectTaskID) {
        this.set((FieldType)TaskField.SUBPROJECT_TASK_ID, subprojectTaskID);
    }

    public void setSubprojectTasksUniqueIDOffset(Integer offset) {
        this.set((FieldType)TaskField.SUBPROJECT_TASKS_UNIQUEID_OFFSET, offset);
    }

    public Integer getSubprojectTasksUniqueIDOffset() {
        return (Integer)this.getCachedValue(TaskField.SUBPROJECT_TASKS_UNIQUEID_OFFSET);
    }

    public boolean getSubprojectReadOnly() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(TaskField.SUBPROJECT_READ_ONLY));
    }

    public void setSubprojectReadOnly(boolean subprojectReadOnly) {
        this.set((FieldType)TaskField.SUBPROJECT_READ_ONLY, subprojectReadOnly);
    }

    public boolean getExternalTask() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(TaskField.EXTERNAL_TASK));
    }

    public void setExternalTask(boolean externalTask) {
        this.set((FieldType)TaskField.EXTERNAL_TASK, externalTask);
    }

    public String getExternalTaskProject() {
        return this.m_externalTaskProject;
    }

    public void setExternalTaskProject(String externalTaskProject) {
        this.m_externalTaskProject = externalTaskProject;
    }

    public Number getACWP() {
        return (Number)this.getCachedValue(TaskField.ACWP);
    }

    public void setACWP(Number acwp) {
        this.set((FieldType)TaskField.ACWP, acwp);
    }

    public TimeUnit getLevelingDelayFormat() {
        return (TimeUnit)this.getCachedValue(TaskField.LEVELING_DELAY_UNITS);
    }

    public void setLevelingDelayFormat(TimeUnit levelingDelayFormat) {
        this.set((FieldType)TaskField.LEVELING_DELAY_UNITS, levelingDelayFormat);
    }

    public boolean getIgnoreResourceCalendar() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(TaskField.IGNORE_RESOURCE_CALENDAR));
    }

    public void setIgnoreResourceCalendar(boolean ignoreResourceCalendar) {
        this.set((FieldType)TaskField.IGNORE_RESOURCE_CALENDAR, ignoreResourceCalendar);
    }

    public Number getPhysicalPercentComplete() {
        return (Number)this.getCachedValue(TaskField.PHYSICAL_PERCENT_COMPLETE);
    }

    public void setPhysicalPercentComplete(Number physicalPercentComplete) {
        this.set((FieldType)TaskField.PHYSICAL_PERCENT_COMPLETE, physicalPercentComplete);
    }

    public EarnedValueMethod getEarnedValueMethod() {
        return (EarnedValueMethod)this.getCachedValue(TaskField.EARNED_VALUE_METHOD);
    }

    public void setEarnedValueMethod(EarnedValueMethod earnedValueMethod) {
        this.set((FieldType)TaskField.EARNED_VALUE_METHOD, earnedValueMethod);
    }

    public Duration getActualWorkProtected() {
        return (Duration)this.getCachedValue(TaskField.ACTUAL_WORK_PROTECTED);
    }

    public void setActualWorkProtected(Duration actualWorkProtected) {
        this.set((FieldType)TaskField.ACTUAL_WORK_PROTECTED, actualWorkProtected);
    }

    public Duration getActualOvertimeWorkProtected() {
        return (Duration)this.getCachedValue(TaskField.ACTUAL_OVERTIME_WORK_PROTECTED);
    }

    public void setActualOvertimeWorkProtected(Duration actualOvertimeWorkProtected) {
        this.set((FieldType)TaskField.ACTUAL_OVERTIME_WORK_PROTECTED, actualOvertimeWorkProtected);
    }

    public Duration getRegularWork() {
        return (Duration)this.getCachedValue(TaskField.REGULAR_WORK);
    }

    public void setRegularWork(Duration regularWork) {
        this.set((FieldType)TaskField.REGULAR_WORK, regularWork);
    }

    public void setEffortDriven(boolean flag) {
        this.set((FieldType)TaskField.EFFORT_DRIVEN, flag);
    }

    public boolean getEffortDriven() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(TaskField.EFFORT_DRIVEN));
    }

    public void setDate(int index, Date value) {
        this.set((FieldType)this.selectField(TaskFieldLists.CUSTOM_DATE, index), value);
    }

    public Date getDate(int index) {
        return (Date)this.getCachedValue(this.selectField(TaskFieldLists.CUSTOM_DATE, index));
    }

    public Number getOvertimeCost() {
        return (Number)this.getCachedValue(TaskField.OVERTIME_COST);
    }

    public void setOvertimeCost(Number number) {
        this.set((FieldType)TaskField.OVERTIME_COST, number);
    }

    public Number getActualOvertimeCost() {
        return (Number)this.getCachedValue(TaskField.ACTUAL_OVERTIME_COST);
    }

    public void setActualOvertimeCost(Number cost) {
        this.set((FieldType)TaskField.ACTUAL_OVERTIME_COST, cost);
    }

    public Duration getActualOvertimeWork() {
        return (Duration)this.getCachedValue(TaskField.ACTUAL_OVERTIME_WORK);
    }

    public void setActualOvertimeWork(Duration work) {
        this.set((FieldType)TaskField.ACTUAL_OVERTIME_WORK, work);
    }

    public AccrueType getFixedCostAccrual() {
        return (AccrueType)this.getCachedValue(TaskField.FIXED_COST_ACCRUAL);
    }

    public void setFixedCostAccrual(AccrueType type) {
        this.set((FieldType)TaskField.FIXED_COST_ACCRUAL, type);
    }

    public String getHyperlink() {
        return (String)this.getCachedValue(TaskField.HYPERLINK);
    }

    public String getHyperlinkAddress() {
        return (String)this.getCachedValue(TaskField.HYPERLINK_ADDRESS);
    }

    public String getHyperlinkSubAddress() {
        return (String)this.getCachedValue(TaskField.HYPERLINK_SUBADDRESS);
    }

    public void setHyperlink(String text) {
        this.set((FieldType)TaskField.HYPERLINK, text);
    }

    public void setHyperlinkAddress(String text) {
        this.set((FieldType)TaskField.HYPERLINK_ADDRESS, text);
    }

    public void setHyperlinkSubAddress(String text) {
        this.set((FieldType)TaskField.HYPERLINK_SUBADDRESS, text);
    }

    public boolean getLevelAssignments() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(TaskField.LEVEL_ASSIGNMENTS));
    }

    public void setLevelAssignments(boolean flag) {
        this.set((FieldType)TaskField.LEVEL_ASSIGNMENTS, flag);
    }

    public boolean getLevelingCanSplit() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(TaskField.LEVELING_CAN_SPLIT));
    }

    public void setLevelingCanSplit(boolean flag) {
        this.set((FieldType)TaskField.LEVELING_CAN_SPLIT, flag);
    }

    public Duration getOvertimeWork() {
        return (Duration)this.getCachedValue(TaskField.OVERTIME_WORK);
    }

    public void setOvertimeWork(Duration work) {
        this.set((FieldType)TaskField.OVERTIME_WORK, work);
    }

    public Date getPreleveledStart() {
        return (Date)this.getCachedValue(TaskField.PRELEVELED_START);
    }

    public Date getPreleveledFinish() {
        return (Date)this.getCachedValue(TaskField.PRELEVELED_FINISH);
    }

    public void setPreleveledStart(Date date) {
        this.set((FieldType)TaskField.PRELEVELED_START, date);
    }

    public void setPreleveledFinish(Date date) {
        this.set((FieldType)TaskField.PRELEVELED_FINISH, date);
    }

    public Duration getRemainingOvertimeWork() {
        return (Duration)this.getCachedValue(TaskField.REMAINING_OVERTIME_WORK);
    }

    public void setRemainingOvertimeWork(Duration work) {
        this.set((FieldType)TaskField.REMAINING_OVERTIME_WORK, work);
    }

    public Number getRemainingOvertimeCost() {
        return (Number)this.getCachedValue(TaskField.REMAINING_OVERTIME_COST);
    }

    public void setRemainingOvertimeCost(Number cost) {
        this.set((FieldType)TaskField.REMAINING_OVERTIME_COST, cost);
    }

    public ProjectCalendar getCalendar() {
        return (ProjectCalendar)this.getCachedValue(TaskField.CALENDAR);
    }

    public void setCalendarUniqueID(Integer id) {
        this.set((FieldType)TaskField.CALENDAR_UNIQUE_ID, id);
    }

    public Integer getCalendarUniqueID() {
        return (Integer)this.getCachedValue(TaskField.CALENDAR_UNIQUE_ID);
    }

    public void setCalendar(ProjectCalendar calendar) {
        this.set((FieldType)TaskField.CALENDAR, calendar);
        this.setCalendarUniqueID(calendar == null ? null : calendar.getUniqueID());
    }

    public boolean getExpanded() {
        return this.m_expanded;
    }

    public void setExpanded(boolean expanded) {
        this.m_expanded = expanded;
    }

    public void setStartSlack(Duration duration) {
        this.set((FieldType)TaskField.START_SLACK, duration);
    }

    public void setFinishSlack(Duration duration) {
        this.set((FieldType)TaskField.FINISH_SLACK, duration);
    }

    public Duration getStartSlack() {
        Duration duration;
        Duration startSlack = (Duration)this.getCachedValue(TaskField.START_SLACK);
        if (startSlack == null && (duration = this.getDuration()) != null) {
            startSlack = DateHelper.getVariance(this, this.getEarlyStart(), this.getLateStart(), duration.getUnits());
            this.set((FieldType)TaskField.START_SLACK, startSlack);
        }
        return startSlack;
    }

    public Duration getFinishSlack() {
        Duration duration;
        Duration finishSlack = (Duration)this.getCachedValue(TaskField.FINISH_SLACK);
        if (finishSlack == null && (duration = this.getDuration()) != null) {
            finishSlack = DateHelper.getVariance(this, this.getEarlyFinish(), this.getLateFinish(), duration.getUnits());
            this.set((FieldType)TaskField.FINISH_SLACK, finishSlack);
        }
        return finishSlack;
    }

    public Object getFieldByAlias(String alias) {
        return this.getCachedValue(this.getParentFile().getCustomFields().getFieldByAlias(FieldTypeClass.TASK, alias));
    }

    public void setFieldByAlias(String alias, Object value) {
        this.set(this.getParentFile().getCustomFields().getFieldByAlias(FieldTypeClass.TASK, alias), value);
    }

    public List<DateRange> getSplits() {
        return (List)this.getCachedValue(TaskField.SPLITS);
    }

    public void setSplits(List<DateRange> splits) {
        this.set((FieldType)TaskField.SPLITS, splits);
    }

    public Date getSplitCompleteDuration() {
        return (Date)this.getCachedValue(TaskField.SPLITS_COMPLETE);
    }

    public void setSplitCompleteDuration(Date splitsComplete) {
        this.set((FieldType)TaskField.SPLITS_COMPLETE, splitsComplete);
    }

    public void remove() {
        this.getParentFile().removeTask(this);
    }

    public SubProject getSubProject() {
        return (SubProject)this.getCachedValue(TaskField.SUBPROJECT);
    }

    public void setSubProject(SubProject subProject) {
        this.set((FieldType)TaskField.SUBPROJECT, subProject);
    }

    public Number getEnterpriseCost(int index) {
        return (Number)this.getCachedValue(this.selectField(TaskFieldLists.ENTERPRISE_COST, index));
    }

    public void setEnterpriseCost(int index, Number value) {
        this.set((FieldType)this.selectField(TaskFieldLists.ENTERPRISE_COST, index), value);
    }

    public Date getEnterpriseDate(int index) {
        return (Date)this.getCachedValue(this.selectField(TaskFieldLists.ENTERPRISE_DATE, index));
    }

    public void setEnterpriseDate(int index, Date value) {
        this.set((FieldType)this.selectField(TaskFieldLists.ENTERPRISE_DATE, index), value);
    }

    public Duration getEnterpriseDuration(int index) {
        return (Duration)this.getCachedValue(this.selectField(TaskFieldLists.ENTERPRISE_DURATION, index));
    }

    public void setEnterpriseDuration(int index, Duration value) {
        this.set((FieldType)this.selectField(TaskFieldLists.ENTERPRISE_DURATION, index), value);
    }

    public boolean getEnterpriseFlag(int index) {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(this.selectField(TaskFieldLists.ENTERPRISE_FLAG, index)));
    }

    public void setEnterpriseFlag(int index, boolean value) {
        this.set((FieldType)this.selectField(TaskFieldLists.ENTERPRISE_FLAG, index), value);
    }

    public Number getEnterpriseNumber(int index) {
        return (Number)this.getCachedValue(this.selectField(TaskFieldLists.ENTERPRISE_NUMBER, index));
    }

    public void setEnterpriseNumber(int index, Number value) {
        this.set((FieldType)this.selectField(TaskFieldLists.ENTERPRISE_NUMBER, index), value);
    }

    public String getEnterpriseText(int index) {
        return (String)this.getCachedValue(this.selectField(TaskFieldLists.ENTERPRISE_TEXT, index));
    }

    public void setEnterpriseText(int index, String value) {
        this.set((FieldType)this.selectField(TaskFieldLists.ENTERPRISE_TEXT, index), value);
    }

    public byte[] getEnterpriseCustomField(int index) {
        return (byte[])this.getCachedValue(this.selectField(TaskFieldLists.ENTERPRISE_CUSTOM_FIELD, index));
    }

    public void setEnterpriseCustomField(int index, byte[] value) {
        this.set((FieldType)this.selectField(TaskFieldLists.ENTERPRISE_CUSTOM_FIELD, index), value);
    }

    public void setBaselineCost(int baselineNumber, Number value) {
        this.set((FieldType)this.selectField(TaskFieldLists.BASELINE_COSTS, baselineNumber), value);
    }

    public void setBaselineDuration(int baselineNumber, Duration value) {
        this.set((FieldType)this.selectField(TaskFieldLists.BASELINE_DURATIONS, baselineNumber), value);
    }

    public void setBaselineFinish(int baselineNumber, Date value) {
        this.set((FieldType)this.selectField(TaskFieldLists.BASELINE_FINISHES, baselineNumber), value);
    }

    public void setBaselineStart(int baselineNumber, Date value) {
        this.set((FieldType)this.selectField(TaskFieldLists.BASELINE_STARTS, baselineNumber), value);
    }

    public void setBaselineWork(int baselineNumber, Duration value) {
        this.set((FieldType)this.selectField(TaskFieldLists.BASELINE_WORKS, baselineNumber), value);
    }

    public Number getBaselineCost(int baselineNumber) {
        return (Number)this.getCachedValue(this.selectField(TaskFieldLists.BASELINE_COSTS, baselineNumber));
    }

    public Duration getBaselineDuration(int baselineNumber) {
        Object result = this.getCachedValue(this.selectField(TaskFieldLists.BASELINE_DURATIONS, baselineNumber));
        if (result == null) {
            result = this.getCachedValue(this.selectField(TaskFieldLists.BASELINE_ESTIMATED_DURATIONS, baselineNumber));
        }
        if (!(result instanceof Duration)) {
            result = null;
        }
        return (Duration)result;
    }

    public String getBaselineDurationText(int baselineNumber) {
        Object result = this.getCachedValue(this.selectField(TaskFieldLists.BASELINE_DURATIONS, baselineNumber));
        if (result == null) {
            result = this.getCachedValue(this.selectField(TaskFieldLists.BASELINE_ESTIMATED_DURATIONS, baselineNumber));
        }
        if (!(result instanceof String)) {
            result = null;
        }
        return (String)result;
    }

    public void setBaselineDurationText(int baselineNumber, String value) {
        this.set((FieldType)this.selectField(TaskFieldLists.BASELINE_DURATIONS, baselineNumber), value);
    }

    public Date getBaselineFinish(int baselineNumber) {
        Object result = this.getCachedValue(this.selectField(TaskFieldLists.BASELINE_FINISHES, baselineNumber));
        if (result == null) {
            result = this.getCachedValue(this.selectField(TaskFieldLists.BASELINE_ESTIMATED_FINISHES, baselineNumber));
        }
        if (!(result instanceof Date)) {
            result = null;
        }
        return (Date)result;
    }

    public String getBaselineFinishText(int baselineNumber) {
        Object result = this.getCachedValue(this.selectField(TaskFieldLists.BASELINE_FINISHES, baselineNumber));
        if (result == null) {
            result = this.getCachedValue(this.selectField(TaskFieldLists.BASELINE_ESTIMATED_FINISHES, baselineNumber));
        }
        if (!(result instanceof String)) {
            result = null;
        }
        return (String)result;
    }

    public void setBaselineFinishText(int baselineNumber, String value) {
        this.set((FieldType)this.selectField(TaskFieldLists.BASELINE_FINISHES, baselineNumber), value);
    }

    public Date getBaselineStart(int baselineNumber) {
        Object result = this.getCachedValue(this.selectField(TaskFieldLists.BASELINE_STARTS, baselineNumber));
        if (result == null) {
            result = this.getCachedValue(this.selectField(TaskFieldLists.BASELINE_ESTIMATED_STARTS, baselineNumber));
        }
        if (!(result instanceof Date)) {
            result = null;
        }
        return (Date)result;
    }

    public String getBaselineStartText(int baselineNumber) {
        Object result = this.getCachedValue(this.selectField(TaskFieldLists.BASELINE_STARTS, baselineNumber));
        if (result == null) {
            result = this.getCachedValue(this.selectField(TaskFieldLists.BASELINE_ESTIMATED_STARTS, baselineNumber));
        }
        if (!(result instanceof String)) {
            result = null;
        }
        return (String)result;
    }

    public void setBaselineStartText(int baselineNumber, String value) {
        this.set((FieldType)this.selectField(TaskFieldLists.BASELINE_STARTS, baselineNumber), value);
    }

    public Duration getBaselineWork(int baselineNumber) {
        return (Duration)this.getCachedValue(this.selectField(TaskFieldLists.BASELINE_WORKS, baselineNumber));
    }

    public Date getCompleteThrough() {
        Date value = (Date)this.getCachedValue(TaskField.COMPLETE_THROUGH);
        if (value == null) {
            int percentComplete = NumberHelper.getInt(this.getPercentageComplete());
            switch (percentComplete) {
                case 0: {
                    break;
                }
                case 100: {
                    value = this.getActualFinish();
                    break;
                }
                default: {
                    Date actualStart = this.getActualStart();
                    Duration duration = this.getDuration();
                    if (actualStart == null || duration == null) break;
                    double durationValue = duration.getDuration() * (double)percentComplete / 100.0;
                    duration = Duration.getInstance(durationValue, duration.getUnits());
                    ProjectCalendar calendar = this.getEffectiveCalendar();
                    value = calendar.getDate(actualStart, duration, true);
                    break;
                }
            }
            this.set((FieldType)TaskField.COMPLETE_THROUGH, value);
        }
        return value;
    }

    public Date getSummaryProgress() {
        Date value = (Date)this.getCachedValue(TaskField.SUMMARY_PROGRESS);
        return value;
    }

    public void setSummaryProgress(Date value) {
        this.set((FieldType)TaskField.SUMMARY_PROGRESS, value);
    }

    public UUID getGUID() {
        return (UUID)this.getCachedValue(TaskField.GUID);
    }

    public void setGUID(UUID value) {
        this.set((FieldType)TaskField.GUID, value);
    }

    public TaskMode getTaskMode() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(TaskField.TASK_MODE)) ? TaskMode.MANUALLY_SCHEDULED : TaskMode.AUTO_SCHEDULED;
    }

    public void setTaskMode(TaskMode mode) {
        this.set((FieldType)TaskField.TASK_MODE, mode == TaskMode.MANUALLY_SCHEDULED);
    }

    public boolean getActive() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(TaskField.ACTIVE));
    }

    public void setActive(boolean active) {
        this.set((FieldType)TaskField.ACTIVE, active);
    }

    public Duration getBaselineEstimatedDuration() {
        return (Duration)this.getCachedValue(TaskField.BASELINE_ESTIMATED_DURATION);
    }

    public void setBaselineEstimatedDuration(Duration duration) {
        this.set((FieldType)TaskField.BASELINE_ESTIMATED_DURATION, duration);
    }

    public void setBaselineEstimatedDuration(int baselineNumber, Duration value) {
        this.set((FieldType)this.selectField(TaskFieldLists.BASELINE_ESTIMATED_DURATIONS, baselineNumber), value);
    }

    public Duration getBaselineEstimatedDuration(int baselineNumber) {
        Object result = this.getCachedValue(this.selectField(TaskFieldLists.BASELINE_ESTIMATED_DURATIONS, baselineNumber));
        if (!(result instanceof Duration)) {
            result = null;
        }
        return (Duration)result;
    }

    public Date getBaselineEstimatedStart() {
        return (Date)this.getCachedValue(TaskField.BASELINE_ESTIMATED_START);
    }

    public void setBaselineEstimatedStart(Date date) {
        this.set((FieldType)TaskField.BASELINE_ESTIMATED_START, date);
    }

    public Date getBaselineEstimatedStart(int baselineNumber) {
        Object result = this.getCachedValue(this.selectField(TaskFieldLists.BASELINE_ESTIMATED_STARTS, baselineNumber));
        if (!(result instanceof Date)) {
            result = null;
        }
        return (Date)result;
    }

    public void setBaselineEstimatedStart(int baselineNumber, Date value) {
        this.set((FieldType)this.selectField(TaskFieldLists.BASELINE_ESTIMATED_STARTS, baselineNumber), value);
    }

    public Date getBaselineEstimatedFinish() {
        return (Date)this.getCachedValue(TaskField.BASELINE_ESTIMATED_FINISH);
    }

    public void setBaselineEstimatedFinish(Date date) {
        this.set((FieldType)TaskField.BASELINE_ESTIMATED_FINISH, date);
    }

    public Date getBaselineEstimatedFinish(int baselineNumber) {
        Object result = this.getCachedValue(this.selectField(TaskFieldLists.BASELINE_ESTIMATED_FINISHES, baselineNumber));
        if (!(result instanceof Date)) {
            result = null;
        }
        return (Date)result;
    }

    public void setBaselineEstimatedFinish(int baselineNumber, Date value) {
        this.set((FieldType)this.selectField(TaskFieldLists.BASELINE_ESTIMATED_FINISHES, baselineNumber), value);
    }

    public void setBaselineFixedCost(Number val) {
        this.set((FieldType)TaskField.BASELINE_FIXED_COST, val);
    }

    public Number getBaselineFixedCost() {
        return (Number)this.getCachedValue(TaskField.BASELINE_FIXED_COST);
    }

    public void setBaselineFixedCost(int baselineNumber, Number value) {
        this.set((FieldType)this.selectField(TaskFieldLists.BASELINE_FIXED_COSTS, baselineNumber), value);
    }

    public Number getBaselineFixedCost(int baselineNumber) {
        return (Number)this.getCachedValue(this.selectField(TaskFieldLists.BASELINE_FIXED_COSTS, baselineNumber));
    }

    public AccrueType getBaselineFixedCostAccrual() {
        return (AccrueType)this.getCachedValue(TaskField.BASELINE_FIXED_COST_ACCRUAL);
    }

    public void setBaselineFixedCostAccrual(AccrueType type) {
        this.set((FieldType)TaskField.BASELINE_FIXED_COST_ACCRUAL, type);
    }

    public void setBaselineFixedCostAccrual(int baselineNumber, AccrueType value) {
        this.set((FieldType)this.selectField(TaskFieldLists.BASELINE_FIXED_COST_ACCRUALS, baselineNumber), value);
    }

    public AccrueType getBaselineFixedCostAccrual(int baselineNumber) {
        return (AccrueType)this.getCachedValue(this.selectField(TaskFieldLists.BASELINE_FIXED_COST_ACCRUALS, baselineNumber));
    }

    public List<ExpenseItem> getExpenseItems() {
        return (List)this.getCachedValue(TaskField.EXPENSE_ITEMS);
    }

    public void setExpenseItems(List<ExpenseItem> items) {
        this.set((FieldType)TaskField.EXPENSE_ITEMS, items);
    }

    public void setStoredMaterial(Number value) {
        this.set((FieldType)TaskField.STORED_MATERIAL, value);
    }

    public Number getStoredMaterial() {
        return (Number)this.getCachedValue(TaskField.STORED_MATERIAL);
    }

    public void setFeatureOfWork(String value) {
        this.set((FieldType)TaskField.FEATURE_OF_WORK, value);
    }

    public String getFeatureOfWork() {
        return (String)this.getCachedValue(TaskField.FEATURE_OF_WORK);
    }

    public void setCategoryOfWork(String value) {
        this.set((FieldType)TaskField.CATEGORY_OF_WORK, value);
    }

    public String getCategoryOfWork() {
        return (String)this.getCachedValue(TaskField.CATEGORY_OF_WORK);
    }

    public void setPhaseOfWork(String value) {
        this.set((FieldType)TaskField.PHASE_OF_WORK, value);
    }

    public String getPhaseOfWork() {
        return (String)this.getCachedValue(TaskField.PHASE_OF_WORK);
    }

    public void setBidItem(String value) {
        this.set((FieldType)TaskField.BID_ITEM, value);
    }

    public String getBidItem() {
        return (String)this.getCachedValue(TaskField.BID_ITEM);
    }

    public void setModOrClaimNumber(String value) {
        this.set((FieldType)TaskField.MOD_OR_CLAIM_NUMBER, value);
    }

    public String getModOrClaimNumber() {
        return (String)this.getCachedValue(TaskField.MOD_OR_CLAIM_NUMBER);
    }

    public void setWorkAreaCode(String value) {
        this.set((FieldType)TaskField.WORK_AREA_CODE, value);
    }

    public String getWorkAreaCode() {
        return (String)this.getCachedValue(TaskField.WORK_AREA_CODE);
    }

    public void setResponsibilityCode(String value) {
        this.set((FieldType)TaskField.RESPONSIBILITY_CODE, value);
    }

    public String getResponsibilityCode() {
        return (String)this.getCachedValue(TaskField.RESPONSIBILITY_CODE);
    }

    public void setWorkersPerDay(Integer value) {
        this.set((FieldType)TaskField.WORKERS_PER_DAY, value);
    }

    public Integer getWorkersPerDay() {
        return (Integer)this.getCachedValue(TaskField.WORKERS_PER_DAY);
    }

    public void setHammockCode(Boolean value) {
        this.set((FieldType)TaskField.HAMMOCK_CODE, value);
    }

    public Boolean getHammockCode() {
        return (Boolean)this.getCachedValue(TaskField.HAMMOCK_CODE);
    }

    public void setMail(String value) {
        this.set((FieldType)TaskField.MAIL, value);
    }

    public String getMail() {
        return (String)this.getCachedValue(TaskField.MAIL);
    }

    public void setSection(String value) {
        this.set((FieldType)TaskField.SECTION, value);
    }

    public String getSection() {
        return (String)this.getCachedValue(TaskField.SECTION);
    }

    public void setManager(String value) {
        this.set((FieldType)TaskField.MANAGER, value);
    }

    public String getManager() {
        return (String)this.getCachedValue(TaskField.MANAGER);
    }

    public void setDepartment(String value) {
        this.set((FieldType)TaskField.DEPARTMENT, value);
    }

    public String getDepartment() {
        return (String)this.getCachedValue(TaskField.DEPARTMENT);
    }

    public void setOverallPercentComplete(Number value) {
        this.set((FieldType)TaskField.OVERALL_PERCENT_COMPLETE, value);
    }

    public Number getOverallPercentComplete() {
        return (Number)this.getCachedValue(TaskField.OVERALL_PERCENT_COMPLETE);
    }

    public void setPlannedFinish(Date value) {
        this.set((FieldType)TaskField.PLANNED_FINISH, value);
    }

    public Date getPlannedFinish() {
        return (Date)this.getCachedValue(TaskField.PLANNED_FINISH);
    }

    public void setPlannedStart(Date value) {
        this.set((FieldType)TaskField.PLANNED_START, value);
    }

    public Date getPlannedStart() {
        return (Date)this.getCachedValue(TaskField.PLANNED_START);
    }

    public void setPlannedDuration(Duration value) {
        this.set((FieldType)TaskField.PLANNED_DURATION, value);
    }

    public Duration getPlannedDuration() {
        return (Duration)this.getCachedValue(TaskField.PLANNED_DURATION);
    }

    public void setPlannedWork(Duration value) {
        this.set((FieldType)TaskField.PLANNED_WORK, value);
    }

    public Duration getPlannedWork() {
        return (Duration)this.getCachedValue(TaskField.PLANNED_WORK);
    }

    public void setPlannedCost(Number value) {
        this.set((FieldType)TaskField.PLANNED_COST, value);
    }

    public Number getPlannedCost() {
        return (Number)this.getCachedValue(TaskField.PLANNED_COST);
    }

    public void setSuspendDate(Date value) {
        this.set((FieldType)TaskField.SUSPEND_DATE, value);
    }

    public Date getSuspendDate() {
        return (Date)this.getCachedValue(TaskField.SUSPEND_DATE);
    }

    public void setPrimaryResourceID(Integer value) {
        this.set((FieldType)TaskField.PRIMARY_RESOURCE_ID, value);
    }

    public Integer getPrimaryResourceID() {
        return (Integer)this.getCachedValue(TaskField.PRIMARY_RESOURCE_ID);
    }

    public void setActivityID(String value) {
        this.set((FieldType)TaskField.ACTIVITY_ID, value);
    }

    public String getCanonicalActivityID() {
        String projectID;
        String activityID = this.getActivityID();
        if (this.getSummary() && activityID != null && (projectID = this.getParentFile().getProjectProperties().getProjectID()) != null && activityID.startsWith(projectID)) {
            activityID = "PROJECT" + activityID.substring(projectID.length());
        }
        return activityID;
    }

    public String getActivityID() {
        return (String)this.getCachedValue(TaskField.ACTIVITY_ID);
    }

    public void setPercentCompleteType(PercentCompleteType value) {
        this.set((FieldType)TaskField.PERCENT_COMPLETE_TYPE, (Object)value);
    }

    public PercentCompleteType getPercentCompleteType() {
        return (PercentCompleteType)((Object)this.getCachedValue(TaskField.PERCENT_COMPLETE_TYPE));
    }

    public ActivityStatus getActivityStatus() {
        return (ActivityStatus)((Object)this.getCachedValue(TaskField.ACTIVITY_STATUS));
    }

    public void setActivityStatus(ActivityStatus value) {
        this.set((FieldType)TaskField.ACTIVITY_STATUS, (Object)value);
    }

    public ActivityType getActivityType() {
        return (ActivityType)((Object)this.getCachedValue(TaskField.ACTIVITY_TYPE));
    }

    public void setActivityType(ActivityType value) {
        this.set((FieldType)TaskField.ACTIVITY_TYPE, (Object)value);
    }

    public ProjectCalendar getEffectiveCalendar() {
        ProjectCalendar result = this.getCalendar();
        if (result == null) {
            result = this.getParentFile().getDefaultCalendar();
        }
        return result;
    }

    public boolean removePredecessor(Task targetTask, RelationType type, Duration lag) {
        boolean matchFound = false;
        List<Relation> predecessorList = this.getPredecessors();
        if (!predecessorList.isEmpty()) {
            List<Relation> successorList;
            if (lag == null) {
                lag = Duration.getInstance(0, TimeUnit.DAYS);
            }
            if ((matchFound = this.removeRelation(predecessorList, targetTask, type, lag)) && !(successorList = targetTask.getSuccessors()).isEmpty()) {
                this.removeRelation(successorList, this, type, lag);
            }
        }
        return matchFound;
    }

    private boolean removeRelation(List<Relation> relationList, Task targetTask, RelationType type, Duration lag) {
        boolean matchFound = false;
        for (Relation relation : relationList) {
            if (relation.getTargetTask() != targetTask || relation.getType() != type || relation.getLag().compareTo(lag) != 0) continue;
            matchFound = relationList.remove(relation);
            break;
        }
        return matchFound;
    }

    private TaskField selectField(TaskField[] fields, int index) {
        if (index < 1 || index > fields.length) {
            throw new IllegalArgumentException(index + " is not a valid field index");
        }
        return fields[index - 1];
    }

    @Override
    public Object getCachedValue(FieldType field) {
        return field == null ? null : this.m_array[field.getValue()];
    }

    @Override
    public Object getCurrentValue(FieldType field) {
        Object result = null;
        if (field != null) {
            switch ((TaskField)field) {
                case PARENT_TASK_UNIQUE_ID: {
                    result = this.m_parent == null ? Integer.valueOf(-1) : this.m_parent.getUniqueID();
                    break;
                }
                case START_VARIANCE: {
                    result = this.getStartVariance();
                    break;
                }
                case FINISH_VARIANCE: {
                    result = this.getFinishVariance();
                    break;
                }
                case START_SLACK: {
                    result = this.getStartSlack();
                    break;
                }
                case FINISH_SLACK: {
                    result = this.getFinishSlack();
                    break;
                }
                case COST_VARIANCE: {
                    result = this.getCostVariance();
                    break;
                }
                case DURATION_VARIANCE: {
                    result = this.getDurationVariance();
                    break;
                }
                case WORK_VARIANCE: {
                    result = this.getWorkVariance();
                    break;
                }
                case CV: {
                    result = this.getCV();
                    break;
                }
                case SV: {
                    result = this.getSV();
                    break;
                }
                case TOTAL_SLACK: {
                    result = this.getTotalSlack();
                    break;
                }
                case CRITICAL: {
                    result = this.getCritical();
                    break;
                }
                case COMPLETE_THROUGH: {
                    result = this.getCompleteThrough();
                    break;
                }
                default: {
                    result = this.m_array[field.getValue()];
                }
            }
        }
        return result;
    }

    @Override
    public void set(FieldType field, Object value) {
        if (field != null) {
            int index = field.getValue();
            if (this.m_eventsEnabled) {
                this.fireFieldChangeEvent((TaskField)field, this.m_array[index], value);
            }
            this.m_array[index] = value;
        }
    }

    private void fireFieldChangeEvent(TaskField field, Object oldValue, Object newValue) {
        switch (field) {
            case UNIQUE_ID: {
                ProjectFile parent = this.getParentFile();
                if (oldValue != null) {
                    parent.getTasks().unmapUniqueID((Integer)oldValue);
                }
                parent.getTasks().mapUniqueID((Integer)newValue, this);
                break;
            }
            case START: 
            case BASELINE_START: {
                this.reset(TaskField.START_VARIANCE);
                break;
            }
            case FINISH: 
            case BASELINE_FINISH: {
                this.reset(TaskField.FINISH_VARIANCE);
                break;
            }
            case COST: 
            case BASELINE_COST: {
                this.reset(TaskField.COST_VARIANCE);
                break;
            }
            case DURATION: {
                this.reset(TaskField.DURATION_VARIANCE, TaskField.COMPLETE_THROUGH);
                break;
            }
            case BASELINE_DURATION: {
                this.reset(TaskField.DURATION_VARIANCE);
                break;
            }
            case WORK: 
            case BASELINE_WORK: {
                this.reset(TaskField.WORK_VARIANCE);
                break;
            }
            case BCWP: 
            case ACWP: {
                this.reset(TaskField.CV, TaskField.SV);
                break;
            }
            case BCWS: {
                this.reset(TaskField.SV);
                break;
            }
            case START_SLACK: 
            case FINISH_SLACK: {
                this.reset(TaskField.TOTAL_SLACK, TaskField.CRITICAL);
                break;
            }
            case EARLY_FINISH: 
            case LATE_FINISH: {
                this.reset(TaskField.FINISH_SLACK, TaskField.TOTAL_SLACK, TaskField.CRITICAL);
                break;
            }
            case EARLY_START: 
            case LATE_START: {
                this.reset(TaskField.START_SLACK, TaskField.TOTAL_SLACK, TaskField.CRITICAL);
                break;
            }
            case ACTUAL_START: 
            case PERCENT_COMPLETE: {
                this.reset(TaskField.COMPLETE_THROUGH);
                break;
            }
        }
        if (this.m_listeners != null) {
            for (FieldListener listener : this.m_listeners) {
                listener.fieldChange(this, field, oldValue, newValue);
            }
        }
    }

    private void reset(TaskField ... fields) {
        Stream.of(fields).forEach(f -> {
            this.m_array[f.getValue()] = null;
        });
    }

    @Override
    public void addFieldListener(FieldListener listener) {
        if (this.m_listeners == null) {
            this.m_listeners = new ArrayList<FieldListener>();
        }
        this.m_listeners.add(listener);
    }

    @Override
    public void removeFieldListener(FieldListener listener) {
        if (this.m_listeners != null) {
            this.m_listeners.remove(listener);
        }
    }

    private void set(FieldType field, boolean value) {
        this.set(field, value ? Boolean.TRUE : Boolean.FALSE);
    }

    public String toString() {
        return "[Task id=" + this.getID() + " uniqueID=" + this.getUniqueID() + " name=" + this.getName() + (this.getExternalTask() ? " [EXTERNAL uid=" + this.getSubprojectTaskUniqueID() + " id=" + this.getSubprojectTaskID() + "]" : "]") + (this.getSubProject() == null ? "" : " project=" + this.getSubProject());
    }

    public boolean isPredecessor(Task task) {
        return this.isRelated(task, this.getPredecessors());
    }

    public boolean isSucessor(Task task) {
        return this.isRelated(task, this.getSuccessors());
    }

    public boolean hasChildTasks() {
        return !this.m_children.isEmpty();
    }

    private boolean isRelated(Task task, List<Relation> list) {
        boolean result = false;
        for (Relation relation : list) {
            if (relation.getTargetTask().getUniqueID().intValue() != task.getUniqueID().intValue()) continue;
            result = true;
            break;
        }
        return result;
    }

    public void disableEvents() {
        this.m_eventsEnabled = false;
    }

    public void enableEvents() {
        this.m_eventsEnabled = true;
    }
}

