/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.util.stream.DoubleStream;

public final class WorkContour {
    private final String m_name;
    private final int m_value;
    private final double[] m_curveValues;
    public static final WorkContour FLAT = new WorkContour("FLAT", 0, 5.0, 5.0, 5.0, 5.0, 5.0, 5.0, 5.0, 5.0, 5.0, 5.0, 5.0, 5.0, 5.0, 5.0, 5.0, 5.0, 5.0, 5.0, 5.0, 5.0);
    public static final WorkContour BACK_LOADED = new WorkContour("BACK_LOADED", 1, 3.5, 3.5, 3.5, 3.5, 3.5, 3.5, 3.5, 3.5, 3.5, 3.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5);
    public static final WorkContour FRONT_LOADED = new WorkContour("FRONT_LOADED", 2, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 6.5, 3.5, 3.5, 3.5, 3.5, 3.5, 3.5, 3.5, 3.5, 3.5, 3.5);
    public static final WorkContour DOUBLE_PEAK = new WorkContour("DOUBLE_PEAK", 3, 1.3, 2.5, 3.8, 5.1, 7.6, 10.1, 7.6, 5.1, 3.8, 2.5, 2.5, 2.5, 3.8, 5.1, 7.6, 10.1, 7.6, 5.1, 3.8, 2.5);
    public static final WorkContour EARLY_PEAK = new WorkContour("EARLY_PEAK", 4, 1.2, 2.5, 3.8, 5.0, 7.5, 10.1, 10.1, 10.1, 8.8, 7.5, 6.3, 5.0, 5.0, 5.0, 3.8, 2.5, 2.0, 1.5, 1.3, 1.0);
    public static final WorkContour LATE_PEAK = new WorkContour("LATE_PEAK", 5, 1.0, 1.3, 1.5, 2.0, 2.5, 3.8, 5.0, 5.0, 5.0, 6.3, 7.5, 8.8, 10.1, 10.1, 10.1, 7.5, 5.0, 3.8, 2.5, 1.2);
    public static final WorkContour BELL = new WorkContour("BELL", 6, 0.5, 0.5, 1.5, 1.5, 4.0, 4.0, 7.5, 7.5, 11.5, 11.5, 11.5, 11.5, 7.5, 7.5, 4.0, 4.0, 1.5, 1.5, 0.5, 0.5);
    public static final WorkContour TURTLE = new WorkContour("TURTLE", 7, 1.0, 1.0, 3.5, 3.5, 5.5, 5.5, 7.5, 7.5, 7.5, 7.5, 7.5, 7.5, 7.5, 7.5, 5.5, 5.5, 3.5, 3.5, 1.0, 1.0);
    public static final WorkContour CONTOURED = new WorkContour("CONTOURED", 8, null);
    private static final WorkContour[] TYPE_VALUES = new WorkContour[]{FLAT, BACK_LOADED, FRONT_LOADED, DOUBLE_PEAK, EARLY_PEAK, LATE_PEAK, BELL, TURTLE, CONTOURED};

    public WorkContour(String name, double ... values) {
        this(name, -1, values);
    }

    private WorkContour(String name, int type, double ... values) {
        this.m_name = name;
        this.m_value = type;
        this.m_curveValues = values;
    }

    public static WorkContour getInstance(int type) {
        if (type < 0 || type >= TYPE_VALUES.length) {
            type = WorkContour.FLAT.m_value;
        }
        return TYPE_VALUES[type];
    }

    public double[] getCurveValues() {
        return this.m_curveValues;
    }

    public String getName() {
        return this.m_name;
    }

    public boolean isContoured() {
        return this.m_curveValues == null;
    }

    public boolean isFlat() {
        return this.m_curveValues != null && DoubleStream.of(this.m_curveValues).distinct().count() == 1L;
    }

    public String toString() {
        return this.m_name;
    }
}

