/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.asta;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.mpxj.ChildTaskContainer;
import net.sf.mpxj.ConstraintType;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Day;
import net.sf.mpxj.DayType;
import net.sf.mpxj.Duration;
import net.sf.mpxj.EventManager;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.ProjectCalendarWeek;
import net.sf.mpxj.ProjectConfig;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.Relation;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.ResourceType;
import net.sf.mpxj.Task;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.asta.Row;
import net.sf.mpxj.asta.RowComparator;
import net.sf.mpxj.common.DateHelper;
import net.sf.mpxj.common.NumberHelper;

final class AstaReader {
    private ProjectFile m_project;
    private EventManager m_eventManager;
    private final Map<Task, Double> m_weights = new HashMap<Task, Double>();
    private final Set<Integer> m_deferredConstraintType = new HashSet<Integer>();
    private static final Double COMPLETE = 100.0;
    private static final Double INCOMPLETE = 0.0;
    private static final String LINE_BREAK = "|@|||";
    private static final RowComparator LEAF_COMPARATOR = new RowComparator("NATURAL_ORDER", "NATURAO_ORDER");
    private static final RowComparator BAR_COMPARATOR = new RowComparator("EXPANDED_TASK", "NATURAL_ORDER");
    private static final RelationType[] RELATION_TYPES = new RelationType[]{RelationType.FINISH_START, RelationType.START_START, RelationType.FINISH_FINISH, RelationType.START_FINISH};

    public AstaReader() {
        this.m_project = new ProjectFile();
        this.m_eventManager = this.m_project.getEventManager();
        ProjectConfig config = this.m_project.getProjectConfig();
        config.setAutoTaskUniqueID(false);
        config.setAutoResourceUniqueID(false);
        config.setAutoCalendarUniqueID(false);
        this.m_project.getProjectProperties().setFileApplication("Asta");
        this.m_project.getProjectProperties().setFileType("PP");
    }

    public ProjectFile getProject() {
        return this.m_project;
    }

    public void processProjectProperties(Row projectSummary, List<Row> progressPeriods) {
        ProjectProperties ph = this.m_project.getProjectProperties();
        if (projectSummary != null) {
            ph.setDuration(projectSummary.getDuration("DURATIONHOURS"));
            ph.setStartDate(projectSummary.getDate("STARU"));
            ph.setFinishDate(projectSummary.getDate("ENE"));
            ph.setName(projectSummary.getString("SHORT_NAME"));
            ph.setAuthor(projectSummary.getString("PROJECT_BY"));
            ph.setLastSaved(projectSummary.getDate("LAST_EDITED_DATE"));
        }
        if (progressPeriods != null) {
            Collections.sort(progressPeriods, new Comparator<Row>(){

                @Override
                public int compare(Row o1, Row o2) {
                    return o1.getInteger("PROGRESS_PERIODID").compareTo(o2.getInteger("PROGRESS_PERIODID"));
                }
            });
            Row lastProgressPeriod = progressPeriods.get(progressPeriods.size() - 1);
            ph.setStatusDate(lastProgressPeriod.getDate("REPORT_DATE"));
        }
    }

    public void processResources(List<Row> permanentRows, List<Row> consumableRows) {
        Resource resource;
        for (Row row : permanentRows) {
            resource = this.m_project.addResource();
            resource.setType(ResourceType.WORK);
            resource.setUniqueID(row.getInteger("PERMANENT_RESOURCEID"));
            resource.setEmailAddress(row.getString("EMAIL_ADDRESS"));
            resource.setName(row.getString("NASE"));
            resource.setResourceCalendar(this.deriveResourceCalendar(row.getInteger("CALENDAV")));
            resource.setMaxUnits(row.getDouble("AVAILABILITY") * 100.0);
            resource.setGeneric(row.getBoolean("CREATED_AS_FOLDER"));
            resource.setInitials(this.getInitials(resource.getName()));
        }
        for (Row row : consumableRows) {
            resource = this.m_project.addResource();
            resource.setType(ResourceType.MATERIAL);
            resource.setUniqueID(row.getInteger("CONSUMABLE_RESOURCEID"));
            resource.setCostPerUse(row.getDouble("COST_PER_USEDEFAULTSAMOUNT"));
            resource.setPeakUnits(row.getDouble("AVAILABILITY") * 100.0);
            resource.setName(row.getString("NASE"));
            resource.setResourceCalendar(this.deriveResourceCalendar(row.getInteger("CALENDAV")));
            resource.setAvailableFrom(row.getDate("AVAILABLE_FROM"));
            resource.setAvailableTo(row.getDate("AVAILABLE_TO"));
            resource.setGeneric(row.getBoolean("CREATED_AS_FOLDER"));
            resource.setMaterialLabel(row.getString("MEASUREMENT"));
            resource.setInitials(this.getInitials(resource.getName()));
        }
    }

    private ProjectCalendar deriveResourceCalendar(Integer parentCalendarID) {
        ProjectCalendar calendar = this.m_project.addDefaultDerivedCalendar();
        calendar.setUniqueID(this.m_project.getProjectConfig().getNextCalendarUniqueID());
        calendar.setParent(this.m_project.getCalendarByUniqueID(parentCalendarID));
        return calendar;
    }

    public void processTasks(List<Row> bars, List<Row> expandedTasks, List<Row> tasks, List<Row> milestones) {
        List<Row> parentBars = this.buildRowHierarchy(bars, expandedTasks, tasks, milestones);
        this.createTasks(this.m_project, "", parentBars);
        this.deriveProjectCalendar();
        this.updateStructure();
        this.updateDates();
        this.calculatePercentComplete();
    }

    /*
     * WARNING - void declaration
     */
    private List<Row> buildRowHierarchy(List<Row> bars, List<Row> expandedTasks, List<Row> tasks, List<Row> milestones) {
        void var8_12;
        Integer expandedTaskID;
        ArrayList<Row> leaves = new ArrayList<Row>();
        leaves.addAll(tasks);
        leaves.addAll(milestones);
        Collections.sort(bars, BAR_COMPARATOR);
        Collections.sort(leaves, LEAF_COMPARATOR);
        HashMap<Integer, Row> barIdToBarMap = new HashMap<Integer, Row>();
        for (Row row : bars) {
            barIdToBarMap.put(row.getInteger("BARID"), row);
        }
        HashMap<Integer, Row> expandedTaskIdToBarMap = new HashMap<Integer, Row>();
        for (Row row : expandedTasks) {
            Row bar3 = (Row)barIdToBarMap.get(row.getInteger("BAR"));
            bar3.merge(row, "_");
            expandedTaskID = bar3.getInteger("_EXPANDED_TASKID");
            expandedTaskIdToBarMap.put(expandedTaskID, bar3);
        }
        ArrayList<Row> arrayList = new ArrayList<Row>();
        for (Row bar : bars) {
            expandedTaskID = bar.getInteger("EXPANDED_TASK");
            Row parentBar = (Row)expandedTaskIdToBarMap.get(expandedTaskID);
            if (parentBar == null) {
                arrayList.add(bar);
                continue;
            }
            parentBar.addChild(bar);
        }
        for (Row leaf : leaves) {
            Integer barID = leaf.getInteger("BAR");
            Row bar4 = (Row)barIdToBarMap.get(barID);
            bar4.addChild(leaf);
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Row bar;
            bar = (Row)iterator.next();
            String barName = bar.getString("NAMH");
            if (barName != null && !barName.isEmpty() && !barName.equals("Displaced Items")) continue;
            iterator.remove();
        }
        if (arrayList.size() == 1) {
            List<Row> list = ((Row)arrayList.get(0)).getChildRows();
        }
        return var8_12;
    }

    private void createTasks(ChildTaskContainer parent, String parentName, List<Row> rows) {
        for (Row row : rows) {
            boolean rowIsBar;
            boolean bl = rowIsBar = row.getInteger("BARID") != null;
            if (rowIsBar && row.getChildRows().isEmpty()) continue;
            Task task = parent.addTask();
            if (rowIsBar) {
                if (this.skipBar(row)) {
                    this.populateLeaf(row.getString("NAMH"), row.getChildRows().get(0), task);
                } else {
                    this.populateBar(row, task);
                    this.createTasks(task, task.getName(), row.getChildRows());
                }
            } else {
                this.populateLeaf(parentName, row, task);
            }
            this.m_eventManager.fireTaskReadEvent(task);
        }
    }

    private boolean skipBar(Row row) {
        List<Row> childRows = row.getChildRows();
        return childRows.size() == 1 && childRows.get(0).getChildRows().isEmpty();
    }

    private void populateLeaf(String parentName, Row row, Task task) {
        if (row.getInteger("TASKID") != null) {
            this.populateTask(row, task);
        } else {
            this.populateMilestone(row, task);
        }
        String name = task.getName();
        if (name == null || name.isEmpty()) {
            task.setName(parentName);
        }
    }

    private void populateTask(Row row, Task task) {
        task.setUniqueID(row.getInteger("TASKID"));
        task.setResume(row.getDate("RESUME"));
        task.setActualDuration(row.getDuration("ACTUAL_DURATIONHOURS"));
        task.setEarlyStart(row.getDate("EARLY_START_DATE"));
        task.setLateStart(row.getDate("LATE_START_DATE"));
        task.setEarlyFinish(row.getDate("EARLY_END_DATE_RS"));
        task.setLateFinish(row.getDate("LATE_END_DATE_RS"));
        task.setName(row.getString("NARE"));
        task.setNotes(this.getNotes(row));
        task.setActivityID(row.getString("UNIQUE_TASK_ID"));
        task.setCalendar(this.m_project.getCalendarByUniqueID(row.getInteger("CALENDAU")));
        task.setStart(row.getDate("STARZ"));
        task.setFinish(row.getDate("ENJ"));
        Duration duration = task.getEffectiveCalendar().getDuration(task.getStart(), task.getFinish());
        duration = Duration.convertUnits(duration.getDuration(), duration.getUnits(), TimeUnit.HOURS, this.m_project.getProjectProperties());
        task.setDuration(duration);
        Double overallPercentComplete = row.getPercent("OVERALL_PERCENV_COMPLETE");
        task.setOverallPercentComplete(overallPercentComplete);
        this.m_weights.put(task, row.getDouble("OVERALL_PERCENT_COMPL_WEIGHT"));
        if (overallPercentComplete != null && overallPercentComplete > 99.0) {
            task.setActualDuration(task.getDuration());
            task.setActualStart(task.getStart());
            task.setActualFinish(task.getFinish());
            task.setPercentageComplete(COMPLETE);
        } else {
            Duration actualDuration = task.getActualDuration();
            if (duration != null && duration.getDuration() > 0.0 && actualDuration != null && actualDuration.getDuration() > 0.0) {
                task.setActualStart(task.getStart());
                double percentComplete = actualDuration.getDuration() / duration.getDuration() * 100.0;
                task.setPercentageComplete(percentComplete);
                if (percentComplete > 99.0) {
                    task.setActualFinish(task.getFinish());
                }
            } else {
                task.setPercentageComplete(INCOMPLETE);
            }
        }
        this.processConstraints(row, task);
    }

    private void populateBar(Row row, Task task) {
        Integer calendarID = row.getInteger("_CALENDAU");
        if (calendarID == null) {
            calendarID = row.getInteger("_COMMON_CALENDAR");
        }
        ProjectCalendar calendar = this.m_project.getCalendarByUniqueID(calendarID);
        task.setUniqueID(row.getInteger("BARID"));
        task.setStart(row.getDate("STARV"));
        task.setFinish(row.getDate("ENF"));
        task.setName(row.getString("NAMH"));
        task.setCalendar(calendar);
        task.setDuration(task.getEffectiveCalendar().getDuration(task.getStart(), task.getFinish()));
    }

    private void populateMilestone(Row row, Task task) {
        task.setMilestone(true);
        task.setUniqueID(row.getInteger("MILESTONEID"));
        task.setStart(row.getDate("GIVEN_DATE_TIME"));
        task.setFinish(row.getDate("GIVEN_DATE_TIME"));
        task.setEarlyStart(row.getDate("EARLY_START_DATE"));
        task.setLateStart(row.getDate("LATE_START_DATE"));
        task.setName(row.getString("NARE"));
        task.setActivityID(row.getString("UNIQUE_TASK_ID"));
        task.setCalendar(this.m_project.getCalendarByUniqueID(row.getInteger("CALENDAU")));
        task.setDuration(Duration.getInstance(0, TimeUnit.HOURS));
        if (row.getBoolean("COMPLETED")) {
            task.setPercentageComplete(COMPLETE);
            task.setActualStart(task.getStart());
            task.setActualFinish(task.getFinish());
        } else {
            task.setPercentageComplete(INCOMPLETE);
        }
        this.processConstraints(row, task);
        this.m_weights.put(task, row.getDouble("OVERALL_PERCENT_COMPL_WEIGHT"));
    }

    private void updateStructure() {
        int id = 1;
        Integer outlineLevel = 1;
        for (Task task : this.m_project.getChildTasks()) {
            id = this.updateStructure(id, task, outlineLevel);
        }
    }

    private int updateStructure(int id, Task task, Integer outlineLevel) {
        task.setID(id++);
        task.setOutlineLevel(outlineLevel);
        outlineLevel = outlineLevel + 1;
        for (Task childTask : task.getChildTasks()) {
            id = this.updateStructure(id, childTask, outlineLevel);
        }
        return id;
    }

    private void calculatePercentComplete() {
        ArrayList<Task> childTasks = new ArrayList<Task>();
        for (Task task : this.m_project.getTasks()) {
            if (!task.hasChildTasks()) continue;
            if (task.getActualFinish() != null) {
                task.setPercentageComplete(COMPLETE);
                continue;
            }
            childTasks.clear();
            this.gatherChildTasks(childTasks, task);
            double totalPercentComplete = 0.0;
            double totalOverallPercentComplete = 0.0;
            double totalWeight = 0.0;
            double totalActualDuration = 0.0;
            double totalDuration = 0.0;
            for (Task child : childTasks) {
                Duration duration;
                totalPercentComplete += NumberHelper.getDouble(child.getPercentageComplete());
                totalOverallPercentComplete += NumberHelper.getDouble(child.getOverallPercentComplete());
                totalWeight += NumberHelper.getDouble(this.m_weights.get(child));
                Duration actualDuration = child.getActualDuration();
                if (actualDuration != null) {
                    totalActualDuration += actualDuration.getDuration();
                }
                if ((duration = child.getDuration()) == null) continue;
                totalDuration += duration.getDuration();
            }
            if (totalWeight == 0.0) {
                totalWeight = 1.0;
            }
            double overallPercentComplete = totalOverallPercentComplete / totalWeight;
            task.setOverallPercentComplete(overallPercentComplete);
            if (totalDuration == 0.0) {
                if (totalPercentComplete == 0.0) continue;
                double durationPercentComplete = totalPercentComplete / (double)childTasks.size();
                task.setPercentageComplete(durationPercentComplete);
                continue;
            }
            TimeUnit units = task.getDuration().getUnits();
            double durationPercentComplete = totalActualDuration / totalDuration * 100.0;
            double duration = task.getDuration().getDuration();
            double actualDuration = duration * durationPercentComplete / 100.0;
            double remainingDuration = duration - actualDuration;
            task.setPercentageComplete(durationPercentComplete);
            task.setActualDuration(Duration.getInstance(actualDuration, units));
            task.setRemainingDuration(Duration.getInstance(remainingDuration, units));
        }
    }

    private void gatherChildTasks(List<Task> tasks, Task task) {
        if (task.hasChildTasks()) {
            task.getChildTasks().forEach(child -> this.gatherChildTasks(tasks, (Task)child));
        } else {
            tasks.add(task);
        }
    }

    private void updateDates() {
        this.m_project.getChildTasks().forEach(task -> this.updateDates((Task)task));
    }

    private void updateDates(Task parentTask) {
        if (parentTask.hasChildTasks()) {
            int finished = 0;
            Date actualStartDate = parentTask.getActualStart();
            Date actualFinishDate = parentTask.getActualFinish();
            Date earlyStartDate = parentTask.getEarlyStart();
            Date earlyFinishDate = parentTask.getEarlyFinish();
            Date lateStartDate = parentTask.getLateStart();
            Date lateFinishDate = parentTask.getLateFinish();
            for (Task task : parentTask.getChildTasks()) {
                this.updateDates(task);
                actualStartDate = DateHelper.min(actualStartDate, task.getActualStart());
                actualFinishDate = DateHelper.max(actualFinishDate, task.getActualFinish());
                earlyStartDate = DateHelper.min(earlyStartDate, task.getEarlyStart());
                earlyFinishDate = DateHelper.max(earlyFinishDate, task.getEarlyFinish());
                lateStartDate = DateHelper.min(lateStartDate, task.getLateStart());
                lateFinishDate = DateHelper.max(lateFinishDate, task.getLateFinish());
                if (task.getActualFinish() == null) continue;
                ++finished;
            }
            parentTask.setActualStart(actualStartDate);
            parentTask.setEarlyStart(earlyStartDate);
            parentTask.setEarlyFinish(earlyFinishDate);
            parentTask.setLateStart(lateStartDate);
            parentTask.setLateFinish(lateFinishDate);
            if (finished == parentTask.getChildTasks().size()) {
                parentTask.setActualFinish(actualFinishDate);
            }
        }
    }

    public void processPredecessors(List<Row> rows, List<Row> completedSections) {
        HashMap<Integer, Integer> completedSectionMap = new HashMap<Integer, Integer>();
        for (Row section : completedSections) {
            completedSectionMap.put(section.getInteger("TASK_COMPLETED_SECTIONID"), section.getInteger("TASK"));
        }
        for (Row row : rows) {
            Integer endTaskID;
            Task endTask;
            Integer startTaskID = row.getInteger("START_TASK");
            Task startTask = this.m_project.getTaskByUniqueID(startTaskID);
            if (startTask == null && (startTaskID = (Integer)completedSectionMap.get(startTaskID)) != null) {
                startTask = this.m_project.getTaskByUniqueID(startTaskID);
            }
            if ((endTask = this.m_project.getTaskByUniqueID(endTaskID = row.getInteger("END_TASK"))) == null && (endTaskID = (Integer)completedSectionMap.get(endTaskID)) != null) {
                endTask = this.m_project.getTaskByUniqueID(endTaskID);
            }
            if (startTask == null || endTask == null) continue;
            RelationType type = this.getRelationType(row.getInt("TYPI"));
            Duration startLag = row.getDuration("START_LAG_TIMEHOURS");
            Duration endLag = row.getDuration("END_LAG_TIMEHOURS");
            double startLagDuration = startLag.getDuration();
            double endLagDuration = endLag.getDuration();
            Duration lag = startLagDuration == 0.0 && endLagDuration == 0.0 ? Duration.getInstance(0, TimeUnit.HOURS) : (startLagDuration != 0.0 && endLagDuration == 0.0 ? startLag : (startLagDuration == 0.0 && endLagDuration != 0.0 ? Duration.getInstance(startLagDuration - endLagDuration, endLag.getUnits()) : Duration.getInstance(startLagDuration - endLagDuration, startLag.getUnits())));
            Relation relation = endTask.addPredecessor(startTask, type, lag);
            relation.setUniqueID(row.getInteger("LINKID"));
            if (!this.m_deferredConstraintType.contains(endTask.getUniqueID())) continue;
            endTask.setConstraintType(ConstraintType.AS_LATE_AS_POSSIBLE);
            endTask.setConstraintDate(null);
        }
    }

    public void processAssignments(List<Row> permanentAssignments) {
        for (Row row : permanentAssignments) {
            Task task = this.m_project.getTaskByUniqueID(row.getInteger("ALLOCATEE_TO"));
            Resource resource = this.m_project.getResourceByUniqueID(row.getInteger("PLAYER"));
            if (task == null || resource == null) continue;
            double percentComplete = row.getPercent("PERCENT_COMPLETE");
            Duration work = row.getWork("EFFORW");
            double actualWork = work.getDuration() * percentComplete;
            double remainingWork = work.getDuration() - actualWork;
            ResourceAssignment assignment = task.addResourceAssignment(resource);
            assignment.setUniqueID(row.getInteger("PERMANENT_SCHEDUL_ALLOCATIONID"));
            assignment.setStart(row.getDate("STARZ"));
            assignment.setFinish(row.getDate("ENJ"));
            assignment.setUnits(row.getDouble("GIVEN_ALLOCATION") * 100.0);
            assignment.setDelay(row.getDuration("DELAAHOURS"));
            assignment.setPercentageWorkComplete(percentComplete * 100.0);
            assignment.setWork(work);
            assignment.setActualWork(Duration.getInstance(actualWork, work.getUnits()));
            assignment.setRemainingWork(Duration.getInstance(remainingWork, work.getUnits()));
        }
    }

    private RelationType getRelationType(int index) {
        if (index < 0 || index > RELATION_TYPES.length) {
            index = 0;
        }
        return RELATION_TYPES[index];
    }

    private String getInitials(String name) {
        String result = null;
        if (name != null && name.length() != 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(name.charAt(0));
            int index = 1;
            while ((index = name.indexOf(32, index)) != -1) {
                if (++index < name.length() && name.charAt(index) != ' ') {
                    sb.append(name.charAt(index));
                }
                ++index;
            }
            result = sb.toString();
        }
        return result;
    }

    private void deriveProjectCalendar() {
        HashMap<ProjectCalendar, Integer> map = new HashMap<ProjectCalendar, Integer>();
        for (Task task : this.m_project.getTasks()) {
            ProjectCalendar calendar = task.getCalendar();
            map.compute(calendar, (k, v) -> v == null ? Integer.valueOf(1) : Integer.valueOf(v + 1));
        }
        int maxCount = 0;
        ProjectCalendar defaultCalendar = null;
        for (Map.Entry entry : map.entrySet()) {
            if ((Integer)entry.getValue() <= maxCount) continue;
            maxCount = (Integer)entry.getValue();
            defaultCalendar = (ProjectCalendar)entry.getKey();
        }
        if (defaultCalendar != null) {
            this.m_project.setDefaultCalendar(defaultCalendar);
            for (Task task : this.m_project.getTasks()) {
                if (task.getCalendar() != defaultCalendar) continue;
                task.setCalendar(null);
            }
        }
    }

    private void processConstraints(Row row, Task task) {
        ConstraintType constraintType = ConstraintType.AS_SOON_AS_POSSIBLE;
        Date constraintDate = null;
        switch (row.getInt("CONSTRAINU")) {
            case 0: {
                if (row.getInt("PLACEMENT") == 1) {
                    this.m_deferredConstraintType.add(task.getUniqueID());
                    constraintType = ConstraintType.START_NO_EARLIER_THAN;
                    constraintDate = row.getDate("START_CONSTRAINT_DATE");
                    break;
                }
                constraintType = ConstraintType.AS_SOON_AS_POSSIBLE;
                break;
            }
            case 1: {
                constraintType = ConstraintType.MUST_START_ON;
                constraintDate = row.getDate("START_CONSTRAINT_DATE");
                break;
            }
            case 2: {
                constraintType = ConstraintType.START_NO_LATER_THAN;
                constraintDate = row.getDate("START_CONSTRAINT_DATE");
                break;
            }
            case 3: {
                constraintType = ConstraintType.START_NO_EARLIER_THAN;
                constraintDate = row.getDate("START_CONSTRAINT_DATE");
                break;
            }
            case 4: {
                constraintType = ConstraintType.MUST_FINISH_ON;
                constraintDate = row.getDate("END_CONSTRAINT_DATE");
                break;
            }
            case 5: {
                constraintType = ConstraintType.FINISH_NO_LATER_THAN;
                constraintDate = row.getDate("END_CONSTRAINT_DATE");
                break;
            }
            case 6: {
                constraintType = ConstraintType.FINISH_NO_EARLIER_THAN;
                constraintDate = row.getDate("END_CONSTRAINT_DATE");
                break;
            }
            case 8: {
                task.setDeadline(row.getDate("END_CONSTRAINT_DATE"));
            }
        }
        task.setConstraintType(constraintType);
        task.setConstraintDate(constraintDate);
    }

    public Map<Integer, DayType> createExceptionTypeMap(List<Row> rows) {
        HashMap<Integer, DayType> map = new HashMap<Integer, DayType>();
        for (Row row : rows) {
            DayType result;
            Integer id = row.getInteger("EXCEPTIONNID");
            switch (row.getInt("UNIQUE_BIT_FIELD")) {
                case 8: 
                case 32: 
                case 128: {
                    result = DayType.WORKING;
                    break;
                }
                default: {
                    result = DayType.NON_WORKING;
                }
            }
            map.put(id, result);
        }
        return map;
    }

    public Map<Integer, Row> createWorkPatternMap(List<Row> rows) {
        HashMap<Integer, Row> map = new HashMap<Integer, Row>();
        for (Row row : rows) {
            map.put(row.getInteger("WORK_PATTERNID"), row);
        }
        return map;
    }

    public Map<Integer, List<Row>> createWorkPatternAssignmentMap(List<Row> rows) {
        HashMap<Integer, List<Row>> map = new HashMap<Integer, List<Row>>();
        for (Row row : rows) {
            Integer calendarID = row.getInteger("WORK_PATTERN_ASSIGNMENTID");
            List list = map.computeIfAbsent(calendarID, k -> new ArrayList());
            list.add(row);
        }
        return map;
    }

    public Map<Integer, List<Row>> createExceptionAssignmentMap(List<Row> rows) {
        HashMap<Integer, List<Row>> map = new HashMap<Integer, List<Row>>();
        for (Row row : rows) {
            Integer calendarID = row.getInteger("EXCEPTION_ASSIGNMENTID");
            List list = map.computeIfAbsent(calendarID, k -> new ArrayList());
            list.add(row);
        }
        return map;
    }

    public Map<Integer, List<Row>> createTimeEntryMap(List<Row> rows) {
        HashMap<Integer, List<Row>> map = new HashMap<Integer, List<Row>>();
        for (Row row : rows) {
            Integer workPatternID = row.getInteger("TIME_ENTRYID");
            List list = map.computeIfAbsent(workPatternID, k -> new ArrayList());
            list.add(row);
        }
        return map;
    }

    public void processCalendar(Row calendarRow, Map<Integer, Row> workPatternMap, Map<Integer, List<Row>> workPatternAssignmentMap, Map<Integer, List<Row>> exceptionAssignmentMap, Map<Integer, List<Row>> timeEntryMap, Map<Integer, DayType> exceptionTypeMap) {
        ProjectCalendar calendar = this.m_project.addCalendar();
        Integer dominantWorkPatternID = calendarRow.getInteger("DOMINANT_WORK_PATTERN");
        calendar.setUniqueID(calendarRow.getInteger("CALENDARID"));
        this.processWorkPattern(calendar, dominantWorkPatternID, workPatternMap, timeEntryMap, exceptionTypeMap);
        calendar.setName(calendarRow.getString("NAMK"));
        List<Row> rows = workPatternAssignmentMap.get(calendar.getUniqueID());
        if (rows != null) {
            for (Row row : rows) {
                Integer workPatternID = row.getInteger("WORK_PATTERN");
                if (workPatternID.equals(dominantWorkPatternID)) continue;
                ProjectCalendarWeek week = calendar.addWorkWeek();
                week.setDateRange(new DateRange(row.getDate("START_DATE"), row.getDate("END_DATE")));
                this.processWorkPattern(week, workPatternID, workPatternMap, timeEntryMap, exceptionTypeMap);
            }
        }
        if ((rows = exceptionAssignmentMap.get(calendar.getUniqueID())) != null) {
            for (Row row : rows) {
                Date startDate = row.getDate("STARU_DATE");
                Date endDate = row.getDate("ENE_DATE");
                if (endDate.getTime() == DateHelper.getDayStartDate(endDate).getTime()) {
                    endDate = DateHelper.addDays(endDate, -1);
                }
                calendar.addCalendarException(startDate, endDate);
            }
        }
        this.m_eventManager.fireCalendarReadEvent(calendar);
    }

    private void processWorkPattern(ProjectCalendarWeek week, Integer workPatternID, Map<Integer, Row> workPatternMap, Map<Integer, List<Row>> timeEntryMap, Map<Integer, DayType> exceptionTypeMap) {
        Row workPatternRow = workPatternMap.get(workPatternID);
        if (workPatternRow != null) {
            week.setName(workPatternRow.getString("NAMN"));
            List<Row> timeEntryRows = timeEntryMap.get(workPatternID);
            if (timeEntryRows != null) {
                long lastEndTime = Long.MIN_VALUE;
                Day currentDay = Day.SUNDAY;
                ProjectCalendarHours hours = week.addCalendarHours(currentDay);
                Arrays.fill(week.getDays(), DayType.NON_WORKING);
                for (Row row : timeEntryRows) {
                    DayType type;
                    Date startTime = row.getDate("START_TIME");
                    Date endTime = row.getDate("END_TIME");
                    if (startTime == null) {
                        startTime = DateHelper.getDayStartDate(new Date(0L));
                    }
                    if (endTime == null) {
                        endTime = DateHelper.getDayEndDate(new Date(0L));
                    }
                    if (startTime.getTime() > endTime.getTime()) {
                        endTime = DateHelper.addDays(endTime, 1);
                    }
                    if (startTime.getTime() < lastEndTime) {
                        currentDay = currentDay.getNextDay();
                        hours = week.addCalendarHours(currentDay);
                    }
                    if ((type = exceptionTypeMap.get(row.getInteger("EXCEPTIOP"))) == DayType.WORKING) {
                        hours.addRange(new DateRange(startTime, endTime));
                        week.setWorkingDay(currentDay, DayType.WORKING);
                    }
                    lastEndTime = endTime.getTime();
                }
            }
        }
    }

    private String getNotes(Row row) {
        String notes = row.getString("NOTET");
        if (notes != null) {
            if (notes.isEmpty()) {
                notes = null;
            } else if (notes.indexOf(LINE_BREAK) != -1) {
                notes = notes.replace(LINE_BREAK, "\n");
            }
        }
        return notes;
    }
}

