/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.common;

import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public final class SemVer
implements Comparable<SemVer> {
    private final int[] m_version;

    public SemVer(int ... version) {
        this.m_version = version;
    }

    public SemVer(String version) {
        this(Arrays.stream(version.split("\\.")).mapToInt(x -> Integer.parseInt(x)).toArray());
    }

    public boolean atLeast(SemVer otherVersion) {
        return this.compareTo(otherVersion) >= 0;
    }

    public boolean before(SemVer otherVersion) {
        return this.compareTo(otherVersion) < 0;
    }

    @Override
    public int compareTo(SemVer o) {
        int maxLength = Math.max(this.m_version.length, o.m_version.length);
        for (int index = 0; index < maxLength; ++index) {
            int otherValue;
            int thisValue = this.m_version.length > index ? this.m_version[index] : 0;
            int n = otherValue = o.m_version.length > index ? o.m_version[index] : 0;
            if (thisValue == otherValue) continue;
            return thisValue - otherValue;
        }
        return 0;
    }

    public String toString() {
        return IntStream.of(this.m_version).mapToObj(Integer::toString).collect(Collectors.joining("."));
    }
}

