/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.explorer;

import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class JTableExtra
extends JTable {
    private Point m_selectedCell = new Point(-1, -1);
    private int m_columnWidth = 20;

    public JTableExtra() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                JTableExtra.this.setSelectedCell(new Point(JTableExtra.this.getSelectedColumn(), JTableExtra.this.getSelectedRow()));
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                JTableExtra.this.setSelectedCell(new Point(JTableExtra.this.getSelectedColumn(), JTableExtra.this.getSelectedRow()));
                            }
                        });
                    }
                }
            }
        });
    }

    public Point getSelectedCell() {
        return this.m_selectedCell;
    }

    public void setSelectedCell(Point selectedCell) {
        this.m_selectedCell = selectedCell;
        this.firePropertyChange("selectedCell", this.m_selectedCell, this.m_selectedCell);
    }

    public int getColumnWidth() {
        return this.m_columnWidth;
    }

    public void setColumnWidth(int columnWidth) {
        this.m_columnWidth = columnWidth;
        this.firePropertyChange("columnWidth", this.m_columnWidth, this.m_columnWidth);
    }

    @Override
    public void setModel(TableModel model) {
        super.setModel(model);
        int columns = model.getColumnCount();
        TableColumnModel tableColumnModel = this.getColumnModel();
        for (int index = 0; index < columns; ++index) {
            tableColumnModel.getColumn(index).setPreferredWidth(this.m_columnWidth);
        }
    }
}

