/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.sf.mpxj.Duration;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.TimephasedCost;
import net.sf.mpxj.TimephasedItem;
import net.sf.mpxj.common.DateHelper;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.common.TimephasedCostNormaliser;

public class MPPTimephasedBaselineCostNormaliser
implements TimephasedCostNormaliser {
    @Override
    public void normalise(ProjectCalendar calendar, List<TimephasedCost> list) {
        if (!list.isEmpty()) {
            this.splitDays(calendar, list);
            this.mergeSameDay(list);
            this.mergeSameCost(list);
        }
    }

    private void splitDays(ProjectCalendar calendar, List<TimephasedCost> list) {
        ArrayList<TimephasedCost> result = new ArrayList<TimephasedCost>();
        boolean remainderInserted = false;
        block0: for (TimephasedCost assignment : list) {
            if (remainderInserted) {
                assignment.setStart(DateHelper.addDays(assignment.getStart(), 1));
                remainderInserted = false;
            }
            while (assignment != null) {
                Date startDay = DateHelper.getDayStartDate(assignment.getStart());
                Date finishDay = DateHelper.getDayStartDate(assignment.getFinish());
                if (assignment.getFinish().getTime() == finishDay.getTime()) {
                    finishDay = DateHelper.addDays(finishDay, -1);
                }
                if (startDay.getTime() == finishDay.getTime()) {
                    result.add(assignment);
                    continue block0;
                }
                TimephasedCost[] split = this.splitFirstDay(calendar, assignment);
                if (split[0] != null) {
                    result.add(split[0]);
                }
                if (assignment.equals(split[1])) continue block0;
                assignment = split[1];
            }
        }
        list.clear();
        list.addAll(result);
    }

    private TimephasedCost[] splitFirstDay(ProjectCalendar calendar, TimephasedCost assignment) {
        Date assignmentFinish;
        TimephasedCost[] result = new TimephasedCost[2];
        Date assignmentStart = assignment.getStart();
        Duration calendarWork = calendar.getWork(assignmentStart, assignmentFinish = assignment.getFinish(), TimeUnit.MINUTES);
        if (calendarWork.getDuration() != 0.0) {
            TimephasedCost split;
            double splitCost;
            Date splitFinish;
            Date splitStart;
            if (calendar.isWorkingDate(assignmentStart)) {
                splitStart = assignmentStart;
                Date splitFinishTime = calendar.getFinishTime(splitStart);
                splitFinish = DateHelper.setTime(splitStart, splitFinishTime);
                Duration calendarSplitWork = calendar.getWork(splitStart, splitFinish, TimeUnit.MINUTES);
                splitCost = ((Number)assignment.getTotalAmount()).doubleValue() * calendarSplitWork.getDuration() / calendarWork.getDuration();
                TimephasedCost split2 = new TimephasedCost();
                split2.setStart(splitStart);
                split2.setFinish(splitFinish);
                split2.setTotalAmount(splitCost);
                result[0] = split2;
            } else {
                splitFinish = assignmentStart;
                splitCost = 0.0;
            }
            splitStart = calendar.getNextWorkStart(splitFinish);
            splitFinish = assignmentFinish;
            if (splitStart.getTime() > splitFinish.getTime()) {
                split = null;
            } else {
                splitCost = ((Number)assignment.getTotalAmount()).doubleValue() - splitCost;
                split = new TimephasedCost();
                split.setStart(splitStart);
                split.setFinish(splitFinish);
                split.setTotalAmount(splitCost);
                split.setAmountPerDay(assignment.getAmountPerDay());
            }
            result[1] = split;
        }
        return result;
    }

    private void mergeSameDay(List<TimephasedCost> list) {
        ArrayList<TimephasedCost> result = new ArrayList<TimephasedCost>();
        TimephasedItem previousAssignment = null;
        for (TimephasedCost assignment : list) {
            if (previousAssignment == null) {
                assignment.setAmountPerDay(assignment.getTotalAmount());
                result.add(assignment);
            } else {
                Date previousAssignmentStart = previousAssignment.getStart();
                Date previousAssignmentStartDay = DateHelper.getDayStartDate(previousAssignmentStart);
                Date assignmentStart = assignment.getStart();
                Date assignmentStartDay = DateHelper.getDayStartDate(assignmentStart);
                if (previousAssignmentStartDay.getTime() == assignmentStartDay.getTime()) {
                    result.remove(result.size() - 1);
                    double cost = ((Number)previousAssignment.getTotalAmount()).doubleValue();
                    TimephasedCost merged = new TimephasedCost();
                    merged.setStart(previousAssignment.getStart());
                    merged.setFinish(assignment.getFinish());
                    merged.setTotalAmount(cost += ((Number)assignment.getTotalAmount()).doubleValue());
                    assignment = merged;
                }
                assignment.setAmountPerDay(assignment.getTotalAmount());
                result.add(assignment);
            }
            previousAssignment = assignment;
        }
        list.clear();
        list.addAll(result);
    }

    protected void mergeSameCost(List<TimephasedCost> list) {
        ArrayList<TimephasedCost> result = new ArrayList<TimephasedCost>();
        TimephasedItem previousAssignment = null;
        for (TimephasedCost assignment : list) {
            if (previousAssignment == null) {
                assignment.setAmountPerDay(assignment.getTotalAmount());
                result.add(assignment);
            } else {
                Number previousAssignmentCost = (Number)previousAssignment.getAmountPerDay();
                Number assignmentCost = (Number)assignment.getTotalAmount();
                if (NumberHelper.equals(previousAssignmentCost.doubleValue(), assignmentCost.doubleValue(), 0.01)) {
                    Date assignmentStart = previousAssignment.getStart();
                    Date assignmentFinish = assignment.getFinish();
                    double total = ((Number)previousAssignment.getTotalAmount()).doubleValue();
                    TimephasedCost merged = new TimephasedCost();
                    merged.setStart(assignmentStart);
                    merged.setFinish(assignmentFinish);
                    merged.setAmountPerDay(assignmentCost);
                    merged.setTotalAmount(total += assignmentCost.doubleValue());
                    result.remove(result.size() - 1);
                    assignment = merged;
                } else {
                    assignment.setAmountPerDay(assignment.getTotalAmount());
                }
                result.add(assignment);
            }
            previousAssignment = assignment;
        }
        list.clear();
        list.addAll(result);
    }
}

