/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.primavera;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.primavera.PrimaveraPMObjectSequences;
import net.sf.mpxj.primavera.PrimaveraPMProjectWriter;
import net.sf.mpxj.primavera.schema.APIBusinessObjects;
import net.sf.mpxj.primavera.schema.ObjectFactory;
import net.sf.mpxj.writer.AbstractProjectWriter;
import org.xml.sax.ContentHandler;

public final class PrimaveraPMFileWriter
extends AbstractProjectWriter {
    private boolean m_writeBaselines;
    private static JAXBContext CONTEXT;
    private static JAXBException CONTEXT_EXCEPTION;
    private static final String NILLABLE_STYLESHEET = "<xsl:stylesheet version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><xsl:output method=\"xml\" indent=\"yes\"/><xsl:template match=\"node()[not(@xsi:nil = 'true')]|@*\"><xsl:copy><xsl:apply-templates select=\"node()|@*\"/></xsl:copy></xsl:template></xsl:stylesheet>";

    public void setWriteBaselines(boolean value) {
        this.m_writeBaselines = value;
    }

    public boolean getWriteBaselines() {
        return this.m_writeBaselines;
    }

    @Override
    public void write(ProjectFile projectFile, OutputStream stream) throws IOException {
        try {
            if (CONTEXT == null) {
                throw CONTEXT_EXCEPTION;
            }
            TransformerFactory transFact = TransformerFactory.newInstance();
            TransformerHandler handler = ((SAXTransformerFactory)transFact).newTransformerHandler(new StreamSource(new ByteArrayInputStream(NILLABLE_STYLESHEET.getBytes())));
            handler.setResult(new StreamResult(stream));
            Transformer transformer = handler.getTransformer();
            try {
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            }
            catch (Exception exception) {
                // empty catch block
            }
            Marshaller marshaller = CONTEXT.createMarshaller();
            marshaller.setProperty("jaxb.schemaLocation", (Object)"");
            APIBusinessObjects apibo = new ObjectFactory().createAPIBusinessObjects();
            PrimaveraPMObjectSequences sequences = new PrimaveraPMObjectSequences();
            Integer projectObjectID = projectFile.getProjectProperties().getUniqueID() == null ? sequences.getProjectObjectID() : projectFile.getProjectProperties().getUniqueID();
            new PrimaveraPMProjectWriter(apibo, projectFile, projectObjectID, sequences).writeProject();
            if (this.m_writeBaselines) {
                projectFile.getBaselines().stream().filter(f -> f != null).forEach(baseline -> {
                    Integer baselineProjectObjectID = baseline.getProjectProperties().getUniqueID() == null ? sequences.getProjectObjectID() : baseline.getProjectProperties().getUniqueID();
                    new PrimaveraPMProjectWriter(apibo, (ProjectFile)baseline, baselineProjectObjectID, sequences).writeBaseline();
                });
            }
            marshaller.marshal((Object)apibo, (ContentHandler)handler);
        }
        catch (JAXBException ex) {
            throw new IOException(ex.toString());
        }
        catch (TransformerConfigurationException ex) {
            throw new IOException(ex.toString());
        }
    }

    static {
        try {
            System.setProperty("com.sun.xml.bind.v2.runtime.JAXBContextImpl.fastBoot", "true");
            CONTEXT = JAXBContext.newInstance((String)"net.sf.mpxj.primavera.schema", (ClassLoader)PrimaveraPMFileWriter.class.getClassLoader());
        }
        catch (JAXBException ex) {
            CONTEXT_EXCEPTION = ex;
            CONTEXT = null;
        }
    }
}

