/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.primavera.p3;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.common.FileHelper;
import net.sf.mpxj.common.FixedLengthInputStream;
import net.sf.mpxj.common.StreamHelper;
import net.sf.mpxj.primavera.common.Blast;
import net.sf.mpxj.primavera.p3.P3DatabaseReader;
import net.sf.mpxj.primavera.suretrak.SureTrakDatabaseReader;
import net.sf.mpxj.reader.AbstractProjectStreamReader;

public final class P3PRXFileReader
extends AbstractProjectStreamReader {
    @Override
    public ProjectFile read(InputStream stream) throws MPXJException {
        ProjectFile projectFile;
        File tempDir;
        block8: {
            block7: {
                tempDir = null;
                StreamHelper.skip(stream, 27000L);
                tempDir = FileHelper.createTempDir();
                while (stream.available() > 0) {
                    this.extractFile(stream, tempDir);
                }
                if (P3DatabaseReader.listProjectNames(tempDir).isEmpty()) break block7;
                ProjectFile projectFile2 = P3DatabaseReader.setProjectNameAndRead(tempDir);
                FileHelper.deleteQuietly(tempDir);
                return projectFile2;
            }
            if (SureTrakDatabaseReader.listProjectNames(tempDir).isEmpty()) break block8;
            ProjectFile projectFile3 = SureTrakDatabaseReader.setProjectNameAndRead(tempDir);
            FileHelper.deleteQuietly(tempDir);
            return projectFile3;
        }
        try {
            projectFile = null;
        }
        catch (IOException ex) {
            try {
                throw new MPXJException("Failed to parse file", ex);
            }
            catch (Throwable throwable) {
                FileHelper.deleteQuietly(tempDir);
                throw throwable;
            }
        }
        FileHelper.deleteQuietly(tempDir);
        return projectFile;
    }

    @Override
    public List<ProjectFile> readAll(InputStream inputStream) throws MPXJException {
        return Arrays.asList(this.read(inputStream));
    }

    private void extractFile(InputStream stream, File dir) throws IOException {
        byte[] header = new byte[8];
        byte[] fileName = new byte[13];
        byte[] dataSize = new byte[4];
        stream.read(header);
        stream.read(fileName);
        stream.read(dataSize);
        int dataSizeValue = this.getInt(dataSize, 0);
        String fileNameValue = this.getString(fileName, 0);
        File file = new File(dir, fileNameValue);
        if (dataSizeValue == 0) {
            FileHelper.createNewFile(file);
        } else {
            FileOutputStream os = new FileOutputStream(file);
            FixedLengthInputStream inputStream = new FixedLengthInputStream(stream, dataSizeValue);
            Blast blast = new Blast();
            blast.blast(inputStream, os);
            ((OutputStream)os).close();
        }
    }

    private int getInt(byte[] data, int offset) {
        int result = 0;
        int i = offset;
        for (int shiftBy = 0; shiftBy < 32; shiftBy += 8) {
            result |= (data[i] & 0xFF) << shiftBy;
            ++i;
        }
        return result;
    }

    private String getString(byte[] data, int offset) {
        char c;
        StringBuilder buffer = new StringBuilder();
        int loop = 0;
        while (offset + loop < data.length && (c = (char)data[offset + loop]) != '\u0000') {
            buffer.append(c);
            ++loop;
        }
        return buffer.toString();
    }
}

