/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.sdef;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.reader.AbstractProjectStreamReader;
import net.sf.mpxj.sdef.ActivityRecord;
import net.sf.mpxj.sdef.CalendarRecord;
import net.sf.mpxj.sdef.Context;
import net.sf.mpxj.sdef.HolidayRecord;
import net.sf.mpxj.sdef.PrecedenceRecord;
import net.sf.mpxj.sdef.ProgressRecord;
import net.sf.mpxj.sdef.ProjectRecord;
import net.sf.mpxj.sdef.SDEFRecord;
import net.sf.mpxj.sdef.UnitCostRecord;
import net.sf.mpxj.sdef.VolumeRecord;

public final class SDEFReader
extends AbstractProjectStreamReader {
    private static final Map<String, Class<? extends SDEFRecord>> RECORD_MAP = new HashMap<String, Class<? extends SDEFRecord>>();

    @Override
    public ProjectFile read(InputStream inputStream) throws MPXJException {
        Context context = new Context();
        ProjectFile project = context.getProject();
        project.getProjectProperties().setFileApplication("SDEF");
        project.getProjectProperties().setFileType("SDEF");
        this.addListenersToProject(project);
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        try {
            while (this.processLine(context, reader.readLine())) {
            }
        }
        catch (IOException ex) {
            throw new MPXJException("Error reading file", ex);
        }
        return project;
    }

    @Override
    public List<ProjectFile> readAll(InputStream inputStream) throws MPXJException {
        return Arrays.asList(this.read(inputStream));
    }

    private boolean processLine(Context context, String line) throws MPXJException {
        SDEFRecord record;
        if (line == null || line.startsWith("END")) {
            return false;
        }
        String recordID = line.substring(0, 4);
        Class<? extends SDEFRecord> klass = RECORD_MAP.get(recordID);
        if (klass == null) {
            throw new MPXJException("Unknown record type: " + recordID);
        }
        try {
            record = klass.newInstance();
        }
        catch (Exception e) {
            throw new MPXJException("Error reading file", e);
        }
        record.read(line);
        record.process(context);
        return true;
    }

    static {
        RECORD_MAP.put("VOLM", VolumeRecord.class);
        RECORD_MAP.put("PROJ", ProjectRecord.class);
        RECORD_MAP.put("CLDR", CalendarRecord.class);
        RECORD_MAP.put("HOLI", HolidayRecord.class);
        RECORD_MAP.put("ACTV", ActivityRecord.class);
        RECORD_MAP.put("PRED", PrecedenceRecord.class);
        RECORD_MAP.put("UNIT", UnitCostRecord.class);
        RECORD_MAP.put("PROG", ProgressRecord.class);
    }
}

