# Getting start with Plaso

Getting started with Plaso can be challenging at first. This page describes
some of the steps we recommend taking.

## I just want to run Plaso or log2timeline

If you just want to run Plaso we stronly recommend to use a [packaged release](Releases-and-roadmap.md)
unless you are the adventurous type that is familiar with troubleshooting
installation issues.

Have a look at the [User Guide](Users-Guide.md) to get familiar with running
the Plaso tools, such as log2timeline.

We also strongly recommend to first read up on various tradeoffs of timeline
analysis:

* [Targeted timelines - Part I](https://osdfir.blogspot.com/2013/02/targeted-timelines-part-i.html)
* [Pearls and pitfalls of timeline analysis](https://osdfir.blogspot.com/2021/10/pearls-and-pitfalls-of-timeline-analysis.html)

If you have questions, suggestions and want to discuss them join the general
discussions mailing list: [log2timeline-discuss](https://groups.google.com/forum/#!forum/log2timeline-discuss).

Please be mindful of people's time:

* Do not be that pushy person that demands help now or is asking for an ETA of a feature. All contributions are best effort.
* Do not assume things are broken just because you cannot get it to work. Most issues we see are caused by people not following the documented instructions.
* Always try to solve the issue yourself first. Also see [troubleshooting](../Troubleshooting.md).
* In your communication be as specific and detailed as possible. Assume others have no context about what you are asking them and reduce the amount of follow up questions others have to do to understand you.

## I want to develop Plaso

There are various ways to develop with Plaso. We expect the more common use
case that you would like to extend Plaso by adding a parser or plugin or
equivalent.

For this you'll need to use a [development release](Releases-and-roadmap.md).

Get a GitHub and Gmail account and enable 2-factor authentication.

To get started have a look at the [Developers guide](../developer/Developers-Guide.md).

Last but not least we also recommend joining the development mailing list:
[log2timeline-dev](https://groups.google.com/forum/#!forum/log2timeline-dev)

### But I don't know how to use git

* [Get started using GitHub to manage Git repositories and collaborate with others](https://docs.github.com/en/get-started/quickstart)

### But I don't know how to program in Python

* [The Python Tutorial](https://docs.python.org/3/tutorial/)
