# AUTOGENERATED! DO NOT EDIT! File to edit: async.ipynb (unless otherwise specified).

__all__ = ['async_wrap', 'asyncMap']

# Cell
import asyncio
from functools import wraps, partial

def async_wrap(func):
    @wraps(func)
    async def run(*args, loop=None, executor=None, **kwargs):
        if loop is None:
            loop = asyncio.get_running_loop()
        pfunc = partial(func, *args, **kwargs)
        return await loop.run_in_executor(executor, pfunc)
    return run


# Cell
import multiprocessing.dummy
from typing import Callable, List, Any, Iterable
from beartype import beartype
def asyncMap(f:Callable, data:Iterable[Any], threads:int = 5):
  p = multiprocessing.dummy.Pool(threads)
  return p.map(f,data)