# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/cloudfront.ipynb (unless otherwise specified).

__all__ = ['invalidate']

# Cell
import boto3, time
from beartype import beartype

# Cell
@beartype
def invalidate(distributionId:str, path:str='/*')->str:
  '''
    create a cloudfront invalidation
    parameters:
      distributionId:str: distribution id of the cf distribution
      path:str: path to invalidate, can use wildcard eg. "/*" means all path
    response:
      invalidationId:
  '''
  cf = boto3.client('cloudfront')
  # Create CloudFront invalidation
  res = cf.create_invalidation(
      DistributionId=distributionId,
      InvalidationBatch={
          'Paths': {
              'Quantity': 1,
              'Items': [
                  path
              ]
          },
          'CallerReference': str(time.time()).replace(".", "")
      }
  )
  invalidation_id = res['Invalidation']['Id']
  return invalidation_id