# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'SecretBackendConnectionCassandra',
    'SecretBackendConnectionElasticsearch',
    'SecretBackendConnectionHana',
    'SecretBackendConnectionMongodb',
    'SecretBackendConnectionMongodbatlas',
    'SecretBackendConnectionMssql',
    'SecretBackendConnectionMysql',
    'SecretBackendConnectionMysqlAurora',
    'SecretBackendConnectionMysqlLegacy',
    'SecretBackendConnectionMysqlRds',
    'SecretBackendConnectionOracle',
    'SecretBackendConnectionPostgresql',
]

@pulumi.output_type
class SecretBackendConnectionCassandra(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectTimeout":
            suggest = "connect_timeout"
        elif key == "insecureTls":
            suggest = "insecure_tls"
        elif key == "pemBundle":
            suggest = "pem_bundle"
        elif key == "pemJson":
            suggest = "pem_json"
        elif key == "protocolVersion":
            suggest = "protocol_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretBackendConnectionCassandra. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretBackendConnectionCassandra.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretBackendConnectionCassandra.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connect_timeout: Optional[int] = None,
                 hosts: Optional[Sequence[str]] = None,
                 insecure_tls: Optional[bool] = None,
                 password: Optional[str] = None,
                 pem_bundle: Optional[str] = None,
                 pem_json: Optional[str] = None,
                 port: Optional[int] = None,
                 protocol_version: Optional[int] = None,
                 tls: Optional[bool] = None,
                 username: Optional[str] = None):
        """
        :param int connect_timeout: The number of seconds to use as a connection
               timeout.
        :param Sequence[str] hosts: The hosts to connect to.
        :param bool insecure_tls: Whether to skip verification of the server
               certificate when using TLS.
        :param str password: The password to be used in the connection.
        :param str pem_bundle: Concatenated PEM blocks configuring the certificate
               chain.
        :param str pem_json: A JSON structure configuring the certificate chain.
        :param int port: The default port to connect to if no port is specified as
               part of the host.
        :param int protocol_version: The CQL protocol version to use.
        :param bool tls: Whether to use TLS when connecting to Cassandra.
        :param str username: The username to be used in the connection.
        """
        if connect_timeout is not None:
            pulumi.set(__self__, "connect_timeout", connect_timeout)
        if hosts is not None:
            pulumi.set(__self__, "hosts", hosts)
        if insecure_tls is not None:
            pulumi.set(__self__, "insecure_tls", insecure_tls)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if pem_bundle is not None:
            pulumi.set(__self__, "pem_bundle", pem_bundle)
        if pem_json is not None:
            pulumi.set(__self__, "pem_json", pem_json)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol_version is not None:
            pulumi.set(__self__, "protocol_version", protocol_version)
        if tls is not None:
            pulumi.set(__self__, "tls", tls)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="connectTimeout")
    def connect_timeout(self) -> Optional[int]:
        """
        The number of seconds to use as a connection
        timeout.
        """
        return pulumi.get(self, "connect_timeout")

    @property
    @pulumi.getter
    def hosts(self) -> Optional[Sequence[str]]:
        """
        The hosts to connect to.
        """
        return pulumi.get(self, "hosts")

    @property
    @pulumi.getter(name="insecureTls")
    def insecure_tls(self) -> Optional[bool]:
        """
        Whether to skip verification of the server
        certificate when using TLS.
        """
        return pulumi.get(self, "insecure_tls")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        The password to be used in the connection.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="pemBundle")
    def pem_bundle(self) -> Optional[str]:
        """
        Concatenated PEM blocks configuring the certificate
        chain.
        """
        return pulumi.get(self, "pem_bundle")

    @property
    @pulumi.getter(name="pemJson")
    def pem_json(self) -> Optional[str]:
        """
        A JSON structure configuring the certificate chain.
        """
        return pulumi.get(self, "pem_json")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        The default port to connect to if no port is specified as
        part of the host.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="protocolVersion")
    def protocol_version(self) -> Optional[int]:
        """
        The CQL protocol version to use.
        """
        return pulumi.get(self, "protocol_version")

    @property
    @pulumi.getter
    def tls(self) -> Optional[bool]:
        """
        Whether to use TLS when connecting to Cassandra.
        """
        return pulumi.get(self, "tls")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        The username to be used in the connection.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class SecretBackendConnectionElasticsearch(dict):
    def __init__(__self__, *,
                 password: str,
                 url: str,
                 username: str):
        """
        :param str password: The password to be used in the connection.
        :param str url: The URL for Elasticsearch's API. https requires certificate
               by trusted CA if used.
        :param str username: The username to be used in the connection.
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "url", url)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        The password to be used in the connection.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        The URL for Elasticsearch's API. https requires certificate
        by trusted CA if used.
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        The username to be used in the connection.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class SecretBackendConnectionHana(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionUrl":
            suggest = "connection_url"
        elif key == "maxConnectionLifetime":
            suggest = "max_connection_lifetime"
        elif key == "maxIdleConnections":
            suggest = "max_idle_connections"
        elif key == "maxOpenConnections":
            suggest = "max_open_connections"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretBackendConnectionHana. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretBackendConnectionHana.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretBackendConnectionHana.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_url: Optional[str] = None,
                 max_connection_lifetime: Optional[int] = None,
                 max_idle_connections: Optional[int] = None,
                 max_open_connections: Optional[int] = None):
        """
        :param str connection_url: A URL containing connection information. See
               the [Vault
               docs](https://www.vaultproject.io/api-docs/secret/databases/oracle.html#sample-payload)
               for an example.
        :param int max_connection_lifetime: The maximum number of seconds to keep
               a connection alive for.
        :param int max_idle_connections: The maximum number of idle connections to
               maintain.
        :param int max_open_connections: The maximum number of open connections to
               use.
        """
        if connection_url is not None:
            pulumi.set(__self__, "connection_url", connection_url)
        if max_connection_lifetime is not None:
            pulumi.set(__self__, "max_connection_lifetime", max_connection_lifetime)
        if max_idle_connections is not None:
            pulumi.set(__self__, "max_idle_connections", max_idle_connections)
        if max_open_connections is not None:
            pulumi.set(__self__, "max_open_connections", max_open_connections)

    @property
    @pulumi.getter(name="connectionUrl")
    def connection_url(self) -> Optional[str]:
        """
        A URL containing connection information. See
        the [Vault
        docs](https://www.vaultproject.io/api-docs/secret/databases/oracle.html#sample-payload)
        for an example.
        """
        return pulumi.get(self, "connection_url")

    @property
    @pulumi.getter(name="maxConnectionLifetime")
    def max_connection_lifetime(self) -> Optional[int]:
        """
        The maximum number of seconds to keep
        a connection alive for.
        """
        return pulumi.get(self, "max_connection_lifetime")

    @property
    @pulumi.getter(name="maxIdleConnections")
    def max_idle_connections(self) -> Optional[int]:
        """
        The maximum number of idle connections to
        maintain.
        """
        return pulumi.get(self, "max_idle_connections")

    @property
    @pulumi.getter(name="maxOpenConnections")
    def max_open_connections(self) -> Optional[int]:
        """
        The maximum number of open connections to
        use.
        """
        return pulumi.get(self, "max_open_connections")


@pulumi.output_type
class SecretBackendConnectionMongodb(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionUrl":
            suggest = "connection_url"
        elif key == "maxConnectionLifetime":
            suggest = "max_connection_lifetime"
        elif key == "maxIdleConnections":
            suggest = "max_idle_connections"
        elif key == "maxOpenConnections":
            suggest = "max_open_connections"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretBackendConnectionMongodb. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretBackendConnectionMongodb.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretBackendConnectionMongodb.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_url: Optional[str] = None,
                 max_connection_lifetime: Optional[int] = None,
                 max_idle_connections: Optional[int] = None,
                 max_open_connections: Optional[int] = None):
        """
        :param str connection_url: A URL containing connection information. See
               the [Vault
               docs](https://www.vaultproject.io/api-docs/secret/databases/oracle.html#sample-payload)
               for an example.
        :param int max_connection_lifetime: The maximum number of seconds to keep
               a connection alive for.
        :param int max_idle_connections: The maximum number of idle connections to
               maintain.
        :param int max_open_connections: The maximum number of open connections to
               use.
        """
        if connection_url is not None:
            pulumi.set(__self__, "connection_url", connection_url)
        if max_connection_lifetime is not None:
            pulumi.set(__self__, "max_connection_lifetime", max_connection_lifetime)
        if max_idle_connections is not None:
            pulumi.set(__self__, "max_idle_connections", max_idle_connections)
        if max_open_connections is not None:
            pulumi.set(__self__, "max_open_connections", max_open_connections)

    @property
    @pulumi.getter(name="connectionUrl")
    def connection_url(self) -> Optional[str]:
        """
        A URL containing connection information. See
        the [Vault
        docs](https://www.vaultproject.io/api-docs/secret/databases/oracle.html#sample-payload)
        for an example.
        """
        return pulumi.get(self, "connection_url")

    @property
    @pulumi.getter(name="maxConnectionLifetime")
    def max_connection_lifetime(self) -> Optional[int]:
        """
        The maximum number of seconds to keep
        a connection alive for.
        """
        return pulumi.get(self, "max_connection_lifetime")

    @property
    @pulumi.getter(name="maxIdleConnections")
    def max_idle_connections(self) -> Optional[int]:
        """
        The maximum number of idle connections to
        maintain.
        """
        return pulumi.get(self, "max_idle_connections")

    @property
    @pulumi.getter(name="maxOpenConnections")
    def max_open_connections(self) -> Optional[int]:
        """
        The maximum number of open connections to
        use.
        """
        return pulumi.get(self, "max_open_connections")


@pulumi.output_type
class SecretBackendConnectionMongodbatlas(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateKey":
            suggest = "private_key"
        elif key == "projectId":
            suggest = "project_id"
        elif key == "publicKey":
            suggest = "public_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretBackendConnectionMongodbatlas. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretBackendConnectionMongodbatlas.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretBackendConnectionMongodbatlas.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 private_key: str,
                 project_id: str,
                 public_key: str):
        """
        :param str private_key: The Private Programmatic API Key used to connect with MongoDB Atlas API.
        :param str project_id: The Project ID the Database User should be created within.
        :param str public_key: The Public Programmatic API Key used to authenticate with the MongoDB Atlas API.
        """
        pulumi.set(__self__, "private_key", private_key)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "public_key", public_key)

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> str:
        """
        The Private Programmatic API Key used to connect with MongoDB Atlas API.
        """
        return pulumi.get(self, "private_key")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        The Project ID the Database User should be created within.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> str:
        """
        The Public Programmatic API Key used to authenticate with the MongoDB Atlas API.
        """
        return pulumi.get(self, "public_key")


@pulumi.output_type
class SecretBackendConnectionMssql(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionUrl":
            suggest = "connection_url"
        elif key == "maxConnectionLifetime":
            suggest = "max_connection_lifetime"
        elif key == "maxIdleConnections":
            suggest = "max_idle_connections"
        elif key == "maxOpenConnections":
            suggest = "max_open_connections"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretBackendConnectionMssql. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretBackendConnectionMssql.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretBackendConnectionMssql.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_url: Optional[str] = None,
                 max_connection_lifetime: Optional[int] = None,
                 max_idle_connections: Optional[int] = None,
                 max_open_connections: Optional[int] = None):
        """
        :param str connection_url: A URL containing connection information. See
               the [Vault
               docs](https://www.vaultproject.io/api-docs/secret/databases/oracle.html#sample-payload)
               for an example.
        :param int max_connection_lifetime: The maximum number of seconds to keep
               a connection alive for.
        :param int max_idle_connections: The maximum number of idle connections to
               maintain.
        :param int max_open_connections: The maximum number of open connections to
               use.
        """
        if connection_url is not None:
            pulumi.set(__self__, "connection_url", connection_url)
        if max_connection_lifetime is not None:
            pulumi.set(__self__, "max_connection_lifetime", max_connection_lifetime)
        if max_idle_connections is not None:
            pulumi.set(__self__, "max_idle_connections", max_idle_connections)
        if max_open_connections is not None:
            pulumi.set(__self__, "max_open_connections", max_open_connections)

    @property
    @pulumi.getter(name="connectionUrl")
    def connection_url(self) -> Optional[str]:
        """
        A URL containing connection information. See
        the [Vault
        docs](https://www.vaultproject.io/api-docs/secret/databases/oracle.html#sample-payload)
        for an example.
        """
        return pulumi.get(self, "connection_url")

    @property
    @pulumi.getter(name="maxConnectionLifetime")
    def max_connection_lifetime(self) -> Optional[int]:
        """
        The maximum number of seconds to keep
        a connection alive for.
        """
        return pulumi.get(self, "max_connection_lifetime")

    @property
    @pulumi.getter(name="maxIdleConnections")
    def max_idle_connections(self) -> Optional[int]:
        """
        The maximum number of idle connections to
        maintain.
        """
        return pulumi.get(self, "max_idle_connections")

    @property
    @pulumi.getter(name="maxOpenConnections")
    def max_open_connections(self) -> Optional[int]:
        """
        The maximum number of open connections to
        use.
        """
        return pulumi.get(self, "max_open_connections")


@pulumi.output_type
class SecretBackendConnectionMysql(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionUrl":
            suggest = "connection_url"
        elif key == "maxConnectionLifetime":
            suggest = "max_connection_lifetime"
        elif key == "maxIdleConnections":
            suggest = "max_idle_connections"
        elif key == "maxOpenConnections":
            suggest = "max_open_connections"
        elif key == "tlsCa":
            suggest = "tls_ca"
        elif key == "tlsCertificateKey":
            suggest = "tls_certificate_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretBackendConnectionMysql. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretBackendConnectionMysql.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretBackendConnectionMysql.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_url: Optional[str] = None,
                 max_connection_lifetime: Optional[int] = None,
                 max_idle_connections: Optional[int] = None,
                 max_open_connections: Optional[int] = None,
                 tls_ca: Optional[str] = None,
                 tls_certificate_key: Optional[str] = None):
        """
        :param str connection_url: A URL containing connection information. See
               the [Vault
               docs](https://www.vaultproject.io/api-docs/secret/databases/oracle.html#sample-payload)
               for an example.
        :param int max_connection_lifetime: The maximum number of seconds to keep
               a connection alive for.
        :param int max_idle_connections: The maximum number of idle connections to
               maintain.
        :param int max_open_connections: The maximum number of open connections to
               use.
        :param str tls_ca: x509 CA file for validating the certificate presented by the MySQL server. Must be PEM encoded.
        :param str tls_certificate_key: x509 certificate for connecting to the database. This must be a PEM encoded version of the private key and the certificate combined.
        """
        if connection_url is not None:
            pulumi.set(__self__, "connection_url", connection_url)
        if max_connection_lifetime is not None:
            pulumi.set(__self__, "max_connection_lifetime", max_connection_lifetime)
        if max_idle_connections is not None:
            pulumi.set(__self__, "max_idle_connections", max_idle_connections)
        if max_open_connections is not None:
            pulumi.set(__self__, "max_open_connections", max_open_connections)
        if tls_ca is not None:
            pulumi.set(__self__, "tls_ca", tls_ca)
        if tls_certificate_key is not None:
            pulumi.set(__self__, "tls_certificate_key", tls_certificate_key)

    @property
    @pulumi.getter(name="connectionUrl")
    def connection_url(self) -> Optional[str]:
        """
        A URL containing connection information. See
        the [Vault
        docs](https://www.vaultproject.io/api-docs/secret/databases/oracle.html#sample-payload)
        for an example.
        """
        return pulumi.get(self, "connection_url")

    @property
    @pulumi.getter(name="maxConnectionLifetime")
    def max_connection_lifetime(self) -> Optional[int]:
        """
        The maximum number of seconds to keep
        a connection alive for.
        """
        return pulumi.get(self, "max_connection_lifetime")

    @property
    @pulumi.getter(name="maxIdleConnections")
    def max_idle_connections(self) -> Optional[int]:
        """
        The maximum number of idle connections to
        maintain.
        """
        return pulumi.get(self, "max_idle_connections")

    @property
    @pulumi.getter(name="maxOpenConnections")
    def max_open_connections(self) -> Optional[int]:
        """
        The maximum number of open connections to
        use.
        """
        return pulumi.get(self, "max_open_connections")

    @property
    @pulumi.getter(name="tlsCa")
    def tls_ca(self) -> Optional[str]:
        """
        x509 CA file for validating the certificate presented by the MySQL server. Must be PEM encoded.
        """
        return pulumi.get(self, "tls_ca")

    @property
    @pulumi.getter(name="tlsCertificateKey")
    def tls_certificate_key(self) -> Optional[str]:
        """
        x509 certificate for connecting to the database. This must be a PEM encoded version of the private key and the certificate combined.
        """
        return pulumi.get(self, "tls_certificate_key")


@pulumi.output_type
class SecretBackendConnectionMysqlAurora(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionUrl":
            suggest = "connection_url"
        elif key == "maxConnectionLifetime":
            suggest = "max_connection_lifetime"
        elif key == "maxIdleConnections":
            suggest = "max_idle_connections"
        elif key == "maxOpenConnections":
            suggest = "max_open_connections"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretBackendConnectionMysqlAurora. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretBackendConnectionMysqlAurora.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretBackendConnectionMysqlAurora.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_url: Optional[str] = None,
                 max_connection_lifetime: Optional[int] = None,
                 max_idle_connections: Optional[int] = None,
                 max_open_connections: Optional[int] = None):
        """
        :param str connection_url: A URL containing connection information. See
               the [Vault
               docs](https://www.vaultproject.io/api-docs/secret/databases/oracle.html#sample-payload)
               for an example.
        :param int max_connection_lifetime: The maximum number of seconds to keep
               a connection alive for.
        :param int max_idle_connections: The maximum number of idle connections to
               maintain.
        :param int max_open_connections: The maximum number of open connections to
               use.
        """
        if connection_url is not None:
            pulumi.set(__self__, "connection_url", connection_url)
        if max_connection_lifetime is not None:
            pulumi.set(__self__, "max_connection_lifetime", max_connection_lifetime)
        if max_idle_connections is not None:
            pulumi.set(__self__, "max_idle_connections", max_idle_connections)
        if max_open_connections is not None:
            pulumi.set(__self__, "max_open_connections", max_open_connections)

    @property
    @pulumi.getter(name="connectionUrl")
    def connection_url(self) -> Optional[str]:
        """
        A URL containing connection information. See
        the [Vault
        docs](https://www.vaultproject.io/api-docs/secret/databases/oracle.html#sample-payload)
        for an example.
        """
        return pulumi.get(self, "connection_url")

    @property
    @pulumi.getter(name="maxConnectionLifetime")
    def max_connection_lifetime(self) -> Optional[int]:
        """
        The maximum number of seconds to keep
        a connection alive for.
        """
        return pulumi.get(self, "max_connection_lifetime")

    @property
    @pulumi.getter(name="maxIdleConnections")
    def max_idle_connections(self) -> Optional[int]:
        """
        The maximum number of idle connections to
        maintain.
        """
        return pulumi.get(self, "max_idle_connections")

    @property
    @pulumi.getter(name="maxOpenConnections")
    def max_open_connections(self) -> Optional[int]:
        """
        The maximum number of open connections to
        use.
        """
        return pulumi.get(self, "max_open_connections")


@pulumi.output_type
class SecretBackendConnectionMysqlLegacy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionUrl":
            suggest = "connection_url"
        elif key == "maxConnectionLifetime":
            suggest = "max_connection_lifetime"
        elif key == "maxIdleConnections":
            suggest = "max_idle_connections"
        elif key == "maxOpenConnections":
            suggest = "max_open_connections"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretBackendConnectionMysqlLegacy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretBackendConnectionMysqlLegacy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretBackendConnectionMysqlLegacy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_url: Optional[str] = None,
                 max_connection_lifetime: Optional[int] = None,
                 max_idle_connections: Optional[int] = None,
                 max_open_connections: Optional[int] = None):
        """
        :param str connection_url: A URL containing connection information. See
               the [Vault
               docs](https://www.vaultproject.io/api-docs/secret/databases/oracle.html#sample-payload)
               for an example.
        :param int max_connection_lifetime: The maximum number of seconds to keep
               a connection alive for.
        :param int max_idle_connections: The maximum number of idle connections to
               maintain.
        :param int max_open_connections: The maximum number of open connections to
               use.
        """
        if connection_url is not None:
            pulumi.set(__self__, "connection_url", connection_url)
        if max_connection_lifetime is not None:
            pulumi.set(__self__, "max_connection_lifetime", max_connection_lifetime)
        if max_idle_connections is not None:
            pulumi.set(__self__, "max_idle_connections", max_idle_connections)
        if max_open_connections is not None:
            pulumi.set(__self__, "max_open_connections", max_open_connections)

    @property
    @pulumi.getter(name="connectionUrl")
    def connection_url(self) -> Optional[str]:
        """
        A URL containing connection information. See
        the [Vault
        docs](https://www.vaultproject.io/api-docs/secret/databases/oracle.html#sample-payload)
        for an example.
        """
        return pulumi.get(self, "connection_url")

    @property
    @pulumi.getter(name="maxConnectionLifetime")
    def max_connection_lifetime(self) -> Optional[int]:
        """
        The maximum number of seconds to keep
        a connection alive for.
        """
        return pulumi.get(self, "max_connection_lifetime")

    @property
    @pulumi.getter(name="maxIdleConnections")
    def max_idle_connections(self) -> Optional[int]:
        """
        The maximum number of idle connections to
        maintain.
        """
        return pulumi.get(self, "max_idle_connections")

    @property
    @pulumi.getter(name="maxOpenConnections")
    def max_open_connections(self) -> Optional[int]:
        """
        The maximum number of open connections to
        use.
        """
        return pulumi.get(self, "max_open_connections")


@pulumi.output_type
class SecretBackendConnectionMysqlRds(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionUrl":
            suggest = "connection_url"
        elif key == "maxConnectionLifetime":
            suggest = "max_connection_lifetime"
        elif key == "maxIdleConnections":
            suggest = "max_idle_connections"
        elif key == "maxOpenConnections":
            suggest = "max_open_connections"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretBackendConnectionMysqlRds. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretBackendConnectionMysqlRds.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretBackendConnectionMysqlRds.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_url: Optional[str] = None,
                 max_connection_lifetime: Optional[int] = None,
                 max_idle_connections: Optional[int] = None,
                 max_open_connections: Optional[int] = None):
        """
        :param str connection_url: A URL containing connection information. See
               the [Vault
               docs](https://www.vaultproject.io/api-docs/secret/databases/oracle.html#sample-payload)
               for an example.
        :param int max_connection_lifetime: The maximum number of seconds to keep
               a connection alive for.
        :param int max_idle_connections: The maximum number of idle connections to
               maintain.
        :param int max_open_connections: The maximum number of open connections to
               use.
        """
        if connection_url is not None:
            pulumi.set(__self__, "connection_url", connection_url)
        if max_connection_lifetime is not None:
            pulumi.set(__self__, "max_connection_lifetime", max_connection_lifetime)
        if max_idle_connections is not None:
            pulumi.set(__self__, "max_idle_connections", max_idle_connections)
        if max_open_connections is not None:
            pulumi.set(__self__, "max_open_connections", max_open_connections)

    @property
    @pulumi.getter(name="connectionUrl")
    def connection_url(self) -> Optional[str]:
        """
        A URL containing connection information. See
        the [Vault
        docs](https://www.vaultproject.io/api-docs/secret/databases/oracle.html#sample-payload)
        for an example.
        """
        return pulumi.get(self, "connection_url")

    @property
    @pulumi.getter(name="maxConnectionLifetime")
    def max_connection_lifetime(self) -> Optional[int]:
        """
        The maximum number of seconds to keep
        a connection alive for.
        """
        return pulumi.get(self, "max_connection_lifetime")

    @property
    @pulumi.getter(name="maxIdleConnections")
    def max_idle_connections(self) -> Optional[int]:
        """
        The maximum number of idle connections to
        maintain.
        """
        return pulumi.get(self, "max_idle_connections")

    @property
    @pulumi.getter(name="maxOpenConnections")
    def max_open_connections(self) -> Optional[int]:
        """
        The maximum number of open connections to
        use.
        """
        return pulumi.get(self, "max_open_connections")


@pulumi.output_type
class SecretBackendConnectionOracle(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionUrl":
            suggest = "connection_url"
        elif key == "maxConnectionLifetime":
            suggest = "max_connection_lifetime"
        elif key == "maxIdleConnections":
            suggest = "max_idle_connections"
        elif key == "maxOpenConnections":
            suggest = "max_open_connections"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretBackendConnectionOracle. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretBackendConnectionOracle.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretBackendConnectionOracle.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_url: Optional[str] = None,
                 max_connection_lifetime: Optional[int] = None,
                 max_idle_connections: Optional[int] = None,
                 max_open_connections: Optional[int] = None):
        """
        :param str connection_url: A URL containing connection information. See
               the [Vault
               docs](https://www.vaultproject.io/api-docs/secret/databases/oracle.html#sample-payload)
               for an example.
        :param int max_connection_lifetime: The maximum number of seconds to keep
               a connection alive for.
        :param int max_idle_connections: The maximum number of idle connections to
               maintain.
        :param int max_open_connections: The maximum number of open connections to
               use.
        """
        if connection_url is not None:
            pulumi.set(__self__, "connection_url", connection_url)
        if max_connection_lifetime is not None:
            pulumi.set(__self__, "max_connection_lifetime", max_connection_lifetime)
        if max_idle_connections is not None:
            pulumi.set(__self__, "max_idle_connections", max_idle_connections)
        if max_open_connections is not None:
            pulumi.set(__self__, "max_open_connections", max_open_connections)

    @property
    @pulumi.getter(name="connectionUrl")
    def connection_url(self) -> Optional[str]:
        """
        A URL containing connection information. See
        the [Vault
        docs](https://www.vaultproject.io/api-docs/secret/databases/oracle.html#sample-payload)
        for an example.
        """
        return pulumi.get(self, "connection_url")

    @property
    @pulumi.getter(name="maxConnectionLifetime")
    def max_connection_lifetime(self) -> Optional[int]:
        """
        The maximum number of seconds to keep
        a connection alive for.
        """
        return pulumi.get(self, "max_connection_lifetime")

    @property
    @pulumi.getter(name="maxIdleConnections")
    def max_idle_connections(self) -> Optional[int]:
        """
        The maximum number of idle connections to
        maintain.
        """
        return pulumi.get(self, "max_idle_connections")

    @property
    @pulumi.getter(name="maxOpenConnections")
    def max_open_connections(self) -> Optional[int]:
        """
        The maximum number of open connections to
        use.
        """
        return pulumi.get(self, "max_open_connections")


@pulumi.output_type
class SecretBackendConnectionPostgresql(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionUrl":
            suggest = "connection_url"
        elif key == "maxConnectionLifetime":
            suggest = "max_connection_lifetime"
        elif key == "maxIdleConnections":
            suggest = "max_idle_connections"
        elif key == "maxOpenConnections":
            suggest = "max_open_connections"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretBackendConnectionPostgresql. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretBackendConnectionPostgresql.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretBackendConnectionPostgresql.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_url: Optional[str] = None,
                 max_connection_lifetime: Optional[int] = None,
                 max_idle_connections: Optional[int] = None,
                 max_open_connections: Optional[int] = None):
        """
        :param str connection_url: A URL containing connection information. See
               the [Vault
               docs](https://www.vaultproject.io/api-docs/secret/databases/oracle.html#sample-payload)
               for an example.
        :param int max_connection_lifetime: The maximum number of seconds to keep
               a connection alive for.
        :param int max_idle_connections: The maximum number of idle connections to
               maintain.
        :param int max_open_connections: The maximum number of open connections to
               use.
        """
        if connection_url is not None:
            pulumi.set(__self__, "connection_url", connection_url)
        if max_connection_lifetime is not None:
            pulumi.set(__self__, "max_connection_lifetime", max_connection_lifetime)
        if max_idle_connections is not None:
            pulumi.set(__self__, "max_idle_connections", max_idle_connections)
        if max_open_connections is not None:
            pulumi.set(__self__, "max_open_connections", max_open_connections)

    @property
    @pulumi.getter(name="connectionUrl")
    def connection_url(self) -> Optional[str]:
        """
        A URL containing connection information. See
        the [Vault
        docs](https://www.vaultproject.io/api-docs/secret/databases/oracle.html#sample-payload)
        for an example.
        """
        return pulumi.get(self, "connection_url")

    @property
    @pulumi.getter(name="maxConnectionLifetime")
    def max_connection_lifetime(self) -> Optional[int]:
        """
        The maximum number of seconds to keep
        a connection alive for.
        """
        return pulumi.get(self, "max_connection_lifetime")

    @property
    @pulumi.getter(name="maxIdleConnections")
    def max_idle_connections(self) -> Optional[int]:
        """
        The maximum number of idle connections to
        maintain.
        """
        return pulumi.get(self, "max_idle_connections")

    @property
    @pulumi.getter(name="maxOpenConnections")
    def max_open_connections(self) -> Optional[int]:
        """
        The maximum number of open connections to
        use.
        """
        return pulumi.get(self, "max_open_connections")


