import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NatgatewayConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/natgateway#datacenter_id Natgateway#datacenter_id}
    */
    readonly datacenterId: string;
    /**
    * Name of the NAT gateway
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/natgateway#name Natgateway#name}
    */
    readonly name: string;
    /**
    * Collection of public IP addresses of the NAT gateway. Should be customer reserved IP addresses in that location
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/natgateway#public_ips Natgateway#public_ips}
    */
    readonly publicIps: string[];
    /**
    * lans block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/natgateway#lans Natgateway#lans}
    */
    readonly lans: NatgatewayLans[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/natgateway#timeouts Natgateway#timeouts}
    */
    readonly timeouts?: NatgatewayTimeouts;
}
export interface NatgatewayLans {
    /**
    * Collection of gateway IP addresses of the NAT gateway. Will be auto-generated if not provided. Should ideally be an IP belonging to the same subnet as the LAN
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/natgateway#gateway_ips Natgateway#gateway_ips}
    */
    readonly gatewayIps?: string[];
    /**
    * Id for the LAN connected to the NAT gateway
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/natgateway#id Natgateway#id}
    */
    readonly id: number;
}
export declare function natgatewayLansToTerraform(struct?: NatgatewayLans | cdktf.IResolvable): any;
export interface NatgatewayTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/natgateway#create Natgateway#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/natgateway#default Natgateway#default}
    */
    readonly default?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/natgateway#delete Natgateway#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/natgateway#update Natgateway#update}
    */
    readonly update?: string;
}
export declare function natgatewayTimeoutsToTerraform(struct?: NatgatewayTimeoutsOutputReference | NatgatewayTimeouts | cdktf.IResolvable): any;
export declare class NatgatewayTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NatgatewayTimeouts | undefined;
    set internalValue(value: NatgatewayTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _default?;
    get default(): string;
    set default(value: string);
    resetDefault(): void;
    get defaultInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/ionoscloud/r/natgateway ionoscloud_natgateway}
*/
export declare class Natgateway extends cdktf.TerraformResource {
    static readonly tfResourceType = "ionoscloud_natgateway";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/ionoscloud/r/natgateway ionoscloud_natgateway} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NatgatewayConfig
    */
    constructor(scope: Construct, id: string, config: NatgatewayConfig);
    private _datacenterId?;
    get datacenterId(): string;
    set datacenterId(value: string);
    get datacenterIdInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _publicIps?;
    get publicIps(): string[];
    set publicIps(value: string[]);
    get publicIpsInput(): string[] | undefined;
    private _lans?;
    get lans(): NatgatewayLans[] | cdktf.IResolvable;
    set lans(value: NatgatewayLans[] | cdktf.IResolvable);
    get lansInput(): cdktf.IResolvable | NatgatewayLans[] | undefined;
    private _timeouts;
    get timeouts(): NatgatewayTimeoutsOutputReference;
    putTimeouts(value: NatgatewayTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): NatgatewayTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
