# Fallowing command is used to upload to pipy
#    python setup.py register sdist upload
# Always prefer setuptools over distutils
from os import path

from setuptools import setup, find_packages

here = path.abspath(path.dirname(__file__))
setup(
    name="scaffan",
    description="",
    # Versions should comply with PEP440.  For a discussion on single-sourcing
    # the version across setup.py and the project code, see
    # http://packaging.python.org/en/latest/tutorial.html#version
    version="0.27.6",
    url="https://github.com//scaffan",
    author="Miroslav Jirik",
    author_email="miroslav.jirik@gmail.com",
    license="MIT",
    # See https://pypi.python.org/pypi?%3Aaction=list_classifiers
    classifiers=[
        # How mature is this project? Common values are
        #   3 - Alpha
        #   4 - Beta
        #   5 - Production/Stable
        "Development Status :: 3 - Alpha",
        # Indicate who your project is intended for
        "Intended Audience :: Developers",
        "Topic :: Scientific/Engineering :: Bio-Informatics",
        # Pick your license as you wish (should match "license" above)
        "License :: OSI Approved :: BSD License",
        # Specify the Python versions you support here. In particular, ensure
        # that you indicate whether you support Python 2, Python 3 or both.
        # 'Programming Language :: Python :: 2',
        # 'Programming Language :: Python :: 2.6',
        # 'Programming Language :: Python :: 2.7',
        # 'Programming Language :: Python :: 3',
        # 'Programming Language :: Python :: 3.2',
        # 'Programming Language :: Python :: 3.3',
        # 'Programming Language :: Python :: 3.4',
        "Programming Language :: Python :: 3.6",
    ],
    # What does your project relate to?
    keywords="",
    # You can just specify the packages manually here if your project is
    # simple. Or you can use find_packages().
    packages=find_packages(exclude=["dist", "docs", "tests*", "devel*"]),
    # List run-time dependencies here.  These will be installed by pip when
    # your project is installed. For an analysis of "install_requires" vs pip's
    # requirements files see:
    # https://packaging.python.org/en/latest/technical.html#install-requires-vs-requirements-files
    install_requires=[
        # 'numpy', 'conda'
    ],
    # 'SimpleITK'],  # Removed becaouse of errors when pip is installing
    dependency_links=[],
    # If there are data files included in your packages that need to be
    # installed, specify them here.  If using Python 2.6 or less, then these
    # have to be included in MANIFEST.in as well.
    package_data={
        "sample1": ["scaffan_icon256.png"],
        "": ["*.png", "*.ico", "*.joblib", "*.pkl", "*.model"],
        # "sample2": ["scaffan/scaffan_icon256.png"],
        "segmentation_model_HCTFS": ["segmentation_model_HCTFS.pkl"],
        "segmentation_model_GLCMTFS": ["segmentation_model_GLCMTFS.pkl"],
        # "segmentation_model_not_working": ["scaffan/segmentation_model.pkl"],
        "cnn_model": ["posenet_highLR.model"], # if it works the scaffan way is the right one
        "sni_area": ["SNI_area_regressor.joblib"],
        "segmentation_model_default_HCTFS": ["segmentation_model_default_HCTFS.pkl"],
        "segmentation_model_default_GLCMTFS": ["segmentation_model_default_GLCMTFS.pkl"],
        # "segmentation_model_default_not_working": ["scaffan/segmentation_model_default.pkl"],
        # "cnn_model_not_working": ["scaffan/posenet_highLR.model"],
        # "sni_area_not_working": ["scaffan/SNI_area_regressor.joblib"],
        "sni_per-pixel": ["SNI_per-pixel_regressor.joblib"],
        "cnn_model_sni": ["v1.h5"]
        # "sni_per-pixel_not_working": ["scaffan/SNI_per-pixel_regressor.joblib"],
    },
    # Although 'package_data' is the preferred approach, in some case you may
    # need to place data files outside of your packages.
    # see
    # http://docs.python.org/3.4/distutils/setupscript.html#installing-additional-files # noqa
    # In this case, 'data_file' will be installed into '<sys.prefix>/my_data'
    # data_files=[('my_data', ['data/data_file'])],
    # To provide executable scripts, use entry points in preference to the
    # "scripts" keyword. Entry points provide cross-platform support and allow
    # pip to create the appropriate form of executable for the target platform.
    # entry_points={
    #     'console_scripts': [
    #         'sample=sample:main',
    #     ],
    # },
)
