"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TriggerInvalidation = exports.Trigger = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path_1 = require("path");
const core_1 = require("@aws-cdk/core");
const constructs_1 = require("constructs");
// keep this import separate from other imports to reduce chance for merge conflicts with v2-main
// eslint-disable-next-line no-duplicate-imports, import/order
const core_2 = require("@aws-cdk/core");
/**
 * Triggers an AWS Lambda function during deployment.
 */
class Trigger extends core_2.Construct {
    constructor(scope, id, props) {
        var _b, _c;
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_triggers_TriggerProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        const handlerArn = this.determineHandlerArn(props);
        const provider = core_1.CustomResourceProvider.getOrCreateProvider(this, 'AWSCDK.TriggerCustomResourceProvider', {
            runtime: core_1.CustomResourceProviderRuntime.NODEJS_14_X,
            codeDirectory: path_1.join(__dirname, 'lambda'),
            policyStatements: [
                {
                    Effect: 'Allow',
                    Action: ['lambda:InvokeFunction'],
                    Resource: [handlerArn],
                },
            ],
        });
        new core_1.CustomResource(this, 'Default', {
            resourceType: 'Custom::Trigger',
            serviceToken: provider.serviceToken,
            properties: {
                HandlerArn: handlerArn,
            },
        });
        this.executeAfter(...(_b = props.executeAfter) !== null && _b !== void 0 ? _b : []);
        this.executeBefore(...(_c = props.executeBefore) !== null && _c !== void 0 ? _c : []);
    }
    executeAfter(...scopes) {
        constructs_1.Node.of(this).addDependency(...scopes);
    }
    executeBefore(...scopes) {
        for (const s of scopes) {
            constructs_1.Node.of(s).addDependency(this);
        }
    }
    determineHandlerArn(props) {
        return props.handler.currentVersion.functionArn;
    }
}
exports.Trigger = Trigger;
_a = JSII_RTTI_SYMBOL_1;
Trigger[_a] = { fqn: "@aws-cdk/triggers.Trigger", version: "1.156.0" };
/**
 * Determines
 */
var TriggerInvalidation;
(function (TriggerInvalidation) {
    /**
     * The trigger will be executed every time the handler (or its configuration)
     * changes. This is implemented by associated the trigger with the `currentVersion`
     * of the AWS Lambda function, which gets recreated every time the handler changes.
     */
    TriggerInvalidation["HANDLER_CHANGE"] = "WHEN_FUNCTION_CHANGES";
})(TriggerInvalidation = exports.TriggerInvalidation || (exports.TriggerInvalidation = {}));
//# sourceMappingURL=data:application/json;base64,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