from setuptools import setup, find_packages
import subprocess
import sys


def get_version():
    # VERSION.txt gets generated by the CI
    # This is used on pip install
    try:
        with open('VERSION.txt', 'r') as version_file:
            return version_file.read()
    except IOError:
        # Use version from git
        print('Using git version')

    # Uses latest git tag on local dev branch
    result = subprocess.run(['git', 'describe', '--tags'], stdout=subprocess.PIPE, stderr=subprocess.PIPE)
    if result.returncode != 0:
        print(result.stderr.decode('utf-8'), file=sys.stderr)
        raise RuntimeError('Could not get version from git')
    git_version = result.stdout.decode('utf-8').strip()
    git_version = git_version.replace('-', '.dev', 1).replace('-', '+', 1)
    return git_version


setup(name='auterion-cli',
      version=get_version(),
      description='CLI tool to interact with AuterionOS devices and apps',
      url='https://docs.auterion.com/app-development/resources/auterion-cli',
      author='Auterion',
      author_email='support@auterion.com',
      license='proprietary',
      packages=find_packages(),
      install_requires=[
          'tabulate',
          'requests',
          'requests_toolbelt',
          'zeroconf',
          'websockets',
          'packaging',
          'tqdm',
          'pyyaml',
          'jsonschema'
      ],
      python_requires='>=3.6',
      zip_safe=False,
      include_package_data=True,
      entry_points={
          'console_scripts': ['auterion-cli=auterioncli.main:main']
      })
