# coding: utf-8

"""
    Veeroute.Fieldservice

    Veeroute Field Service Engineers API  # noqa: E501

    The version of the OpenAPI document: 3.10.176203
    Contact: support@veeroute.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from vrt_lss_fieldservice.configuration import Configuration


class Order(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'key': 'str',
        'location': 'Location',
        'time_windows': 'list[TimeWindow]',
        'duration': 'float',
        'cost': 'OrderCost',
        'restrictions': 'list[str]',
        'blacklist': 'list[str]'
    }

    attribute_map = {
        'key': 'key',
        'location': 'location',
        'time_windows': 'time_windows',
        'duration': 'duration',
        'cost': 'cost',
        'restrictions': 'restrictions',
        'blacklist': 'blacklist'
    }

    def __init__(self, key=None, location=None, time_windows=None, duration=None, cost=None, restrictions=[], blacklist=[], local_vars_configuration=None):  # noqa: E501
        """Order - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._key = None
        self._location = None
        self._time_windows = None
        self._duration = None
        self._cost = None
        self._restrictions = None
        self._blacklist = None
        self.discriminator = None

        self.key = key
        self.location = location
        self.time_windows = time_windows
        self.duration = duration
        if cost is not None:
            self.cost = cost
        if restrictions is not None:
            self.restrictions = restrictions
        if blacklist is not None:
            self.blacklist = blacklist

    @property
    def key(self):
        """Gets the key of this Order.  # noqa: E501

        Unique ID.  # noqa: E501

        :return: The key of this Order.  # noqa: E501
        :rtype: str
        """
        return self._key

    @key.setter
    def key(self, key):
        """Sets the key of this Order.

        Unique ID.  # noqa: E501

        :param key: The key of this Order.  # noqa: E501
        :type key: str
        """
        if self.local_vars_configuration.client_side_validation and key is None:  # noqa: E501
            raise ValueError("Invalid value for `key`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                key is not None and len(key) > 1024):
            raise ValueError("Invalid value for `key`, length must be less than or equal to `1024`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                key is not None and len(key) < 1):
            raise ValueError("Invalid value for `key`, length must be greater than or equal to `1`")  # noqa: E501

        self._key = key

    @property
    def location(self):
        """Gets the location of this Order.  # noqa: E501


        :return: The location of this Order.  # noqa: E501
        :rtype: Location
        """
        return self._location

    @location.setter
    def location(self, location):
        """Sets the location of this Order.


        :param location: The location of this Order.  # noqa: E501
        :type location: Location
        """
        if self.local_vars_configuration.client_side_validation and location is None:  # noqa: E501
            raise ValueError("Invalid value for `location`, must not be `None`")  # noqa: E501

        self._location = location

    @property
    def time_windows(self):
        """Gets the time_windows of this Order.  # noqa: E501

        The list of possible windows for work completion.  # noqa: E501

        :return: The time_windows of this Order.  # noqa: E501
        :rtype: list[TimeWindow]
        """
        return self._time_windows

    @time_windows.setter
    def time_windows(self, time_windows):
        """Sets the time_windows of this Order.

        The list of possible windows for work completion.  # noqa: E501

        :param time_windows: The time_windows of this Order.  # noqa: E501
        :type time_windows: list[TimeWindow]
        """
        if self.local_vars_configuration.client_side_validation and time_windows is None:  # noqa: E501
            raise ValueError("Invalid value for `time_windows`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                time_windows is not None and len(time_windows) > 100):
            raise ValueError("Invalid value for `time_windows`, number of items must be less than or equal to `100`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                time_windows is not None and len(time_windows) < 1):
            raise ValueError("Invalid value for `time_windows`, number of items must be greater than or equal to `1`")  # noqa: E501

        self._time_windows = time_windows

    @property
    def duration(self):
        """Gets the duration of this Order.  # noqa: E501

        Work duration in minutes.  # noqa: E501

        :return: The duration of this Order.  # noqa: E501
        :rtype: float
        """
        return self._duration

    @duration.setter
    def duration(self, duration):
        """Sets the duration of this Order.

        Work duration in minutes.  # noqa: E501

        :param duration: The duration of this Order.  # noqa: E501
        :type duration: float
        """
        if self.local_vars_configuration.client_side_validation and duration is None:  # noqa: E501
            raise ValueError("Invalid value for `duration`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                duration is not None and duration > 43800):  # noqa: E501
            raise ValueError("Invalid value for `duration`, must be a value less than or equal to `43800`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                duration is not None and duration < 0):  # noqa: E501
            raise ValueError("Invalid value for `duration`, must be a value greater than or equal to `0`")  # noqa: E501

        self._duration = duration

    @property
    def cost(self):
        """Gets the cost of this Order.  # noqa: E501


        :return: The cost of this Order.  # noqa: E501
        :rtype: OrderCost
        """
        return self._cost

    @cost.setter
    def cost(self, cost):
        """Sets the cost of this Order.


        :param cost: The cost of this Order.  # noqa: E501
        :type cost: OrderCost
        """

        self._cost = cost

    @property
    def restrictions(self):
        """Gets the restrictions of this Order.  # noqa: E501

        Requirements list for the performer. Used for checking the compatibility of the performer and the order (work).   # noqa: E501

        :return: The restrictions of this Order.  # noqa: E501
        :rtype: list[str]
        """
        return self._restrictions

    @restrictions.setter
    def restrictions(self, restrictions):
        """Sets the restrictions of this Order.

        Requirements list for the performer. Used for checking the compatibility of the performer and the order (work).   # noqa: E501

        :param restrictions: The restrictions of this Order.  # noqa: E501
        :type restrictions: list[str]
        """
        if (self.local_vars_configuration.client_side_validation and
                restrictions is not None and len(restrictions) > 1000):
            raise ValueError("Invalid value for `restrictions`, number of items must be less than or equal to `1000`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                restrictions is not None and len(restrictions) < 0):
            raise ValueError("Invalid value for `restrictions`, number of items must be greater than or equal to `0`")  # noqa: E501

        self._restrictions = restrictions

    @property
    def blacklist(self):
        """Gets the blacklist of this Order.  # noqa: E501

        A list of requirements that the performer is not allowed to have. Used for checking the compatibility of the performer and the order (work). This list should not intersect with `performer_restrictions`.   # noqa: E501

        :return: The blacklist of this Order.  # noqa: E501
        :rtype: list[str]
        """
        return self._blacklist

    @blacklist.setter
    def blacklist(self, blacklist):
        """Sets the blacklist of this Order.

        A list of requirements that the performer is not allowed to have. Used for checking the compatibility of the performer and the order (work). This list should not intersect with `performer_restrictions`.   # noqa: E501

        :param blacklist: The blacklist of this Order.  # noqa: E501
        :type blacklist: list[str]
        """
        if (self.local_vars_configuration.client_side_validation and
                blacklist is not None and len(blacklist) > 1000):
            raise ValueError("Invalid value for `blacklist`, number of items must be less than or equal to `1000`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                blacklist is not None and len(blacklist) < 0):
            raise ValueError("Invalid value for `blacklist`, number of items must be greater than or equal to `0`")  # noqa: E501

        self._blacklist = blacklist

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Order):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Order):
            return True

        return self.to_dict() != other.to_dict()
