# Generated by Django 3.2.12 on 2022-04-24 14:35

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


def set_main_char(apps, schema_editor):
    EntryCharacter = apps.get_model('allianceauth_pve.EntryCharacter')
    User = apps.get_model(settings.AUTH_USER_MODEL)

    main_char_query = User.objects.filter(pk=models.OuterRef('user_id')).values(main_character=models.F('profile__main_character'))[:1]

    EntryCharacter.objects.all().update(
        user_character=models.Subquery(main_char_query),
    )


def add_default_role(apps, schema_editor):
    Entry = apps.get_model('allianceauth_pve.Entry')
    EntryRole = apps.get_model('allianceauth_pve.EntryRole')

    for entry in Entry.objects.all():
        role = EntryRole.objects.create(entry=entry, name='Krab', value=1)
        entry.ratting_shares.update(role=role)


class Migration(migrations.Migration):

    dependencies = [
        ('eveonline', '0015_factions'),
        ('allianceauth_pve', '0007_alter_rotation_tax_rate'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.AddField(
            model_name='entrycharacter',
            name='user_character',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='ratting_shares', to='eveonline.evecharacter'),
        ),
        migrations.RunPython(
            set_main_char,
            migrations.RunPython.noop,
        ),
        migrations.AlterField(
            model_name='entrycharacter',
            name='user_character',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='ratting_shares', to='eveonline.evecharacter'),
        ),
        migrations.RenameField(
            model_name='entrycharacter',
            old_name='share_count',
            new_name='site_count',
        ),
        migrations.CreateModel(
            name='EntryRole',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=64)),
                ('value', models.PositiveIntegerField(help_text="Relative role value. Share values are computed using this field. If there are 2 roles with 10 and 15, they'll receive 10/25 and 15/25 of the share value.", verbose_name='relative role value')),
                ('entry', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='roles', to='allianceauth_pve.entry')),
            ],
            options={
                'default_permissions': (),
            },
        ),
        migrations.AddField(
            model_name='entrycharacter',
            name='role',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.RESTRICT, related_name='shares', to='allianceauth_pve.entryrole'),
        ),
        migrations.RunPython(
            add_default_role,
            migrations.RunPython.noop,
        ),
        migrations.AlterField(
            model_name='entrycharacter',
            name='role',
            field=models.ForeignKey(on_delete=django.db.models.deletion.RESTRICT, related_name='shares', to='allianceauth_pve.entryrole'),
        ),
        migrations.RemoveField(
            model_name='entry',
            name='shares',
        ),
    ]
