# Generated by Django 4.0.5 on 2022-07-26 13:49

from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('allianceauth_pve', '0011_entryrole_unique_role_name_per_entry_and_more'),
    ]

    operations = [
        migrations.AlterModelOptions(
            name='entry',
            options={'default_permissions': (), 'verbose_name': 'entry', 'verbose_name_plural': 'entries'},
        ),
        migrations.AlterField(
            model_name='rotation',
            name='min_people_share_setup',
            field=models.PositiveSmallIntegerField(default=3, help_text='The minimum number of users in an entry to consider the helped setup valid.'),
        ),
        migrations.RunSQL(
            sql="""
            DROP VIEW IF EXISTS allianceauth_pve_setup_summary;
            CREATE VIEW allianceauth_pve_setup_summary AS
            SELECT row_number() OVER () as id,
                allianceauth_pve_rotation.id AS rotation_id,
                allianceauth_pve_entrycharacter.user_id AS user_id,
                DATE(allianceauth_pve_entry.created_at) AS entry_date,
                CASE
                    WHEN SUM(
                        CASE
                            WHEN allianceauth_pve_entrycharacter.helped_setup THEN 1
                            ELSE 0
                        END
                    ) <= allianceauth_pve_rotation.max_daily_setups THEN SUM(
                        CASE
                            WHEN allianceauth_pve_entrycharacter.helped_setup THEN 1
                            ELSE 0
                        END
                    )
                    ELSE allianceauth_pve_rotation.max_daily_setups
                END AS valid_setups
            FROM allianceauth_pve_entrycharacter
                INNER JOIN allianceauth_pve_entry ON (
                    allianceauth_pve_entrycharacter.entry_id = allianceauth_pve_entry.id
                )
                LEFT OUTER JOIN allianceauth_pve_rotation ON (
                    allianceauth_pve_entry.rotation_id = allianceauth_pve_rotation.id
                )
            WHERE allianceauth_pve_entrycharacter.entry_id IN (
                SELECT re2.entry_id
                FROM allianceauth_pve_entrycharacter re2
                    INNER JOIN allianceauth_pve_entry re ON (re2.entry_id = re.id)
                    INNER JOIN allianceauth_pve_rotation rr ON(re.rotation_id = rr.id)
                GROUP BY re2.entry_id, rr.min_people_share_setup
                HAVING COUNT(DISTINCT re2.user_id) >= rr.min_people_share_setup
            )
            GROUP BY allianceauth_pve_entrycharacter.user_id,
                DATE(allianceauth_pve_entry.created_at),
                allianceauth_pve_rotation.id;
            """,
            reverse_sql="""
            DROP VIEW IF EXISTS allianceauth_pve_setup_summary;
            CREATE VIEW allianceauth_pve_setup_summary AS
            SELECT row_number() OVER () as id,
                allianceauth_pve_rotation.id AS rotation_id,
                allianceauth_pve_entrycharacter.user_id AS user_id,
                DATE(allianceauth_pve_entry.created_at) AS entry_date,
                CASE
                    WHEN SUM(
                        CASE
                            WHEN allianceauth_pve_entrycharacter.helped_setup THEN 1
                            ELSE 0
                        END
                    ) <= allianceauth_pve_rotation.max_daily_setups THEN SUM(
                        CASE
                            WHEN allianceauth_pve_entrycharacter.helped_setup THEN 1
                            ELSE 0
                        END
                    )
                    ELSE allianceauth_pve_rotation.max_daily_setups
                END AS valid_setups
            FROM allianceauth_pve_entrycharacter
                INNER JOIN allianceauth_pve_entry ON (
                    allianceauth_pve_entrycharacter.entry_id = allianceauth_pve_entry.id
                )
                LEFT OUTER JOIN allianceauth_pve_rotation ON (
                    allianceauth_pve_entry.rotation_id = allianceauth_pve_rotation.id
                )
            WHERE allianceauth_pve_entrycharacter.entry_id IN (
                SELECT re2.entry_id
                FROM allianceauth_pve_entrycharacter re2
                    INNER JOIN allianceauth_pve_entry re ON (re2.entry_id = re.id)
                    INNER JOIN allianceauth_pve_rotation rr ON(re.rotation_id = rr.id)
                GROUP BY re2.entry_id, rr.min_people_share_setup
                HAVING COUNT(re2.id) >= rr.min_people_share_setup
            )
            GROUP BY allianceauth_pve_entrycharacter.user_id,
                DATE(allianceauth_pve_entry.created_at),
                allianceauth_pve_rotation.id;
            """
        )
    ]
