"use strict";
// Generated from the AliCloud ROS Resource Specification
Object.defineProperty(exports, "__esModule", { value: true });
exports.RosMultiZoneInstance = exports.RosInstance = void 0;
const ros = require("@alicloud/ros-cdk-core");
/**
 * Determine whether the given properties match those of a `RosInstanceProps`
 *
 * @param properties - the TypeScript properties of a `RosInstanceProps`
 *
 * @returns the result of the validation.
 */
function RosInstancePropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('instanceStorage', ros.validateNumber)(properties.instanceStorage));
    errors.collect(ros.propertyValidator('resourceGroupId', ros.validateString)(properties.resourceGroupId));
    errors.collect(ros.propertyValidator('zoneId', ros.validateString)(properties.zoneId));
    if (properties.instanceChargeType && (typeof properties.instanceChargeType) !== 'object') {
        errors.collect(ros.propertyValidator('instanceChargeType', ros.validateAllowedValues)({
            data: properties.instanceChargeType,
            allowedValues: ["PayAsYouGo", "PostPaid", "PayOnDemand", "Postpaid", "PostPay", "POSTPAY", "POST", "Subscription", "PrePaid", "Prepaid", "PrePay", "PREPAY", "PRE"],
        }));
    }
    errors.collect(ros.propertyValidator('instanceChargeType', ros.validateString)(properties.instanceChargeType));
    errors.collect(ros.propertyValidator('vSwitchId', ros.validateString)(properties.vSwitchId));
    if (properties.coldStorage && (typeof properties.coldStorage) !== 'object') {
        errors.collect(ros.propertyValidator('coldStorage', ros.validateRange)({
            data: properties.coldStorage,
            min: 800,
            max: 1000000,
        }));
    }
    errors.collect(ros.propertyValidator('coldStorage', ros.validateNumber)(properties.coldStorage));
    if (properties.period && (typeof properties.period) !== 'object') {
        errors.collect(ros.propertyValidator('period', ros.validateAllowedValues)({
            data: properties.period,
            allowedValues: [1, 2, 3, 4, 5, 6, 7, 8, 9, 12, 24, 36],
        }));
    }
    errors.collect(ros.propertyValidator('period', ros.validateNumber)(properties.period));
    errors.collect(ros.propertyValidator('diskCategory', ros.requiredValidator)(properties.diskCategory));
    if (properties.diskCategory && (typeof properties.diskCategory) !== 'object') {
        errors.collect(ros.propertyValidator('diskCategory', ros.validateAllowedValues)({
            data: properties.diskCategory,
            allowedValues: ["capacity_cloud_storage", "cloud_efficiency", "cloud_ssd", "local_hdd_pro", "local_ssd_pro"],
        }));
    }
    errors.collect(ros.propertyValidator('diskCategory', ros.validateString)(properties.diskCategory));
    errors.collect(ros.propertyValidator('instanceName', ros.requiredValidator)(properties.instanceName));
    errors.collect(ros.propertyValidator('instanceName', ros.validateString)(properties.instanceName));
    if (properties.solrNum && (typeof properties.solrNum) !== 'object') {
        errors.collect(ros.propertyValidator('solrNum', ros.validateRange)({
            data: properties.solrNum,
            min: 0,
            max: 60,
        }));
    }
    errors.collect(ros.propertyValidator('solrNum', ros.validateNumber)(properties.solrNum));
    errors.collect(ros.propertyValidator('solrSpec', ros.validateString)(properties.solrSpec));
    errors.collect(ros.propertyValidator('vpcId', ros.requiredValidator)(properties.vpcId));
    errors.collect(ros.propertyValidator('vpcId', ros.validateString)(properties.vpcId));
    if (properties.filestoreNum && (typeof properties.filestoreNum) !== 'object') {
        errors.collect(ros.propertyValidator('filestoreNum', ros.validateRange)({
            data: properties.filestoreNum,
            min: 0,
            max: 60,
        }));
    }
    errors.collect(ros.propertyValidator('filestoreNum', ros.validateNumber)(properties.filestoreNum));
    errors.collect(ros.propertyValidator('securityIpList', ros.listValidator(ros.validateString))(properties.securityIpList));
    errors.collect(ros.propertyValidator('lindormSpec', ros.validateString)(properties.lindormSpec));
    errors.collect(ros.propertyValidator('tsdbSpec', ros.validateString)(properties.tsdbSpec));
    errors.collect(ros.propertyValidator('coreSpec', ros.validateString)(properties.coreSpec));
    if (properties.lindormNum && (typeof properties.lindormNum) !== 'object') {
        errors.collect(ros.propertyValidator('lindormNum', ros.validateRange)({
            data: properties.lindormNum,
            min: 0,
            max: 400,
        }));
    }
    errors.collect(ros.propertyValidator('lindormNum', ros.validateNumber)(properties.lindormNum));
    if (properties.tsdbNum && (typeof properties.tsdbNum) !== 'object') {
        errors.collect(ros.propertyValidator('tsdbNum', ros.validateRange)({
            data: properties.tsdbNum,
            min: 0,
            max: 32,
        }));
    }
    errors.collect(ros.propertyValidator('tsdbNum', ros.validateNumber)(properties.tsdbNum));
    errors.collect(ros.propertyValidator('filestoreSpec', ros.validateString)(properties.filestoreSpec));
    if (properties.periodUnit && (typeof properties.periodUnit) !== 'object') {
        errors.collect(ros.propertyValidator('periodUnit', ros.validateAllowedValues)({
            data: properties.periodUnit,
            allowedValues: ["Month", "Year", "month", "year"],
        }));
    }
    errors.collect(ros.propertyValidator('periodUnit', ros.validateString)(properties.periodUnit));
    return errors.wrap('supplied properties not correct for "RosInstanceProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::Lindorm::Instance` resource
 *
 * @param properties - the TypeScript properties of a `RosInstanceProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::Lindorm::Instance` resource.
 */
// @ts-ignore TS6133
function rosInstancePropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosInstancePropsValidator(properties).assertSuccess();
    }
    return {
        DiskCategory: ros.stringToRosTemplate(properties.diskCategory),
        InstanceName: ros.stringToRosTemplate(properties.instanceName),
        VpcId: ros.stringToRosTemplate(properties.vpcId),
        ColdStorage: ros.numberToRosTemplate(properties.coldStorage),
        CoreSpec: ros.stringToRosTemplate(properties.coreSpec),
        FilestoreNum: ros.numberToRosTemplate(properties.filestoreNum),
        FilestoreSpec: ros.stringToRosTemplate(properties.filestoreSpec),
        InstanceChargeType: ros.stringToRosTemplate(properties.instanceChargeType),
        InstanceStorage: ros.numberToRosTemplate(properties.instanceStorage),
        LindormNum: ros.numberToRosTemplate(properties.lindormNum),
        LindormSpec: ros.stringToRosTemplate(properties.lindormSpec),
        Period: ros.numberToRosTemplate(properties.period),
        PeriodUnit: ros.stringToRosTemplate(properties.periodUnit),
        ResourceGroupId: ros.stringToRosTemplate(properties.resourceGroupId),
        SecurityIpList: ros.listMapper(ros.stringToRosTemplate)(properties.securityIpList),
        SolrNum: ros.numberToRosTemplate(properties.solrNum),
        SolrSpec: ros.stringToRosTemplate(properties.solrSpec),
        TsdbNum: ros.numberToRosTemplate(properties.tsdbNum),
        TsdbSpec: ros.stringToRosTemplate(properties.tsdbSpec),
        VSwitchId: ros.stringToRosTemplate(properties.vSwitchId),
        ZoneId: ros.stringToRosTemplate(properties.zoneId),
    };
}
/**
 * A ROS template type:  `ALIYUN::Lindorm::Instance`
 */
class RosInstance extends ros.RosResource {
    /**
     * Create a new `ALIYUN::Lindorm::Instance`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosInstance.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrInstanceId = this.getAtt('InstanceId');
        this.attrJdbcUrlList = this.getAtt('JdbcUrlList');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.diskCategory = props.diskCategory;
        this.instanceName = props.instanceName;
        this.vpcId = props.vpcId;
        this.coldStorage = props.coldStorage;
        this.coreSpec = props.coreSpec;
        this.filestoreNum = props.filestoreNum;
        this.filestoreSpec = props.filestoreSpec;
        this.instanceChargeType = props.instanceChargeType;
        this.instanceStorage = props.instanceStorage;
        this.lindormNum = props.lindormNum;
        this.lindormSpec = props.lindormSpec;
        this.period = props.period;
        this.periodUnit = props.periodUnit;
        this.resourceGroupId = props.resourceGroupId;
        this.securityIpList = props.securityIpList;
        this.solrNum = props.solrNum;
        this.solrSpec = props.solrSpec;
        this.tsdbNum = props.tsdbNum;
        this.tsdbSpec = props.tsdbSpec;
        this.vSwitchId = props.vSwitchId;
        this.zoneId = props.zoneId;
    }
    get rosProperties() {
        return {
            diskCategory: this.diskCategory,
            instanceName: this.instanceName,
            vpcId: this.vpcId,
            coldStorage: this.coldStorage,
            coreSpec: this.coreSpec,
            filestoreNum: this.filestoreNum,
            filestoreSpec: this.filestoreSpec,
            instanceChargeType: this.instanceChargeType,
            instanceStorage: this.instanceStorage,
            lindormNum: this.lindormNum,
            lindormSpec: this.lindormSpec,
            period: this.period,
            periodUnit: this.periodUnit,
            resourceGroupId: this.resourceGroupId,
            securityIpList: this.securityIpList,
            solrNum: this.solrNum,
            solrSpec: this.solrSpec,
            tsdbNum: this.tsdbNum,
            tsdbSpec: this.tsdbSpec,
            vSwitchId: this.vSwitchId,
            zoneId: this.zoneId,
        };
    }
    renderProperties(props) {
        return rosInstancePropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosInstance = RosInstance;
/**
 * The resource type name for this resource class.
 */
RosInstance.ROS_RESOURCE_TYPE_NAME = "ALIYUN::Lindorm::Instance";
/**
 * Determine whether the given properties match those of a `RosMultiZoneInstanceProps`
 *
 * @param properties - the TypeScript properties of a `RosMultiZoneInstanceProps`
 *
 * @returns the result of the validation.
 */
function RosMultiZoneInstancePropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('standbyZoneId', ros.validateString)(properties.standbyZoneId));
    errors.collect(ros.propertyValidator('resourceGroupId', ros.validateString)(properties.resourceGroupId));
    if (properties.instanceChargeType && (typeof properties.instanceChargeType) !== 'object') {
        errors.collect(ros.propertyValidator('instanceChargeType', ros.validateAllowedValues)({
            data: properties.instanceChargeType,
            allowedValues: ["PayAsYouGo", "PostPaid", "PayOnDemand", "Postpaid", "PostPay", "POSTPAY", "POST", "Subscription", "PrePaid", "Prepaid", "PrePay", "PREPAY", "PRE"],
        }));
    }
    errors.collect(ros.propertyValidator('instanceChargeType', ros.validateString)(properties.instanceChargeType));
    if (properties.logDiskCategory && (typeof properties.logDiskCategory) !== 'object') {
        errors.collect(ros.propertyValidator('logDiskCategory', ros.validateAllowedValues)({
            data: properties.logDiskCategory,
            allowedValues: ["cloud_efficiency", "cloud_essd"],
        }));
    }
    errors.collect(ros.propertyValidator('logDiskCategory', ros.validateString)(properties.logDiskCategory));
    errors.collect(ros.propertyValidator('standbyVSwitchId', ros.validateString)(properties.standbyVSwitchId));
    if (properties.solrNum && (typeof properties.solrNum) !== 'object') {
        errors.collect(ros.propertyValidator('solrNum', ros.validateRange)({
            data: properties.solrNum,
            min: 0,
            max: 60,
        }));
    }
    errors.collect(ros.propertyValidator('solrNum', ros.validateNumber)(properties.solrNum));
    errors.collect(ros.propertyValidator('solrSpec', ros.validateString)(properties.solrSpec));
    errors.collect(ros.propertyValidator('coreSpec', ros.validateString)(properties.coreSpec));
    errors.collect(ros.propertyValidator('filestoreSpec', ros.validateString)(properties.filestoreSpec));
    if (properties.tsdbNum && (typeof properties.tsdbNum) !== 'object') {
        errors.collect(ros.propertyValidator('tsdbNum', ros.validateRange)({
            data: properties.tsdbNum,
            min: 0,
            max: 32,
        }));
    }
    errors.collect(ros.propertyValidator('tsdbNum', ros.validateNumber)(properties.tsdbNum));
    errors.collect(ros.propertyValidator('arbiterZoneId', ros.validateString)(properties.arbiterZoneId));
    errors.collect(ros.propertyValidator('primaryZoneId', ros.validateString)(properties.primaryZoneId));
    errors.collect(ros.propertyValidator('multiZoneCombination', ros.validateString)(properties.multiZoneCombination));
    if (properties.coreSingleStorage && (typeof properties.coreSingleStorage) !== 'object') {
        errors.collect(ros.propertyValidator('coreSingleStorage', ros.validateRange)({
            data: properties.coreSingleStorage,
            min: 400,
            max: 64000,
        }));
    }
    errors.collect(ros.propertyValidator('coreSingleStorage', ros.validateNumber)(properties.coreSingleStorage));
    if (properties.coldStorage && (typeof properties.coldStorage) !== 'object') {
        errors.collect(ros.propertyValidator('coldStorage', ros.validateRange)({
            data: properties.coldStorage,
            min: 800,
            max: 1000000,
        }));
    }
    errors.collect(ros.propertyValidator('coldStorage', ros.validateNumber)(properties.coldStorage));
    errors.collect(ros.propertyValidator('diskCategory', ros.requiredValidator)(properties.diskCategory));
    if (properties.diskCategory && (typeof properties.diskCategory) !== 'object') {
        errors.collect(ros.propertyValidator('diskCategory', ros.validateAllowedValues)({
            data: properties.diskCategory,
            allowedValues: ["capacity_cloud_storage", "cloud_efficiency", "cloud_ssd", "local_hdd_pro", "local_ssd_pro"],
        }));
    }
    errors.collect(ros.propertyValidator('diskCategory', ros.validateString)(properties.diskCategory));
    errors.collect(ros.propertyValidator('logSpec', ros.validateString)(properties.logSpec));
    if (properties.period && (typeof properties.period) !== 'object') {
        errors.collect(ros.propertyValidator('period', ros.validateAllowedValues)({
            data: properties.period,
            allowedValues: [1, 2, 3, 4, 5, 6, 7, 8, 9, 12, 24, 36],
        }));
    }
    errors.collect(ros.propertyValidator('period', ros.validateNumber)(properties.period));
    errors.collect(ros.propertyValidator('primaryVSwitchId', ros.validateString)(properties.primaryVSwitchId));
    errors.collect(ros.propertyValidator('arbiterVSwitchId', ros.validateString)(properties.arbiterVSwitchId));
    errors.collect(ros.propertyValidator('instanceName', ros.requiredValidator)(properties.instanceName));
    errors.collect(ros.propertyValidator('instanceName', ros.validateString)(properties.instanceName));
    if (properties.filestoreNum && (typeof properties.filestoreNum) !== 'object') {
        errors.collect(ros.propertyValidator('filestoreNum', ros.validateRange)({
            data: properties.filestoreNum,
            min: 0,
            max: 60,
        }));
    }
    errors.collect(ros.propertyValidator('filestoreNum', ros.validateNumber)(properties.filestoreNum));
    errors.collect(ros.propertyValidator('vpcId', ros.requiredValidator)(properties.vpcId));
    errors.collect(ros.propertyValidator('vpcId', ros.validateString)(properties.vpcId));
    errors.collect(ros.propertyValidator('securityIpList', ros.listValidator(ros.validateString))(properties.securityIpList));
    errors.collect(ros.propertyValidator('lindormSpec', ros.validateString)(properties.lindormSpec));
    errors.collect(ros.propertyValidator('tsdbSpec', ros.validateString)(properties.tsdbSpec));
    if (properties.logSingleStorage && (typeof properties.logSingleStorage) !== 'object') {
        errors.collect(ros.propertyValidator('logSingleStorage', ros.validateRange)({
            data: properties.logSingleStorage,
            min: 400,
            max: 64000,
        }));
    }
    errors.collect(ros.propertyValidator('logSingleStorage', ros.validateNumber)(properties.logSingleStorage));
    if (properties.lindormNum && (typeof properties.lindormNum) !== 'object') {
        errors.collect(ros.propertyValidator('lindormNum', ros.validateRange)({
            data: properties.lindormNum,
            min: 0,
            max: 400,
        }));
    }
    errors.collect(ros.propertyValidator('lindormNum', ros.validateNumber)(properties.lindormNum));
    if (properties.logNum && (typeof properties.logNum) !== 'object') {
        errors.collect(ros.propertyValidator('logNum', ros.validateRange)({
            data: properties.logNum,
            min: 4,
            max: 400,
        }));
    }
    errors.collect(ros.propertyValidator('logNum', ros.validateNumber)(properties.logNum));
    if (properties.periodUnit && (typeof properties.periodUnit) !== 'object') {
        errors.collect(ros.propertyValidator('periodUnit', ros.validateAllowedValues)({
            data: properties.periodUnit,
            allowedValues: ["Month", "Year", "month", "year"],
        }));
    }
    errors.collect(ros.propertyValidator('periodUnit', ros.validateString)(properties.periodUnit));
    return errors.wrap('supplied properties not correct for "RosMultiZoneInstanceProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::Lindorm::MultiZoneInstance` resource
 *
 * @param properties - the TypeScript properties of a `RosMultiZoneInstanceProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::Lindorm::MultiZoneInstance` resource.
 */
// @ts-ignore TS6133
function rosMultiZoneInstancePropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosMultiZoneInstancePropsValidator(properties).assertSuccess();
    }
    return {
        DiskCategory: ros.stringToRosTemplate(properties.diskCategory),
        InstanceName: ros.stringToRosTemplate(properties.instanceName),
        VpcId: ros.stringToRosTemplate(properties.vpcId),
        ArbiterVSwitchId: ros.stringToRosTemplate(properties.arbiterVSwitchId),
        ArbiterZoneId: ros.stringToRosTemplate(properties.arbiterZoneId),
        ColdStorage: ros.numberToRosTemplate(properties.coldStorage),
        CoreSingleStorage: ros.numberToRosTemplate(properties.coreSingleStorage),
        CoreSpec: ros.stringToRosTemplate(properties.coreSpec),
        FilestoreNum: ros.numberToRosTemplate(properties.filestoreNum),
        FilestoreSpec: ros.stringToRosTemplate(properties.filestoreSpec),
        InstanceChargeType: ros.stringToRosTemplate(properties.instanceChargeType),
        LindormNum: ros.numberToRosTemplate(properties.lindormNum),
        LindormSpec: ros.stringToRosTemplate(properties.lindormSpec),
        LogDiskCategory: ros.stringToRosTemplate(properties.logDiskCategory),
        LogNum: ros.numberToRosTemplate(properties.logNum),
        LogSingleStorage: ros.numberToRosTemplate(properties.logSingleStorage),
        LogSpec: ros.stringToRosTemplate(properties.logSpec),
        MultiZoneCombination: ros.stringToRosTemplate(properties.multiZoneCombination),
        Period: ros.numberToRosTemplate(properties.period),
        PeriodUnit: ros.stringToRosTemplate(properties.periodUnit),
        PrimaryVSwitchId: ros.stringToRosTemplate(properties.primaryVSwitchId),
        PrimaryZoneId: ros.stringToRosTemplate(properties.primaryZoneId),
        ResourceGroupId: ros.stringToRosTemplate(properties.resourceGroupId),
        SecurityIpList: ros.listMapper(ros.stringToRosTemplate)(properties.securityIpList),
        SolrNum: ros.numberToRosTemplate(properties.solrNum),
        SolrSpec: ros.stringToRosTemplate(properties.solrSpec),
        StandbyVSwitchId: ros.stringToRosTemplate(properties.standbyVSwitchId),
        StandbyZoneId: ros.stringToRosTemplate(properties.standbyZoneId),
        TsdbNum: ros.numberToRosTemplate(properties.tsdbNum),
        TsdbSpec: ros.stringToRosTemplate(properties.tsdbSpec),
    };
}
/**
 * A ROS template type:  `ALIYUN::Lindorm::MultiZoneInstance`
 */
class RosMultiZoneInstance extends ros.RosResource {
    /**
     * Create a new `ALIYUN::Lindorm::MultiZoneInstance`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosMultiZoneInstance.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrInstanceId = this.getAtt('InstanceId');
        this.attrJdbcUrlList = this.getAtt('JdbcUrlList');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.diskCategory = props.diskCategory;
        this.instanceName = props.instanceName;
        this.vpcId = props.vpcId;
        this.arbiterVSwitchId = props.arbiterVSwitchId;
        this.arbiterZoneId = props.arbiterZoneId;
        this.coldStorage = props.coldStorage;
        this.coreSingleStorage = props.coreSingleStorage;
        this.coreSpec = props.coreSpec;
        this.filestoreNum = props.filestoreNum;
        this.filestoreSpec = props.filestoreSpec;
        this.instanceChargeType = props.instanceChargeType;
        this.lindormNum = props.lindormNum;
        this.lindormSpec = props.lindormSpec;
        this.logDiskCategory = props.logDiskCategory;
        this.logNum = props.logNum;
        this.logSingleStorage = props.logSingleStorage;
        this.logSpec = props.logSpec;
        this.multiZoneCombination = props.multiZoneCombination;
        this.period = props.period;
        this.periodUnit = props.periodUnit;
        this.primaryVSwitchId = props.primaryVSwitchId;
        this.primaryZoneId = props.primaryZoneId;
        this.resourceGroupId = props.resourceGroupId;
        this.securityIpList = props.securityIpList;
        this.solrNum = props.solrNum;
        this.solrSpec = props.solrSpec;
        this.standbyVSwitchId = props.standbyVSwitchId;
        this.standbyZoneId = props.standbyZoneId;
        this.tsdbNum = props.tsdbNum;
        this.tsdbSpec = props.tsdbSpec;
    }
    get rosProperties() {
        return {
            diskCategory: this.diskCategory,
            instanceName: this.instanceName,
            vpcId: this.vpcId,
            arbiterVSwitchId: this.arbiterVSwitchId,
            arbiterZoneId: this.arbiterZoneId,
            coldStorage: this.coldStorage,
            coreSingleStorage: this.coreSingleStorage,
            coreSpec: this.coreSpec,
            filestoreNum: this.filestoreNum,
            filestoreSpec: this.filestoreSpec,
            instanceChargeType: this.instanceChargeType,
            lindormNum: this.lindormNum,
            lindormSpec: this.lindormSpec,
            logDiskCategory: this.logDiskCategory,
            logNum: this.logNum,
            logSingleStorage: this.logSingleStorage,
            logSpec: this.logSpec,
            multiZoneCombination: this.multiZoneCombination,
            period: this.period,
            periodUnit: this.periodUnit,
            primaryVSwitchId: this.primaryVSwitchId,
            primaryZoneId: this.primaryZoneId,
            resourceGroupId: this.resourceGroupId,
            securityIpList: this.securityIpList,
            solrNum: this.solrNum,
            solrSpec: this.solrSpec,
            standbyVSwitchId: this.standbyVSwitchId,
            standbyZoneId: this.standbyZoneId,
            tsdbNum: this.tsdbNum,
            tsdbSpec: this.tsdbSpec,
        };
    }
    renderProperties(props) {
        return rosMultiZoneInstancePropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosMultiZoneInstance = RosMultiZoneInstance;
/**
 * The resource type name for this resource class.
 */
RosMultiZoneInstance.ROS_RESOURCE_TYPE_NAME = "ALIYUN::Lindorm::MultiZoneInstance";
//# sourceMappingURL=data:application/json;base64,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