"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MultiZoneInstance = exports.MultiZoneInstanceProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const lindorm_generated_1 = require("./lindorm.generated");
Object.defineProperty(exports, "MultiZoneInstanceProperty", { enumerable: true, get: function () { return lindorm_generated_1.RosMultiZoneInstance; } });
/**
 * A ROS resource type:  `ALIYUN::Lindorm::MultiZoneInstance`
 */
class MultiZoneInstance extends ros.Resource {
    /**
     * Create a new `ALIYUN::Lindorm::MultiZoneInstance`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosMultiZoneInstance = new lindorm_generated_1.RosMultiZoneInstance(this, id, {
            standbyZoneId: props.standbyZoneId,
            resourceGroupId: props.resourceGroupId,
            instanceChargeType: props.instanceChargeType === undefined || props.instanceChargeType === null ? 'POSTPAY' : props.instanceChargeType,
            logDiskCategory: props.logDiskCategory,
            standbyVSwitchId: props.standbyVSwitchId,
            solrNum: props.solrNum,
            solrSpec: props.solrSpec,
            coreSpec: props.coreSpec,
            filestoreSpec: props.filestoreSpec,
            tsdbNum: props.tsdbNum,
            arbiterZoneId: props.arbiterZoneId,
            primaryZoneId: props.primaryZoneId,
            multiZoneCombination: props.multiZoneCombination,
            coreSingleStorage: props.coreSingleStorage,
            coldStorage: props.coldStorage,
            diskCategory: props.diskCategory,
            logSpec: props.logSpec,
            period: props.period,
            primaryVSwitchId: props.primaryVSwitchId,
            arbiterVSwitchId: props.arbiterVSwitchId,
            instanceName: props.instanceName,
            filestoreNum: props.filestoreNum,
            vpcId: props.vpcId,
            securityIpList: props.securityIpList,
            lindormSpec: props.lindormSpec,
            tsdbSpec: props.tsdbSpec,
            logSingleStorage: props.logSingleStorage,
            lindormNum: props.lindormNum,
            logNum: props.logNum,
            periodUnit: props.periodUnit,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosMultiZoneInstance;
        this.attrInstanceId = rosMultiZoneInstance.attrInstanceId;
        this.attrJdbcUrlList = rosMultiZoneInstance.attrJdbcUrlList;
    }
}
exports.MultiZoneInstance = MultiZoneInstance;
//# sourceMappingURL=data:application/json;base64,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