# coding: utf-8

"""
    Intrinio API

    Welcome to the Intrinio API! Through our Financial Data Marketplace, we offer a wide selection of financial data feed APIs sourced by our own proprietary processes as well as from many data vendors. For a complete API request / response reference please view the [Intrinio API documentation](https://docs.intrinio.com/documentation/api_v2). If you need additional help in using the API, please visit the [Intrinio website](https://intrinio.com) and click on the chat icon in the lower right corner.  # noqa: E501

    OpenAPI spec version: 2.30.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from intrinio_sdk.models.esg_company_summary import ESGCompanySummary  # noqa: F401,E501


class ESGComprehensiveRatingWithCompany(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'date': 'date',
        'country_average_rating': 'float',
        'industry_average_rating': 'float',
        'overall_rating': 'float',
        'community_rating': 'float',
        'employee_rating': 'float',
        'environment_rating': 'float',
        'governance_rating': 'float',
        'human_rights_and_supply_chain_rating': 'float',
        'community_dev_and_philanthropy_rating': 'float',
        'product_rating': 'float',
        'compensation_and_benefits_rating': 'float',
        'diversity_and_labor_rights_rating': 'float',
        'training_health_and_safety_rating': 'float',
        'energy_climate_change_rating': 'float',
        'environment_policy_and_reporting_rating': 'float',
        'resource_management_rating': 'float',
        'board_rating': 'float',
        'leadership_ethics_rating': 'float',
        'transparency_reporting_rating': 'float',
        'country_percentile_rank': 'float',
        'industry_percentile_rank': 'float',
        'overall_percentile_rank': 'float',
        'community_percentile_rank': 'float',
        'employee_percentile_rank': 'float',
        'environment_percentile_rank': 'float',
        'governance_percentile_rank': 'float',
        'human_rights_and_supply_chain_percentile_rank': 'float',
        'community_dev_and_philanthropy_percentile_rank': 'float',
        'product_percentile_rank': 'float',
        'compensation_and_benefits_percentile_rank': 'float',
        'diversity_and_labor_rights_percentile_rank': 'float',
        'training_health_and_safety_percentile_rank': 'float',
        'energy_climate_change_percentile_rank': 'float',
        'environment_policy_and_reporting_percentile_rank': 'float',
        'resource_management_percentile_rank': 'float',
        'board_percentile_rank': 'float',
        'leadership_ethics_percentile_rank': 'float',
        'transparency_reporting_percentile_rank': 'float',
        'company': 'ESGCompanySummary'
    }

    attribute_map = {
        'date': 'date',
        'country_average_rating': 'country_average_rating',
        'industry_average_rating': 'industry_average_rating',
        'overall_rating': 'overall_rating',
        'community_rating': 'community_rating',
        'employee_rating': 'employee_rating',
        'environment_rating': 'environment_rating',
        'governance_rating': 'governance_rating',
        'human_rights_and_supply_chain_rating': 'human_rights_and_supply_chain_rating',
        'community_dev_and_philanthropy_rating': 'community_dev_and_philanthropy_rating',
        'product_rating': 'product_rating',
        'compensation_and_benefits_rating': 'compensation_and_benefits_rating',
        'diversity_and_labor_rights_rating': 'diversity_and_labor_rights_rating',
        'training_health_and_safety_rating': 'training_health_and_safety_rating',
        'energy_climate_change_rating': 'energy_climate_change_rating',
        'environment_policy_and_reporting_rating': 'environment_policy_and_reporting_rating',
        'resource_management_rating': 'resource_management_rating',
        'board_rating': 'board_rating',
        'leadership_ethics_rating': 'leadership_ethics_rating',
        'transparency_reporting_rating': 'transparency_reporting_rating',
        'country_percentile_rank': 'country_percentile_rank',
        'industry_percentile_rank': 'industry_percentile_rank',
        'overall_percentile_rank': 'overall_percentile_rank',
        'community_percentile_rank': 'community_percentile_rank',
        'employee_percentile_rank': 'employee_percentile_rank',
        'environment_percentile_rank': 'environment_percentile_rank',
        'governance_percentile_rank': 'governance_percentile_rank',
        'human_rights_and_supply_chain_percentile_rank': 'human_rights_and_supply_chain_percentile_rank',
        'community_dev_and_philanthropy_percentile_rank': 'community_dev_and_philanthropy_percentile_rank',
        'product_percentile_rank': 'product_percentile_rank',
        'compensation_and_benefits_percentile_rank': 'compensation_and_benefits_percentile_rank',
        'diversity_and_labor_rights_percentile_rank': 'diversity_and_labor_rights_percentile_rank',
        'training_health_and_safety_percentile_rank': 'training_health_and_safety_percentile_rank',
        'energy_climate_change_percentile_rank': 'energy_climate_change_percentile_rank',
        'environment_policy_and_reporting_percentile_rank': 'environment_policy_and_reporting_percentile_rank',
        'resource_management_percentile_rank': 'resource_management_percentile_rank',
        'board_percentile_rank': 'board_percentile_rank',
        'leadership_ethics_percentile_rank': 'leadership_ethics_percentile_rank',
        'transparency_reporting_percentile_rank': 'transparency_reporting_percentile_rank',
        'company': 'company'
    }

    def __init__(self, date=None, country_average_rating=None, industry_average_rating=None, overall_rating=None, community_rating=None, employee_rating=None, environment_rating=None, governance_rating=None, human_rights_and_supply_chain_rating=None, community_dev_and_philanthropy_rating=None, product_rating=None, compensation_and_benefits_rating=None, diversity_and_labor_rights_rating=None, training_health_and_safety_rating=None, energy_climate_change_rating=None, environment_policy_and_reporting_rating=None, resource_management_rating=None, board_rating=None, leadership_ethics_rating=None, transparency_reporting_rating=None, country_percentile_rank=None, industry_percentile_rank=None, overall_percentile_rank=None, community_percentile_rank=None, employee_percentile_rank=None, environment_percentile_rank=None, governance_percentile_rank=None, human_rights_and_supply_chain_percentile_rank=None, community_dev_and_philanthropy_percentile_rank=None, product_percentile_rank=None, compensation_and_benefits_percentile_rank=None, diversity_and_labor_rights_percentile_rank=None, training_health_and_safety_percentile_rank=None, energy_climate_change_percentile_rank=None, environment_policy_and_reporting_percentile_rank=None, resource_management_percentile_rank=None, board_percentile_rank=None, leadership_ethics_percentile_rank=None, transparency_reporting_percentile_rank=None, company=None):  # noqa: E501
        """ESGComprehensiveRatingWithCompany - a model defined in Swagger"""  # noqa: E501

        self._date = None
        self._country_average_rating = None
        self._industry_average_rating = None
        self._overall_rating = None
        self._community_rating = None
        self._employee_rating = None
        self._environment_rating = None
        self._governance_rating = None
        self._human_rights_and_supply_chain_rating = None
        self._community_dev_and_philanthropy_rating = None
        self._product_rating = None
        self._compensation_and_benefits_rating = None
        self._diversity_and_labor_rights_rating = None
        self._training_health_and_safety_rating = None
        self._energy_climate_change_rating = None
        self._environment_policy_and_reporting_rating = None
        self._resource_management_rating = None
        self._board_rating = None
        self._leadership_ethics_rating = None
        self._transparency_reporting_rating = None
        self._country_percentile_rank = None
        self._industry_percentile_rank = None
        self._overall_percentile_rank = None
        self._community_percentile_rank = None
        self._employee_percentile_rank = None
        self._environment_percentile_rank = None
        self._governance_percentile_rank = None
        self._human_rights_and_supply_chain_percentile_rank = None
        self._community_dev_and_philanthropy_percentile_rank = None
        self._product_percentile_rank = None
        self._compensation_and_benefits_percentile_rank = None
        self._diversity_and_labor_rights_percentile_rank = None
        self._training_health_and_safety_percentile_rank = None
        self._energy_climate_change_percentile_rank = None
        self._environment_policy_and_reporting_percentile_rank = None
        self._resource_management_percentile_rank = None
        self._board_percentile_rank = None
        self._leadership_ethics_percentile_rank = None
        self._transparency_reporting_percentile_rank = None
        self._company = None
        self.discriminator = None

        if date is not None:
            self.date = date
        if country_average_rating is not None:
            self.country_average_rating = country_average_rating
        if industry_average_rating is not None:
            self.industry_average_rating = industry_average_rating
        if overall_rating is not None:
            self.overall_rating = overall_rating
        if community_rating is not None:
            self.community_rating = community_rating
        if employee_rating is not None:
            self.employee_rating = employee_rating
        if environment_rating is not None:
            self.environment_rating = environment_rating
        if governance_rating is not None:
            self.governance_rating = governance_rating
        if human_rights_and_supply_chain_rating is not None:
            self.human_rights_and_supply_chain_rating = human_rights_and_supply_chain_rating
        if community_dev_and_philanthropy_rating is not None:
            self.community_dev_and_philanthropy_rating = community_dev_and_philanthropy_rating
        if product_rating is not None:
            self.product_rating = product_rating
        if compensation_and_benefits_rating is not None:
            self.compensation_and_benefits_rating = compensation_and_benefits_rating
        if diversity_and_labor_rights_rating is not None:
            self.diversity_and_labor_rights_rating = diversity_and_labor_rights_rating
        if training_health_and_safety_rating is not None:
            self.training_health_and_safety_rating = training_health_and_safety_rating
        if energy_climate_change_rating is not None:
            self.energy_climate_change_rating = energy_climate_change_rating
        if environment_policy_and_reporting_rating is not None:
            self.environment_policy_and_reporting_rating = environment_policy_and_reporting_rating
        if resource_management_rating is not None:
            self.resource_management_rating = resource_management_rating
        if board_rating is not None:
            self.board_rating = board_rating
        if leadership_ethics_rating is not None:
            self.leadership_ethics_rating = leadership_ethics_rating
        if transparency_reporting_rating is not None:
            self.transparency_reporting_rating = transparency_reporting_rating
        if country_percentile_rank is not None:
            self.country_percentile_rank = country_percentile_rank
        if industry_percentile_rank is not None:
            self.industry_percentile_rank = industry_percentile_rank
        if overall_percentile_rank is not None:
            self.overall_percentile_rank = overall_percentile_rank
        if community_percentile_rank is not None:
            self.community_percentile_rank = community_percentile_rank
        if employee_percentile_rank is not None:
            self.employee_percentile_rank = employee_percentile_rank
        if environment_percentile_rank is not None:
            self.environment_percentile_rank = environment_percentile_rank
        if governance_percentile_rank is not None:
            self.governance_percentile_rank = governance_percentile_rank
        if human_rights_and_supply_chain_percentile_rank is not None:
            self.human_rights_and_supply_chain_percentile_rank = human_rights_and_supply_chain_percentile_rank
        if community_dev_and_philanthropy_percentile_rank is not None:
            self.community_dev_and_philanthropy_percentile_rank = community_dev_and_philanthropy_percentile_rank
        if product_percentile_rank is not None:
            self.product_percentile_rank = product_percentile_rank
        if compensation_and_benefits_percentile_rank is not None:
            self.compensation_and_benefits_percentile_rank = compensation_and_benefits_percentile_rank
        if diversity_and_labor_rights_percentile_rank is not None:
            self.diversity_and_labor_rights_percentile_rank = diversity_and_labor_rights_percentile_rank
        if training_health_and_safety_percentile_rank is not None:
            self.training_health_and_safety_percentile_rank = training_health_and_safety_percentile_rank
        if energy_climate_change_percentile_rank is not None:
            self.energy_climate_change_percentile_rank = energy_climate_change_percentile_rank
        if environment_policy_and_reporting_percentile_rank is not None:
            self.environment_policy_and_reporting_percentile_rank = environment_policy_and_reporting_percentile_rank
        if resource_management_percentile_rank is not None:
            self.resource_management_percentile_rank = resource_management_percentile_rank
        if board_percentile_rank is not None:
            self.board_percentile_rank = board_percentile_rank
        if leadership_ethics_percentile_rank is not None:
            self.leadership_ethics_percentile_rank = leadership_ethics_percentile_rank
        if transparency_reporting_percentile_rank is not None:
            self.transparency_reporting_percentile_rank = transparency_reporting_percentile_rank
        if company is not None:
            self.company = company

    @property
    def date(self):
        """Gets the date of this ESGComprehensiveRatingWithCompany.  # noqa: E501

        Indicates the date on which the ESG Rating was calculated.  # noqa: E501

        :return: The date of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :rtype: date
        """
        return self._date
        
    @property
    def date_dict(self):
        """Gets the date of this ESGComprehensiveRatingWithCompany.  # noqa: E501

        Indicates the date on which the ESG Rating was calculated. as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The date of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :rtype: date
        """

        result = None

        value = self.date
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'date': value }

        
        return result
        

    @date.setter
    def date(self, date):
        """Sets the date of this ESGComprehensiveRatingWithCompany.

        Indicates the date on which the ESG Rating was calculated.  # noqa: E501

        :param date: The date of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :type: date
        """

        self._date = date

    @property
    def country_average_rating(self):
        """Gets the country_average_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501

        The average ESG rating of all companies in a particular country in which the company is a peer of.  # noqa: E501

        :return: The country_average_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :rtype: float
        """
        return self._country_average_rating
        
    @property
    def country_average_rating_dict(self):
        """Gets the country_average_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501

        The average ESG rating of all companies in a particular country in which the company is a peer of. as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The country_average_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.country_average_rating
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'country_average_rating': value }

        
        return result
        

    @country_average_rating.setter
    def country_average_rating(self, country_average_rating):
        """Sets the country_average_rating of this ESGComprehensiveRatingWithCompany.

        The average ESG rating of all companies in a particular country in which the company is a peer of.  # noqa: E501

        :param country_average_rating: The country_average_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :type: float
        """

        self._country_average_rating = country_average_rating

    @property
    def industry_average_rating(self):
        """Gets the industry_average_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501

        The average ESG rating of all companies in a particular industry in which the company is a peer of.  # noqa: E501

        :return: The industry_average_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :rtype: float
        """
        return self._industry_average_rating
        
    @property
    def industry_average_rating_dict(self):
        """Gets the industry_average_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501

        The average ESG rating of all companies in a particular industry in which the company is a peer of. as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The industry_average_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.industry_average_rating
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'industry_average_rating': value }

        
        return result
        

    @industry_average_rating.setter
    def industry_average_rating(self, industry_average_rating):
        """Sets the industry_average_rating of this ESGComprehensiveRatingWithCompany.

        The average ESG rating of all companies in a particular industry in which the company is a peer of.  # noqa: E501

        :param industry_average_rating: The industry_average_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :type: float
        """

        self._industry_average_rating = industry_average_rating

    @property
    def overall_rating(self):
        """Gets the overall_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501

        The company's overall aggregated ESG rating, taking into account its ESG scoring from the Community, Employee, Enviroment, and Governance categories.  # noqa: E501

        :return: The overall_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :rtype: float
        """
        return self._overall_rating
        
    @property
    def overall_rating_dict(self):
        """Gets the overall_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501

        The company's overall aggregated ESG rating, taking into account its ESG scoring from the Community, Employee, Enviroment, and Governance categories. as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The overall_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.overall_rating
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'overall_rating': value }

        
        return result
        

    @overall_rating.setter
    def overall_rating(self, overall_rating):
        """Sets the overall_rating of this ESGComprehensiveRatingWithCompany.

        The company's overall aggregated ESG rating, taking into account its ESG scoring from the Community, Employee, Enviroment, and Governance categories.  # noqa: E501

        :param overall_rating: The overall_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :type: float
        """

        self._overall_rating = overall_rating

    @property
    def community_rating(self):
        """Gets the community_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501

        The Community Category reflects a companys citizenship, charitable giving, and volunteerism. This category covers the company's human rights record and treatment of its supply chain. It also covers the environmental and social impacts of the companys products and services, and the development of sustainable products, processes and technologies.  # noqa: E501

        :return: The community_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :rtype: float
        """
        return self._community_rating
        
    @property
    def community_rating_dict(self):
        """Gets the community_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501

        The Community Category reflects a companys citizenship, charitable giving, and volunteerism. This category covers the company's human rights record and treatment of its supply chain. It also covers the environmental and social impacts of the companys products and services, and the development of sustainable products, processes and technologies. as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The community_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.community_rating
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'community_rating': value }

        
        return result
        

    @community_rating.setter
    def community_rating(self, community_rating):
        """Sets the community_rating of this ESGComprehensiveRatingWithCompany.

        The Community Category reflects a companys citizenship, charitable giving, and volunteerism. This category covers the company's human rights record and treatment of its supply chain. It also covers the environmental and social impacts of the companys products and services, and the development of sustainable products, processes and technologies.  # noqa: E501

        :param community_rating: The community_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :type: float
        """

        self._community_rating = community_rating

    @property
    def employee_rating(self):
        """Gets the employee_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501

        The Employees category includes disclosure of policies, programs, and performance in diversity, labor relations and labor rights. The evaluation focuses on the quality of policies and programs, compliance with national laws and regulations, and proactive management initiatives. The category includes evaluation of inclusive diversity policies, fair treatment of all employees, robust diversity (EEO-1) programs and training.  # noqa: E501

        :return: The employee_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :rtype: float
        """
        return self._employee_rating
        
    @property
    def employee_rating_dict(self):
        """Gets the employee_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501

        The Employees category includes disclosure of policies, programs, and performance in diversity, labor relations and labor rights. The evaluation focuses on the quality of policies and programs, compliance with national laws and regulations, and proactive management initiatives. The category includes evaluation of inclusive diversity policies, fair treatment of all employees, robust diversity (EEO-1) programs and training. as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The employee_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.employee_rating
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'employee_rating': value }

        
        return result
        

    @employee_rating.setter
    def employee_rating(self, employee_rating):
        """Sets the employee_rating of this ESGComprehensiveRatingWithCompany.

        The Employees category includes disclosure of policies, programs, and performance in diversity, labor relations and labor rights. The evaluation focuses on the quality of policies and programs, compliance with national laws and regulations, and proactive management initiatives. The category includes evaluation of inclusive diversity policies, fair treatment of all employees, robust diversity (EEO-1) programs and training.  # noqa: E501

        :param employee_rating: The employee_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :type: float
        """

        self._employee_rating = employee_rating

    @property
    def environment_rating(self):
        """Gets the environment_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501

        The Environment category data covers a company's interactions with the environment at large, including use of natural resources. The category evaluates corporate environmental performance, compliance with environmental regulations, and mitigation of environmental footprint. It also includes leadership in addressing climate change through appropriate policies and strategies.  # noqa: E501

        :return: The environment_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :rtype: float
        """
        return self._environment_rating
        
    @property
    def environment_rating_dict(self):
        """Gets the environment_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501

        The Environment category data covers a company's interactions with the environment at large, including use of natural resources. The category evaluates corporate environmental performance, compliance with environmental regulations, and mitigation of environmental footprint. It also includes leadership in addressing climate change through appropriate policies and strategies. as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The environment_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.environment_rating
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'environment_rating': value }

        
        return result
        

    @environment_rating.setter
    def environment_rating(self, environment_rating):
        """Sets the environment_rating of this ESGComprehensiveRatingWithCompany.

        The Environment category data covers a company's interactions with the environment at large, including use of natural resources. The category evaluates corporate environmental performance, compliance with environmental regulations, and mitigation of environmental footprint. It also includes leadership in addressing climate change through appropriate policies and strategies.  # noqa: E501

        :param environment_rating: The environment_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :type: float
        """

        self._environment_rating = environment_rating

    @property
    def governance_rating(self):
        """Gets the governance_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501

        Corporate governance refers to leadership structure and the values that determine corporate direction, ethics and performance. The Governance category covers disclosure of policies and procedures, board independence and diversity, executive compensation, attention to stakeholder concerns, and evaluation of a company's culture of ethical leadership and compliance.  # noqa: E501

        :return: The governance_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :rtype: float
        """
        return self._governance_rating
        
    @property
    def governance_rating_dict(self):
        """Gets the governance_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501

        Corporate governance refers to leadership structure and the values that determine corporate direction, ethics and performance. The Governance category covers disclosure of policies and procedures, board independence and diversity, executive compensation, attention to stakeholder concerns, and evaluation of a company's culture of ethical leadership and compliance. as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The governance_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.governance_rating
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'governance_rating': value }

        
        return result
        

    @governance_rating.setter
    def governance_rating(self, governance_rating):
        """Sets the governance_rating of this ESGComprehensiveRatingWithCompany.

        Corporate governance refers to leadership structure and the values that determine corporate direction, ethics and performance. The Governance category covers disclosure of policies and procedures, board independence and diversity, executive compensation, attention to stakeholder concerns, and evaluation of a company's culture of ethical leadership and compliance.  # noqa: E501

        :param governance_rating: The governance_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :type: float
        """

        self._governance_rating = governance_rating

    @property
    def human_rights_and_supply_chain_rating(self):
        """Gets the human_rights_and_supply_chain_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501

        The Human Rights and Supply Chain subcategory measures a company's commitment to respecting fundamental human rights conventions. This subcategory covers a company's transparency in overseas sourcing disclosure and monitoring. The subcategory also covers the relationship with and respect for the human rights of indigenous peoples near its proposed or current operations.  # noqa: E501

        :return: The human_rights_and_supply_chain_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :rtype: float
        """
        return self._human_rights_and_supply_chain_rating
        
    @property
    def human_rights_and_supply_chain_rating_dict(self):
        """Gets the human_rights_and_supply_chain_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501

        The Human Rights and Supply Chain subcategory measures a company's commitment to respecting fundamental human rights conventions. This subcategory covers a company's transparency in overseas sourcing disclosure and monitoring. The subcategory also covers the relationship with and respect for the human rights of indigenous peoples near its proposed or current operations. as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The human_rights_and_supply_chain_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.human_rights_and_supply_chain_rating
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'human_rights_and_supply_chain_rating': value }

        
        return result
        

    @human_rights_and_supply_chain_rating.setter
    def human_rights_and_supply_chain_rating(self, human_rights_and_supply_chain_rating):
        """Sets the human_rights_and_supply_chain_rating of this ESGComprehensiveRatingWithCompany.

        The Human Rights and Supply Chain subcategory measures a company's commitment to respecting fundamental human rights conventions. This subcategory covers a company's transparency in overseas sourcing disclosure and monitoring. The subcategory also covers the relationship with and respect for the human rights of indigenous peoples near its proposed or current operations.  # noqa: E501

        :param human_rights_and_supply_chain_rating: The human_rights_and_supply_chain_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :type: float
        """

        self._human_rights_and_supply_chain_rating = human_rights_and_supply_chain_rating

    @property
    def community_dev_and_philanthropy_rating(self):
        """Gets the community_dev_and_philanthropy_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501

        The Community Development and Philanthropy subcategory covers the relationship between a company and the communities within which it is embedded. It reflects a company's community citizenship through charitable giving, donations of goods, and volunteerism of staff time. It also includes protecting public health (e.g., avoidance of industrial accidents) and managing the social impacts of its operations.  # noqa: E501

        :return: The community_dev_and_philanthropy_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :rtype: float
        """
        return self._community_dev_and_philanthropy_rating
        
    @property
    def community_dev_and_philanthropy_rating_dict(self):
        """Gets the community_dev_and_philanthropy_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501

        The Community Development and Philanthropy subcategory covers the relationship between a company and the communities within which it is embedded. It reflects a company's community citizenship through charitable giving, donations of goods, and volunteerism of staff time. It also includes protecting public health (e.g., avoidance of industrial accidents) and managing the social impacts of its operations. as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The community_dev_and_philanthropy_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.community_dev_and_philanthropy_rating
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'community_dev_and_philanthropy_rating': value }

        
        return result
        

    @community_dev_and_philanthropy_rating.setter
    def community_dev_and_philanthropy_rating(self, community_dev_and_philanthropy_rating):
        """Sets the community_dev_and_philanthropy_rating of this ESGComprehensiveRatingWithCompany.

        The Community Development and Philanthropy subcategory covers the relationship between a company and the communities within which it is embedded. It reflects a company's community citizenship through charitable giving, donations of goods, and volunteerism of staff time. It also includes protecting public health (e.g., avoidance of industrial accidents) and managing the social impacts of its operations.  # noqa: E501

        :param community_dev_and_philanthropy_rating: The community_dev_and_philanthropy_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :type: float
        """

        self._community_dev_and_philanthropy_rating = community_dev_and_philanthropy_rating

    @property
    def product_rating(self):
        """Gets the product_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501

        The Product subcategory covers the responsibility of a company for the development, design, and management of its products and services. This subcategory reflects a company's capacity to reduce environmental costs, create new market opportunities, and produce or market goods and services that enhance the health and quality of life for consumers.  # noqa: E501

        :return: The product_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :rtype: float
        """
        return self._product_rating
        
    @property
    def product_rating_dict(self):
        """Gets the product_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501

        The Product subcategory covers the responsibility of a company for the development, design, and management of its products and services. This subcategory reflects a company's capacity to reduce environmental costs, create new market opportunities, and produce or market goods and services that enhance the health and quality of life for consumers. as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The product_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.product_rating
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'product_rating': value }

        
        return result
        

    @product_rating.setter
    def product_rating(self, product_rating):
        """Sets the product_rating of this ESGComprehensiveRatingWithCompany.

        The Product subcategory covers the responsibility of a company for the development, design, and management of its products and services. This subcategory reflects a company's capacity to reduce environmental costs, create new market opportunities, and produce or market goods and services that enhance the health and quality of life for consumers.  # noqa: E501

        :param product_rating: The product_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :type: float
        """

        self._product_rating = product_rating

    @property
    def compensation_and_benefits_rating(self):
        """Gets the compensation_and_benefits_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501

        The Compensation and Benefits subcategory covers a company's capacity to increase its workforce loyalty and productivity. It includes benefits that engage employees and improve worker development. This subcategory also focuses on long-term employment growth and stability by promotion practices, lay-off practices, and relations with retired employees.  # noqa: E501

        :return: The compensation_and_benefits_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :rtype: float
        """
        return self._compensation_and_benefits_rating
        
    @property
    def compensation_and_benefits_rating_dict(self):
        """Gets the compensation_and_benefits_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501

        The Compensation and Benefits subcategory covers a company's capacity to increase its workforce loyalty and productivity. It includes benefits that engage employees and improve worker development. This subcategory also focuses on long-term employment growth and stability by promotion practices, lay-off practices, and relations with retired employees. as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The compensation_and_benefits_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.compensation_and_benefits_rating
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'compensation_and_benefits_rating': value }

        
        return result
        

    @compensation_and_benefits_rating.setter
    def compensation_and_benefits_rating(self, compensation_and_benefits_rating):
        """Sets the compensation_and_benefits_rating of this ESGComprehensiveRatingWithCompany.

        The Compensation and Benefits subcategory covers a company's capacity to increase its workforce loyalty and productivity. It includes benefits that engage employees and improve worker development. This subcategory also focuses on long-term employment growth and stability by promotion practices, lay-off practices, and relations with retired employees.  # noqa: E501

        :param compensation_and_benefits_rating: The compensation_and_benefits_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :type: float
        """

        self._compensation_and_benefits_rating = compensation_and_benefits_rating

    @property
    def diversity_and_labor_rights_rating(self):
        """Gets the diversity_and_labor_rights_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501

        The Diversity and Labor Rights subcategory covers workplace policies and practices covering fair and non-discriminatory treatment of employees. It covers a company's labor-management relations and participation by employees. Fundamental labor rights include freedom of association and protection of the right to organize.  # noqa: E501

        :return: The diversity_and_labor_rights_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :rtype: float
        """
        return self._diversity_and_labor_rights_rating
        
    @property
    def diversity_and_labor_rights_rating_dict(self):
        """Gets the diversity_and_labor_rights_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501

        The Diversity and Labor Rights subcategory covers workplace policies and practices covering fair and non-discriminatory treatment of employees. It covers a company's labor-management relations and participation by employees. Fundamental labor rights include freedom of association and protection of the right to organize. as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The diversity_and_labor_rights_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.diversity_and_labor_rights_rating
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'diversity_and_labor_rights_rating': value }

        
        return result
        

    @diversity_and_labor_rights_rating.setter
    def diversity_and_labor_rights_rating(self, diversity_and_labor_rights_rating):
        """Sets the diversity_and_labor_rights_rating of this ESGComprehensiveRatingWithCompany.

        The Diversity and Labor Rights subcategory covers workplace policies and practices covering fair and non-discriminatory treatment of employees. It covers a company's labor-management relations and participation by employees. Fundamental labor rights include freedom of association and protection of the right to organize.  # noqa: E501

        :param diversity_and_labor_rights_rating: The diversity_and_labor_rights_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :type: float
        """

        self._diversity_and_labor_rights_rating = diversity_and_labor_rights_rating

    @property
    def training_health_and_safety_rating(self):
        """Gets the training_health_and_safety_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501

        The Training, Safety and Health subcategory measures a company's effectiveness in providing a healthy and safe workplace. It includes programs to support the health, well-being and productivity of all employees. This subcategory includes workplace policies and programs that boost employee morale, workplace productivity and worker development.  # noqa: E501

        :return: The training_health_and_safety_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :rtype: float
        """
        return self._training_health_and_safety_rating
        
    @property
    def training_health_and_safety_rating_dict(self):
        """Gets the training_health_and_safety_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501

        The Training, Safety and Health subcategory measures a company's effectiveness in providing a healthy and safe workplace. It includes programs to support the health, well-being and productivity of all employees. This subcategory includes workplace policies and programs that boost employee morale, workplace productivity and worker development. as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The training_health_and_safety_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.training_health_and_safety_rating
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'training_health_and_safety_rating': value }

        
        return result
        

    @training_health_and_safety_rating.setter
    def training_health_and_safety_rating(self, training_health_and_safety_rating):
        """Sets the training_health_and_safety_rating of this ESGComprehensiveRatingWithCompany.

        The Training, Safety and Health subcategory measures a company's effectiveness in providing a healthy and safe workplace. It includes programs to support the health, well-being and productivity of all employees. This subcategory includes workplace policies and programs that boost employee morale, workplace productivity and worker development.  # noqa: E501

        :param training_health_and_safety_rating: The training_health_and_safety_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :type: float
        """

        self._training_health_and_safety_rating = training_health_and_safety_rating

    @property
    def energy_climate_change_rating(self):
        """Gets the energy_climate_change_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501

        The Energy and Climate Change subcategory measures a company's effectiveness in addressing climate change through appropriate policies and strategies. The subcategory includes energy use, emissions to air of CO2 and other Greenhouse Gas Emissions (GHG) and other alternative environmental technologies.  # noqa: E501

        :return: The energy_climate_change_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :rtype: float
        """
        return self._energy_climate_change_rating
        
    @property
    def energy_climate_change_rating_dict(self):
        """Gets the energy_climate_change_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501

        The Energy and Climate Change subcategory measures a company's effectiveness in addressing climate change through appropriate policies and strategies. The subcategory includes energy use, emissions to air of CO2 and other Greenhouse Gas Emissions (GHG) and other alternative environmental technologies. as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The energy_climate_change_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.energy_climate_change_rating
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'energy_climate_change_rating': value }

        
        return result
        

    @energy_climate_change_rating.setter
    def energy_climate_change_rating(self, energy_climate_change_rating):
        """Sets the energy_climate_change_rating of this ESGComprehensiveRatingWithCompany.

        The Energy and Climate Change subcategory measures a company's effectiveness in addressing climate change through appropriate policies and strategies. The subcategory includes energy use, emissions to air of CO2 and other Greenhouse Gas Emissions (GHG) and other alternative environmental technologies.  # noqa: E501

        :param energy_climate_change_rating: The energy_climate_change_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :type: float
        """

        self._energy_climate_change_rating = energy_climate_change_rating

    @property
    def environment_policy_and_reporting_rating(self):
        """Gets the environment_policy_and_reporting_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501

        The Environmental Policy and Reporting subcategory includes a company's policies and intention to reduce the environmental impact of a company. The data includes the company's environmental reporting performance, adherence to environmental reporting standards and compliance with investor, regulatory and stakeholders' requests for transparency. Compliance data consists of breaches of regulatory limits and accidental releases.  # noqa: E501

        :return: The environment_policy_and_reporting_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :rtype: float
        """
        return self._environment_policy_and_reporting_rating
        
    @property
    def environment_policy_and_reporting_rating_dict(self):
        """Gets the environment_policy_and_reporting_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501

        The Environmental Policy and Reporting subcategory includes a company's policies and intention to reduce the environmental impact of a company. The data includes the company's environmental reporting performance, adherence to environmental reporting standards and compliance with investor, regulatory and stakeholders' requests for transparency. Compliance data consists of breaches of regulatory limits and accidental releases. as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The environment_policy_and_reporting_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.environment_policy_and_reporting_rating
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'environment_policy_and_reporting_rating': value }

        
        return result
        

    @environment_policy_and_reporting_rating.setter
    def environment_policy_and_reporting_rating(self, environment_policy_and_reporting_rating):
        """Sets the environment_policy_and_reporting_rating of this ESGComprehensiveRatingWithCompany.

        The Environmental Policy and Reporting subcategory includes a company's policies and intention to reduce the environmental impact of a company. The data includes the company's environmental reporting performance, adherence to environmental reporting standards and compliance with investor, regulatory and stakeholders' requests for transparency. Compliance data consists of breaches of regulatory limits and accidental releases.  # noqa: E501

        :param environment_policy_and_reporting_rating: The environment_policy_and_reporting_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :type: float
        """

        self._environment_policy_and_reporting_rating = environment_policy_and_reporting_rating

    @property
    def resource_management_rating(self):
        """Gets the resource_management_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501

        The Resource Management subcategory covers how efficiently resources are used in manufacturing and delivering products and services. It includes a company's capacity to reduce the use of materials, energy or water, and to find more efficient solutions by improving its supply chain management. This subcategory includes environmental performance relative to production size.  # noqa: E501

        :return: The resource_management_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :rtype: float
        """
        return self._resource_management_rating
        
    @property
    def resource_management_rating_dict(self):
        """Gets the resource_management_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501

        The Resource Management subcategory covers how efficiently resources are used in manufacturing and delivering products and services. It includes a company's capacity to reduce the use of materials, energy or water, and to find more efficient solutions by improving its supply chain management. This subcategory includes environmental performance relative to production size. as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The resource_management_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.resource_management_rating
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'resource_management_rating': value }

        
        return result
        

    @resource_management_rating.setter
    def resource_management_rating(self, resource_management_rating):
        """Sets the resource_management_rating of this ESGComprehensiveRatingWithCompany.

        The Resource Management subcategory covers how efficiently resources are used in manufacturing and delivering products and services. It includes a company's capacity to reduce the use of materials, energy or water, and to find more efficient solutions by improving its supply chain management. This subcategory includes environmental performance relative to production size.  # noqa: E501

        :param resource_management_rating: The resource_management_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :type: float
        """

        self._resource_management_rating = resource_management_rating

    @property
    def board_rating(self):
        """Gets the board_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501

        The Board subcategory covers a company's effectiveness in following best practices in corporate governance principles related to board membership. It includes how the company provides competitive and proportionate management compensation and its ability to incent executives and board members to achieve both financial and extra-financial targets.  # noqa: E501

        :return: The board_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :rtype: float
        """
        return self._board_rating
        
    @property
    def board_rating_dict(self):
        """Gets the board_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501

        The Board subcategory covers a company's effectiveness in following best practices in corporate governance principles related to board membership. It includes how the company provides competitive and proportionate management compensation and its ability to incent executives and board members to achieve both financial and extra-financial targets. as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The board_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.board_rating
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'board_rating': value }

        
        return result
        

    @board_rating.setter
    def board_rating(self, board_rating):
        """Sets the board_rating of this ESGComprehensiveRatingWithCompany.

        The Board subcategory covers a company's effectiveness in following best practices in corporate governance principles related to board membership. It includes how the company provides competitive and proportionate management compensation and its ability to incent executives and board members to achieve both financial and extra-financial targets.  # noqa: E501

        :param board_rating: The board_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :type: float
        """

        self._board_rating = board_rating

    @property
    def leadership_ethics_rating(self):
        """Gets the leadership_ethics_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501

        The Leadership Ethics subcategory measures how a company manages its relationships with its various stakeholders, including investors, customers, communities, and regulators. It measures a company's commitment and effectiveness toward the vision of integrating social and environmental aspects into the overall core strategy. It also measures whether sustainability principles are integrated from the top down into the day-to-day operations of the company.  # noqa: E501

        :return: The leadership_ethics_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :rtype: float
        """
        return self._leadership_ethics_rating
        
    @property
    def leadership_ethics_rating_dict(self):
        """Gets the leadership_ethics_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501

        The Leadership Ethics subcategory measures how a company manages its relationships with its various stakeholders, including investors, customers, communities, and regulators. It measures a company's commitment and effectiveness toward the vision of integrating social and environmental aspects into the overall core strategy. It also measures whether sustainability principles are integrated from the top down into the day-to-day operations of the company. as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The leadership_ethics_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.leadership_ethics_rating
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'leadership_ethics_rating': value }

        
        return result
        

    @leadership_ethics_rating.setter
    def leadership_ethics_rating(self, leadership_ethics_rating):
        """Sets the leadership_ethics_rating of this ESGComprehensiveRatingWithCompany.

        The Leadership Ethics subcategory measures how a company manages its relationships with its various stakeholders, including investors, customers, communities, and regulators. It measures a company's commitment and effectiveness toward the vision of integrating social and environmental aspects into the overall core strategy. It also measures whether sustainability principles are integrated from the top down into the day-to-day operations of the company.  # noqa: E501

        :param leadership_ethics_rating: The leadership_ethics_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :type: float
        """

        self._leadership_ethics_rating = leadership_ethics_rating

    @property
    def transparency_reporting_rating(self):
        """Gets the transparency_reporting_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501

        The Transparency and Reporting subcategory rates factors including are corporate policies and practices aligned with sustainability goals. It also covers whether the company is a signatory of Global Compact and other leading global entities. It evaluates the assurance (3rd party audit) of the accuracy, completeness, and reliability of its Sustainability or Corporate Social Responsibility reports.  # noqa: E501

        :return: The transparency_reporting_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :rtype: float
        """
        return self._transparency_reporting_rating
        
    @property
    def transparency_reporting_rating_dict(self):
        """Gets the transparency_reporting_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501

        The Transparency and Reporting subcategory rates factors including are corporate policies and practices aligned with sustainability goals. It also covers whether the company is a signatory of Global Compact and other leading global entities. It evaluates the assurance (3rd party audit) of the accuracy, completeness, and reliability of its Sustainability or Corporate Social Responsibility reports. as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The transparency_reporting_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.transparency_reporting_rating
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'transparency_reporting_rating': value }

        
        return result
        

    @transparency_reporting_rating.setter
    def transparency_reporting_rating(self, transparency_reporting_rating):
        """Sets the transparency_reporting_rating of this ESGComprehensiveRatingWithCompany.

        The Transparency and Reporting subcategory rates factors including are corporate policies and practices aligned with sustainability goals. It also covers whether the company is a signatory of Global Compact and other leading global entities. It evaluates the assurance (3rd party audit) of the accuracy, completeness, and reliability of its Sustainability or Corporate Social Responsibility reports.  # noqa: E501

        :param transparency_reporting_rating: The transparency_reporting_rating of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :type: float
        """

        self._transparency_reporting_rating = transparency_reporting_rating

    @property
    def country_percentile_rank(self):
        """Gets the country_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501

        The percentile rank of the company's ESG rating in comparison to it's country peers.  # noqa: E501

        :return: The country_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :rtype: float
        """
        return self._country_percentile_rank
        
    @property
    def country_percentile_rank_dict(self):
        """Gets the country_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501

        The percentile rank of the company's ESG rating in comparison to it's country peers. as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The country_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.country_percentile_rank
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'country_percentile_rank': value }

        
        return result
        

    @country_percentile_rank.setter
    def country_percentile_rank(self, country_percentile_rank):
        """Sets the country_percentile_rank of this ESGComprehensiveRatingWithCompany.

        The percentile rank of the company's ESG rating in comparison to it's country peers.  # noqa: E501

        :param country_percentile_rank: The country_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :type: float
        """

        self._country_percentile_rank = country_percentile_rank

    @property
    def industry_percentile_rank(self):
        """Gets the industry_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501

        The percentile rank of the company's ESG rating in comparison to it's industry peers.  # noqa: E501

        :return: The industry_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :rtype: float
        """
        return self._industry_percentile_rank
        
    @property
    def industry_percentile_rank_dict(self):
        """Gets the industry_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501

        The percentile rank of the company's ESG rating in comparison to it's industry peers. as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The industry_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.industry_percentile_rank
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'industry_percentile_rank': value }

        
        return result
        

    @industry_percentile_rank.setter
    def industry_percentile_rank(self, industry_percentile_rank):
        """Sets the industry_percentile_rank of this ESGComprehensiveRatingWithCompany.

        The percentile rank of the company's ESG rating in comparison to it's industry peers.  # noqa: E501

        :param industry_percentile_rank: The industry_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :type: float
        """

        self._industry_percentile_rank = industry_percentile_rank

    @property
    def overall_percentile_rank(self):
        """Gets the overall_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501

        The percentile rank of the company's overall ESG rating in comparison to all companies within the CSRHub ESG universe.  # noqa: E501

        :return: The overall_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :rtype: float
        """
        return self._overall_percentile_rank
        
    @property
    def overall_percentile_rank_dict(self):
        """Gets the overall_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501

        The percentile rank of the company's overall ESG rating in comparison to all companies within the CSRHub ESG universe. as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The overall_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.overall_percentile_rank
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'overall_percentile_rank': value }

        
        return result
        

    @overall_percentile_rank.setter
    def overall_percentile_rank(self, overall_percentile_rank):
        """Sets the overall_percentile_rank of this ESGComprehensiveRatingWithCompany.

        The percentile rank of the company's overall ESG rating in comparison to all companies within the CSRHub ESG universe.  # noqa: E501

        :param overall_percentile_rank: The overall_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :type: float
        """

        self._overall_percentile_rank = overall_percentile_rank

    @property
    def community_percentile_rank(self):
        """Gets the community_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501

        The percentile rank of the company's Community rating in comparison to all companies within the CSRHub ESG universe.  # noqa: E501

        :return: The community_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :rtype: float
        """
        return self._community_percentile_rank
        
    @property
    def community_percentile_rank_dict(self):
        """Gets the community_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501

        The percentile rank of the company's Community rating in comparison to all companies within the CSRHub ESG universe. as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The community_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.community_percentile_rank
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'community_percentile_rank': value }

        
        return result
        

    @community_percentile_rank.setter
    def community_percentile_rank(self, community_percentile_rank):
        """Sets the community_percentile_rank of this ESGComprehensiveRatingWithCompany.

        The percentile rank of the company's Community rating in comparison to all companies within the CSRHub ESG universe.  # noqa: E501

        :param community_percentile_rank: The community_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :type: float
        """

        self._community_percentile_rank = community_percentile_rank

    @property
    def employee_percentile_rank(self):
        """Gets the employee_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501

        The percentile rank of the company's Employee rating in comparison to all companies within the CSRHub ESG universe.  # noqa: E501

        :return: The employee_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :rtype: float
        """
        return self._employee_percentile_rank
        
    @property
    def employee_percentile_rank_dict(self):
        """Gets the employee_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501

        The percentile rank of the company's Employee rating in comparison to all companies within the CSRHub ESG universe. as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The employee_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.employee_percentile_rank
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'employee_percentile_rank': value }

        
        return result
        

    @employee_percentile_rank.setter
    def employee_percentile_rank(self, employee_percentile_rank):
        """Sets the employee_percentile_rank of this ESGComprehensiveRatingWithCompany.

        The percentile rank of the company's Employee rating in comparison to all companies within the CSRHub ESG universe.  # noqa: E501

        :param employee_percentile_rank: The employee_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :type: float
        """

        self._employee_percentile_rank = employee_percentile_rank

    @property
    def environment_percentile_rank(self):
        """Gets the environment_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501

        The percentile rank of the company's Environment rating in comparison to all companies within the CSRHub ESG universe.  # noqa: E501

        :return: The environment_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :rtype: float
        """
        return self._environment_percentile_rank
        
    @property
    def environment_percentile_rank_dict(self):
        """Gets the environment_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501

        The percentile rank of the company's Environment rating in comparison to all companies within the CSRHub ESG universe. as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The environment_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.environment_percentile_rank
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'environment_percentile_rank': value }

        
        return result
        

    @environment_percentile_rank.setter
    def environment_percentile_rank(self, environment_percentile_rank):
        """Sets the environment_percentile_rank of this ESGComprehensiveRatingWithCompany.

        The percentile rank of the company's Environment rating in comparison to all companies within the CSRHub ESG universe.  # noqa: E501

        :param environment_percentile_rank: The environment_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :type: float
        """

        self._environment_percentile_rank = environment_percentile_rank

    @property
    def governance_percentile_rank(self):
        """Gets the governance_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501

        The percentile rank of the company's Governance rating in comparison to all companies within the CSRHub ESG universe.  # noqa: E501

        :return: The governance_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :rtype: float
        """
        return self._governance_percentile_rank
        
    @property
    def governance_percentile_rank_dict(self):
        """Gets the governance_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501

        The percentile rank of the company's Governance rating in comparison to all companies within the CSRHub ESG universe. as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The governance_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.governance_percentile_rank
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'governance_percentile_rank': value }

        
        return result
        

    @governance_percentile_rank.setter
    def governance_percentile_rank(self, governance_percentile_rank):
        """Sets the governance_percentile_rank of this ESGComprehensiveRatingWithCompany.

        The percentile rank of the company's Governance rating in comparison to all companies within the CSRHub ESG universe.  # noqa: E501

        :param governance_percentile_rank: The governance_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :type: float
        """

        self._governance_percentile_rank = governance_percentile_rank

    @property
    def human_rights_and_supply_chain_percentile_rank(self):
        """Gets the human_rights_and_supply_chain_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501

        The percentile rank of the company's Human Rights and Supply Chain rating in comparison to all companies within the CSRHub ESG universe.  # noqa: E501

        :return: The human_rights_and_supply_chain_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :rtype: float
        """
        return self._human_rights_and_supply_chain_percentile_rank
        
    @property
    def human_rights_and_supply_chain_percentile_rank_dict(self):
        """Gets the human_rights_and_supply_chain_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501

        The percentile rank of the company's Human Rights and Supply Chain rating in comparison to all companies within the CSRHub ESG universe. as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The human_rights_and_supply_chain_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.human_rights_and_supply_chain_percentile_rank
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'human_rights_and_supply_chain_percentile_rank': value }

        
        return result
        

    @human_rights_and_supply_chain_percentile_rank.setter
    def human_rights_and_supply_chain_percentile_rank(self, human_rights_and_supply_chain_percentile_rank):
        """Sets the human_rights_and_supply_chain_percentile_rank of this ESGComprehensiveRatingWithCompany.

        The percentile rank of the company's Human Rights and Supply Chain rating in comparison to all companies within the CSRHub ESG universe.  # noqa: E501

        :param human_rights_and_supply_chain_percentile_rank: The human_rights_and_supply_chain_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :type: float
        """

        self._human_rights_and_supply_chain_percentile_rank = human_rights_and_supply_chain_percentile_rank

    @property
    def community_dev_and_philanthropy_percentile_rank(self):
        """Gets the community_dev_and_philanthropy_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501

        The percentile rank of the company's Community, Dev, and Philanthropy rating in comparison to all companies within the CSRHub ESG universe.  # noqa: E501

        :return: The community_dev_and_philanthropy_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :rtype: float
        """
        return self._community_dev_and_philanthropy_percentile_rank
        
    @property
    def community_dev_and_philanthropy_percentile_rank_dict(self):
        """Gets the community_dev_and_philanthropy_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501

        The percentile rank of the company's Community, Dev, and Philanthropy rating in comparison to all companies within the CSRHub ESG universe. as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The community_dev_and_philanthropy_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.community_dev_and_philanthropy_percentile_rank
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'community_dev_and_philanthropy_percentile_rank': value }

        
        return result
        

    @community_dev_and_philanthropy_percentile_rank.setter
    def community_dev_and_philanthropy_percentile_rank(self, community_dev_and_philanthropy_percentile_rank):
        """Sets the community_dev_and_philanthropy_percentile_rank of this ESGComprehensiveRatingWithCompany.

        The percentile rank of the company's Community, Dev, and Philanthropy rating in comparison to all companies within the CSRHub ESG universe.  # noqa: E501

        :param community_dev_and_philanthropy_percentile_rank: The community_dev_and_philanthropy_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :type: float
        """

        self._community_dev_and_philanthropy_percentile_rank = community_dev_and_philanthropy_percentile_rank

    @property
    def product_percentile_rank(self):
        """Gets the product_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501

        The percentile rank of the company's Product rating in comparison to all companies within the CSRHub ESG universe.  # noqa: E501

        :return: The product_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :rtype: float
        """
        return self._product_percentile_rank
        
    @property
    def product_percentile_rank_dict(self):
        """Gets the product_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501

        The percentile rank of the company's Product rating in comparison to all companies within the CSRHub ESG universe. as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The product_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.product_percentile_rank
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'product_percentile_rank': value }

        
        return result
        

    @product_percentile_rank.setter
    def product_percentile_rank(self, product_percentile_rank):
        """Sets the product_percentile_rank of this ESGComprehensiveRatingWithCompany.

        The percentile rank of the company's Product rating in comparison to all companies within the CSRHub ESG universe.  # noqa: E501

        :param product_percentile_rank: The product_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :type: float
        """

        self._product_percentile_rank = product_percentile_rank

    @property
    def compensation_and_benefits_percentile_rank(self):
        """Gets the compensation_and_benefits_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501

        The percentile rank of the company's Compensation and Benefits rating in comparison to all companies within the CSRHub ESG universe.  # noqa: E501

        :return: The compensation_and_benefits_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :rtype: float
        """
        return self._compensation_and_benefits_percentile_rank
        
    @property
    def compensation_and_benefits_percentile_rank_dict(self):
        """Gets the compensation_and_benefits_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501

        The percentile rank of the company's Compensation and Benefits rating in comparison to all companies within the CSRHub ESG universe. as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The compensation_and_benefits_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.compensation_and_benefits_percentile_rank
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'compensation_and_benefits_percentile_rank': value }

        
        return result
        

    @compensation_and_benefits_percentile_rank.setter
    def compensation_and_benefits_percentile_rank(self, compensation_and_benefits_percentile_rank):
        """Sets the compensation_and_benefits_percentile_rank of this ESGComprehensiveRatingWithCompany.

        The percentile rank of the company's Compensation and Benefits rating in comparison to all companies within the CSRHub ESG universe.  # noqa: E501

        :param compensation_and_benefits_percentile_rank: The compensation_and_benefits_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :type: float
        """

        self._compensation_and_benefits_percentile_rank = compensation_and_benefits_percentile_rank

    @property
    def diversity_and_labor_rights_percentile_rank(self):
        """Gets the diversity_and_labor_rights_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501

        The percentile rank of the company's Diversity and Labor Rights rating in comparison to all companies within the CSRHub ESG universe.  # noqa: E501

        :return: The diversity_and_labor_rights_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :rtype: float
        """
        return self._diversity_and_labor_rights_percentile_rank
        
    @property
    def diversity_and_labor_rights_percentile_rank_dict(self):
        """Gets the diversity_and_labor_rights_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501

        The percentile rank of the company's Diversity and Labor Rights rating in comparison to all companies within the CSRHub ESG universe. as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The diversity_and_labor_rights_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.diversity_and_labor_rights_percentile_rank
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'diversity_and_labor_rights_percentile_rank': value }

        
        return result
        

    @diversity_and_labor_rights_percentile_rank.setter
    def diversity_and_labor_rights_percentile_rank(self, diversity_and_labor_rights_percentile_rank):
        """Sets the diversity_and_labor_rights_percentile_rank of this ESGComprehensiveRatingWithCompany.

        The percentile rank of the company's Diversity and Labor Rights rating in comparison to all companies within the CSRHub ESG universe.  # noqa: E501

        :param diversity_and_labor_rights_percentile_rank: The diversity_and_labor_rights_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :type: float
        """

        self._diversity_and_labor_rights_percentile_rank = diversity_and_labor_rights_percentile_rank

    @property
    def training_health_and_safety_percentile_rank(self):
        """Gets the training_health_and_safety_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501

        The percentile rank of the company's Training, Health, and Safety rating in comparison to all companies within the CSRHub ESG universe.  # noqa: E501

        :return: The training_health_and_safety_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :rtype: float
        """
        return self._training_health_and_safety_percentile_rank
        
    @property
    def training_health_and_safety_percentile_rank_dict(self):
        """Gets the training_health_and_safety_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501

        The percentile rank of the company's Training, Health, and Safety rating in comparison to all companies within the CSRHub ESG universe. as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The training_health_and_safety_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.training_health_and_safety_percentile_rank
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'training_health_and_safety_percentile_rank': value }

        
        return result
        

    @training_health_and_safety_percentile_rank.setter
    def training_health_and_safety_percentile_rank(self, training_health_and_safety_percentile_rank):
        """Sets the training_health_and_safety_percentile_rank of this ESGComprehensiveRatingWithCompany.

        The percentile rank of the company's Training, Health, and Safety rating in comparison to all companies within the CSRHub ESG universe.  # noqa: E501

        :param training_health_and_safety_percentile_rank: The training_health_and_safety_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :type: float
        """

        self._training_health_and_safety_percentile_rank = training_health_and_safety_percentile_rank

    @property
    def energy_climate_change_percentile_rank(self):
        """Gets the energy_climate_change_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501

        The percentile rank of the company's Energy Climate Change rating in comparison to all companies within the CSRHub ESG universe.  # noqa: E501

        :return: The energy_climate_change_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :rtype: float
        """
        return self._energy_climate_change_percentile_rank
        
    @property
    def energy_climate_change_percentile_rank_dict(self):
        """Gets the energy_climate_change_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501

        The percentile rank of the company's Energy Climate Change rating in comparison to all companies within the CSRHub ESG universe. as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The energy_climate_change_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.energy_climate_change_percentile_rank
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'energy_climate_change_percentile_rank': value }

        
        return result
        

    @energy_climate_change_percentile_rank.setter
    def energy_climate_change_percentile_rank(self, energy_climate_change_percentile_rank):
        """Sets the energy_climate_change_percentile_rank of this ESGComprehensiveRatingWithCompany.

        The percentile rank of the company's Energy Climate Change rating in comparison to all companies within the CSRHub ESG universe.  # noqa: E501

        :param energy_climate_change_percentile_rank: The energy_climate_change_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :type: float
        """

        self._energy_climate_change_percentile_rank = energy_climate_change_percentile_rank

    @property
    def environment_policy_and_reporting_percentile_rank(self):
        """Gets the environment_policy_and_reporting_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501

        The percentile rank of the company's Environment Policy and Reporting rating in comparison to all companies within the CSRHub ESG universe.  # noqa: E501

        :return: The environment_policy_and_reporting_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :rtype: float
        """
        return self._environment_policy_and_reporting_percentile_rank
        
    @property
    def environment_policy_and_reporting_percentile_rank_dict(self):
        """Gets the environment_policy_and_reporting_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501

        The percentile rank of the company's Environment Policy and Reporting rating in comparison to all companies within the CSRHub ESG universe. as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The environment_policy_and_reporting_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.environment_policy_and_reporting_percentile_rank
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'environment_policy_and_reporting_percentile_rank': value }

        
        return result
        

    @environment_policy_and_reporting_percentile_rank.setter
    def environment_policy_and_reporting_percentile_rank(self, environment_policy_and_reporting_percentile_rank):
        """Sets the environment_policy_and_reporting_percentile_rank of this ESGComprehensiveRatingWithCompany.

        The percentile rank of the company's Environment Policy and Reporting rating in comparison to all companies within the CSRHub ESG universe.  # noqa: E501

        :param environment_policy_and_reporting_percentile_rank: The environment_policy_and_reporting_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :type: float
        """

        self._environment_policy_and_reporting_percentile_rank = environment_policy_and_reporting_percentile_rank

    @property
    def resource_management_percentile_rank(self):
        """Gets the resource_management_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501

        The percentile rank of the company's Resource Management rating in comparison to all companies within the CSRHub ESG universe.  # noqa: E501

        :return: The resource_management_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :rtype: float
        """
        return self._resource_management_percentile_rank
        
    @property
    def resource_management_percentile_rank_dict(self):
        """Gets the resource_management_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501

        The percentile rank of the company's Resource Management rating in comparison to all companies within the CSRHub ESG universe. as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The resource_management_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.resource_management_percentile_rank
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'resource_management_percentile_rank': value }

        
        return result
        

    @resource_management_percentile_rank.setter
    def resource_management_percentile_rank(self, resource_management_percentile_rank):
        """Sets the resource_management_percentile_rank of this ESGComprehensiveRatingWithCompany.

        The percentile rank of the company's Resource Management rating in comparison to all companies within the CSRHub ESG universe.  # noqa: E501

        :param resource_management_percentile_rank: The resource_management_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :type: float
        """

        self._resource_management_percentile_rank = resource_management_percentile_rank

    @property
    def board_percentile_rank(self):
        """Gets the board_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501

        The percentile rank of the company's Board rating in comparison to all companies within the CSRHub ESG universe.  # noqa: E501

        :return: The board_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :rtype: float
        """
        return self._board_percentile_rank
        
    @property
    def board_percentile_rank_dict(self):
        """Gets the board_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501

        The percentile rank of the company's Board rating in comparison to all companies within the CSRHub ESG universe. as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The board_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.board_percentile_rank
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'board_percentile_rank': value }

        
        return result
        

    @board_percentile_rank.setter
    def board_percentile_rank(self, board_percentile_rank):
        """Sets the board_percentile_rank of this ESGComprehensiveRatingWithCompany.

        The percentile rank of the company's Board rating in comparison to all companies within the CSRHub ESG universe.  # noqa: E501

        :param board_percentile_rank: The board_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :type: float
        """

        self._board_percentile_rank = board_percentile_rank

    @property
    def leadership_ethics_percentile_rank(self):
        """Gets the leadership_ethics_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501

        The percentile rank of the company's Leadership Ethics rating in comparison to all companies within the CSRHub ESG universe.  # noqa: E501

        :return: The leadership_ethics_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :rtype: float
        """
        return self._leadership_ethics_percentile_rank
        
    @property
    def leadership_ethics_percentile_rank_dict(self):
        """Gets the leadership_ethics_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501

        The percentile rank of the company's Leadership Ethics rating in comparison to all companies within the CSRHub ESG universe. as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The leadership_ethics_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.leadership_ethics_percentile_rank
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'leadership_ethics_percentile_rank': value }

        
        return result
        

    @leadership_ethics_percentile_rank.setter
    def leadership_ethics_percentile_rank(self, leadership_ethics_percentile_rank):
        """Sets the leadership_ethics_percentile_rank of this ESGComprehensiveRatingWithCompany.

        The percentile rank of the company's Leadership Ethics rating in comparison to all companies within the CSRHub ESG universe.  # noqa: E501

        :param leadership_ethics_percentile_rank: The leadership_ethics_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :type: float
        """

        self._leadership_ethics_percentile_rank = leadership_ethics_percentile_rank

    @property
    def transparency_reporting_percentile_rank(self):
        """Gets the transparency_reporting_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501

        The percentile rank of the company's Transaperency Reporting rating in comparison to all companies within the CSRHub ESG universe.  # noqa: E501

        :return: The transparency_reporting_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :rtype: float
        """
        return self._transparency_reporting_percentile_rank
        
    @property
    def transparency_reporting_percentile_rank_dict(self):
        """Gets the transparency_reporting_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501

        The percentile rank of the company's Transaperency Reporting rating in comparison to all companies within the CSRHub ESG universe. as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The transparency_reporting_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.transparency_reporting_percentile_rank
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'transparency_reporting_percentile_rank': value }

        
        return result
        

    @transparency_reporting_percentile_rank.setter
    def transparency_reporting_percentile_rank(self, transparency_reporting_percentile_rank):
        """Sets the transparency_reporting_percentile_rank of this ESGComprehensiveRatingWithCompany.

        The percentile rank of the company's Transaperency Reporting rating in comparison to all companies within the CSRHub ESG universe.  # noqa: E501

        :param transparency_reporting_percentile_rank: The transparency_reporting_percentile_rank of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :type: float
        """

        self._transparency_reporting_percentile_rank = transparency_reporting_percentile_rank

    @property
    def company(self):
        """Gets the company of this ESGComprehensiveRatingWithCompany.  # noqa: E501


        :return: The company of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :rtype: ESGCompanySummary
        """
        return self._company
        
    @property
    def company_dict(self):
        """Gets the company of this ESGComprehensiveRatingWithCompany.  # noqa: E501


        :return: The company of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :rtype: ESGCompanySummary
        """

        result = None

        value = self.company
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'company': value }

        
        return result
        

    @company.setter
    def company(self, company):
        """Sets the company of this ESGComprehensiveRatingWithCompany.


        :param company: The company of this ESGComprehensiveRatingWithCompany.  # noqa: E501
        :type: ESGCompanySummary
        """

        self._company = company

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ESGComprehensiveRatingWithCompany):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
