# -*- coding: utf-8 -*-
# Generated by Django 1.11.2 on 2019-05-17 16:51


from django.db import migrations

from aparnik.contrib.notifications.models import NotificationType


def add_keys(apps, schema_editor):
    '''
    We can't import the Post model directly as it may be a newer
    version than this migration expects. We use the historical version.
    '''
    Notification = apps.get_model('notifications', 'Notification')
    for notification in Notification.objects.all():
        notification.notification_send_type = NotificationType.ALL_USER if notification.is_for_all_users else NotificationType.SINGLE_USER
        notification.save()


def remove_keys(apps, schema_editor):
    '''
    We can't import the Post model directly as it may be a newer
    version than this migration expects. We use the historical version.
    '''
    Notification = apps.get_model('notifications', 'Notification')
    for notification in Notification.objects.all():
        notification.is_for_all_users = notification.notification_send_type == NotificationType.ALL_USER
        notification.save()


class Migration(migrations.Migration):

    dependencies = [
        ('notifications', '0002_notification_notification_send_type'),
    ]

    operations = [
        migrations.RunPython(add_keys, reverse_code=remove_keys),
    ]
