# -*- coding: utf-8 -*-
# Generated by Django 1.11.2 on 2019-01-09 13:21


from django.db import migrations


def add_keys(apps, schema_editor):
    '''
    We can't import the Post model directly as it may be a newer
    version than this migration expects. We use the historical version.
    '''
    Setting = apps.get_model('settings', 'Setting')

    key = ''
    try:
        key = 'ORDER_CODE_PREFIX'
        Setting.objects.get(key=key)
    except Exception:
        Setting.objects.create(
            title='پیشوند کد فاکتور',
            key=key,
            value='APARNIK',
            value_type='s',
            is_show=False,
            is_variable_in_home=False,
        )
    try:
        key = 'POSTAL_COST'
        Setting.objects.get(key=key)
    except Exception:
        Setting.objects.create(
            title='هزینه پستی',
            key=key,
            value=0,
            value_type='i',
            is_show=False,
            is_variable_in_home=False,
        )


class Migration(migrations.Migration):

    dependencies = [
        ('settings', '0007_auto_20190105_1314'),
    ]

    operations = [
        migrations.RunPython(add_keys, reverse_code=migrations.RunPython.noop),
    ]
