# -*- coding: utf-8 -*-
# Generated by Django 1.11.2 on 2019-01-22 23:37


from django.db import migrations


def add_keys(apps, schema_editor):
    '''
    We can't import the Post model directly as it may be a newer
    version than this migration expects. We use the historical version.
    '''
    Setting = apps.get_model('settings', 'Setting')

    key = ''
    try:
        key = 'INVITATION_FORMAT_STRING'
        Setting.objects.get(key=key)
    except Exception:
        Setting.objects.create(
            title=' کد دعوت',
            key=key,
            value='شما می توانید با کد {{}} به برنامه بپیوندید.',
            value_type='s',
            is_show=False,
            is_variable_in_home=True,
        )


class Migration(migrations.Migration):

    dependencies = [
        ('settings', '0011_auto_20190122_2122'),
    ]

    operations = [
        migrations.RunPython(add_keys, reverse_code=migrations.RunPython.noop),
    ]
