# -*- coding: utf-8 -*-
# Generated by Django 1.11.2 on 2018-10-25 15:43


import aparnik.utils.fields
from django.conf import settings
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Coupon',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('code', models.CharField(blank=True, help_text='If blank default no limitation.', max_length=10, null=True, unique=True, verbose_name='Code')),
                ('expire_at', models.DateTimeField(blank=True, help_text='If blank default no limitation.', null=True, verbose_name='Expire at')),
                ('value', aparnik.utils.fields.PriceField(decimal_places=0, max_digits=8, validators=[django.core.validators.MinValueValidator(1)], verbose_name='Value')),
                ('type', models.CharField(choices=[('p', 'Percent'), ('v', 'Value')], default='p', max_length=2, verbose_name='type')),
                ('max_price_order', aparnik.utils.fields.PriceField(decimal_places=0, default=0, help_text='If blank default no limitation.', max_digits=20, verbose_name='Max price of order')),
                ('min_price_order', aparnik.utils.fields.PriceField(decimal_places=0, default=0, help_text='If blank default no limitation.', max_digits=20, verbose_name='Min price of order')),
                ('for_users', models.CharField(choices=[('a', 'All user'), ('l', 'Limited user'), ('c', 'Custom user')], default='a', max_length=2, verbose_name='For users')),
                ('for_limited_users_value', models.IntegerField(blank=True, null=True, verbose_name='Limited users value')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='Created at')),
                ('update_at', models.DateTimeField(auto_now=True, verbose_name='Update at')),
            ],
            options={
                'ordering': ('-created_at',),
                'verbose_name': 'Coupon',
                'verbose_name_plural': 'Coupons',
            },
        ),
        migrations.CreateModel(
            name='Membership',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('is_redeem', models.BooleanField(default=False, verbose_name='Is redeem')),
                ('coupon', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='coupons.Coupon', verbose_name='Coupon')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='coupons', to=settings.AUTH_USER_MODEL, verbose_name='User')),
            ],
            options={
                'verbose_name': 'Membership',
                'verbose_name_plural': 'Memberships',
            },
        ),
        migrations.AddField(
            model_name='coupon',
            name='users',
            field=models.ManyToManyField(through='coupons.Membership', to=settings.AUTH_USER_MODEL, verbose_name='Membership'),
        ),
        migrations.CreateModel(
            name='CouponForAllUser',
            fields=[
            ],
            options={
                'verbose_name': 'Coupon for all users',
                'proxy': True,
                'verbose_name_plural': 'Coupons for all users',
                'indexes': [],
            },
            bases=('coupons.coupon',),
        ),
        migrations.CreateModel(
            name='CouponForCoustomUser',
            fields=[
            ],
            options={
                'verbose_name': 'Coupon for custom users',
                'proxy': True,
                'verbose_name_plural': 'Coupons for custom users',
                'indexes': [],
            },
            bases=('coupons.coupon',),
        ),
        migrations.CreateModel(
            name='CouponForLimitedUser',
            fields=[
            ],
            options={
                'verbose_name': 'Coupon for limited users',
                'proxy': True,
                'verbose_name_plural': 'Coupons for limited users',
                'indexes': [],
            },
            bases=('coupons.coupon',),
        ),
    ]
