import { HttpRouteIntegrationBindOptions, HttpRouteIntegrationConfig } from '@aws-cdk/aws-apigatewayv2-alpha';
import * as elbv2 from 'aws-cdk-lib/aws-elasticloadbalancingv2';
import { HttpPrivateIntegrationOptions } from './base-types';
import { HttpPrivateIntegration } from './private/integration';
/**
 * (experimental) Properties to initialize `HttpAlbIntegration`.
 *
 * @experimental
 */
export interface HttpAlbIntegrationProps extends HttpPrivateIntegrationOptions {
}
/**
 * (experimental) The Application Load Balancer integration resource for HTTP API.
 *
 * @experimental
 */
export declare class HttpAlbIntegration extends HttpPrivateIntegration {
    private readonly listener;
    private readonly props;
    /**
     * @param id id of the underlying integration construct.
     * @param listener the ELB application listener.
     * @param props properties to configure the integration.
     * @experimental
     */
    constructor(id: string, listener: elbv2.IApplicationListener, props?: HttpAlbIntegrationProps);
    /**
     * (experimental) (experimental) Bind this integration to the route.
     *
     * @experimental
     */
    bind(options: HttpRouteIntegrationBindOptions): HttpRouteIntegrationConfig;
}
