"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpServiceDiscoveryIntegration = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const integration_1 = require("./private/integration");
/**
 * (experimental) The Service Discovery integration resource for HTTP API.
 *
 * @experimental
 */
class HttpServiceDiscoveryIntegration extends integration_1.HttpPrivateIntegration {
    /**
     * @param id id of the underlying integration construct.
     * @param service the service discovery resource to integrate with.
     * @param props properties to configure the integration.
     * @experimental
     */
    constructor(id, service, props = {}) {
        super(id);
        this.service = service;
        this.props = props;
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_integrations_alpha_HttpServiceDiscoveryIntegrationProps(props);
    }
    /**
     * (experimental) (experimental) Bind this integration to the route.
     *
     * @experimental
     */
    bind(_) {
        var _b;
        if (!this.props.vpcLink) {
            throw new Error('The vpcLink property is mandatory');
        }
        return {
            method: (_b = this.props.method) !== null && _b !== void 0 ? _b : this.httpMethod,
            payloadFormatVersion: this.payloadFormatVersion,
            type: this.integrationType,
            connectionType: this.connectionType,
            connectionId: this.props.vpcLink.vpcLinkId,
            uri: this.service.serviceArn,
            secureServerName: this.props.secureServerName,
            parameterMapping: this.props.parameterMapping,
        };
    }
}
exports.HttpServiceDiscoveryIntegration = HttpServiceDiscoveryIntegration;
_a = JSII_RTTI_SYMBOL_1;
HttpServiceDiscoveryIntegration[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-integrations-alpha.HttpServiceDiscoveryIntegration", version: "2.10.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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