# Generated by Django 3.2.7 on 2021-11-24 16:11

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import simple_history.models


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("francedata", "0002_auto_20211101_1541"),
    ]

    operations = [
        migrations.CreateModel(
            name="DataMapping",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created_at",
                    models.DateTimeField(
                        auto_now_add=True, verbose_name="date de création"
                    ),
                ),
                (
                    "updated_at",
                    models.DateTimeField(
                        auto_now=True, verbose_name="date de modification"
                    ),
                ),
                ("name", models.CharField(max_length=100, verbose_name="nom")),
                (
                    "file_format",
                    models.CharField(
                        choices=[("csv", "csv"), ("excel", "excel")],
                        max_length=5,
                        verbose_name="format du fichier",
                    ),
                ),
                ("mapping", models.JSONField(verbose_name="données")),
            ],
            options={
                "verbose_name": "table de correspondance",
                "verbose_name_plural": "tables de correspondance",
                "ordering": ["name"],
            },
        ),
        migrations.AddField(
            model_name="communedata",
            name="label",
            field=models.CharField(
                blank=True, max_length=255, null=True, verbose_name="label"
            ),
        ),
        migrations.AddField(
            model_name="departementdata",
            name="label",
            field=models.CharField(
                blank=True, max_length=255, null=True, verbose_name="label"
            ),
        ),
        migrations.AddField(
            model_name="epcidata",
            name="label",
            field=models.CharField(
                blank=True, max_length=255, null=True, verbose_name="label"
            ),
        ),
        migrations.AddField(
            model_name="regiondata",
            name="label",
            field=models.CharField(
                blank=True, max_length=255, null=True, verbose_name="label"
            ),
        ),
        migrations.RemoveField(
            model_name="datasource",
            name="imported_at",
        ),
        migrations.RemoveField(
            model_name="datasource",
            name="is_imported",
        ),
        migrations.CreateModel(
            name="DataSourceFile",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created_at",
                    models.DateTimeField(
                        auto_now_add=True, verbose_name="date de création"
                    ),
                ),
                (
                    "updated_at",
                    models.DateTimeField(
                        auto_now=True, verbose_name="date de modification"
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        blank=True, max_length=100, null=True, verbose_name="Nom"
                    ),
                ),
                (
                    "data_file",
                    models.FileField(upload_to="", verbose_name="Fichier de données"),
                ),
                (
                    "data_mapping",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="francedata.datamapping",
                        verbose_name="Table de correspondance",
                    ),
                ),
                (
                    "source",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="francedata.datasource",
                        verbose_name="source",
                    ),
                ),
                (
                    "imported_at",
                    models.DateTimeField(
                        blank=True, null=True, verbose_name="date d’import"
                    ),
                ),
                (
                    "is_imported",
                    models.BooleanField(default=False, verbose_name="import effectué"),
                ),
            ],
            options={
                "verbose_name": "fichier source",
                "verbose_name_plural": "Sources - fichiers",
            },
        ),
        migrations.CreateModel(
            name="HistoricalDataMapping",
            fields=[
                (
                    "id",
                    models.BigIntegerField(
                        auto_created=True, blank=True, db_index=True, verbose_name="ID"
                    ),
                ),
                (
                    "created_at",
                    models.DateTimeField(
                        blank=True, editable=False, verbose_name="date de création"
                    ),
                ),
                (
                    "updated_at",
                    models.DateTimeField(
                        blank=True, editable=False, verbose_name="date de modification"
                    ),
                ),
                ("name", models.CharField(max_length=100, verbose_name="nom")),
                (
                    "file_format",
                    models.CharField(
                        choices=[("csv", "csv"), ("excel", "excel")],
                        max_length=5,
                        verbose_name="format du fichier",
                    ),
                ),
                ("mapping", models.JSONField(verbose_name="données")),
                ("history_id", models.AutoField(primary_key=True, serialize=False)),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "verbose_name": "historical table de correspondance",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
    ]
