import { PolicyDocument } from '@aws-cdk/aws-iam';
import { Resource } from '@aws-cdk/core';
import { Construct } from 'constructs';
import { IQueue } from './queue-base';
/**
 * Properties to associate SQS queues with a policy.
 *
 * @stability stable
 */
export interface QueuePolicyProps {
    /**
     * The set of queues this policy applies to.
     *
     * @stability stable
     */
    readonly queues: IQueue[];
}
/**
 * Applies a policy to SQS queues.
 *
 * @stability stable
 */
export declare class QueuePolicy extends Resource {
    /**
     * The IAM policy document for this policy.
     *
     * @stability stable
     */
    readonly document: PolicyDocument;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: QueuePolicyProps);
}
