# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['termsandconditions',
 'termsandconditions.management',
 'termsandconditions.management.commands',
 'termsandconditions.migrations',
 'termsandconditions.templatetags']

package_data = \
{'': ['*'],
 'termsandconditions': ['locale/en/LC_MESSAGES/*',
                        'locale/pt_BR/LC_MESSAGES/*',
                        'locale/ru/LC_MESSAGES/*',
                        'static/termsandconditions/css/*',
                        'static/termsandconditions/js/*',
                        'templates/termsandconditions/*',
                        'templates/termsandconditions/snippets/*']}

install_requires = \
['Django>2.2']

setup_kwargs = {
    'name': 'django-termsandconditions',
    'version': '2.0.9',
    'description': 'Django app that enables users to accept terms and conditions of a site.',
    'long_description': "Django Terms and Conditions\n===========================\n\n[![PyPi Package Version](https://badge.fury.io/py/django-termsandconditions.svg)](http://badge.fury.io/py/django-termsandconditions) [![Actions Status](https://github.com/cyface/django-termsandconditions/workflows/Python%20package/badge.svg)](https://github.com/cyface/django-termsandconditions/actions) [![codecov](https://codecov.io/gh/cyface/django-termsandconditions/branch/master/graph/badge.svg?token=RvtjZ2bngZ)](https://codecov.io/gh/cyface/django-termsandconditions)\n\nDjango Terms and Conditions gives you an configurable way to send users\nto a T&C acceptance page before they can access the site.\n\n*Note that version 2.0+ requires Python 3.6+ and Django 2.2+.*\n\nMaintainer: - Tim White (<tim@cyface.com>)\n\nContributors: - Adibo (<https://github.com/adibo>) - Nathan Swain (<https://github.com/swainn>)\n\nFeatures\n--------\n\nThis module is meant to be as quick to integrate as possible, and thus\nextensive customization will likely benefit from a fork. That said, a\nnumber of options are available. Currently, the app allows for\n\n-   terms-and-conditions versioning (via version\\_number)\n-   multiple terms-and-conditions allowed (via slug field)\n-   per-user terms-and-conditions acceptance\n-   middleware to take care of redirecting to proper\n    terms-and-conditions acceptance page upon the version change\n-   multi-language support\n\nInstallation\n------------\n\n**Note that version 2.0+ of django-termsandconditions only works with Python 3.6+ and Django 2.2+**\n\nFrom [pypi](https://pypi.python.org):\n\n    $ pip install django-termsandconditions\n\nor:\n\n    $ easy_install django-termsandconditions\n\nor clone from [github](http://github.com):\n\n    $ git clone git://github.com/cyface/django-termsandconditions.git\n\nand add django-termsandconditions to the `PYTHONPATH`:\n\n    $ export PYTHONPATH=$PYTHONPATH:$(pwd)/django-termsandconditions/\n\nor:\n\n    $ cd django-termsandconditions\n    $ sudo python setup.py install\n\nDemo App\n--------\n\nThe termsandconditions\\_demo app is included to quickly let you see how\nto get a working installation going.\n\nThe demo is built as a mobile app using\n[jQueryMobile](http://jquerymobile.com/) loaded from the jQuery CDN.\n\nTake a look at the `requirements.txt` file in the\n`termsandconditions_demo` directory for a quick way to use pip to\ninstall all the needed dependencies:\n\n    $ pip install -r requirements.txt\n\nThe `settings_main.py`, file has a working configuration you can crib\nfrom.\n\nThe templates in the `termsandconditions/templates`, and\n`termsandconditions_demo/templates` directories give you a good idea of\nthe kinds of things you will need to do if you want to provide a custom\ninterface.\n\nConfiguration\n-------------\n\nConfiguration is minimal for termsandconditions itself, A quick guide to\na basic setup is below, take a look at the demo app's settings.py for\nmore details.\n\nSome useful settings:\n:   -   TERMS\\_IP\\_HEADER\\_NAME Name of header to check for IP address.\n        Defaults to 'REMOTE\\_ADDR'. You might need to use\n        'HTTP\\_X\\_FORWARDED\\_FOR', or other headers in proxy setups.\n    -   TERMS\\_STORE\\_IP\\_ADDRESS - True/False whether to store IPs with\n        Terms Acceptance\n\n### Requirements\n\nThe app needs `django>=2.2`.\n\n### Add INSTALLED\\_APPS\n\nAdd termsandconditions to installed applications:\n\n    INSTALLED_APPS = (\n        ...\n        'termsandconditions',\n    )\n\n### Add urls to urls.py\n\nIn your urls.py, you need to pull in the termsandconditions and/or\ntermsandconditions urls:\n\n    # Terms and Conditions\n    url(r'^terms/', include('termsandconditions.urls')),\n\nTerms and Conditions\n--------------------\n\nYou will need to set up a Terms and Conditions entry in the admin (or\nvia direct DB load) for users to accept if you want to use the T&C\nmodule.\n\n### Terms and Conditions Versioning\n\nNote that the versions and dates of T&Cs are important. You can create a\nnew version of a T&C with a future date, and once that date is in the\npast, it will force users to accept that new version of the T&Cs.\n\n### Terms and Conditions Default URLs\n\nIf you have included the terms urls under **/terms**, these URLs would\nall be prefixed by that (e.g. /terms/accept/).\n\n-   **/** - List all terms that have not been accepted\n-   **/accept/** - List all terms that have not been accepted with\n    accept links\n-   **/accept/\\<slug\\>/** - Show page to accept latest version of a\n    specific terms\n-   **/accept/\\<slug\\>/\\<version\\>/** - Show page to accept a specific\n    version of a specific terms\n-   **/active/** - List all active terms\n-   **/email/** - Show page to email all unaccepted terms\n-   **/email/\\<slug\\>/\\<version\\>/** - Show page to email specific\n    version of specific terms\n-   **/view/\\<slug\\>/** - View the latest version of a specific terms\n-   **/view/\\<slug\\>/\\<version\\>/** - View a specific version of a\n    specific terms\n\n### Terms and Conditions Middleware\n\nYou can force protection of your whole site by using the T&C middleware.\nOnce activated, any attempt to access an authenticated page will first\ncheck to see if the user has accepted the active T&Cs. This can be a\nperformance impact, so you can also use the\n\\_TermsAndConditionsDecorator to protect specific views, or the pipeline\nsetup to only check on account creation.\n\nHere is the middleware configuration:\n\n    MIDDLEWARE_CLASSES = (\n        ...\n        'termsandconditions.middleware.TermsAndConditionsRedirectMiddleware',\n\nBy default, some pages are excluded from the middleware, you can\nconfigure exclusions with these settings:\n\n    ACCEPT_TERMS_PATH = '/terms/accept/'\n    TERMS_EXCLUDE_URL_PREFIX_LIST = {'/admin/',})\n    TERMS_EXCLUDE_URL_LIST = {'/', '/terms/required/', '/logout/', '/securetoo/'}\n    TERMS_EXCLUDE_URL_CONTAINS_LIST = {}\n\nTERMS\\_EXCLUDE\\_URL\\_PREFIX\\_LIST is a list of 'starts with' strings to\nexclude, while TERMS\\_EXCLUDE\\_URL\\_LIST is a list of explicit full\npaths to exclude. TERMS\\_EXCLUDE\\_URL\\_CONTAINS\\_LIST is a list of url\nfragments to check, if the url 'contains' that string, it is excluded.\nThis can be particularly useful for i18n, where your url could get\nprepended with a language code.\n\nYou can also define a setting TERMS\\_EXCLUDE\\_USERS\\_WITH\\_PERM to\nexclude users with a custom permission you create yourself.:\n\n    TERMS_EXCLUDE_USERS_WITH_PERM = 'MyModel.can_skip_terms'\n\nThis can be useful if you need to run continuous login integration tests\nor simply exclude specific users from having to accept your T&Cs. Note\nthat we exclude superusers by default from this check due to Django's\nhas\\_perm() method returning True for any permission check, so adding\nthis permission to a superuser has no effect. If you want to exclude\nsuperusers you can set TERMS\\_EXCLUDE\\_SUPERUSERS:\n\n    TERMS_EXCLUDE_SUPERUSERS = True\n\n### Terms and Conditions Useful Methods\n\n-   **TermsAndConditions.get\\_active\\_terms\\_list()** - Returns a list\n    of all active terms (accepted by current user or not)\n-   **TermsAndConditions.get\\_active\\_terms\\_not\\_agreed\\_to(\\<User\\>)**\n    - Returns a list of terms the specified user has not agreed to\n-   **TermsAndConditions.get\\_active(\\<slug\\>)** - Returns the active\n    terms of the specified terms slug\n\n### Terms and Conditions Cache\n\nTo speed performance, especially for the middleware, the terms and their\nacceptance are cached.\n\nYou can control how long they are cached (or if they are cached at all)\nwith this setting:\n\n    TERMS_CACHE_SECONDS = 30\n\nA numeric value is the number of seconds that the terms and their\nacceptance should be cached (default 30). If set to 0, values will never\nbe cached.\n\n### Terms and Conditions View Decorator\n\nYou can protect only specific views with T&Cs using the\n@terms\\_required() decorator at the top of a function like this:\n\n    from termsandconditions.decorators import terms_required\n\n    @login_required\n    @terms_required\n    def terms_required_view(request):\n        ...\n\nNote that you can skip @login\\_required only if you are forcing auth on\nthat view in some other way.\n\nRequiring T&Cs for Anonymous Users is not supported.\n\nMany of the templates extend the 'base.html' template by default. The\nTERMS\\_BASE\\_TEMPLATE setting can be used to specify a different\ntemplate to extend:\n\n    TERMS_BASE_TEMPLATE = 'page.html'\n\nA bare minimum template that can be used is the following:\n\n    <!DOCTYPE html>\n    <html>\n      <head>\n        <title>[My Title]</title>\n        {% block styles %}{% endblock %}\n        <link href='<path-to-my-css>' rel='stylesheet' type='text/css' />\n      </head>\n      <body>\n        <main>\n          <h2>{% block title %}{% endblock %}</h2>\n          {% block content %}{% endblock %}\n        </main>\n      </body>\n    </html>\n\n### Terms and Conditions Template Tag\n\nTo facilitate support of terms changes without a direct redirection to\nthe `/terms/accept` url, a template tag is supplied for convenience.\nThus, instead of using e.g. the `TermsAndConditionsRedirectMiddleware`\none can use the template tag. The template tag will take care that a\nproper modal is shown to the user informing a user that new terms have\nbeen set and need to be accepted. To use the template tag, do the\nfollowing. In your template (for example in base.html), include the\nfollowing lines:\n\n    {% load terms_tags %}\n    .... your template here ....\n\n    {% show_terms_if_not_agreed %}\n\nAlternatively use:\n\n    {% load terms_tags %}\n    .... your template here ....\n\n    {% show_terms_if_not_agreed field='HTTP_REFERER' %}\n\nif you want other than default `TERMS_HTTP_PATH_FIELD` to be used (this\ncan also be controlled via settings, see below). This will ensure that\non every page using the template (that is on each page using base.html\nin this case), respective T&C css and js are loaded to take care for\nhandling the modal.\n\nThe modal will show the basic information about the new terms as well as\na link to page which enables the user to accept these terms. Please note\nthat a user may wish not to accept terms and close the modal. In such a\ncase, the modal will be shown again as soon as another view with the\ntemplate including the template tag is called. This simple mechanism\nallows to nag users with new T&C while still allowing them to use the\nservice, without instant redirections.\n\nThe following configuration setting applies for the template tag:\n\n    TERMS_HTTP_PATH_FIELD = 'PATH_INFO'\n\nwhich defaults to `PATH_INFO`. When needed (e.g. while using a separate\nAJAX view to take care for the modal) this can be changed to\n`HTTP_REFERER`.\n\n### Using terms with as\\_template filter\n\nIf you happen to use termsandconditions which text field includes some\ntemplate tags (e.g. `{% url 'you-url' %}`), you may want to render its\ncontent, before including it into your template. To achieve this goal,\nuse `include` with the `as_template` filter, i.e.:\n\n    {% load terms_tags %}\n    .... your template here ....\n\n    {% include terms|as_template %}\n\nNote, that you need to modify the default termsandconditions templates,\nas the default ones use terms as template variable.\n\n### Terms and Conditions Pipeline\n\nYou can force T&C acceptance when a new user account is created using\nthe django-socialauth pipeline:\n\n    SOCIAL_AUTH_PIPELINE = (\n        'social_auth.backends.pipeline.social.social_auth_user',\n        'social_auth.backends.pipeline.associate.associate_by_email',\n        'social_auth.backends.pipeline.user.get_username',\n        'social_auth.backends.pipeline.user.create_user',\n        'social_auth.backends.pipeline.social.associate_user',\n        'social_auth.backends.pipeline.social.load_extra_data',\n        'social_auth.backends.pipeline.misc.save_status_to_session',\n        'termsandconditions.pipeline.user_accept_terms',\n    )\n\nNote that the configuration above also prevents django-socialauth from\nupdating profile data from the social backends once a profile is\ncreated, due to:\n\n    'social_auth.backends.pipeline.user.update_user_details'\n\n...not being included in the pipeline. This is wise behavior when you\nare letting users update their own profile details.\n\nThis pipeline configuration will send users to the '/terms/accept' page\nright before sending them on to whatever you have set\nSOCIAL\\_AUTH\\_NEW\\_USER\\_REDIRECT\\_URL to. However, it will not, without\nthe middleware or decorators described above, check that the user has\naccepted the latest T&Cs before letting them continue on to viewing the\nsite.\n\nYou can use the various T&C methods in concert depending on your needs.\n\nMulti-Language Support\n----------------------\n\nIn case you are in need of your `termsandconditions` objects to handle\nmultiple languages, we recommend to use\n`django-modeltranslation <https://github.com/deschler/django-modeltranslation>`\n(or similar) module. In case of django-modeltranslation the setup is\nrather straight forward, but needs several steps. Here they are.\n\n### 1. Modify your `settings.py`\n\nIn your `settings.py` file, you need to specify the `LANGUAGES` and set\n`MIGRATION_MODULES` to point to a local migration directory for the\n`termsandconditions` module (the migration due to modeltranslation will\nlive there):\n\n    LANGUAGES = (\n        ('en', 'English'),\n        ('pl', 'Polish'),\n    )\n\n    MIGRATION_MODULES = {\n        # local path for migration for the termsandconditions\n        'termsandconditions': 'your_app.migrations.migrations_termsandconditions',\n    }\n\nDon't forget to create the respective directory and the `__init__.py`\nfile there! Please note that `migrations_termsandconditions` directory\nname is used to avoid confusion with the T&C app name.\n\nYou will also need to add `modeltranslation` to `INSTALLED_APPS` in your\n`settings.py`.  You also need to ensure the module that you added your translations.py file to is in ``INSTALLED_APPS``.\n\n### 2. Make initial local migration\n\nAs we switch to the local migration for the `termsandconditions` module,\nwe need to execute initial migration for the module (as a starting\npoint). Thus:\n\n    python manage.py makemigrations termsandconditions\n\nThe relevant initial migration file should now be in\n`your_app/migrations/migrations_termsandconditions` directory. Now, just\nexecute the migration:\n\n    python manage.py migrate termsandconditions\n\n### 3. Add translation\n\nTo translate terms-and-conditions model to other languages (as specified\nin `settings.py`), create a `translation.py` file in your project, with\nthe following content:\n\n    from modeltranslation.translator import translator, TranslationOptions\n    from termsandconditions.models import TermsAndConditions\n\n    class TermsAndConditionsTranslationOptions(TranslationOptions):\n        fields = ('name', 'text', 'info')\n    translator.register(TermsAndConditions, TermsAndConditionsTranslationOptions)\n\nThis assumes you want to have 3 most relevant model fields translated.\nAfter that you just need to make migrations again (to account for new\nfields due to modeltranslation):\n\n    python manage.py makemigrations termsandconditions\n    python manage.py migrate termsandconditions\n\nYour model is now ready to cover the translations! Just as\nhint we suggest to also include some data migration in order to populate\nnewly created, translated fields (i.e. `name_en`, `name_pl`, etc.) with\nthe initial data (e.g. by copying the content of the base field, i.e.\n`name`, etc.)\n\n### 4. Add ``/terms/`` to the ``TERMS_EXCLUDE_URL_CONTAINS_LIST`` setting.\nIn order to prevent redirect loops, if you are using internationalized URLs, you will need to add add:\n\n``TERMS_EXCLUDE_URL_CONTAINS_LIST = {'/terms/', '/i18n/setlang/', }``\n\nto your ``settings.py`` to prevent redirect loops with the language-code-prepended URLs (e.g. ``/en/terms/``)\n",
    'author': 'Tim White',
    'author_email': 'tim@cyface.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/cyface/django-termsandconditions',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
