# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from . import utilities, tables

class GetContainerRegistryResult:
    """
    A collection of values returned by getContainerRegistry.
    """
    def __init__(__self__, endpoint=None, id=None, name=None, server_url=None):
        if endpoint and not isinstance(endpoint, str):
            raise TypeError("Expected argument 'endpoint' to be a str")
        __self__.endpoint = endpoint
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        __self__.id = id
        """
        The provider-assigned unique ID for this managed resource.
        """
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        __self__.name = name
        """
        The name of the container registry
        * `endpoint`: The URL endpoint of the container registry. Ex: `registry.digitalocean.com/my_registry`
        * `server_url`: The domain of the container registry. Ex: `registry.digitalocean.com`
        """
        if server_url and not isinstance(server_url, str):
            raise TypeError("Expected argument 'server_url' to be a str")
        __self__.server_url = server_url
class AwaitableGetContainerRegistryResult(GetContainerRegistryResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetContainerRegistryResult(
            endpoint=self.endpoint,
            id=self.id,
            name=self.name,
            server_url=self.server_url)

def get_container_registry(name=None,opts=None):
    """
    Get information on a container registry. This data source provides the name as 
    configured on your DigitalOcean account. This is useful if the container 
    registry name in question is not managed by this provider or you need validate if 
    the container registry exists in the account.

    An error is triggered if the provided container registry name does not exist.

    ## Example Usage

    ### Basic Example

    ```python
    import pulumi
    import pulumi_digitalocean as digitalocean

    example = digitalocean.get_container_registry(name="example")
    ```



    :param str name: The name of the container registry.
    """
    __args__ = dict()


    __args__['name'] = name
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = utilities.get_version()
    __ret__ = pulumi.runtime.invoke('digitalocean:index/getContainerRegistry:getContainerRegistry', __args__, opts=opts).value

    return AwaitableGetContainerRegistryResult(
        endpoint=__ret__.get('endpoint'),
        id=__ret__.get('id'),
        name=__ret__.get('name'),
        server_url=__ret__.get('serverUrl'))
