# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from . import utilities, tables

class GetImageResult:
    """
    A collection of values returned by getImage.
    """
    def __init__(__self__, created=None, distribution=None, error_message=None, id=None, image=None, min_disk_size=None, name=None, private=None, regions=None, size_gigabytes=None, slug=None, source=None, status=None, tags=None, type=None):
        if created and not isinstance(created, str):
            raise TypeError("Expected argument 'created' to be a str")
        __self__.created = created
        if distribution and not isinstance(distribution, str):
            raise TypeError("Expected argument 'distribution' to be a str")
        __self__.distribution = distribution
        """
        The name of the distribution of the OS of the image.
        * `min_disk_size`: The minimum 'disk' required for the image.
        * `size_gigabytes`: The size of the image in GB.
        """
        if error_message and not isinstance(error_message, str):
            raise TypeError("Expected argument 'error_message' to be a str")
        __self__.error_message = error_message
        if id and not isinstance(id, float):
            raise TypeError("Expected argument 'id' to be a float")
        __self__.id = id
        if image and not isinstance(image, str):
            raise TypeError("Expected argument 'image' to be a str")
        __self__.image = image
        """
        The id of the image (legacy parameter).
        """
        if min_disk_size and not isinstance(min_disk_size, float):
            raise TypeError("Expected argument 'min_disk_size' to be a float")
        __self__.min_disk_size = min_disk_size
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        __self__.name = name
        if private and not isinstance(private, bool):
            raise TypeError("Expected argument 'private' to be a bool")
        __self__.private = private
        """
        Is image a public image or not. Public images represent
        Linux distributions or One-Click Applications, while non-public images represent
        snapshots and backups and are only available within your account.
        * `regions`: A set of the regions that the image is available in.
        * `tags`: A set of tags applied to the image
        * `created`: When the image was created
        * `status`: Current status of the image
        * `error_message`: Any applicable error message pertaining to the image
        """
        if regions and not isinstance(regions, list):
            raise TypeError("Expected argument 'regions' to be a list")
        __self__.regions = regions
        if size_gigabytes and not isinstance(size_gigabytes, float):
            raise TypeError("Expected argument 'size_gigabytes' to be a float")
        __self__.size_gigabytes = size_gigabytes
        if slug and not isinstance(slug, str):
            raise TypeError("Expected argument 'slug' to be a str")
        __self__.slug = slug
        if source and not isinstance(source, str):
            raise TypeError("Expected argument 'source' to be a str")
        __self__.source = source
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        __self__.status = status
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        __self__.tags = tags
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        __self__.type = type
class AwaitableGetImageResult(GetImageResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetImageResult(
            created=self.created,
            distribution=self.distribution,
            error_message=self.error_message,
            id=self.id,
            image=self.image,
            min_disk_size=self.min_disk_size,
            name=self.name,
            private=self.private,
            regions=self.regions,
            size_gigabytes=self.size_gigabytes,
            slug=self.slug,
            source=self.source,
            status=self.status,
            tags=self.tags,
            type=self.type)

def get_image(id=None,name=None,slug=None,source=None,opts=None):
    """
    Get information on an image for use in other resources (e.g. creating a Droplet
    based on snapshot). This data source provides all of the image properties as
    configured on your DigitalOcean account. This is useful if the image in question
    is not managed by this provider or you need to utilize any of the image's data.

    An error is triggered if zero or more than one result is returned by the query.

    ## Example Usage



    ```python
    import pulumi
    import pulumi_digitalocean as digitalocean

    example1 = digitalocean.get_image(name="example-1.0.0")
    ```



    :param float id: The id of the image
    :param str name: The name of the image.
    :param str slug: The slug of the official image.
    :param str source: Restrict the search to one of the following categories of images:
           - `all` - All images (whether public or private)
           - `applications` - One-click applications
           - `distributions` - Distributions
           - `user` - (Default) User (private) images
    """
    __args__ = dict()


    __args__['id'] = id
    __args__['name'] = name
    __args__['slug'] = slug
    __args__['source'] = source
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = utilities.get_version()
    __ret__ = pulumi.runtime.invoke('digitalocean:index/getImage:getImage', __args__, opts=opts).value

    return AwaitableGetImageResult(
        created=__ret__.get('created'),
        distribution=__ret__.get('distribution'),
        error_message=__ret__.get('errorMessage'),
        id=__ret__.get('id'),
        image=__ret__.get('image'),
        min_disk_size=__ret__.get('minDiskSize'),
        name=__ret__.get('name'),
        private=__ret__.get('private'),
        regions=__ret__.get('regions'),
        size_gigabytes=__ret__.get('sizeGigabytes'),
        slug=__ret__.get('slug'),
        source=__ret__.get('source'),
        status=__ret__.get('status'),
        tags=__ret__.get('tags'),
        type=__ret__.get('type'))
