# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from . import utilities, tables

class GetKubernetesClusterResult:
    """
    A collection of values returned by getKubernetesCluster.
    """
    def __init__(__self__, cluster_subnet=None, created_at=None, endpoint=None, id=None, ipv4_address=None, kube_configs=None, name=None, node_pools=None, region=None, service_subnet=None, status=None, tags=None, updated_at=None, version=None, vpc_uuid=None):
        if cluster_subnet and not isinstance(cluster_subnet, str):
            raise TypeError("Expected argument 'cluster_subnet' to be a str")
        __self__.cluster_subnet = cluster_subnet
        """
        The range of IP addresses in the overlay network of the Kubernetes cluster.
        """
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        __self__.created_at = created_at
        """
        The date and time when the Kubernetes cluster was created.
        """
        if endpoint and not isinstance(endpoint, str):
            raise TypeError("Expected argument 'endpoint' to be a str")
        __self__.endpoint = endpoint
        """
        The base URL of the API server on the Kubernetes master node.
        """
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        __self__.id = id
        """
        The provider-assigned unique ID for this managed resource.
        """
        if ipv4_address and not isinstance(ipv4_address, str):
            raise TypeError("Expected argument 'ipv4_address' to be a str")
        __self__.ipv4_address = ipv4_address
        """
        The public IPv4 address of the Kubernetes master node.
        """
        if kube_configs and not isinstance(kube_configs, list):
            raise TypeError("Expected argument 'kube_configs' to be a list")
        __self__.kube_configs = kube_configs
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        __self__.name = name
        if node_pools and not isinstance(node_pools, list):
            raise TypeError("Expected argument 'node_pools' to be a list")
        __self__.node_pools = node_pools
        """
        A list of node pools associated with the cluster. Each node pool exports the following attributes:
        - `id` -  The unique ID that can be used to identify and reference the node pool.
        - `name` - The name of the node pool.
        - `size` - The slug identifier for the type of Droplet used as workers in the node pool.
        - `node_count` - The number of Droplet instances in the node pool.
        - `actual_node_count` - The actual number of nodes in the node pool, which is especially useful when auto-scaling is enabled.
        - `auto_scale` - A boolean indicating whether auto-scaling is enabled on the node pool.
        - `min_nodes` - If auto-scaling is enabled, this represents the minimum number of nodes that the node pool can be scaled down to.
        - `max_nodes` - If auto-scaling is enabled, this represents the maximum number of nodes that the node pool can be scaled up to.
        - `tags` - A list of tag names applied to the node pool.
        - `labels` - A map of key/value pairs applied to nodes in the pool. The labels are exposed in the Kubernetes API as labels in the metadata of the corresponding [Node resources](https://kubernetes.io/docs/concepts/architecture/nodes/).
        - `nodes` - A list of nodes in the pool. Each node exports the following attributes:
        + `id` -  A unique ID that can be used to identify and reference the node.
        + `name` - The auto-generated name for the node.
        + `status` -  A string indicating the current status of the individual node.
        + `created_at` - The date and time when the node was created.
        + `updated_at` - The date and time when the node was last updated.
        """
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        __self__.region = region
        """
        The slug identifier for the region where the Kubernetes cluster is located.
        """
        if service_subnet and not isinstance(service_subnet, str):
            raise TypeError("Expected argument 'service_subnet' to be a str")
        __self__.service_subnet = service_subnet
        """
        The range of assignable IP addresses for services running in the Kubernetes cluster.
        """
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        __self__.status = status
        """
        A string indicating the current status of the cluster. Potential values include running, provisioning, and errored.
        """
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        __self__.tags = tags
        """
        A list of tag names to be applied to the Kubernetes cluster.
        """
        if updated_at and not isinstance(updated_at, str):
            raise TypeError("Expected argument 'updated_at' to be a str")
        __self__.updated_at = updated_at
        """
        The date and time when the Kubernetes cluster was last updated.
        * `kube_config.0` - A representation of the Kubernetes cluster's kubeconfig with the following attributes:
        - `raw_config` - The full contents of the Kubernetes cluster's kubeconfig file.
        - `host` - The URL of the API server on the Kubernetes master node.
        - `cluster_ca_certificate` - The base64 encoded public certificate for the cluster's certificate authority.
        - `token` - The DigitalOcean API access token used by clients to access the cluster.
        - `client_key` - The base64 encoded private key used by clients to access the cluster. Only available if token authentication is not supported on your cluster.
        - `client_certificate` - The base64 encoded public certificate used by clients to access the cluster. Only available if token authentication is not supported on your cluster.
        - `expires_at` - The date and time when the credentials will expire and need to be regenerated.
        """
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        __self__.version = version
        """
        The slug identifier for the version of Kubernetes used for the cluster.
        """
        if vpc_uuid and not isinstance(vpc_uuid, str):
            raise TypeError("Expected argument 'vpc_uuid' to be a str")
        __self__.vpc_uuid = vpc_uuid
        """
        The ID of the VPC where the Kubernetes cluster is located.
        """
class AwaitableGetKubernetesClusterResult(GetKubernetesClusterResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetKubernetesClusterResult(
            cluster_subnet=self.cluster_subnet,
            created_at=self.created_at,
            endpoint=self.endpoint,
            id=self.id,
            ipv4_address=self.ipv4_address,
            kube_configs=self.kube_configs,
            name=self.name,
            node_pools=self.node_pools,
            region=self.region,
            service_subnet=self.service_subnet,
            status=self.status,
            tags=self.tags,
            updated_at=self.updated_at,
            version=self.version,
            vpc_uuid=self.vpc_uuid)

def get_kubernetes_cluster(name=None,tags=None,opts=None):
    """
    Retrieves information about a DigitalOcean Kubernetes cluster for use in other resources. This data source provides all of the cluster's properties as configured on your DigitalOcean account. This is useful if the cluster in question is not managed by this provider.




    :param str name: The name of Kubernetes cluster.
    :param list tags: A list of tag names to be applied to the Kubernetes cluster.
    """
    __args__ = dict()


    __args__['name'] = name
    __args__['tags'] = tags
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = utilities.get_version()
    __ret__ = pulumi.runtime.invoke('digitalocean:index/getKubernetesCluster:getKubernetesCluster', __args__, opts=opts).value

    return AwaitableGetKubernetesClusterResult(
        cluster_subnet=__ret__.get('clusterSubnet'),
        created_at=__ret__.get('createdAt'),
        endpoint=__ret__.get('endpoint'),
        id=__ret__.get('id'),
        ipv4_address=__ret__.get('ipv4Address'),
        kube_configs=__ret__.get('kubeConfigs'),
        name=__ret__.get('name'),
        node_pools=__ret__.get('nodePools'),
        region=__ret__.get('region'),
        service_subnet=__ret__.get('serviceSubnet'),
        status=__ret__.get('status'),
        tags=__ret__.get('tags'),
        updated_at=__ret__.get('updatedAt'),
        version=__ret__.get('version'),
        vpc_uuid=__ret__.get('vpcUuid'))
