import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement, Operator } from "../shared";
/**
 * (experimental) Statement provider for service [glacier](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonglacier.html).
 *
 * @experimental
 */
export declare class Glacier extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [glacier](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonglacier.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Aborts a multipart upload identified by the upload ID.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-multipart-abort-upload.html
     *
     * @experimental
     */
    toAbortMultipartUpload(): this;
    /**
     * (experimental) Aborts the vault locking process if the vault lock is not in the Locked state.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-AbortVaultLock.html
     *
     * @experimental
     */
    toAbortVaultLock(): this;
    /**
     * (experimental) Adds the specified tags to a vault.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-AddTagsToVault.html
     *
     * @experimental
     */
    toAddTagsToVault(): this;
    /**
     * (experimental) Completes a multipart upload process.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-multipart-complete-upload.html
     *
     * @experimental
     */
    toCompleteMultipartUpload(): this;
    /**
     * (experimental) Completes the vault locking process.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-CompleteVaultLock.html
     *
     * @experimental
     */
    toCompleteVaultLock(): this;
    /**
     * (experimental) Creates a new vault with the specified name.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-vault-put.html
     *
     * @experimental
     */
    toCreateVault(): this;
    /**
     * (experimental) Deletes an archive from a vault.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifArchiveAgeInDays()
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-archive-delete.html
     *
     * @experimental
     */
    toDeleteArchive(): this;
    /**
     * (experimental) Deletes a vault.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-vault-delete.html
     *
     * @experimental
     */
    toDeleteVault(): this;
    /**
     * (experimental) Deletes the access policy associated with the specified vault.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-DeleteVaultAccessPolicy.html
     *
     * @experimental
     */
    toDeleteVaultAccessPolicy(): this;
    /**
     * (experimental) Deletes the notification configuration set for a vault.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-vault-notifications-delete.html
     *
     * @experimental
     */
    toDeleteVaultNotifications(): this;
    /**
     * (experimental) Returns information about a job you previously initiated.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-describe-job-get.html
     *
     * @experimental
     */
    toDescribeJob(): this;
    /**
     * (experimental) Returns information about a vault.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-vault-get..html
     *
     * @experimental
     */
    toDescribeVault(): this;
    /**
     * (experimental) Returns the current data retrieval policy for the account and region specified in the GET request.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-GetDataRetrievalPolicy.html
     *
     * @experimental
     */
    toGetDataRetrievalPolicy(): this;
    /**
     * (experimental) Downloads the output of the job you initiated.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-job-output-get.html
     *
     * @experimental
     */
    toGetJobOutput(): this;
    /**
     * (experimental) Retrieves the access-policy subresource set on the vault.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-GetVaultAccessPolicy.html
     *
     * @experimental
     */
    toGetVaultAccessPolicy(): this;
    /**
     * (experimental) Retrieves attributes from the lock-policy subresource set on the specified vault.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-GetVaultLock.html
     *
     * @experimental
     */
    toGetVaultLock(): this;
    /**
     * (experimental) Retrieves the notification-configuration subresource set on the vault.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-vault-notifications-get.html
     *
     * @experimental
     */
    toGetVaultNotifications(): this;
    /**
     * (experimental) Initiates a job of the specified type.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifArchiveAgeInDays()
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-initiate-job-post.html
     *
     * @experimental
     */
    toInitiateJob(): this;
    /**
     * (experimental) Initiates a multipart upload.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-multipart-initiate-upload.html
     *
     * @experimental
     */
    toInitiateMultipartUpload(): this;
    /**
     * (experimental) Initiates the vault locking process.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-InitiateVaultLock.html
     *
     * @experimental
     */
    toInitiateVaultLock(): this;
    /**
     * (experimental) Lists jobs for a vault that are in-progress and jobs that have recently finished.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-jobs-get.html
     *
     * @experimental
     */
    toListJobs(): this;
    /**
     * (experimental) Lists in-progress multipart uploads for the specified vault.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-multipart-list-uploads.html
     *
     * @experimental
     */
    toListMultipartUploads(): this;
    /**
     * (experimental) Lists the parts of an archive that have been uploaded in a specific multipart upload.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-multipart-list-parts.html
     *
     * @experimental
     */
    toListParts(): this;
    /**
     * (experimental) This operation lists the provisioned capacity for the specified AWS account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-ListProvisionedCapacity.html
     *
     * @experimental
     */
    toListProvisionedCapacity(): this;
    /**
     * (experimental) Lists all the tags attached to a vault.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-ListTagsForVault.html
     *
     * @experimental
     */
    toListTagsForVault(): this;
    /**
     * (experimental) Lists all vaults.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-vaults-get.html
     *
     * @experimental
     */
    toListVaults(): this;
    /**
     * (experimental) This operation purchases a provisioned capacity unit for an AWS account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-PurchaseProvisionedCapacity.html
     *
     * @experimental
     */
    toPurchaseProvisionedCapacity(): this;
    /**
     * (experimental) Removes one or more tags from the set of tags attached to a vault.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-RemoveTagsFromVault.html
     *
     * @experimental
     */
    toRemoveTagsFromVault(): this;
    /**
     * (experimental) Sets and then enacts a data retrieval policy in the region specified in the PUT request.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-SetDataRetrievalPolicy.html
     *
     * @experimental
     */
    toSetDataRetrievalPolicy(): this;
    /**
     * (experimental) Configures an access policy for a vault and will overwrite an existing policy.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-SetVaultAccessPolicy.html
     *
     * @experimental
     */
    toSetVaultAccessPolicy(): this;
    /**
     * (experimental) Configures vault notifications.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-vault-notifications-put.html
     *
     * @experimental
     */
    toSetVaultNotifications(): this;
    /**
     * (experimental) Adds an archive to a vault.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-archive-post.html
     *
     * @experimental
     */
    toUploadArchive(): this;
    /**
     * (experimental) Uploads a part of an archive.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/api-upload-part.html
     *
     * @experimental
     */
    toUploadMultipartPart(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type vault to the statement.
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/working-with-vaults.html
     *
     * @param vaultName - Identifier for the vaultName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onVault(vaultName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) How long an archive has been stored in the vault, in days.
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/access-control-overview.html#specifying-conditions
     *
     * Applies to actions:
     * - .toDeleteArchive()
     * - .toInitiateJob()
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifArchiveAgeInDays(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) A customer-defined tag.
     *
     * https://docs.aws.amazon.com/amazonglacier/latest/dev/access-control-overview.html#specifying-conditions
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifResourceTagExists(value: string | string[], operator?: Operator | string): this;
}
