"use strict";
// Generated from the AliCloud ROS Resource Specification
Object.defineProperty(exports, "__esModule", { value: true });
exports.RosVirtualHost = exports.RosQueue = exports.RosInstance = exports.RosExchange = exports.RosBinding = void 0;
const ros = require("@alicloud/ros-cdk-core");
/**
 * Determine whether the given properties match those of a `RosBindingProps`
 *
 * @param properties - the TypeScript properties of a `RosBindingProps`
 *
 * @returns the result of the validation.
 */
function RosBindingPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('argument', ros.requiredValidator)(properties.argument));
    errors.collect(ros.propertyValidator('argument', ros.validateString)(properties.argument));
    errors.collect(ros.propertyValidator('sourceExchange', ros.requiredValidator)(properties.sourceExchange));
    errors.collect(ros.propertyValidator('sourceExchange', ros.validateString)(properties.sourceExchange));
    errors.collect(ros.propertyValidator('instanceId', ros.requiredValidator)(properties.instanceId));
    errors.collect(ros.propertyValidator('instanceId', ros.validateString)(properties.instanceId));
    errors.collect(ros.propertyValidator('bindingKey', ros.requiredValidator)(properties.bindingKey));
    errors.collect(ros.propertyValidator('bindingKey', ros.validateString)(properties.bindingKey));
    errors.collect(ros.propertyValidator('bindingType', ros.requiredValidator)(properties.bindingType));
    if (properties.bindingType && (typeof properties.bindingType) !== 'object') {
        errors.collect(ros.propertyValidator('bindingType', ros.validateAllowedValues)({
            data: properties.bindingType,
            allowedValues: ["0", "0", "QUEUE", "1", "1", "EXCHANGE"],
        }));
    }
    errors.collect(ros.propertyValidator('bindingType', ros.validateString)(properties.bindingType));
    errors.collect(ros.propertyValidator('destinationName', ros.requiredValidator)(properties.destinationName));
    errors.collect(ros.propertyValidator('destinationName', ros.validateString)(properties.destinationName));
    errors.collect(ros.propertyValidator('virtualHost', ros.requiredValidator)(properties.virtualHost));
    errors.collect(ros.propertyValidator('virtualHost', ros.validateString)(properties.virtualHost));
    return errors.wrap('supplied properties not correct for "RosBindingProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::AMQP::Binding` resource
 *
 * @param properties - the TypeScript properties of a `RosBindingProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::AMQP::Binding` resource.
 */
// @ts-ignore TS6133
function rosBindingPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosBindingPropsValidator(properties).assertSuccess();
    }
    return {
        Argument: ros.stringToRosTemplate(properties.argument),
        BindingKey: ros.stringToRosTemplate(properties.bindingKey),
        BindingType: ros.stringToRosTemplate(properties.bindingType),
        DestinationName: ros.stringToRosTemplate(properties.destinationName),
        InstanceId: ros.stringToRosTemplate(properties.instanceId),
        SourceExchange: ros.stringToRosTemplate(properties.sourceExchange),
        VirtualHost: ros.stringToRosTemplate(properties.virtualHost),
    };
}
/**
 * A ROS template type:  `ALIYUN::AMQP::Binding`
 */
class RosBinding extends ros.RosResource {
    /**
     * Create a new `ALIYUN::AMQP::Binding`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosBinding.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.argument = props.argument;
        this.bindingKey = props.bindingKey;
        this.bindingType = props.bindingType;
        this.destinationName = props.destinationName;
        this.instanceId = props.instanceId;
        this.sourceExchange = props.sourceExchange;
        this.virtualHost = props.virtualHost;
    }
    get rosProperties() {
        return {
            argument: this.argument,
            bindingKey: this.bindingKey,
            bindingType: this.bindingType,
            destinationName: this.destinationName,
            instanceId: this.instanceId,
            sourceExchange: this.sourceExchange,
            virtualHost: this.virtualHost,
        };
    }
    renderProperties(props) {
        return rosBindingPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosBinding = RosBinding;
/**
 * The resource type name for this resource class.
 */
RosBinding.ROS_RESOURCE_TYPE_NAME = "ALIYUN::AMQP::Binding";
/**
 * Determine whether the given properties match those of a `RosExchangeProps`
 *
 * @param properties - the TypeScript properties of a `RosExchangeProps`
 *
 * @returns the result of the validation.
 */
function RosExchangePropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('instanceId', ros.requiredValidator)(properties.instanceId));
    errors.collect(ros.propertyValidator('instanceId', ros.validateString)(properties.instanceId));
    errors.collect(ros.propertyValidator('alternateExchange', ros.validateString)(properties.alternateExchange));
    errors.collect(ros.propertyValidator('internal', ros.requiredValidator)(properties.internal));
    errors.collect(ros.propertyValidator('internal', ros.validateBoolean)(properties.internal));
    errors.collect(ros.propertyValidator('virtualHost', ros.requiredValidator)(properties.virtualHost));
    errors.collect(ros.propertyValidator('virtualHost', ros.validateString)(properties.virtualHost));
    errors.collect(ros.propertyValidator('autoDeleteState', ros.requiredValidator)(properties.autoDeleteState));
    errors.collect(ros.propertyValidator('autoDeleteState', ros.validateBoolean)(properties.autoDeleteState));
    errors.collect(ros.propertyValidator('exchangeName', ros.requiredValidator)(properties.exchangeName));
    if (properties.exchangeName && (Array.isArray(properties.exchangeName) || (typeof properties.exchangeName) === 'string')) {
        errors.collect(ros.propertyValidator('exchangeName', ros.validateLength)({
            data: properties.exchangeName.length,
            min: undefined,
            max: 255,
        }));
    }
    errors.collect(ros.propertyValidator('exchangeName', ros.validateString)(properties.exchangeName));
    errors.collect(ros.propertyValidator('exchangeType', ros.requiredValidator)(properties.exchangeType));
    if (properties.exchangeType && (typeof properties.exchangeType) !== 'object') {
        errors.collect(ros.propertyValidator('exchangeType', ros.validateAllowedValues)({
            data: properties.exchangeType,
            allowedValues: ["FANOUT", "DIRECT", "TOPIC", "HEADERS"],
        }));
    }
    errors.collect(ros.propertyValidator('exchangeType', ros.validateString)(properties.exchangeType));
    return errors.wrap('supplied properties not correct for "RosExchangeProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::AMQP::Exchange` resource
 *
 * @param properties - the TypeScript properties of a `RosExchangeProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::AMQP::Exchange` resource.
 */
// @ts-ignore TS6133
function rosExchangePropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosExchangePropsValidator(properties).assertSuccess();
    }
    return {
        AutoDeleteState: ros.booleanToRosTemplate(properties.autoDeleteState),
        ExchangeName: ros.stringToRosTemplate(properties.exchangeName),
        ExchangeType: ros.stringToRosTemplate(properties.exchangeType),
        InstanceId: ros.stringToRosTemplate(properties.instanceId),
        Internal: ros.booleanToRosTemplate(properties.internal),
        VirtualHost: ros.stringToRosTemplate(properties.virtualHost),
        AlternateExchange: ros.stringToRosTemplate(properties.alternateExchange),
    };
}
/**
 * A ROS template type:  `ALIYUN::AMQP::Exchange`
 */
class RosExchange extends ros.RosResource {
    /**
     * Create a new `ALIYUN::AMQP::Exchange`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosExchange.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrExchangeName = this.getAtt('ExchangeName');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.autoDeleteState = props.autoDeleteState;
        this.exchangeName = props.exchangeName;
        this.exchangeType = props.exchangeType;
        this.instanceId = props.instanceId;
        this.internal = props.internal;
        this.virtualHost = props.virtualHost;
        this.alternateExchange = props.alternateExchange;
    }
    get rosProperties() {
        return {
            autoDeleteState: this.autoDeleteState,
            exchangeName: this.exchangeName,
            exchangeType: this.exchangeType,
            instanceId: this.instanceId,
            internal: this.internal,
            virtualHost: this.virtualHost,
            alternateExchange: this.alternateExchange,
        };
    }
    renderProperties(props) {
        return rosExchangePropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosExchange = RosExchange;
/**
 * The resource type name for this resource class.
 */
RosExchange.ROS_RESOURCE_TYPE_NAME = "ALIYUN::AMQP::Exchange";
/**
 * Determine whether the given properties match those of a `RosInstanceProps`
 *
 * @param properties - the TypeScript properties of a `RosInstanceProps`
 *
 * @returns the result of the validation.
 */
function RosInstancePropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('maxTps', ros.requiredValidator)(properties.maxTps));
    if (properties.maxTps && (typeof properties.maxTps) !== 'object') {
        errors.collect(ros.propertyValidator('maxTps', ros.validateAllowedValues)({
            data: properties.maxTps,
            allowedValues: [1000, 1500, 2000, 2500, 3000, 4000, 5000, 8000, 10000, 15000, 20000, 25000, 30000, 40000, 50000, 100000, 200000, 300000, 500000, 800000, 1000000],
        }));
    }
    errors.collect(ros.propertyValidator('maxTps', ros.validateNumber)(properties.maxTps));
    if (properties.maxEipTps && (typeof properties.maxEipTps) !== 'object') {
        errors.collect(ros.propertyValidator('maxEipTps', ros.validateRange)({
            data: properties.maxEipTps,
            min: 128,
            max: undefined,
        }));
    }
    errors.collect(ros.propertyValidator('maxEipTps', ros.validateNumber)(properties.maxEipTps));
    if (properties.supportEip && (typeof properties.supportEip) !== 'object') {
        errors.collect(ros.propertyValidator('supportEip', ros.validateAllowedValues)({
            data: properties.supportEip,
            allowedValues: ["true", "false"],
        }));
    }
    errors.collect(ros.propertyValidator('supportEip', ros.validateString)(properties.supportEip));
    if (properties.period && (typeof properties.period) !== 'object') {
        errors.collect(ros.propertyValidator('period', ros.validateAllowedValues)({
            data: properties.period,
            allowedValues: [1, 2, 3, 6, 12, 24, 36],
        }));
    }
    errors.collect(ros.propertyValidator('period', ros.validateNumber)(properties.period));
    errors.collect(ros.propertyValidator('storageSize', ros.requiredValidator)(properties.storageSize));
    if (properties.storageSize && (typeof properties.storageSize) !== 'object') {
        errors.collect(ros.propertyValidator('storageSize', ros.validateRange)({
            data: properties.storageSize,
            min: 200,
            max: 2800,
        }));
    }
    errors.collect(ros.propertyValidator('storageSize', ros.validateNumber)(properties.storageSize));
    if (properties.payType && (typeof properties.payType) !== 'object') {
        errors.collect(ros.propertyValidator('payType', ros.validateAllowedValues)({
            data: properties.payType,
            allowedValues: ["Subscription", "PrePaid", "Prepaid", "PrePay", "PREPAY", "PRE"],
        }));
    }
    errors.collect(ros.propertyValidator('payType', ros.validateString)(properties.payType));
    errors.collect(ros.propertyValidator('queueCapacity', ros.requiredValidator)(properties.queueCapacity));
    if (properties.queueCapacity && (typeof properties.queueCapacity) !== 'object') {
        errors.collect(ros.propertyValidator('queueCapacity', ros.validateRange)({
            data: properties.queueCapacity,
            min: 50,
            max: 80000,
        }));
    }
    errors.collect(ros.propertyValidator('queueCapacity', ros.validateNumber)(properties.queueCapacity));
    if (properties.tracingStorageTime && (typeof properties.tracingStorageTime) !== 'object') {
        errors.collect(ros.propertyValidator('tracingStorageTime', ros.validateAllowedValues)({
            data: properties.tracingStorageTime,
            allowedValues: [3, 7, 15],
        }));
    }
    errors.collect(ros.propertyValidator('tracingStorageTime', ros.validateNumber)(properties.tracingStorageTime));
    errors.collect(ros.propertyValidator('instanceName', ros.validateString)(properties.instanceName));
    if (properties.orderNum && (typeof properties.orderNum) !== 'object') {
        errors.collect(ros.propertyValidator('orderNum', ros.validateRange)({
            data: properties.orderNum,
            min: 1,
            max: 9999,
        }));
    }
    errors.collect(ros.propertyValidator('orderNum', ros.validateNumber)(properties.orderNum));
    if (properties.supportTracing && (typeof properties.supportTracing) !== 'object') {
        errors.collect(ros.propertyValidator('supportTracing', ros.validateAllowedValues)({
            data: properties.supportTracing,
            allowedValues: ["true", "false"],
        }));
    }
    errors.collect(ros.propertyValidator('supportTracing', ros.validateString)(properties.supportTracing));
    errors.collect(ros.propertyValidator('instanceType', ros.requiredValidator)(properties.instanceType));
    if (properties.instanceType && (typeof properties.instanceType) !== 'object') {
        errors.collect(ros.propertyValidator('instanceType', ros.validateAllowedValues)({
            data: properties.instanceType,
            allowedValues: ["professional", "enterprise", "vip"],
        }));
    }
    errors.collect(ros.propertyValidator('instanceType', ros.validateString)(properties.instanceType));
    if (properties.periodUnit && (typeof properties.periodUnit) !== 'object') {
        errors.collect(ros.propertyValidator('periodUnit', ros.validateAllowedValues)({
            data: properties.periodUnit,
            allowedValues: ["month", "year", "Month", "Year"],
        }));
    }
    errors.collect(ros.propertyValidator('periodUnit', ros.validateString)(properties.periodUnit));
    return errors.wrap('supplied properties not correct for "RosInstanceProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::AMQP::Instance` resource
 *
 * @param properties - the TypeScript properties of a `RosInstanceProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::AMQP::Instance` resource.
 */
// @ts-ignore TS6133
function rosInstancePropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosInstancePropsValidator(properties).assertSuccess();
    }
    return {
        InstanceType: ros.stringToRosTemplate(properties.instanceType),
        MaxTps: ros.numberToRosTemplate(properties.maxTps),
        QueueCapacity: ros.numberToRosTemplate(properties.queueCapacity),
        StorageSize: ros.numberToRosTemplate(properties.storageSize),
        InstanceName: ros.stringToRosTemplate(properties.instanceName),
        MaxEipTps: ros.numberToRosTemplate(properties.maxEipTps),
        OrderNum: ros.numberToRosTemplate(properties.orderNum),
        PayType: ros.stringToRosTemplate(properties.payType),
        Period: ros.numberToRosTemplate(properties.period),
        PeriodUnit: ros.stringToRosTemplate(properties.periodUnit),
        SupportEip: ros.stringToRosTemplate(properties.supportEip),
        SupportTracing: ros.stringToRosTemplate(properties.supportTracing),
        TracingStorageTime: ros.numberToRosTemplate(properties.tracingStorageTime),
    };
}
/**
 * A ROS template type:  `ALIYUN::AMQP::Instance`
 */
class RosInstance extends ros.RosResource {
    /**
     * Create a new `ALIYUN::AMQP::Instance`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosInstance.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrInstanceId = this.getAtt('InstanceId');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.instanceType = props.instanceType;
        this.maxTps = props.maxTps;
        this.queueCapacity = props.queueCapacity;
        this.storageSize = props.storageSize;
        this.instanceName = props.instanceName;
        this.maxEipTps = props.maxEipTps;
        this.orderNum = props.orderNum;
        this.payType = props.payType;
        this.period = props.period;
        this.periodUnit = props.periodUnit;
        this.supportEip = props.supportEip;
        this.supportTracing = props.supportTracing;
        this.tracingStorageTime = props.tracingStorageTime;
    }
    get rosProperties() {
        return {
            instanceType: this.instanceType,
            maxTps: this.maxTps,
            queueCapacity: this.queueCapacity,
            storageSize: this.storageSize,
            instanceName: this.instanceName,
            maxEipTps: this.maxEipTps,
            orderNum: this.orderNum,
            payType: this.payType,
            period: this.period,
            periodUnit: this.periodUnit,
            supportEip: this.supportEip,
            supportTracing: this.supportTracing,
            tracingStorageTime: this.tracingStorageTime,
        };
    }
    renderProperties(props) {
        return rosInstancePropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosInstance = RosInstance;
/**
 * The resource type name for this resource class.
 */
RosInstance.ROS_RESOURCE_TYPE_NAME = "ALIYUN::AMQP::Instance";
/**
 * Determine whether the given properties match those of a `RosQueueProps`
 *
 * @param properties - the TypeScript properties of a `RosQueueProps`
 *
 * @returns the result of the validation.
 */
function RosQueuePropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('deadLetterExchange', ros.validateString)(properties.deadLetterExchange));
    errors.collect(ros.propertyValidator('maximumPriority', ros.validateNumber)(properties.maximumPriority));
    errors.collect(ros.propertyValidator('instanceId', ros.requiredValidator)(properties.instanceId));
    errors.collect(ros.propertyValidator('instanceId', ros.validateString)(properties.instanceId));
    errors.collect(ros.propertyValidator('exclusiveState', ros.validateBoolean)(properties.exclusiveState));
    errors.collect(ros.propertyValidator('deadLetterRoutingKey', ros.validateString)(properties.deadLetterRoutingKey));
    errors.collect(ros.propertyValidator('virtualHost', ros.requiredValidator)(properties.virtualHost));
    errors.collect(ros.propertyValidator('virtualHost', ros.validateString)(properties.virtualHost));
    errors.collect(ros.propertyValidator('maxLength', ros.validateNumber)(properties.maxLength));
    errors.collect(ros.propertyValidator('autoDeleteState', ros.validateBoolean)(properties.autoDeleteState));
    errors.collect(ros.propertyValidator('queueName', ros.requiredValidator)(properties.queueName));
    if (properties.queueName && (Array.isArray(properties.queueName) || (typeof properties.queueName) === 'string')) {
        errors.collect(ros.propertyValidator('queueName', ros.validateLength)({
            data: properties.queueName.length,
            min: undefined,
            max: 255,
        }));
    }
    errors.collect(ros.propertyValidator('queueName', ros.validateString)(properties.queueName));
    errors.collect(ros.propertyValidator('messageTtl', ros.validateNumber)(properties.messageTtl));
    errors.collect(ros.propertyValidator('autoExpireState', ros.validateNumber)(properties.autoExpireState));
    return errors.wrap('supplied properties not correct for "RosQueueProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::AMQP::Queue` resource
 *
 * @param properties - the TypeScript properties of a `RosQueueProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::AMQP::Queue` resource.
 */
// @ts-ignore TS6133
function rosQueuePropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosQueuePropsValidator(properties).assertSuccess();
    }
    return {
        InstanceId: ros.stringToRosTemplate(properties.instanceId),
        QueueName: ros.stringToRosTemplate(properties.queueName),
        VirtualHost: ros.stringToRosTemplate(properties.virtualHost),
        AutoDeleteState: ros.booleanToRosTemplate(properties.autoDeleteState),
        AutoExpireState: ros.numberToRosTemplate(properties.autoExpireState),
        DeadLetterExchange: ros.stringToRosTemplate(properties.deadLetterExchange),
        DeadLetterRoutingKey: ros.stringToRosTemplate(properties.deadLetterRoutingKey),
        ExclusiveState: ros.booleanToRosTemplate(properties.exclusiveState),
        MaximumPriority: ros.numberToRosTemplate(properties.maximumPriority),
        MaxLength: ros.numberToRosTemplate(properties.maxLength),
        MessageTTL: ros.numberToRosTemplate(properties.messageTtl),
    };
}
/**
 * A ROS template type:  `ALIYUN::AMQP::Queue`
 */
class RosQueue extends ros.RosResource {
    /**
     * Create a new `ALIYUN::AMQP::Queue`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosQueue.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrQueueName = this.getAtt('QueueName');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.instanceId = props.instanceId;
        this.queueName = props.queueName;
        this.virtualHost = props.virtualHost;
        this.autoDeleteState = props.autoDeleteState;
        this.autoExpireState = props.autoExpireState;
        this.deadLetterExchange = props.deadLetterExchange;
        this.deadLetterRoutingKey = props.deadLetterRoutingKey;
        this.exclusiveState = props.exclusiveState;
        this.maximumPriority = props.maximumPriority;
        this.maxLength = props.maxLength;
        this.messageTtl = props.messageTtl;
    }
    get rosProperties() {
        return {
            instanceId: this.instanceId,
            queueName: this.queueName,
            virtualHost: this.virtualHost,
            autoDeleteState: this.autoDeleteState,
            autoExpireState: this.autoExpireState,
            deadLetterExchange: this.deadLetterExchange,
            deadLetterRoutingKey: this.deadLetterRoutingKey,
            exclusiveState: this.exclusiveState,
            maximumPriority: this.maximumPriority,
            maxLength: this.maxLength,
            messageTtl: this.messageTtl,
        };
    }
    renderProperties(props) {
        return rosQueuePropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosQueue = RosQueue;
/**
 * The resource type name for this resource class.
 */
RosQueue.ROS_RESOURCE_TYPE_NAME = "ALIYUN::AMQP::Queue";
/**
 * Determine whether the given properties match those of a `RosVirtualHostProps`
 *
 * @param properties - the TypeScript properties of a `RosVirtualHostProps`
 *
 * @returns the result of the validation.
 */
function RosVirtualHostPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('instanceId', ros.requiredValidator)(properties.instanceId));
    errors.collect(ros.propertyValidator('instanceId', ros.validateString)(properties.instanceId));
    errors.collect(ros.propertyValidator('virtualHost', ros.requiredValidator)(properties.virtualHost));
    if (properties.virtualHost && (Array.isArray(properties.virtualHost) || (typeof properties.virtualHost) === 'string')) {
        errors.collect(ros.propertyValidator('virtualHost', ros.validateLength)({
            data: properties.virtualHost.length,
            min: undefined,
            max: 100,
        }));
    }
    errors.collect(ros.propertyValidator('virtualHost', ros.validateString)(properties.virtualHost));
    return errors.wrap('supplied properties not correct for "RosVirtualHostProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::AMQP::VirtualHost` resource
 *
 * @param properties - the TypeScript properties of a `RosVirtualHostProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::AMQP::VirtualHost` resource.
 */
// @ts-ignore TS6133
function rosVirtualHostPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosVirtualHostPropsValidator(properties).assertSuccess();
    }
    return {
        InstanceId: ros.stringToRosTemplate(properties.instanceId),
        VirtualHost: ros.stringToRosTemplate(properties.virtualHost),
    };
}
/**
 * A ROS template type:  `ALIYUN::AMQP::VirtualHost`
 */
class RosVirtualHost extends ros.RosResource {
    /**
     * Create a new `ALIYUN::AMQP::VirtualHost`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosVirtualHost.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrVirtualHost = this.getAtt('VirtualHost');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.instanceId = props.instanceId;
        this.virtualHost = props.virtualHost;
    }
    get rosProperties() {
        return {
            instanceId: this.instanceId,
            virtualHost: this.virtualHost,
        };
    }
    renderProperties(props) {
        return rosVirtualHostPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosVirtualHost = RosVirtualHost;
/**
 * The resource type name for this resource class.
 */
RosVirtualHost.ROS_RESOURCE_TYPE_NAME = "ALIYUN::AMQP::VirtualHost";
//# sourceMappingURL=data:application/json;base64,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