"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Binding = exports.BindingProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const amqp_generated_1 = require("./amqp.generated");
Object.defineProperty(exports, "BindingProperty", { enumerable: true, get: function () { return amqp_generated_1.RosBinding; } });
/**
 * A ROS resource type:  `ALIYUN::AMQP::Binding`
 */
class Binding extends ros.Resource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the properties of this ROS resource, which will be assigned to ROS resource.
     */
    /**
     * Create a new `ALIYUN::AMQP::Binding`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosBinding = new amqp_generated_1.RosBinding(this, id, {
            argument: props.argument,
            sourceExchange: props.sourceExchange,
            instanceId: props.instanceId,
            bindingKey: props.bindingKey,
            bindingType: props.bindingType,
            destinationName: props.destinationName,
            virtualHost: props.virtualHost,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosBinding;
    }
}
exports.Binding = Binding;
//# sourceMappingURL=data:application/json;base64,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