# coding: utf-8

"""
    Tator REST API

    Interface to the Tator backend.  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ..configuration import Configuration


class AlgorithmSpec(object):
    """
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'cluster': 'int',
        'description': 'str',
        'files_per_job': 'int',
        'manifest': 'str',
        'name': 'str',
        'user': 'int'
    }

    attribute_map = {
        'cluster': 'cluster',
        'description': 'description',
        'files_per_job': 'files_per_job',
        'manifest': 'manifest',
        'name': 'name',
        'user': 'user'
    }

    def __init__(self, cluster=None, description=None, files_per_job=None, manifest=None, name=None, user=None, local_vars_configuration=None):  # noqa: E501
        """AlgorithmSpec - a model defined in OpenAPI"""
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._cluster = None
        self._description = None
        self._files_per_job = None
        self._manifest = None
        self._name = None
        self._user = None
        self.discriminator = None

        if cluster is not None:
            self.cluster = cluster
        if description is not None:
            self.description = description
        self.files_per_job = files_per_job
        self.manifest = manifest
        self.name = name
        self.user = user

    @property
    def cluster(self):
        """
        Unique integer identifying the job cluster.

        :return: The cluster of this AlgorithmSpec. 
        :rtype: int
        """
        return self._cluster

    @cluster.setter
    def cluster(self, cluster):
        """
        Unique integer identifying the job cluster.

        :param cluster: The cluster of this AlgorithmSpec.
        :type: int
        """

        self._cluster = cluster

    @property
    def description(self):
        """
        Description of the algorithm.

        :return: The description of this AlgorithmSpec. 
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Description of the algorithm.

        :param description: The description of this AlgorithmSpec.
        :type: str
        """

        self._description = description

    @property
    def files_per_job(self):
        """
        Number of media files to be submitted to each workflow.

        :return: The files_per_job of this AlgorithmSpec. 
        :rtype: int
        """
        return self._files_per_job

    @files_per_job.setter
    def files_per_job(self, files_per_job):
        """
        Number of media files to be submitted to each workflow.

        :param files_per_job: The files_per_job of this AlgorithmSpec.
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and files_per_job is None:  # noqa: E501
            raise ValueError("Invalid value for `files_per_job`, must not be `None`")  # noqa: E501

        self._files_per_job = files_per_job

    @property
    def manifest(self):
        """
        Server URL to argo manifest file (.yaml)

        :return: The manifest of this AlgorithmSpec. 
        :rtype: str
        """
        return self._manifest

    @manifest.setter
    def manifest(self, manifest):
        """
        Server URL to argo manifest file (.yaml)

        :param manifest: The manifest of this AlgorithmSpec.
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and manifest is None:  # noqa: E501
            raise ValueError("Invalid value for `manifest`, must not be `None`")  # noqa: E501

        self._manifest = manifest

    @property
    def name(self):
        """
        Unique name of the algorithm workflow.

        :return: The name of this AlgorithmSpec. 
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Unique name of the algorithm workflow.

        :param name: The name of this AlgorithmSpec.
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def user(self):
        """
        Unique integer identifying the user registering the algorithm.

        :return: The user of this AlgorithmSpec. 
        :rtype: int
        """
        return self._user

    @user.setter
    def user(self, user):
        """
        Unique integer identifying the user registering the algorithm.

        :param user: The user of this AlgorithmSpec.
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and user is None:  # noqa: E501
            raise ValueError("Invalid value for `user`, must not be `None`")  # noqa: E501

        self._user = user

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AlgorithmSpec):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, AlgorithmSpec):
            return True

        return self.to_dict() != other.to_dict()
