# coding: utf-8

"""
    Tator REST API

    Interface to the Tator backend.  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ..configuration import Configuration


class BucketSpec(object):
    """
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'access_key': 'str',
        'archive_sc': 'str',
        'endpoint_url': 'str',
        'gcs_key_info': 'str',
        'live_sc': 'str',
        'name': 'str',
        'region': 'str',
        'secret_key': 'str'
    }

    attribute_map = {
        'access_key': 'access_key',
        'archive_sc': 'archive_sc',
        'endpoint_url': 'endpoint_url',
        'gcs_key_info': 'gcs_key_info',
        'live_sc': 'live_sc',
        'name': 'name',
        'region': 'region',
        'secret_key': 'secret_key'
    }

    def __init__(self, access_key=None, archive_sc=None, endpoint_url=None, gcs_key_info=None, live_sc=None, name=None, region=None, secret_key=None, local_vars_configuration=None):  # noqa: E501
        """BucketSpec - a model defined in OpenAPI"""
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._access_key = None
        self._archive_sc = None
        self._endpoint_url = None
        self._gcs_key_info = None
        self._live_sc = None
        self._name = None
        self._region = None
        self._secret_key = None
        self.discriminator = None

        if access_key is not None:
            self.access_key = access_key
        if archive_sc is not None:
            self.archive_sc = archive_sc
        if endpoint_url is not None:
            self.endpoint_url = endpoint_url
        if gcs_key_info is not None:
            self.gcs_key_info = gcs_key_info
        if live_sc is not None:
            self.live_sc = live_sc
        self.name = name
        if region is not None:
            self.region = region
        if secret_key is not None:
            self.secret_key = secret_key

    @property
    def access_key(self):
        """
        Account access key.

        :return: The access_key of this BucketSpec. 
        :rtype: str
        """
        return self._access_key

    @access_key.setter
    def access_key(self, access_key):
        """
        Account access key.

        :param access_key: The access_key of this BucketSpec.
        :type: str
        """

        self._access_key = access_key

    @property
    def archive_sc(self):
        """
        Storage class in which archived objects live.

        :return: The archive_sc of this BucketSpec. 
        :rtype: str
        """
        return self._archive_sc

    @archive_sc.setter
    def archive_sc(self, archive_sc):
        """
        Storage class in which archived objects live.

        :param archive_sc: The archive_sc of this BucketSpec.
        :type: str
        """

        self._archive_sc = archive_sc

    @property
    def endpoint_url(self):
        """
        Endpoint URL for bucket.

        :return: The endpoint_url of this BucketSpec. 
        :rtype: str
        """
        return self._endpoint_url

    @endpoint_url.setter
    def endpoint_url(self, endpoint_url):
        """
        Endpoint URL for bucket.

        :param endpoint_url: The endpoint_url of this BucketSpec.
        :type: str
        """

        self._endpoint_url = endpoint_url

    @property
    def gcs_key_info(self):
        """
        JSON string containing Google Cloud Storage credentials.

        :return: The gcs_key_info of this BucketSpec. 
        :rtype: str
        """
        return self._gcs_key_info

    @gcs_key_info.setter
    def gcs_key_info(self, gcs_key_info):
        """
        JSON string containing Google Cloud Storage credentials.

        :param gcs_key_info: The gcs_key_info of this BucketSpec.
        :type: str
        """

        self._gcs_key_info = gcs_key_info

    @property
    def live_sc(self):
        """
        Storage class in which live objects live.

        :return: The live_sc of this BucketSpec. 
        :rtype: str
        """
        return self._live_sc

    @live_sc.setter
    def live_sc(self, live_sc):
        """
        Storage class in which live objects live.

        :param live_sc: The live_sc of this BucketSpec.
        :type: str
        """

        self._live_sc = live_sc

    @property
    def name(self):
        """
        Bucket name.

        :return: The name of this BucketSpec. 
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Bucket name.

        :param name: The name of this BucketSpec.
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def region(self):
        """
        Bucket region.

        :return: The region of this BucketSpec. 
        :rtype: str
        """
        return self._region

    @region.setter
    def region(self, region):
        """
        Bucket region.

        :param region: The region of this BucketSpec.
        :type: str
        """

        self._region = region

    @property
    def secret_key(self):
        """
        Account secret key.

        :return: The secret_key of this BucketSpec. 
        :rtype: str
        """
        return self._secret_key

    @secret_key.setter
    def secret_key(self, secret_key):
        """
        Account secret key.

        :param secret_key: The secret_key of this BucketSpec.
        :type: str
        """

        self._secret_key = secret_key

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, BucketSpec):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, BucketSpec):
            return True

        return self.to_dict() != other.to_dict()
