# coding: utf-8

"""
    Tator REST API

    Interface to the Tator backend.  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ..configuration import Configuration


class ColorMap(object):
    """
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'alpha_ranges': 'dict(str, list)',
        'default': 'object',
        'default_fill': 'Fill',
        'fill_map': 'dict(str, Fill)',
        'key': 'str',
        'map': 'dict(str, object)',
        'version': 'dict(str, object)'
    }

    attribute_map = {
        'alpha_ranges': 'alpha_ranges',
        'default': 'default',
        'default_fill': 'defaultFill',
        'fill_map': 'fillMap',
        'key': 'key',
        'map': 'map',
        'version': 'version'
    }

    def __init__(self, alpha_ranges=None, default=None, default_fill=None, fill_map=None, key=None, map=None, version=None, local_vars_configuration=None):  # noqa: E501
        """ColorMap - a model defined in OpenAPI"""
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._alpha_ranges = None
        self._default = None
        self._default_fill = None
        self._fill_map = None
        self._key = None
        self._map = None
        self._version = None
        self.discriminator = None

        if alpha_ranges is not None:
            self.alpha_ranges = alpha_ranges
        if default is not None:
            self.default = default
        if default_fill is not None:
            self.default_fill = default_fill
        if fill_map is not None:
            self.fill_map = fill_map
        if key is not None:
            self.key = key
        if map is not None:
            self.map = map
        if version is not None:
            self.version = version

    @property
    def alpha_ranges(self):
        """
        Map of attribute values to alpha level.

        :return: The alpha_ranges of this ColorMap. 
        :rtype: dict(str, list)
        """
        return self._alpha_ranges

    @alpha_ranges.setter
    def alpha_ranges(self, alpha_ranges):
        """
        Map of attribute values to alpha level.

        :param alpha_ranges: The alpha_ranges of this ColorMap.
        :type: dict(str, list)
        """

        self._alpha_ranges = alpha_ranges

    @property
    def default(self):
        """
        RGB array, RGBA array, or hex string.

        :return: The default of this ColorMap. 
        :rtype: object
        """
        return self._default

    @default.setter
    def default(self, default):
        """
        RGB array, RGBA array, or hex string.

        :param default: The default of this ColorMap.
        :type: object
        """

        self._default = default

    @property
    def default_fill(self):
        """

        :return: The default_fill of this ColorMap. 
        :rtype: Fill
        """
        return self._default_fill

    @default_fill.setter
    def default_fill(self, default_fill):
        """

        :param default_fill: The default_fill of this ColorMap.
        :type: Fill
        """

        self._default_fill = default_fill

    @property
    def fill_map(self):
        """
        Map of attribute values to fill types.

        :return: The fill_map of this ColorMap. 
        :rtype: dict(str, Fill)
        """
        return self._fill_map

    @fill_map.setter
    def fill_map(self, fill_map):
        """
        Map of attribute values to fill types.

        :param fill_map: The fill_map of this ColorMap.
        :type: dict(str, Fill)
        """

        self._fill_map = fill_map

    @property
    def key(self):
        """
        Attribute name.

        :return: The key of this ColorMap. 
        :rtype: str
        """
        return self._key

    @key.setter
    def key(self, key):
        """
        Attribute name.

        :param key: The key of this ColorMap.
        :type: str
        """

        self._key = key

    @property
    def map(self):
        """
        Map of attribute values to colors.

        :return: The map of this ColorMap. 
        :rtype: dict(str, object)
        """
        return self._map

    @map.setter
    def map(self, map):
        """
        Map of attribute values to colors.

        :param map: The map of this ColorMap.
        :type: dict(str, object)
        """

        self._map = map

    @property
    def version(self):
        """
        Map of version IDs to colors.

        :return: The version of this ColorMap. 
        :rtype: dict(str, object)
        """
        return self._version

    @version.setter
    def version(self, version):
        """
        Map of version IDs to colors.

        :param version: The version of this ColorMap.
        :type: dict(str, object)
        """

        self._version = version

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ColorMap):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ColorMap):
            return True

        return self.to_dict() != other.to_dict()
