# coding: utf-8

"""
    Tator REST API

    Interface to the Tator backend.  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ..configuration import Configuration


class FileDefinition(object):
    """
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'host': 'str',
        'http_auth': 'str',
        'mime': 'str',
        'name': 'str',
        'path': 'str',
        'size': 'int'
    }

    attribute_map = {
        'host': 'host',
        'http_auth': 'http_auth',
        'mime': 'mime',
        'name': 'name',
        'path': 'path',
        'size': 'size'
    }

    def __init__(self, host=None, http_auth=None, mime=None, name=None, path=None, size=None, local_vars_configuration=None):  # noqa: E501
        """FileDefinition - a model defined in OpenAPI"""
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._host = None
        self._http_auth = None
        self._mime = None
        self._name = None
        self._path = None
        self._size = None
        self.discriminator = None

        if host is not None:
            self.host = host
        if http_auth is not None:
            self.http_auth = http_auth
        if mime is not None:
            self.mime = mime
        if name is not None:
            self.name = name
        self.path = path
        if size is not None:
            self.size = size

    @property
    def host(self):
        """
        If supplied will use this instead of currently connected host, e.g. https://example.com

        :return: The host of this FileDefinition. 
        :rtype: str
        """
        return self._host

    @host.setter
    def host(self, host):
        """
        If supplied will use this instead of currently connected host, e.g. https://example.com

        :param host: The host of this FileDefinition.
        :type: str
        """

        self._host = host

    @property
    def http_auth(self):
        """
        If specified will be used for HTTP authorization in request for media, i.e. \"bearer <token>\".

        :return: The http_auth of this FileDefinition. 
        :rtype: str
        """
        return self._http_auth

    @http_auth.setter
    def http_auth(self, http_auth):
        """
        If specified will be used for HTTP authorization in request for media, i.e. \"bearer <token>\".

        :param http_auth: The http_auth of this FileDefinition.
        :type: str
        """

        self._http_auth = http_auth

    @property
    def mime(self):
        """
        Example mime: \"text/csv\".

        :return: The mime of this FileDefinition. 
        :rtype: str
        """
        return self._mime

    @mime.setter
    def mime(self, mime):
        """
        Example mime: \"text/csv\".

        :param mime: The mime of this FileDefinition.
        :type: str
        """

        self._mime = mime

    @property
    def name(self):
        """
        Name of the file.

        :return: The name of this FileDefinition. 
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Name of the file.

        :param name: The name of this FileDefinition.
        :type: str
        """

        self._name = name

    @property
    def path(self):
        """
        Relative URL to the file.

        :return: The path of this FileDefinition. 
        :rtype: str
        """
        return self._path

    @path.setter
    def path(self, path):
        """
        Relative URL to the file.

        :param path: The path of this FileDefinition.
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and path is None:  # noqa: E501
            raise ValueError("Invalid value for `path`, must not be `None`")  # noqa: E501

        self._path = path

    @property
    def size(self):
        """
        File size in bytes.

        :return: The size of this FileDefinition. 
        :rtype: int
        """
        return self._size

    @size.setter
    def size(self, size):
        """
        File size in bytes.

        :param size: The size of this FileDefinition.
        :type: int
        """

        self._size = size

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, FileDefinition):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, FileDefinition):
            return True

        return self.to_dict() != other.to_dict()
